/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.apiinvoke.mall.AccessTokenInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.weixin.WeiXinBaseMapper;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.api.TokenAPI;
import weixin.popular.bean.token.Token;

@Component
public class WeiXinBaseAccessToken {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AccessTokenInvoke accessTokenInvoke;
    @Autowired
    private WeiXinBaseMapper weiXinBaseMapper;
    @Autowired
    RedisService redisService;
    @Autowired
    private MallRedisLock mallRedisLock;

    public WeiXinBaseEntity getAccessTokenByPlatformId(Integer platformId) {
        WeiXinBaseEntity weiXinBase = this.weiXinBaseMapper.getAccessTokenByPlatformId(platformId);
        if (weiXinBase != null) {
            if (weiXinBase.getExpired().after(DateUtils.now())) {
                return weiXinBase;
            }
            BaseJsonVo baseJsonVo = this.accessTokenInvoke.getAccessTokenValueByPlatformId(platformId);
            if (baseJsonVo.isSuccess()) {
                weiXinBase.setAccessToken(baseJsonVo.getValue().toString());
            } else {
                throw new RuntimeException("\u83b7\u53d6accessToken\u51fa\u9519");
            }
        }
        return weiXinBase;
    }

    public String getAccessTokenValueByPlatformId(Integer platformId) {
        WeiXinBaseEntity weiXinBaseEntity = this.getAccessTokenByPlatformId(platformId);
        if (weiXinBaseEntity != null) {
            return weiXinBaseEntity.getAccessToken();
        }
        return "";
    }

    public String getQiYeAccessTokenValueByPlatformId(Integer platformId) {
        return this.getAccessTokenValueByPlatformId(platformId);
    }

    private String getQiYeAccessTokenValueByPlatformId(Integer platformId, boolean clearCache) {
        String key = "QiYeAccessTokenValue:" + platformId;
        Object cacheData = this.redisService.get(key);
        if (clearCache || cacheData == null || StringUtils.isEmpty((String)cacheData.toString().trim())) {
            if (this.mallRedisLock.lock("wechat_accesstoken_lock" + platformId, "1", 30L, TimeUnit.SECONDS)) {
                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseMapper.getAccessTokenByPlatformId(platformId);
                if (weiXinBaseEntity != null) {
                    if (weiXinBaseEntity.getExpired() != null && weiXinBaseEntity.getExpired().after(DateUtils.now())) {
                        return weiXinBaseEntity.getAccessToken();
                    }
                    Token token = TokenAPI.getQYtoken((String)weiXinBaseEntity.getAppid(), (String)weiXinBaseEntity.getAppscret());
                    this.redisService.save(key, weiXinBaseEntity.getAccessToken(), token.getExpires_in());
                    weiXinBaseEntity.setAccessToken(token.getAccess_token());
                    weiXinBaseEntity.setExpired(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)token.getExpires_in()));
                    this.weiXinBaseMapper.updateByPrimaryKeySelective(weiXinBaseEntity);
                    return token.getAccess_token();
                }
                throw new RuntimeException("platformId \u6709\u8bef");
            }
        } else {
            return cacheData.toString();
        }
        return "";
    }

    private long getDateDiff(Date sdate) {
        Date now = new Date();
        if (now.after(sdate)) {
            return 0L;
        }
        long second = 0L;
        try {
            second = (sdate.getTime() - now.getTime()) / 1000L;
        }
        catch (Exception e) {
            return 0L;
        }
        return second;
    }
}

