/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinBaseMapper;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseVo;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WeiXinBaseService
extends BaseService
implements WeiXinBaseInterface {
    @Autowired
    private WeiXinBaseMapper weiXinBaseMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="WeiXinBaseService.getWeiXinBase", expiration=180)
    public WeiXinBaseEntity getWeiXinBase(@ParameterValueKeyProvider Integer id) {
        return (WeiXinBaseEntity)this.weiXinBaseMapper.selectByPrimaryKey(id);
    }

    @Override
    public boolean saveWeiXinBase(WeiXinBaseEntity weiXinBaseEntity) {
        this.removCache(weiXinBaseEntity.getWeixinBaseId(), weiXinBaseEntity.getAppid(), weiXinBaseEntity.getPlatformId());
        if (weiXinBaseEntity.getWeixinBaseId() != null && weiXinBaseEntity.getWeixinBaseId() != 0) {
            return this.weiXinBaseMapper.updateByPrimaryKeySelective(weiXinBaseEntity) >= 1;
        }
        return this.weiXinBaseMapper.insertSelective(weiXinBaseEntity) >= 1;
    }

    @Override
    public List<WeiXinBaseVo> getWeiXinBaseList(Pageable pageable) {
        return PageHelper.startPage((int)pageable.getPageNumber(), (int)pageable.getPageSize()).doSelectPage(() -> this.weiXinBaseMapper.getPageList(new WeiXinBaseEntity()));
    }

    private void removCache(Integer id, String appId, int platformId) {
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBase", String.valueOf(id == null ? 0 : id));
        this.memcachedService.delete("WeiXinBaseService.getWeiXinBasefromAppId", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessToken", appId);
        this.memcachedService.delete("WeiXinBaseService.getAccessTokenByPlatformId", String.valueOf(platformId));
        this.memcachedService.delete("WeiXinBaseService.getWeixinBaseByFlatformId", String.valueOf(platformId));
    }

    @Override
    public WeiXinBaseEntity selectByPrimaryKey(Integer id) {
        return (WeiXinBaseEntity)this.weiXinBaseMapper.selectByPrimaryKey(id);
    }
}

