/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.constants.message.WechatMsgType;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.weixin.WeiXinGroupMapper;
import cc.lechun.mall.entity.weixin.WeiXinGroupEntity;
import cc.lechun.mall.entity.weixin.WeiXinGroupUserRefEntity;
import cc.lechun.mall.entity.weixin.WeiXinGroupVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.entity.weixin.WeiXinMessageSendEntity;
import cc.lechun.mall.iservice.weixin.WeiXinGroupInterface;
import cc.lechun.mall.iservice.weixin.WeiXinGroupUserInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMessageSendInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MessageAPI;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.MessageSendResult;
import weixin.popular.bean.message.massmessage.Filter;
import weixin.popular.bean.message.massmessage.MassImageMessage;
import weixin.popular.bean.message.massmessage.MassMPnewsMessage;
import weixin.popular.bean.message.massmessage.MassMessage;
import weixin.popular.bean.message.massmessage.MassTextMessage;
import weixin.popular.bean.message.message.ImageMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.NewsMessage;
import weixin.popular.bean.message.message.TextMessage;
import weixin.popular.bean.message.preview.ImagePreview;
import weixin.popular.bean.message.preview.MpnewsPreview;
import weixin.popular.bean.message.preview.Preview;
import weixin.popular.bean.message.preview.TextPreview;
import weixin.popular.bean.user.Group;

@Service
public class WeiXinGroupService
extends BaseService
implements WeiXinGroupInterface {
    @Autowired
    private WeiXinGroupMapper groupMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private WeiXinMediaInterface mediaInterface;
    @Autowired
    private WeiXinGroupUserInterface groupUserInterface;
    @Autowired
    private WeiXinBaseAccessToken baseInterface;
    @Autowired
    private WeiXinMessageSendInterface messageSendInterface;
    @Autowired
    private MessageQueueService messageQueueService;

    @Override
    public PageInfo getGroupList(int pageNum, int pageSize, WeiXinGroupEntity groupEntity) {
        String[] groupName = groupEntity.getGroupName() != null && !groupEntity.getGroupName().isEmpty() ? groupEntity.getGroupName().split(",") : null;
        Page list = PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPage(() -> this.groupMapper.getGroupList(groupName, groupEntity.getCreateTime(), groupEntity.getPlatformId()));
        for (WeiXinGroupVo g : list) {
            WeiXinKeywordEntity keywordEntity;
            if (g.getKeywordId() != null && (keywordEntity = this.keywordInterface.getWeiXinKeywordById(g.getKeywordId())) != null) {
                List<WeiXinMediaEntity> mediaEntities;
                g.setKeywordName(keywordEntity.getKeyword());
                if (keywordEntity.getType().equals("news") && !keywordEntity.getMediaId().isEmpty() && (mediaEntities = this.mediaInterface.getMediaListByMediaId(keywordEntity.getMediaId())) != null && mediaEntities.size() > 0) {
                    g.setMediaName(Arrays.toString(mediaEntities.stream().map(c -> c.getTitle()).toArray()));
                }
            }
            g.setUserCount(this.groupUserInterface.getGroupUserCount(g.getGroupId(), null).intValue());
            g.setUnLoadUserCount(this.groupUserInterface.getGroupUserCount(g.getGroupId(), 0).intValue());
            g.setFailCount(this.groupUserInterface.getGroupUserCount(g.getGroupId(), -1).intValue());
            if (!"\u5206\u7ec4\u7528\u6237\u63d0\u4ea4\u6210\u529f\uff0c\u6b63\u5728\u5206\u7ec4".equals(g.getMessage()) || g.getUnLoadUserCount() != 0L) continue;
            g.setMessage("\u5206\u7ec4\u5b8c\u6210");
        }
        return new PageInfo((List)list);
    }

    @Override
    public BaseJsonVo getGroups(Integer platformGroupId, Integer platformId) {
        List groupDatas;
        String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        Group group = UserAPI.groupsGet((String)accessToken);
        if (group != null && (groupDatas = group.getGroups()) != null && groupDatas.size() > 0) {
            for (Group.GroupData groupData : groupDatas) {
                WeiXinGroupEntity groupEntity = this.getGroupByWxGroupId(platformId, groupData.getId());
                if (groupEntity != null) {
                    groupEntity.setGroupCount(groupData.getCount());
                } else {
                    groupEntity = new WeiXinGroupEntity();
                    groupEntity.setCreateTime(DateUtils.now());
                    groupEntity.setGroupCount(groupData.getCount());
                    groupEntity.setGroupId(platformId + "_" + groupData.getId());
                    groupEntity.setGroupName(groupData.getName());
                    groupEntity.setRemark("");
                    groupEntity.setWxgroupId(groupData.getId());
                    groupEntity.setStatus(1);
                    groupEntity.setPlatformId(platformId);
                    groupEntity.setPlatformGroupId(platformGroupId);
                }
                this.saveGroup(groupEntity);
            }
        }
        return BaseJsonVo.success((Object)"\u83b7\u53d6\u6210\u529f");
    }

    @Override
    public WeiXinGroupEntity getGroup(String groupId) {
        return (WeiXinGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)groupId));
    }

    public WeiXinGroupEntity getGroupByWxGroupId(Integer platformId, String wxGroupId) {
        WeiXinGroupEntity groupEntity = new WeiXinGroupEntity();
        groupEntity.setPlatformId(platformId);
        groupEntity.setWxgroupId(wxGroupId);
        return (WeiXinGroupEntity)this.groupMapper.getSingle(groupEntity);
    }

    @Override
    public boolean saveGroup(WeiXinGroupEntity groupEntity) {
        if (groupEntity == null) {
            return false;
        }
        if (this.groupMapper.exists((Serializable)((Object)groupEntity.getGroupId())) > 0) {
            return this.groupMapper.updateByPrimaryKeySelective(groupEntity) > 0;
        }
        return this.groupMapper.insertSelective(groupEntity) > 0;
    }

    @Override
    public void execUnComplateGroup() {
        WeiXinGroupEntity search = new WeiXinGroupEntity();
        search.setMessage("\u6b63\u5728\u5206\u7ec4\u7528\u6237...");
        List lst = this.groupMapper.getList(search);
        for (WeiXinGroupEntity groupEntity : lst) {
            this.uploadGroupUsers(groupEntity.getPlatformId(), groupEntity.getGroupId());
        }
    }

    @Override
    public void uploadGroupUsers(final int platformId, final String groupId) {
        try {
            WeiXinGroupEntity group = this.getGroup(groupId);
            final String gId = group == null ? "" : group.getWxgroupId();
            this.logger.info("uploadGroupUsers:" + platformId + "," + groupId + "," + gId);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    boolean b = true;
                    WeiXinGroupEntity groupEntity = new WeiXinGroupEntity();
                    groupEntity.setMessage("\u6b63\u5728\u5206\u7ec4\u7528\u6237...");
                    groupEntity.setGroupId(groupId);
                    WeiXinGroupService.this.saveGroup(groupEntity);
                    Integer lastId = null;
                    WeiXinGroupService.this.logger.info("\u5f00\u59cb\u7ebf\u7a0b");
                    while (b) {
                        try {
                            WeiXinGroupService.this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237\u6761\u4ef6\uff1a" + b);
                            List<WeiXinGroupUserRefEntity> lst = WeiXinGroupService.this.groupUserInterface.getGroupUserOpenIds(groupId, 50, lastId);
                            WeiXinGroupService.this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237\uff1a" + lst.size());
                            List openIdNullList = lst.stream().filter(c -> StringUtils.isEmpty((String)c.getOpenId())).collect(Collectors.toList());
                            if (openIdNullList.size() > 0) {
                                WeiXinGroupService.this.groupUserInterface.updateGroupUserStatusBatchById(groupId, lst.stream().map(c -> c.getRefId()).collect(Collectors.toList()), -1, "1000", "openId\u4e3a\u7a7a");
                                lst.removeAll(openIdNullList);
                            }
                            if (lst.size() == 0) {
                                b = false;
                                groupEntity.setMessage("\u5206\u7ec4\u7528\u6237\u5b8c\u6210");
                                WeiXinGroupService.this.saveGroup(groupEntity);
                                break;
                            }
                            String accessToken = WeiXinGroupService.this.baseInterface.getAccessTokenValueByPlatformId(platformId);
                            WeiXinGroupService.this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237accessToken:" + accessToken);
                            BaseResult s = UserAPI.groupsMembersBatchUpdate((String)accessToken, lst.stream().map(c -> c.getOpenId()).collect(Collectors.toList()), (String)gId);
                            WeiXinGroupService.this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237BaseResult:" + s.isSuccess() + s.getErrmsg());
                            if (s.isSuccess()) {
                                WeiXinGroupService.this.groupUserInterface.updateGroupUserStatusBatchById(groupId, lst.stream().map(c -> c.getRefId()).collect(Collectors.toList()), 1, "", "");
                                if (lst.size() <= 0) continue;
                                lastId = lst.get(lst.size() - 1).getRefId();
                                continue;
                            }
                            if ("49003".equals(s.getErrcode()) || "40003".equals(s.getErrcode()) || "45059".equals(s.getErrcode())) {
                                ArrayList<WeiXinGroupUserRefEntity> user1 = new ArrayList<WeiXinGroupUserRefEntity>();
                                for (WeiXinGroupUserRefEntity u : lst) {
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                    }
                                    user1.add(u);
                                    s = UserAPI.groupsMembersBatchUpdate((String)accessToken, user1.stream().map(c -> c.getOpenId()).collect(Collectors.toList()), (String)gId);
                                    if (s.isSuccess()) {
                                        WeiXinGroupService.this.groupUserInterface.updateGroupUserStatusBatchById(groupId, user1.stream().map(c -> c.getRefId()).collect(Collectors.toList()), 1, "", "");
                                        lastId = u.getRefId();
                                    } else if ("49003".equals(s.getErrcode()) || "40003".equals(s.getErrcode()) || "45059".equals(s.getErrcode())) {
                                        WeiXinGroupService.this.groupUserInterface.updateGroupUserStatusBatch(groupId, user1.stream().map(c -> c.getOpenId()).collect(Collectors.toList()), -1, s.getErrcode(), s.getErrmsg());
                                        lastId = u.getRefId();
                                    }
                                    user1.remove(u);
                                }
                                continue;
                            }
                            if ("45011".equals(s.getErrcode())) {
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (InterruptedException ex) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            WeiXinGroupService.this.logger.error("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237:" + s.isSuccess() + "|" + s.getErrcode() + "|" + s.getErrmsg());
                        }
                        catch (Exception e) {
                            WeiXinGroupService.this.logger.error("\u4e0a\u4f20\u5206\u7ec4" + e.getMessage());
                        }
                    }
                }
            });
            pool.shutdown();
            this.logger.info("\u5173\u95ed\u7ebf\u7a0b");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public BaseJsonVo getSendMessageStatus(int platformId, String groupId) {
        WeiXinMessageSendEntity messageSendEntity = this.messageSendInterface.getLastMessageSend(groupId);
        if (messageSendEntity != null && !messageSendEntity.getMsgId().isEmpty()) {
            String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
            MessageSendResult b = MessageAPI.messageMassGet((String)accessToken, (String)messageSendEntity.getMsgId());
            if (b.isSuccess()) {
                messageSendEntity.setStatus(3);
                this.messageSendInterface.updateWeiXinMessageSend(messageSendEntity);
                WeiXinGroupEntity groupEntity = this.getGroup(groupId);
                groupEntity.setMessage("\u53d1\u9001\u6210\u529f");
            }
            if (b.isSuccess()) {
                return BaseJsonVo.success((Object)"\u53d1\u9001\u6210\u529f");
            }
            return BaseJsonVo.error((String)b.getErrmsg());
        }
        return BaseJsonVo.error((String)"\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public BaseJsonVo prevMessage(Integer platformId, String wxuserName, String groupId) {
        String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        BaseJsonVo jsonVo = this.getMessageBody(platformId, groupId);
        if (jsonVo.isSuccess()) {
            Map map = (Map)jsonVo.getValue();
            MpnewsPreview preview = null;
            if (map.containsKey(WechatMsgType.news)) {
                preview = new MpnewsPreview((String)map.get(WechatMsgType.news));
            }
            if (map.containsKey(WechatMsgType.text)) {
                preview = new TextPreview((String)map.get(WechatMsgType.text));
            }
            if (map.containsKey(WechatMsgType.image)) {
                preview = new ImagePreview((String)map.get(WechatMsgType.image));
            }
            preview.setTowxname(wxuserName);
            MessageSendResult messageSendResult = MessageAPI.messageMassPreview((String)accessToken, (Preview)preview);
            if (messageSendResult.isSuccess()) {
                return BaseJsonVo.success((Object)"\u9884\u89c8\u6210\u529f");
            }
            return BaseJsonVo.error((String)messageSendResult.getErrmsg());
        }
        return BaseJsonVo.error((String)"\u9884\u89c8\u5931\u8d25");
    }

    private BaseJsonVo getMessageBody(Integer platformId, String groupId) {
        WeiXinGroupEntity groupEntity = this.getGroup(groupId);
        Map<Object, Object> map = new HashMap();
        if (groupEntity != null) {
            if (groupEntity.getKeywordId() == null) {
                return BaseJsonVo.error((String)"\u8bf7\u5148\u5173\u8054\u5173\u952e\u5b57");
            }
        } else {
            return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        map = this.keywordInterface.getKeywordMapContent(groupEntity.getKeywordId());
        if (map.size() == 0) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u627e\u5230\u53d1\u9001\u7684\u4fe1\u606f");
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo sendMessage(int platformGroupId, int platformId, String groupId) {
        String gId;
        String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        BaseJsonVo jsonVo = this.getMessageBody(platformId, groupId);
        WeiXinGroupEntity group = this.getGroup(groupId);
        String string = gId = group == null ? "0" : group.getWxgroupId();
        if (group == null) {
            return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        if (jsonVo.isSuccess()) {
            Map map = (Map)jsonVo.getValue();
            MassTextMessage massMessage = null;
            if (map.containsKey(WechatMsgType.text)) {
                massMessage = new MassTextMessage((String)map.get(WechatMsgType.text));
            }
            if (map.containsKey(WechatMsgType.news)) {
                massMessage = new MassMPnewsMessage((String)map.get(WechatMsgType.news));
            }
            if (map.containsKey(WechatMsgType.image)) {
                massMessage = new MassImageMessage((String)map.get(WechatMsgType.image));
            }
            Filter filter = new Filter(false, Integer.valueOf(Integer.parseInt(gId)));
            massMessage.setFilter(filter);
            MessageSendResult messageSendResult = MessageAPI.messageMassSendall((String)accessToken, (MassMessage)massMessage);
            this.logger.info("\u6d88\u606f\u63d0\u4ea4:{}", (Object)messageSendResult.toString());
            this.logger.info("\u6d88\u606f\u63d0\u4ea4:{}", (Object)messageSendResult.getMsg_data_id());
            this.logger.info("\u6d88\u606f\u63d0\u4ea4:{}", (Object)messageSendResult.getMsg_id());
            this.logger.info("\u6d88\u606f\u63d0\u4ea4:{}", (Object)messageSendResult.getErrmsg());
            this.logger.info("\u6d88\u606f\u63d0\u4ea4:{}", (Object)messageSendResult.getType());
            WeiXinMessageSendEntity messageSendEntity = new WeiXinMessageSendEntity();
            messageSendEntity.setStatus(messageSendResult.getErrcode().equals("0") ? 1 : 0);
            messageSendEntity.setGroupId(groupId);
            messageSendEntity.setCreateTime(DateUtils.now());
            messageSendEntity.setPlatformId(platformId);
            messageSendEntity.setPlatformGroupId(platformGroupId);
            messageSendEntity.setErrorCode(messageSendResult.getErrcode());
            messageSendEntity.setErrorMsg(messageSendResult.getErrmsg());
            messageSendEntity.setMsgId(messageSendResult.getMsg_id());
            messageSendEntity.setSendMsg(group.getKeywordId().toString());
            this.messageSendInterface.insertWeiXinMessageSend(messageSendEntity);
            group.setStatus(2);
            if (messageSendResult.isSuccess()) {
                group.setMessage("\u63d0\u4ea4\u6210\u529f");
                group.setMsgId(messageSendResult.getMsg_id());
                this.saveGroup(group);
                return BaseJsonVo.success((Object)"\u63d0\u4ea4\u6210\u529f");
            }
            group.setMessage("\u63d0\u4ea4\u5931\u8d25");
            this.saveGroup(group);
            return BaseJsonVo.error((String)messageSendResult.getErrmsg());
        }
        return BaseJsonVo.error((String)"\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public BaseJsonVo sendCustomizedMessage(Integer platformId, final String groupId, final String openId) {
        String sql = "";
        final String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        BaseJsonVo baseJsonVo = this.getMessageBody(platformId, groupId);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        Map map = (Map)baseJsonVo.getValue();
        TextMessage message = null;
        ArrayList<NewsMessage.Article> articles = new ArrayList<NewsMessage.Article>();
        if (map.containsKey(WechatMsgType.text)) {
            message = new TextMessage("", (String)map.get(WechatMsgType.text));
        }
        if (map.containsKey(WechatMsgType.news)) {
            List<WeiXinMediaEntity> mediaEntities = this.mediaInterface.getMediaListByMediaId((String)map.get(WechatMsgType.news));
            if (mediaEntities != null && mediaEntities.size() > 0) {
                for (WeiXinMediaEntity mediaEntity : mediaEntities) {
                    NewsMessage.Article article = new NewsMessage.Article(mediaEntity.getTitle(), mediaEntity.getDigest(), mediaEntity.getUrl(), mediaEntity.getImageUrl());
                    articles.add(article);
                }
                message = new NewsMessage("", articles);
            } else {
                return BaseJsonVo.error((String)"\u7d20\u6750\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5173\u952e\u5b57\u6ca1\u6709\u5173\u8054\u7d20\u6750");
            }
        }
        if (map.containsKey(WechatMsgType.image)) {
            message = new ImageMessage("", (String)map.get(WechatMsgType.image));
        }
        if (message == null) {
            return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\u7684\u53d1\u9001");
        }
        final ArrayList<TextMessage> messages = new ArrayList<TextMessage>();
        messages.add(message);
        try {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    boolean b = true;
                    int[] status = new int[]{0, 1};
                    while (b) {
                        List<Object> lst = new ArrayList<String>();
                        if (openId == null || openId.trim().isEmpty()) {
                            lst = WeiXinGroupService.this.groupUserInterface.getGroupUserOpenIds(groupId, 1000, status);
                        } else {
                            lst.add(openId);
                        }
                        if (lst.size() == 0) {
                            b = false;
                            break;
                        }
                        Message message1 = (Message)messages.get(0);
                        for (String string : lst) {
                            message1.setTouser(string);
                            BaseResult baseResult = MessageAPI.messageCustomSend((String)accessToken, (Message)message1);
                            if (baseResult.isSuccess()) {
                                WeiXinGroupService.this.groupUserInterface.updateGroupUserStatus(groupId, string, 1);
                                continue;
                            }
                            WeiXinGroupService.this.groupUserInterface.updateGroupUserStatus(groupId, string, 2);
                        }
                    }
                }
            });
            pool.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BaseJsonVo.success((Object)"\u5df2\u6267\u884c\u63a8\u9001");
    }

    @Override
    public BaseJsonVo delMessage(int platformGroupId, int platformId, String groupId, String actIndex) {
        String msgId;
        String gId;
        String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        WeiXinGroupEntity group = this.getGroup(groupId);
        String string = gId = group == null ? "0" : group.getWxgroupId();
        if (group == null) {
            return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        Integer i = 0;
        if (StringUtils.isNotEmpty((String)actIndex)) {
            if (!("0".equals(actIndex) || "1".equals(actIndex) || "2".equals(actIndex) || "3".equals(actIndex) || "4".equals(actIndex) || "5".equals(actIndex))) {
                return BaseJsonVo.error((String)"\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6570\u5b570~4\uff1a0\u8868\u793a\u5168\u5220\uff0c1\u8868\u793a\u5220\u9664\u7b2c1\u7bc7\uff0c\u4ee5\u6b64\u7c7b\u63a8");
            }
            i = Integer.parseInt(actIndex);
        }
        if (StringUtils.isEmpty((String)(msgId = group.getMsgId()))) {
            return BaseJsonVo.error((String)"msgId\u4e0d\u5b58\u5728\u4e0d\u80fd\u64a4\u56de\u6d88\u606f");
        }
        BaseResult messageSendResult = MessageAPI.messageMassDelete((String)accessToken, (String)group.getMsgId(), (Integer)i);
        this.logger.info("\u6d88\u606f\u64a4\u56de\u63d0\u4ea4:{}", (Object)messageSendResult.toString());
        WeiXinMessageSendEntity messageSendEntity = new WeiXinMessageSendEntity();
        messageSendEntity.setStatus(messageSendResult.getErrcode().equals("0") ? 1 : 0);
        messageSendEntity.setGroupId(groupId);
        messageSendEntity.setCreateTime(DateUtils.now());
        messageSendEntity.setPlatformId(platformId);
        messageSendEntity.setPlatformGroupId(platformGroupId);
        messageSendEntity.setErrorCode(messageSendResult.getErrcode());
        messageSendEntity.setErrorMsg(messageSendResult.getErrmsg());
        messageSendEntity.setMsgId(msgId);
        messageSendEntity.setSendMsg("\u6d88\u606f\u64a4\u56de:" + messageSendResult.isSuccess());
        this.messageSendInterface.insertWeiXinMessageSend(messageSendEntity);
        if (messageSendResult.isSuccess()) {
            return BaseJsonVo.success((Object)"\u64a4\u56de\u6210\u529f");
        }
        return BaseJsonVo.error((String)("\u64a4\u56de\u5931\u8d25\uff1a" + messageSendResult.getErrmsg()));
    }
}

