/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinKeywordContentMapper;
import cc.lechun.mall.dao.weixin.WeiXinKeywordMapper;
import cc.lechun.mall.entity.weixin.TemplateExecTypeEnum;
import cc.lechun.mall.entity.weixin.WeiXinKeywordContentEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordContentVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordContentInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeiXinKeywordContentService
extends BaseService<WeiXinKeywordContentEntity, Integer>
implements WeiXinKeywordContentInterface {
    @Resource
    private WeiXinKeywordContentMapper weiXinKeywordContentMapper;
    @Autowired
    private WeiXinKeywordMapper weiXinKeywordInterface;

    @Override
    public List<WeiXinKeywordContentVo> getList(Integer keyworldId) {
        WeiXinKeywordContentEntity weiXinKeywordContentEntity = new WeiXinKeywordContentEntity();
        weiXinKeywordContentEntity.setKeyworldId(keyworldId);
        List list = this.weiXinKeywordContentMapper.getList(weiXinKeywordContentEntity);
        ArrayList<WeiXinKeywordContentVo> result = new ArrayList<WeiXinKeywordContentVo>();
        WeiXinKeywordEntity weiXinKeywordEntity = (WeiXinKeywordEntity)this.weiXinKeywordInterface.selectByPrimaryKey(keyworldId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(keywordContent -> {
                WeiXinKeywordContentVo weiXinKeywordContentVo = new WeiXinKeywordContentVo();
                BeanUtils.copyProperties((Object)keywordContent, (Object)weiXinKeywordContentVo);
                weiXinKeywordContentVo.setKeyword(weiXinKeywordEntity.getKeyword());
                weiXinKeywordContentVo.setExecTypeName(TemplateExecTypeEnum.getName(keywordContent.getExecType()));
                weiXinKeywordContentVo.setStatusName(keywordContent.getStatus().intValue() == 1 ? "\u53ef\u7528" : "\u7981\u7528");
                result.add(weiXinKeywordContentVo);
            });
        }
        return result;
    }

    @Override
    public WeiXinKeywordContentVo getKeywordMessageContent(Integer keyworldId) {
        WeiXinKeywordEntity weiXinKeywordEntity = (WeiXinKeywordEntity)this.weiXinKeywordInterface.selectByPrimaryKey(keyworldId);
        WeiXinKeywordContentVo weiXinKeywordContentVo = new WeiXinKeywordContentVo();
        BeanUtils.copyProperties((Object)weiXinKeywordEntity, (Object)weiXinKeywordContentVo);
        weiXinKeywordContentVo.setKeyworldId(keyworldId);
        return weiXinKeywordContentVo;
    }

    @Override
    public BaseJsonVo saveKeywordMessageContent(WeiXinKeywordContentEntity weiXinKeywordContentEntity) {
        weiXinKeywordContentEntity.setCreateTime(DateUtils.now());
        return this.weiXinKeywordContentMapper.insertOrUpdate(weiXinKeywordContentEntity) >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

