/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.constants.message.WechatMsgType;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinMediaMapper;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaOptionVo;
import cc.lechun.mall.entity.weixin.WeiXinMediaVo;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.DraftAPI;
import weixin.popular.api.MaterialAPI;
import weixin.popular.api.MediaAPI;
import weixin.popular.bean.draft.DraftBatchgetResult;
import weixin.popular.bean.draft.DraftBatchgetResultItem;
import weixin.popular.bean.draft.DraftBatchgetResultItemContent;
import weixin.popular.bean.draft.DraftCountResult;
import weixin.popular.bean.material.MaterialBatchgetResult;
import weixin.popular.bean.material.MaterialBatchgetResultItem;
import weixin.popular.bean.material.MaterialBatchgetResultItemContent;
import weixin.popular.bean.material.MaterialcountResult;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.Article;

@Service
public class WeiXinMediaService
extends BaseService
implements WeiXinMediaInterface {
    @Autowired
    private WeiXinMediaMapper weiXinMediaMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseService;
    @Autowired
    private OssService ossSerivce;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    public boolean pullMediaList(int platformId, int platformGroupId) {
        boolean f = true;
        String access_Token = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
        if (access_Token == null || access_Token.isEmpty()) {
            return false;
        }
        MaterialcountResult materialcountResult = MaterialAPI.get_materialcount((String)access_Token);
        if (materialcountResult != null) {
            for (int i = 0; i <= materialcountResult.getNews_count() / 20; ++i) {
                MaterialBatchgetResult news = MaterialAPI.batchget_material((String)access_Token, (String)WechatMsgType.news, (int)(i * 20), (int)20);
                if (news == null || Integer.parseInt(news.getItem_count()) <= 0) continue;
                f &= this.savePullMedia(WechatMsgType.news, news, platformId, platformGroupId);
            }
        }
        return f;
    }

    @Override
    public boolean pullDraftList(int platformId, int platformGroupId) {
        boolean f = true;
        String access_Token = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
        if (access_Token == null || access_Token.isEmpty()) {
            return false;
        }
        DraftCountResult draftcount = DraftAPI.get_draftcount((String)access_Token);
        if (draftcount != null) {
            for (int i = 0; i <= draftcount.getTotal_count() / 20; ++i) {
                MaterialBatchgetResult news = DraftAPI.batchget_draft((String)access_Token, (int)(i * 20), (int)20);
                if (news == null || Integer.parseInt(news.getItem_count()) <= 0) continue;
                f &= this.savePullMedia(WechatMsgType.news, news, platformId, platformGroupId);
            }
        }
        return f;
    }

    @Override
    public boolean pullDraftSuccessList(int platformId, int platformGroupId) {
        boolean f = true;
        String access_Token = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
        if (access_Token == null || access_Token.isEmpty()) {
            return false;
        }
        for (int i = 0; i <= 5; ++i) {
            DraftBatchgetResult news = DraftAPI.batchget_draftSuccess((String)access_Token, (int)(i * 20), (int)20);
            if (news == null || Integer.parseInt(news.getItem_count()) <= 0) continue;
            f &= this.savePullDraftSuccess(WechatMsgType.news, news, platformId, platformGroupId);
        }
        return f;
    }

    private boolean savePullMedia(String type, MaterialBatchgetResult news, int platformId, int platformGroupId) {
        boolean b = true;
        List items = news.getItem();
        WeiXinMediaEntity mediaEntity = new WeiXinMediaEntity();
        for (int i = 0; i < items.size(); ++i) {
            MaterialBatchgetResultItem item = (MaterialBatchgetResultItem)items.get(i);
            String mediaId = item.getMedia_id();
            Date updateTime = new Date(Long.parseLong(item.getUpdate_time()) * 1000L);
            int showType = 0;
            String thirdUrl = "";
            String name = item.getName() == null ? "" : item.getName();
            MaterialBatchgetResultItemContent content = item.getContent();
            List articles = content.getNews_item();
            List<WeiXinMediaEntity> mediaEntities = this.getMediaListByMediaId(mediaId);
            for (Article article : articles) {
                String url;
                String title = article.getTitle() == null ? "" : article.getTitle();
                String thumbMediaid = article.getThumb_media_id() == null ? "" : article.getThumb_media_id();
                String string = url = article.getUrl() == null ? "" : article.getUrl();
                if (mediaEntities != null && mediaEntities.size() > 0) {
                    List existsMedias = mediaEntities.stream().filter(c -> c.getThumbMediaId().equals(thumbMediaid)).collect(Collectors.toList());
                    if (existsMedias.size() > 0) {
                        mediaEntity = (WeiXinMediaEntity)existsMedias.get(0);
                    }
                } else {
                    mediaEntity = new WeiXinMediaEntity();
                    mediaEntity.setShowType(showType);
                    mediaEntity.setStatus((short)1);
                }
                mediaEntity.setMediaId(mediaId);
                mediaEntity.setDigest(article.getDigest());
                mediaEntity.setTitle(title);
                mediaEntity.setPlatformGroupId(platformGroupId);
                mediaEntity.setAuthor(article.getAuthor());
                mediaEntity.setContent(article.getContent());
                mediaEntity.setName(name);
                mediaEntity.setPlatformId(platformId);
                mediaEntity.setShowCoverPic(Integer.parseInt(article.getShow_cover_pic()));
                mediaEntity.setContentSourceUrl(article.getContent_source_url());
                mediaEntity.setThumbMediaId(thumbMediaid);
                mediaEntity.setType(type);
                mediaEntity.setUpdateTime(updateTime);
                mediaEntity.setUrl(url);
                mediaEntity.setPublish(0);
                b &= this.saveMedia(mediaEntity);
            }
        }
        return b;
    }

    private boolean savePullDraftSuccess(String type, DraftBatchgetResult news, int platformId, int platformGroupId) {
        boolean b = true;
        List items = news.getItem();
        WeiXinMediaEntity mediaEntity = new WeiXinMediaEntity();
        for (int i = 0; i < items.size(); ++i) {
            DraftBatchgetResultItem item = (DraftBatchgetResultItem)items.get(i);
            String mediaId = item.getArticle_id();
            Date updateTime = new Date(Long.parseLong(item.getUpdate_time()) * 1000L);
            int showType = 0;
            String thirdUrl = "";
            String name = "";
            DraftBatchgetResultItemContent content = item.getContent();
            List articles = content.getNews_item();
            List<WeiXinMediaEntity> mediaEntities = this.getMediaListByMediaId(mediaId);
            for (weixin.popular.bean.draft.Article article : articles) {
                String url;
                String title = article.getTitle() == null ? "" : article.getTitle();
                String thumbMediaid = article.getThumb_media_id() == null ? "" : article.getThumb_media_id();
                String string = url = article.getUrl() == null ? "" : article.getUrl();
                if (mediaEntities != null && mediaEntities.size() > 0) {
                    List existsMedias = mediaEntities.stream().filter(c -> c.getThumbMediaId().equals(thumbMediaid)).collect(Collectors.toList());
                    if (existsMedias.size() > 0) {
                        mediaEntity = (WeiXinMediaEntity)existsMedias.get(0);
                    }
                } else {
                    mediaEntity = new WeiXinMediaEntity();
                    mediaEntity.setShowType(showType);
                    mediaEntity.setStatus((short)1);
                }
                mediaEntity.setMediaId(mediaId);
                mediaEntity.setDigest(article.getDigest());
                mediaEntity.setTitle(title);
                mediaEntity.setPlatformGroupId(platformGroupId);
                mediaEntity.setAuthor(article.getAuthor());
                mediaEntity.setContent(article.getContent());
                mediaEntity.setName(name);
                mediaEntity.setPlatformId(platformId);
                mediaEntity.setShowCoverPic(Integer.parseInt(article.getShow_cover_pic()));
                mediaEntity.setContentSourceUrl(article.getContent_source_url());
                mediaEntity.setThumbMediaId(thumbMediaid);
                mediaEntity.setType(type);
                mediaEntity.setUpdateTime(updateTime);
                mediaEntity.setUrl(url);
                mediaEntity.setPublish(1);
                b &= this.saveMedia(mediaEntity);
            }
        }
        return b;
    }

    @Override
    public boolean saveMedia(WeiXinMediaEntity weiXinMedia) {
        weiXinMedia.setImageUrl(this.ossSerivce.removeUrlDomain(weiXinMedia.getImageUrl()));
        this.removeCache(weiXinMedia.getMediaId(), weiXinMedia.getId(), weiXinMedia.getPlatformId());
        if (weiXinMedia.getId() == null || weiXinMedia.getId() == 0) {
            if (weiXinMedia.getType().equals("image")) {
                try {
                    URI uri = new URI(this.ossSerivce.getImageResoure(weiXinMedia.getImageUrl()));
                    String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(weiXinMedia.getPlatformId());
                    Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)uri);
                    if (media == null) {
                        this.logger.error("\u4e0a\u4f20\u4e34\u65f6\u7d20\u6750\u51fa\u9519,{}", (Object)weiXinMedia.toString());
                        return false;
                    }
                    weiXinMedia.setMediaId(media.getMedia_id());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return this.weiXinMediaMapper.insert(weiXinMedia) >= 1;
        }
        return this.weiXinMediaMapper.updateByPrimaryKeySelective(weiXinMedia) >= 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getWeiXinMediaById", expiration=300)
    public WeiXinMediaEntity getWeiXinMediaById(@ParameterValueKeyProvider Integer id) {
        WeiXinMediaEntity weiXinMedia = (WeiXinMediaEntity)this.weiXinMediaMapper.selectByPrimaryKey(id);
        weiXinMedia.setImageUrl(this.ossSerivce.getImageResoure(weiXinMedia.getImageUrl()));
        return weiXinMedia;
    }

    @Override
    public BaseJsonVo queryPageList(int page, int pageSize, WeiXinMediaEntity weiXinMediaVo) {
        ArrayList volist = new ArrayList();
        Page pages = PageHelper.startPage((int)page, (int)pageSize);
        pages.setOrderBy(" UPDATE_TIME desc");
        this.weiXinMediaMapper.getPageList(weiXinMediaVo);
        PageInfo pageInfo = pages.toPageInfo();
        List list = pageInfo.getList();
        list.forEach(c -> {
            WeiXinMediaVo mediaVo = new WeiXinMediaVo();
            BeanUtils.copyProperties((Object)c, (Object)mediaVo);
            mediaVo.setImageUrl(this.ossSerivce.getImageResoure(c.getImageUrl()));
            PlatFormAndGroupVo platFormAndGroupVo = this.platFormInterface.getPlatFormAndGroup(c.getPlatformId());
            mediaVo.setPlatformGroupName(platFormAndGroupVo != null ? platFormAndGroupVo.getPlatformGroupName() : "");
            mediaVo.setPlatformName(platFormAndGroupVo != null ? platFormAndGroupVo.getPlatformName() : "");
            volist.add(mediaVo);
        });
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Long.valueOf(pageInfo.getTotal()));
        map.put("list", volist);
        return BaseJsonVo.success(map);
    }

    @Override
    public boolean deleteMedia(int id) {
        WeiXinMediaEntity weiXinMedia = this.getWeiXinMediaById(id);
        this.removeCache(weiXinMedia.getMediaId(), weiXinMedia.getId(), weiXinMedia.getPlatformId());
        return this.weiXinMediaMapper.deleteByPrimaryKey(Integer.valueOf(id)) >= 1;
    }

    @Override
    public List<WeiXinMediaEntity> getMediaListByMediaId(String mediaId) {
        return this.weiXinMediaMapper.getMediaListByMediaId(mediaId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getMediaByMediaId")
    public WeiXinMediaEntity getMediaByMediaId(@ParameterValueKeyProvider String mediaId) {
        WeiXinMediaEntity queryWeiXinMediaEntity = new WeiXinMediaEntity();
        queryWeiXinMediaEntity.setMediaId(mediaId);
        return this.getWeiXinMedia(queryWeiXinMediaEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getMediaListByStatus", expiration=300)
    public List<WeiXinMediaEntity> getMediaListByStatus(@ParameterValueKeyProvider(order=0) Integer status, @ParameterValueKeyProvider(order=1) Integer platformId) {
        return this.weiXinMediaMapper.getMediaListByStatus(status, platformId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getMediaListForOption", expiration=300)
    public List<WeiXinMediaOptionVo> getMediaListForOption(@ParameterValueKeyProvider Integer platformId) {
        return this.weiXinMediaMapper.getMediaListForOption(platformId);
    }

    @Override
    public boolean updateSelectMedia(WeiXinMediaEntity weiXinMedia) {
        this.removeCache(weiXinMedia.getMediaId(), weiXinMedia.getId(), weiXinMedia.getPlatformId());
        return this.weiXinMediaMapper.updateByPrimaryKeySelective(weiXinMedia) >= 1;
    }

    @Override
    public WeiXinMediaEntity getWeiXinMedia(WeiXinMediaEntity weiXinMediaEntity) {
        return (WeiXinMediaEntity)this.weiXinMediaMapper.getSingle(weiXinMediaEntity);
    }

    private void removeCache(String mediaId, Integer Id, Integer platformId) {
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", "1");
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", "0");
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", String.valueOf(Integer.MAX_VALUE));
        this.memcachedService.delete("WeiXinMediaService.getMediaListByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getMediaByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getMediaListByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getWeiXinMediaById", String.valueOf(Id == null ? 0 : Id));
        this.memcachedService.delete("WeiXinMediaService.getMediaListForOption", String.valueOf(platformId));
    }
}

