/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinMenuMapper;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.weixin.WeiXinMenuEntity;
import cc.lechun.mall.entity.weixin.WeiXinMenuListVo;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMenuInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MenuAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.menu.Button;
import weixin.popular.bean.menu.Menu;
import weixin.popular.bean.menu.MenuButtons;

@Service
public class WeiXinMenuService
extends BaseService<WeiXinMenuEntity, String>
implements WeiXinMenuInterface {
    @Resource
    private WeiXinMenuMapper weiXinMenuMapper;
    @Autowired
    WeiXinBaseAccessToken weiXinBaseInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    public PageInfo<WeiXinMenuListVo> getMenuList(WeiXinMenuEntity weiXinMenuEntity) {
        Page page = PageHelper.startPage((int)1, (int)9999);
        page.setOrderBy(" SORT,MENU_LEVEL ");
        ArrayList result = new ArrayList();
        List list = this.weiXinMenuMapper.getList(weiXinMenuEntity);
        if (list.size() > 0) {
            result.addAll(list.stream().map(menu -> {
                WeiXinMenuListVo weiXinMenuListVo = new WeiXinMenuListVo();
                BeanUtils.copyProperties((Object)menu, (Object)weiXinMenuListVo);
                PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(menu.getPlatformId());
                weiXinMenuListVo.setPlatformIdName(platFormEntity == null ? "" : platFormEntity.getPlatformName());
                if (StringUtils.isNotEmpty((String)menu.getfId())) {
                    WeiXinMenuEntity father = (WeiXinMenuEntity)this.weiXinMenuMapper.selectByPrimaryKey((Serializable)((Object)menu.getfId()));
                    weiXinMenuListVo.setFatherMenuName(father == null ? "" : father.getMenuName());
                }
                return weiXinMenuListVo;
            }).collect(Collectors.toList()));
        }
        PageInfo pg = new PageInfo();
        pg.setList(result);
        pg.setTotal(page.getTotal());
        return pg;
    }

    @Override
    public BaseJsonVo saveWeiXinMenu(WeiXinMenuEntity weiXinMenuEntity) {
        this.logger.info(weiXinMenuEntity.toString());
        WeiXinMenuEntity query = new WeiXinMenuEntity();
        query.setfId("0");
        query.setPlatformId(weiXinMenuEntity.getPlatformId());
        PageInfo<WeiXinMenuListVo> pageInfo = this.getMenuList(query);
        if (pageInfo.getTotal() >= 3L && weiXinMenuEntity.getfId().equals("0") && StringUtils.isEmpty((String)weiXinMenuEntity.getMenuId())) {
            return BaseJsonVo.error((String)"\u81ea\u5b9a\u4e49\u83dc\u5355\u6700\u591a\u5305\u62ec3\u4e2a\u4e00\u7ea7\u83dc\u5355");
        }
        if (StringUtils.isNotEmpty((String)weiXinMenuEntity.getfId()) && !"0".equals(weiXinMenuEntity.getfId())) {
            query = new WeiXinMenuEntity();
            query.setfId(weiXinMenuEntity.getfId());
            pageInfo = this.getMenuList(query);
            if (pageInfo.getTotal() >= 5L && StringUtils.isEmpty((String)weiXinMenuEntity.getMenuId())) {
                return BaseJsonVo.error((String)"\u6bcf\u4e2a\u4e00\u7ea7\u83dc\u5355\u6700\u591a\u5305\u542b5\u4e2a\u4e8c\u7ea7\u83dc\u5355");
            }
        }
        if (StringUtils.isEmpty((String)weiXinMenuEntity.getMenuId()) && StringUtils.isNotEmpty((String)weiXinMenuEntity.getfId())) {
            WeiXinMenuEntity father = (WeiXinMenuEntity)this.weiXinMenuMapper.selectByPrimaryKey((Serializable)((Object)weiXinMenuEntity.getfId()));
            weiXinMenuEntity.setMenuLevel(father != null ? (father.getMenuLevel() != null ? father.getMenuLevel() + 1 : 1) : 1);
        }
        if (StringUtils.isEmpty((String)weiXinMenuEntity.getMenuId())) {
            weiXinMenuEntity.setMenuId(IDGenerate.getUniqueIdStr());
            return this.weiXinMenuMapper.insert(weiXinMenuEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        return this.weiXinMenuMapper.updateByPrimaryKeySelective(weiXinMenuEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u5019\u91cd\u8bd5");
    }

    @Override
    public void pushMenu(Integer platformGroupId) {
        WeiXinMenuEntity query = new WeiXinMenuEntity();
        query.setPlatformGroupId(platformGroupId);
        PageInfo<WeiXinMenuListVo> pageInfo = this.getMenuList(query);
        if (pageInfo.getTotal() > 0L) {
            MenuButtons menuButtons = new MenuButtons();
            HashSet plateformIdList = new HashSet();
            if (pageInfo.getTotal() > 0L) {
                pageInfo.getList().forEach(menu -> plateformIdList.add(menu.getPlatformId()));
            }
            List parentList = pageInfo.getList().stream().filter(menu -> StringUtils.isEmpty((String)menu.getfId()) || "0".equals(menu.getfId())).collect(Collectors.toList());
            Button[] buttons = new Button[parentList.size()];
            int i = 0;
            for (WeiXinMenuListVo weiXinMenuEntity : parentList) {
                Button button = new Button();
                button.setAppid(weiXinMenuEntity.getAppId());
                button.setAppid(weiXinMenuEntity.getAppId());
                button.setKey(weiXinMenuEntity.getMenuKey());
                button.setName(weiXinMenuEntity.getMenuName());
                button.setPagepath(weiXinMenuEntity.getPagePath());
                button.setType(weiXinMenuEntity.getMenuType());
                button.setUrl(weiXinMenuEntity.getMenuUrl());
                List<Button> children = this.getSubMenu(weiXinMenuEntity.getMenuId(), pageInfo.getList());
                if (children != null && children.size() > 0) {
                    button.setSub_button(children);
                }
                buttons[i] = button;
                ++i;
            }
            menuButtons.setButton(buttons);
            this.logger.info(JsonUtils.toJson((Object)menuButtons, (boolean)false));
            plateformIdList.forEach(platformId -> {
                BaseResult baseResult = MenuAPI.menuCreate((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId((Integer)platformId), (MenuButtons)menuButtons);
                this.logger.info("\u63d0\u4ea4\u83dc\u5355\u5230\u5fae\u4fe1:{}", (Object)(baseResult == null ? "\u51fa\u9519" : baseResult.getErrcode()));
            });
        }
    }

    private List<Button> getSubMenu(String menuId, List<WeiXinMenuListVo> list) {
        return list.stream().filter(menu -> menu.getfId().equals(menuId)).sorted((m1, m2) -> m1.getSort() - m2.getSort()).map(menu -> {
            Button sub_button = new Button();
            sub_button.setAppid(menu.getAppId());
            sub_button.setKey(menu.getMenuKey());
            sub_button.setName(menu.getMenuName());
            sub_button.setPagepath(menu.getPagePath());
            sub_button.setType(menu.getMenuType());
            sub_button.setUrl(menu.getMenuUrl());
            sub_button.setSub_button(this.getSubMenu(menu.getMenuId(), list));
            return sub_button;
        }).collect(Collectors.toList());
    }

    @Override
    public void pullMenu(Integer platformGroupId) {
        WeiXinMenuEntity query = new WeiXinMenuEntity();
        query.setPlatformGroupId(platformGroupId);
        PageInfo<WeiXinMenuListVo> pageInfo = this.getMenuList(query);
        HashSet<Integer> plateformIdList = new HashSet<Integer>();
        if (pageInfo.getTotal() > 0L) {
            pageInfo.getList().forEach(menu -> {
                plateformIdList.add(menu.getPlatformId());
                this.weiXinMenuMapper.deleteByPrimaryKey((Serializable)((Object)menu.getMenuId()));
            });
        }
        if (plateformIdList.size() == 0) {
            plateformIdList.add(1);
        }
        plateformIdList.forEach(platformId -> {
            Menu menu = MenuAPI.menuGet((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId((Integer)platformId));
            this.logger.info(JsonUtils.toJson((Object)menu, (boolean)false));
            if (menu != null && menu.getMenu() != null) {
                int sort = 0;
                for (Button button : menu.getMenu().getButton()) {
                    this.saveMenu(button, platformGroupId, (Integer)platformId, "0", 1, sort * 10, pageInfo.getList());
                    ++sort;
                }
            }
        });
    }

    private void saveMenu(Button button, Integer platformGroupId, Integer platformId, String fid, int level, int sort, List<WeiXinMenuListVo> list) {
        this.logger.info(JsonUtils.toJson((Object)button, (boolean)false));
        if (StringUtils.isNotEmpty((String)button.getUrl()) && StringUtils.isEmpty((String)button.getKey())) {
            Optional<WeiXinMenuListVo> weiXinMenuListVoOptional = list.stream().filter(weiXinMenuListVo -> button.getUrl().equals(weiXinMenuListVo.getMenuUrl()) && !"http://mp.weixin.qq.com".equals(button.getUrl())).findFirst();
            button.setKey(weiXinMenuListVoOptional.isPresent() ? weiXinMenuListVoOptional.get().getMenuKey() : IDGenerate.getUniqueIdStr());
        } else if (StringUtils.isEmpty((String)button.getKey())) {
            button.setKey(IDGenerate.getUniqueIdStr());
        }
        WeiXinMenuEntity weiXinMenuEntity = new WeiXinMenuEntity();
        weiXinMenuEntity.setMenuName(button.getName());
        weiXinMenuEntity.setAppId(button.getAppid());
        weiXinMenuEntity.setfId(fid);
        weiXinMenuEntity.setMenuId(IDGenerate.getUniqueIdStr());
        weiXinMenuEntity.setMenuKey(button.getKey());
        weiXinMenuEntity.setMenuType(button.getType());
        weiXinMenuEntity.setMenuLevel(fid.equals("0") || fid.equals("") ? 1 : 2);
        weiXinMenuEntity.setMenuUrl(button.getUrl());
        weiXinMenuEntity.setPagePath(button.getPagepath());
        weiXinMenuEntity.setPlatformGroupId(platformGroupId);
        weiXinMenuEntity.setPlatformId(platformId);
        weiXinMenuEntity.setMenuLevel(level);
        weiXinMenuEntity.setSort(sort);
        this.weiXinMenuMapper.insert(weiXinMenuEntity);
        if (button.getSub_button().size() > 0) {
            int sort2 = sort + level;
            for (Button subButton : button.getSub_button()) {
                this.saveMenu(subButton, platformGroupId, platformId, weiXinMenuEntity.getMenuId(), level + 1, sort2, list);
                ++sort2;
            }
        }
    }

    @Override
    public void deleteMenu(String menuId) {
        WeiXinMenuEntity query = new WeiXinMenuEntity();
        query.setfId(menuId);
        PageInfo<WeiXinMenuListVo> pageInfo = this.getMenuList(query);
        if (pageInfo.getTotal() > 0L) {
            pageInfo.getList().forEach(menu -> this.weiXinMenuMapper.deleteByPrimaryKey((Serializable)((Object)menu.getMenuId())));
        }
        this.weiXinMenuMapper.deleteByPrimaryKey((Serializable)((Object)menuId));
    }
}

