/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.domain;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.dao.QuestionClassMapper;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerThankResultEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.iservice.PaperAnswerInterface;
import cc.lechun.organization.iservice.PaperAnswerThankResultInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgQuestionClassDomain
extends BaseService
implements IOrgQuestionClassDomain {
    @Autowired
    private QuestionClassMapper questionClassMapper;
    @Autowired
    PaperAnswerInterface paperAnswerInterface;
    @Autowired
    PaperAnswerThankResultInterface paperAnswerThankResultInterface;

    @Override
    public List<QuestionClassEntity> getQuestionClassEntityList(Integer parrentClassId) {
        QuestionClassEntity questionClassEntity = new QuestionClassEntity();
        questionClassEntity.setParrentClassId(parrentClassId);
        return this.questionClassMapper.getList(questionClassEntity);
    }

    @Override
    public List<QuestionClassEntity> getQuestionClassEntityList() {
        QuestionClassEntity questionClassEntity = new QuestionClassEntity();
        return this.questionClassMapper.getList(questionClassEntity);
    }

    @Override
    public QuestionClassEntity getQuestionClassEntity(Integer classId) {
        return (QuestionClassEntity)this.questionClassMapper.selectByPrimaryKey(classId);
    }

    @Override
    public PageInfo<QuestionClassEntity> getQuestionClassPageList(PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.questionClassMapper.getList(new QuestionClassEntity());
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void save(QuestionClassEntity questionClassEntity) {
        if (questionClassEntity != null) {
            if (questionClassEntity.getClassId() != null && questionClassEntity.getClassId() != 0) {
                this.questionClassMapper.updateByPrimaryKey(questionClassEntity);
            } else {
                this.questionClassMapper.insert(questionClassEntity);
            }
        }
    }

    @Override
    public boolean insert(QuestionClassEntity questionClassEntity) {
        return this.questionClassMapper.insert(questionClassEntity) > 0;
    }

    @Override
    public boolean update(QuestionClassEntity QuestionClassEntity2) {
        return this.questionClassMapper.updateByPrimaryKeySelective(QuestionClassEntity2) > 0;
    }

    @Override
    public boolean delete(Integer id) {
        return this.questionClassMapper.deleteByPrimaryKey(id) > 0;
    }

    @Override
    public QuestionClassEntity select(Integer id) {
        return (QuestionClassEntity)this.questionClassMapper.selectByPrimaryKey(id);
    }

    @Override
    public QuestionClassEntity getSingle(QuestionClassEntity searchEntity) {
        return (QuestionClassEntity)this.questionClassMapper.getSingle(searchEntity);
    }

    @Override
    public List<QuestionClassEntity> getList(QuestionClassEntity searchEntity) {
        return this.questionClassMapper.getList(searchEntity);
    }

    @Override
    public PageInfo getPageList(int pageNum, int pageSize, QuestionClassEntity search) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.questionClassMapper.getList(search);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void rebuildWeekPaperThankResult() {
        this.questionClassMapper.deleteThanksResult();
        PaperAnswerEntity param = new PaperAnswerEntity();
        param.setQuestionId(15);
        List list = this.paperAnswerInterface.getList(param);
        ArrayList toList = new ArrayList();
        list.forEach(entity -> {
            String answer = entity.getAnswer();
            if (JsonUtils.isValidate((String)answer)) {
                try {
                    ArrayList contents = (ArrayList)JsonUtils.fromJson((String)answer, ArrayList.class);
                    if (contents != null && contents.size() > 0) {
                        contents.forEach(content -> {
                            String toUserId = (String)((LinkedHashMap)content).get("relationUserId");
                            String contentStr = (String)((LinkedHashMap)content).get("content");
                            PaperAnswerThankResultEntity rstEntity = new PaperAnswerThankResultEntity();
                            rstEntity.setUserId(entity.getUserId());
                            rstEntity.setToUserId(toUserId);
                            rstEntity.setContent(contentStr);
                            rstEntity.setCreateTime(entity.getCreateTime());
                            toList.add(rstEntity);
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        if (toList.size() > 0) {
            this.paperAnswerThankResultInterface.batchInsert(toList);
        }
        this.questionClassMapper.updateThankResult();
    }
}

