/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service;

import cc.lechun.apiinvoke.bi.BICustomerDataInvoke;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinTransferCustomerMapper;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinTransferCustomerEntity;
import cc.lechun.qiyeweixin.iservice.QiYeWeiXinContactInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.transfercustomer.TransferCustomerResult;
import weixin.popular.bean.qy.transfercustomer.TransferResult;

@Service
public class QiYeWeiXinContactService
implements QiYeWeiXinContactInterface {
    private static final Logger logger = LoggerFactory.getLogger(QiYeWeiXinContactService.class);
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private QiYeWeiXinTransferCustomerMapper transferCustomerMapper;
    @Autowired
    private DistributorQiyeweixinExternalContactInterface contactInterface;
    @Autowired
    private BICustomerDataInvoke biCustomerDataInvoke;

    @Override
    public BaseJsonVo transferCustomerBatch() {
        String transferSuccessMsg = "Hi\u5c0f\u4f19\u4f34\uff0c\u6765\u548c\u4f60\u8bf4\u4e00\u4e0b\u6211\u5347\u7ea7\u4e86\u8d26\u53f7\u529f\u80fd\uff0c\u9a6c\u4e0a\u4f1a\u81ea\u52a8\u66f4\u65b0\u54c8\uff0c\u7b49\u4e0b\u4e3a\u4f60\u51c6\u5907\u4e86\u300c\u8349\u8393\u539a\u4e73\u5e0c\u814a\u9178\u5976\u300d\u5238\u4f5c\u4e3a\u793c\u7269 :)";
        String token = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        QiYeWeiXinTransferCustomerEntity param = new QiYeWeiXinTransferCustomerEntity();
        param.setTransferStatus(0);
        List<QiYeWeiXinTransferCustomerEntity> list = this.transferCustomerMapper.getUnTransferList(100);
        HashMap transferMap = new HashMap();
        list.forEach(entity -> {
            String key = entity.getHandoverFollowUserId() + ">" + entity.getTakeoverFollowUserId();
            if (transferMap.containsKey(key) && transferMap.get(key) != null) {
                ((List)transferMap.get(key)).add(entity.getExternalUserId());
            } else {
                ArrayList<String> externalIds = new ArrayList<String>(){
                    {
                        this.add(entity.getExternalUserId());
                    }
                };
                transferMap.put(key, externalIds);
            }
        });
        logger.info("\u5f85\u8f6c\u79fb\u540d\u5355\uff1a{}", (Object)JsonUtils.toJson(transferMap, (boolean)false));
        for (String key : transferMap.keySet()) {
            String[] split = key.split(">");
            String handoverId = split[0];
            String takeoverId = split[1];
            List externalIds = (List)transferMap.get(key);
            ArrayList limitExternalIds = new ArrayList();
            for (int i = 0; i < externalIds.size(); ++i) {
                limitExternalIds.add(externalIds.get(i));
                if (i != 100) continue;
                TransferCustomerResult transferCustomerResult = WxApiUtils.transferCustomer((String)token, (String)handoverId, (String)takeoverId, limitExternalIds, (String)transferSuccessMsg);
                if (!transferCustomerResult.isSuccess()) {
                    logger.error("\u6279\u91cf\u8f6c\u79fb\u4f01\u5fae\u5ba2\u6237\u5931\u8d25[handoverId={}][takeoverId={}][i={}][errcode={}][errmsg={}],limitExternalIds:{}", new Object[]{handoverId, takeoverId, i, transferCustomerResult.getErrcode(), transferCustomerResult.getErrmsg(), JsonUtils.toJson((Object)externalIds, (boolean)false)});
                    limitExternalIds.forEach(externalId -> {
                        QiYeWeiXinTransferCustomerEntity entity = new QiYeWeiXinTransferCustomerEntity();
                        entity.setHandoverFollowUserId(handoverId);
                        entity.setTakeoverFollowUserId(takeoverId);
                        entity.setExternalUserId((String)externalId);
                        Integer transferStatus = "0".equals(transferCustomerResult.getErrcode()) ? 1 : 2;
                        this.transferCustomerMapper.updateTransferStatus(handoverId, takeoverId, (String)externalId, transferStatus, null, transferCustomerResult.getErrmsg());
                    });
                } else {
                    logger.info("\u6279\u91cf\u8f6c\u79fb\u4f01\u5fae\u5ba2\u6237\u6210\u529f[handoverId={}][takeoverId={}][i={}][errcode={}][errmsg={}],limitExternalIds:{}", new Object[]{handoverId, takeoverId, i, transferCustomerResult.getErrcode(), transferCustomerResult.getErrmsg(), JsonUtils.toJson((Object)externalIds, (boolean)false)});
                }
                transferCustomerResult.getCustomer().forEach(transferCustomer -> {
                    QiYeWeiXinTransferCustomerEntity entity = new QiYeWeiXinTransferCustomerEntity();
                    entity.setHandoverFollowUserId(handoverId);
                    entity.setTakeoverFollowUserId(takeoverId);
                    entity.setExternalUserId(transferCustomer.getExternalUserId());
                    Integer transferStatus = "0".equals(transferCustomer.getErrcode()) ? 1 : 2;
                    this.transferCustomerMapper.updateTransferStatus(handoverId, takeoverId, transferCustomer.getExternalUserId(), transferStatus, null, transferCustomerResult.getErrmsg());
                });
                limitExternalIds = new ArrayList();
            }
            if (limitExternalIds.size() <= 0) continue;
            TransferCustomerResult transferCustomerResult = WxApiUtils.transferCustomer((String)token, (String)handoverId, (String)takeoverId, limitExternalIds, (String)transferSuccessMsg);
            if (!transferCustomerResult.isSuccess()) {
                logger.error("\u6279\u91cf\u8f6c\u79fb\u4f01\u5fae\u5ba2\u6237\u5931\u8d25[handoverId={}][takeoverId={}][errcode={}][errmsg={}],limitExternalIds:{}", new Object[]{handoverId, takeoverId, transferCustomerResult.getErrcode(), transferCustomerResult.getErrmsg(), JsonUtils.toJson((Object)externalIds, (boolean)false)});
                limitExternalIds.forEach(externalId -> {
                    QiYeWeiXinTransferCustomerEntity entity = new QiYeWeiXinTransferCustomerEntity();
                    entity.setHandoverFollowUserId(handoverId);
                    entity.setTakeoverFollowUserId(takeoverId);
                    entity.setExternalUserId((String)externalId);
                    Integer transferStatus = "0".equals(transferCustomerResult.getErrcode()) ? 1 : 2;
                    logger.info("\u8f6c\u79fb\u5931\u8d25\u6807\u5fd7\u62102\uff0chandoverId={},takeoverId={},externalId={},transferStatus={},errMsg={}", new Object[]{handoverId, takeoverId, externalId, transferStatus, transferCustomerResult.getErrmsg()});
                    this.transferCustomerMapper.updateTransferStatus(handoverId, takeoverId, (String)externalId, transferStatus, null, transferCustomerResult.getErrmsg());
                });
            } else {
                logger.info("\u6279\u91cf\u8f6c\u79fb\u4f01\u5fae\u5ba2\u6237\u6210\u529f[handoverId={}][takeoverId={}][errcode={}][errmsg={}],limitExternalIds:{}", new Object[]{handoverId, takeoverId, transferCustomerResult.getErrcode(), transferCustomerResult.getErrmsg(), JsonUtils.toJson((Object)externalIds, (boolean)false)});
            }
            transferCustomerResult.getCustomer().forEach(transferCustomer -> {
                QiYeWeiXinTransferCustomerEntity entity = new QiYeWeiXinTransferCustomerEntity();
                entity.setHandoverFollowUserId(handoverId);
                entity.setTakeoverFollowUserId(takeoverId);
                entity.setExternalUserId(transferCustomer.getExternalUserId());
                Integer transferStatus = "0".equals(transferCustomer.getErrcode()) ? 1 : 2;
                this.transferCustomerMapper.updateTransferStatus(handoverId, takeoverId, transferCustomer.getExternalUserId(), transferStatus, null, null);
            });
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo checkTransferResult() {
        List<Map<String, String>> waitTransferUserIds = this.transferCustomerMapper.getWaitTransferUserId();
        waitTransferUserIds.forEach(waitTransferUserId -> {
            String handover_userid = (String)waitTransferUserId.get("handover_userid");
            String takeover_userid = (String)waitTransferUserId.get("takeover_userid");
            String cursor = "";
            do {
                String token;
                TransferResult transferResult;
                cursor = (transferResult = WxApiUtils.getTransferResult((String)(token = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue())), (String)handover_userid, (String)takeover_userid, (String)cursor)).getNextCursor() == null ? "" : transferResult.getNextCursor();
                transferResult.getCustomer().forEach(transferCustomer -> {
                    Integer transferStatus = null;
                    String failReason = "";
                    Date transferTime = null;
                    if (transferCustomer.getStatus() == 1) {
                        transferStatus = 3;
                        transferTime = new Date(transferCustomer.getTakeoverTime() * 1000L);
                    } else if (transferCustomer.getStatus() != 2) {
                        if (transferCustomer.getStatus() == 3) {
                            transferStatus = 4;
                            failReason = "customer_refused";
                        } else if (transferCustomer.getStatus() == 4) {
                            transferStatus = 4;
                            failReason = "customer_limit_exceed";
                        } else if (transferCustomer.getStatus() == 5) {
                            transferStatus = 2;
                        }
                    }
                    if (transferStatus != null) {
                        this.transferOver(transferStatus, handover_userid, takeover_userid, transferCustomer.getExternalUserId(), failReason, transferTime);
                    }
                });
            } while (StringUtils.isNotEmpty((String)cursor));
        });
        return BaseJsonVo.success((Object)"\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo transferOver(Integer transferStatus, String handoverUserId, String takeoverUserId, String externalUserID, String failReason, Date transferTime) {
        logger.info("\u8f6c\u79fb\u5931\u8d254-0\uff1atransferStatus={},handoverUserId={},takeoverUserId={},externalUserID={},failReason={},transferTime={}", new Object[]{transferStatus, handoverUserId, takeoverUserId, externalUserID, failReason, transferTime});
        logger.info("\u8f6c\u79fb\u5931\u8d254-1");
        if (transferStatus == null || StringUtils.isEmpty((String)takeoverUserId) || StringUtils.isEmpty((String)externalUserID)) {
            logger.info("\u8f6c\u79fb\u5931\u8d254-2");
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        logger.info("\u8f6c\u79fb\u5931\u8d254-3");
        int i = this.transferCustomerMapper.updateTransferStatus(handoverUserId, takeoverUserId, externalUserID, transferStatus, transferTime, failReason);
        logger.info("\u8f6c\u79fb\u5931\u8d254-4\uff0ci={}", (Object)i);
        return i > 0 ? BaseJsonVo.success((String)"\u66f4\u65b0\u6210\u529f", null) : BaseJsonVo.success((String)"\u6ca1\u6709\u66f4\u65b0\u8bb0\u5f55", null);
    }

    @Override
    public Boolean isTransferTakeOverRelation(String externalUserid, String qyWeixinUserid) {
        QiYeWeiXinTransferCustomerEntity param = new QiYeWeiXinTransferCustomerEntity();
        param.setExternalUserId(externalUserid);
        param.setTakeoverFollowUserId(qyWeixinUserid);
        return this.transferCustomerMapper.getList(param).size() > 0;
    }

    @Override
    public Boolean isTransferHandOverRelation(String externalUserid, String qyWeixinUserid) {
        QiYeWeiXinTransferCustomerEntity param = new QiYeWeiXinTransferCustomerEntity();
        param.setExternalUserId(externalUserid);
        param.setHandoverFollowUserId(qyWeixinUserid);
        return this.transferCustomerMapper.getList(param).size() > 0;
    }

    @Override
    public BaseJsonVo getQwListForTransfer() {
        BaseJsonVo<List<Map<String, Object>>> contactCountRst = this.biCustomerDataInvoke.getContactCount();
        if (!contactCountRst.isSuccess()) {
            return contactCountRst;
        }
        List contactCount = (List)contactCountRst.getValue();
        if (contactCount != null && contactCount.size() > 0) {
            contactCount.forEach(qw -> {
                String qwId = qw.get("qwId").toString();
                BaseJsonVo<Integer> canTransferCountRst = this.biCustomerDataInvoke.getTransferableCount(qwId);
                if (canTransferCountRst.isSuccess() && canTransferCountRst.getValue() != null) {
                    qw.put("canTransferCount", canTransferCountRst.getValue());
                } else {
                    qw.put("canTransferCount", 0);
                }
            });
        }
        return BaseJsonVo.success((Object)contactCount);
    }

    @Override
    public BaseJsonVo autoTransferCustomer() {
        return BaseJsonVo.error((String)"\u65b9\u6cd5\u8fd8\u6ca1\u5199\u5b8c\uff0c\u81ea\u52a8\u8fc1\u79fb\u4e0d\u53ef\u7528");
    }

    @Override
    public BaseJsonVo manualTransferCustomer(List<Map<String, Object>> handOver, List<Map<String, Object>> takeOver) {
        ArrayList<String> handOverIds = new ArrayList<String>();
        handOver.forEach(map -> handOverIds.add((String)map.get("qwID")));
        this.transferCustomerMapper.importCanTransferExternalToNameListTable(handOverIds);
        handOver.forEach(qwUser -> {
            Map<String, BigDecimal> chosenCountMap = this.transferCustomerMapper.chosenCountMap((String)qwUser.get("qwID"), (Integer)qwUser.get("count"));
            this.transferCustomerMapper.choseCount((String)qwUser.get("qwID"), 1, chosenCountMap.get("TYPE_1").intValue());
            this.transferCustomerMapper.choseCount((String)qwUser.get("qwID"), 2, chosenCountMap.get("TYPE_2").intValue());
            this.transferCustomerMapper.choseCount((String)qwUser.get("qwID"), 3, chosenCountMap.get("TYPE_3").intValue());
        });
        this.transferCustomerMapper.deleteUnChosen();
        takeOver.forEach(qwUser -> {
            Map<String, BigDecimal> takeCountMap = this.transferCustomerMapper.takeCountMap((Integer)qwUser.get("count"));
            this.transferCustomerMapper.takeCount((String)qwUser.get("qwID"), 1, takeCountMap.get("TYPE_1").intValue());
            this.transferCustomerMapper.takeCount((String)qwUser.get("qwID"), 2, takeCountMap.get("TYPE_2").intValue());
            this.transferCustomerMapper.takeCount((String)qwUser.get("qwID"), 3, takeCountMap.get("TYPE_3").intValue());
        });
        this.transferCustomerMapper.insertToTransfer();
        return BaseJsonVo.success((Object)"\u540d\u5355\u6574\u7406\u6210\u529f\uff0c\u5f00\u59cb\u8f6c\u79fb");
    }

    @Override
    public void userSumDaily() {
        try {
            this.transferCustomerMapper.userSumDaily();
        }
        catch (Exception e) {
            logger.error("\u6bcf\u65e5\u7edf\u8ba1\u4f01\u5fae\u7528\u6237\u6570\u62a5\u9519", (Throwable)e);
        }
        try {
            this.transferCustomerMapper.userSumDailyByQw();
        }
        catch (Exception e) {
            logger.error("\u6bcf\u65e5\u7edf\u8ba1\u5355\u4e2a\u4f01\u5fae\u7528\u6237\u6570\u62a5\u9519", (Throwable)e);
        }
        try {
            String currentDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-1), (String)"yyyy-MM-dd");
            this.transferCustomerMapper.backUpQwCustomer("t_qw_customer_" + currentDate);
        }
        catch (Exception e) {
            logger.error("\u6bcf\u65e5\u5907\u4efd\u4f01\u5fae\u7528\u6237\u8868\u62a5\u9519", (Throwable)e);
        }
    }

    @Override
    public BaseJsonVo getResignationCustomer() {
        return null;
    }

    private /* synthetic */ void lambda$autoTransferCustomer$8(Map handOver) {
        String qwUserId = (String)handOver.get("qy_weixin_userid");
        Integer qwCount = (Integer)handOver.get("_COU");
        Integer needTransferCount = qwCount - 4500;
        Integer canTransferCount = this.transferCustomerMapper.getCanTransferCount(qwUserId);
    }
}

