/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.callback;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.qiyeweixin.iservice.QiYeWeiXinContactInterface;
import cc.lechun.qiyeweixin.iservice.tag.CorpTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.CustomerTagInterface;
import cc.lechun.qiyeweixin.service.callback.ICorpChangeCallBack;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.iservice.contact.CustomerContactQrcodeInterface;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="change_external_contact")
public class ChangeExternalContactHandle
implements ICorpChangeCallBack {
    private static final Logger logger = LoggerFactory.getLogger(ChangeExternalContactHandle.class);
    String ADD_EXTERNAL_CONTACT = "add_external_contact";
    String EDIT_EXTERNAL_CONTACT = "edit_external_contact";
    String DEL_EXTERNAL_CONTACT = "del_external_contact";
    String DEL_FOLLOW_USER = "del_follow_user";
    String TRANSFER_FAIL = "transfer_fail";
    @Autowired
    DistributorInterface distributorService;
    @Lazy
    @Autowired
    RouteCustomerInterface routeCustomerInterface;
    @Autowired
    QiYeWeiXinContactInterface qiYeWeiXinContactInterface;
    @Autowired
    CustomerContactQrcodeInterface customerContactQrcodeInterface;
    @Autowired
    CorpTagInterface corpTagService;
    @Autowired
    CustomerTagInterface customerTagService;

    @Override
    public String callBack(JSONObject jsonObject) {
        JSONObject xmlJsonObject = jsonObject.getJSONObject("xml");
        String changeType = xmlJsonObject.getString("changetype");
        String wxCorpId = xmlJsonObject.getString("tousername");
        if (this.ADD_EXTERNAL_CONTACT.equals(changeType)) {
            BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> baseJsonVo = this.save(xmlJsonObject);
            if (baseJsonVo.isSuccess() && baseJsonVo.getValue() != null && ((List)baseJsonVo.getValue()).size() > 0) {
                ExecutorService pool = Executors.newFixedThreadPool(1);
                try {
                    CompletableFuture<Void> addRouteCustomerCompletableFuture = CompletableFuture.runAsync(() -> {
                        this.routeCustomerInterface.saveRouteCustomer(xmlJsonObject.getString("externaluserid"), ((DistributorQiyeweixinExternalContactEntity)((List)baseJsonVo.getValue()).get(0)).getCustomerId(), xmlJsonObject.getString("state"), xmlJsonObject.getString("welcomecode"), xmlJsonObject.getString("userid"));
                        this.corpTagService.markTag(xmlJsonObject.getString("externaluserid"), xmlJsonObject.getString("state"), xmlJsonObject.getString("userid"));
                    }, pool);
                    pool.shutdown();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    e.printStackTrace();
                    pool.shutdown();
                }
            }
        } else if (this.EDIT_EXTERNAL_CONTACT.equals(changeType)) {
            this.save(xmlJsonObject);
        } else if (this.DEL_EXTERNAL_CONTACT.equals(changeType)) {
            this.distributorService.deleteExternalContact(xmlJsonObject.getString("userid"), xmlJsonObject.getString("externaluserid"), 3, xmlJsonObject.containsKey((Object)"source") && "DELETE_BY_TRANSFER".equals(xmlJsonObject.getString("source")));
        } else if (this.DEL_FOLLOW_USER.equals(changeType)) {
            this.distributorService.deleteExternalContact(xmlJsonObject.getString("userid"), xmlJsonObject.getString("externaluserid"), 2, xmlJsonObject.containsKey((Object)"source") && "DELETE_BY_TRANSFER".equals(xmlJsonObject.getString("source")));
        } else if (this.TRANSFER_FAIL.equals(changeType)) {
            logger.info("\u8f6c\u79fb\u5931\u8d251");
            String takeoverUserId = xmlJsonObject.getString("userid");
            logger.info("\u8f6c\u79fb\u5931\u8d252\uff0ctakeoverUserId={}", (Object)takeoverUserId);
            String externalUserID = xmlJsonObject.getString("externaluserid");
            logger.info("\u8f6c\u79fb\u5931\u8d253\uff0cexternalUserID={}", (Object)externalUserID);
            String failReason = xmlJsonObject.getString("failreason");
            logger.info("\u8f6c\u79fb\u5931\u8d254\uff0cfailReason={}", (Object)failReason);
            Date transferTime = new Date(xmlJsonObject.getLong("createtime") * 1000L);
            BaseJsonVo baseJsonVo = this.qiYeWeiXinContactInterface.transferOver(4, null, takeoverUserId, externalUserID, failReason, transferTime);
            logger.info("\u8f6c\u79fb\u5931\u8d255\uff0cbaseJsonVo={}", (Object)JsonUtils.toJson((Object)baseJsonVo, (boolean)false));
        }
        return "";
    }

    private BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> save(JSONObject xmlJsonObject) {
        return this.distributorService.addOrUpdateExternalContact((Integer)AppEnum.SCRM.getValue(), xmlJsonObject.getString("userid"), xmlJsonObject.getString("externaluserid"));
    }

    private void scanCodeAddCustomer(JSONObject xmlJsonObject) {
        BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> baseJsonVo = this.save(xmlJsonObject);
        this.routeCustomerInterface.saveRouteCustomer(xmlJsonObject.getString("externaluserid"), ((DistributorQiyeweixinExternalContactEntity)((List)baseJsonVo.getValue()).get(0)).getCustomerId(), xmlJsonObject.getString("state"), xmlJsonObject.getString("welcomecode"), xmlJsonObject.getString("userid"));
    }
}

