/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.callback;

import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinCallbackMapper;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinCallbackEntity;
import cc.lechun.qiyeweixin.service.callback.ICorpChangeCallBack;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CorpCallBackContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    WeiXinBaseAccessToken weiXinBaseInterface;
    @Autowired
    QiYeWeiXinCallbackMapper qiYeWeiXinCallbackMapper;
    private final Map<String, ICorpChangeCallBack> callBackMap = new ConcurrentHashMap<String, ICorpChangeCallBack>();

    @Autowired
    public CorpCallBackContext(Map<String, ICorpChangeCallBack> callBackMap) {
        this.callBackMap.clear();
        callBackMap.forEach((k, v) -> this.callBackMap.put((String)k, (ICorpChangeCallBack)v));
    }

    public String callBack(String dataJson) {
        this.logger.info("\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03\u53c2\u6570:{}", (Object)dataJson);
        JSONObject jsonObject = JSON.parseObject((String)dataJson);
        this.saveCallBack(jsonObject);
        String event = jsonObject.getJSONObject("xml").getString("event");
        if (this.callBackMap.containsKey(event)) {
            this.callBackMap.get(event).callBack(jsonObject);
        }
        return "success";
    }

    private void saveCallBack(JSONObject jsonObject) {
        new Thread(() -> {
            try {
                JSONObject xml = jsonObject.getJSONObject("xml");
                QiYeWeiXinCallbackEntity callback = new QiYeWeiXinCallbackEntity();
                callback.setNoticeTime(new Date());
                callback.setFullText(jsonObject.toJSONString());
                if (xml.containsKey((Object)"fromusername")) {
                    callback.setFromUserName(xml.getString("fromusername"));
                }
                if (xml.containsKey((Object)"tousername")) {
                    callback.setToUserName(xml.getString("tousername"));
                }
                if (xml.containsKey((Object)"createtime")) {
                    callback.setCreateTime(new Date(xml.getLong("createtime") * 1000L));
                }
                if (xml.containsKey((Object)"msgtype")) {
                    callback.setMsgType(xml.getString("msgtype"));
                }
                if (xml.containsKey((Object)"event")) {
                    callback.setEvent(xml.getString("event"));
                }
                if (xml.containsKey((Object)"changetype")) {
                    callback.setChangeType(xml.getString("changetype"));
                }
                if (xml.containsKey((Object)"userid")) {
                    callback.setUserId(xml.getString("userid"));
                }
                if (xml.containsKey((Object)"externaluserid")) {
                    callback.setExternalUserId(xml.getString("externaluserid"));
                }
                if (xml.containsKey((Object)"state")) {
                    callback.setState(xml.getString("state"));
                }
                if (xml.containsKey((Object)"welcomecode")) {
                    callback.setWelcomeCode(xml.getString("welcomecode"));
                }
                if (xml.containsKey((Object)"source")) {
                    callback.setSource(xml.getString("source"));
                }
                if (xml.containsKey((Object)"failreason")) {
                    callback.setFailReason(xml.getString("failreason"));
                }
                if (xml.containsKey((Object)"chatid")) {
                    callback.setChatId(xml.getString("chatid"));
                }
                if (xml.containsKey((Object)"updatedetail")) {
                    callback.setUpdateDetail(xml.getString("updatedetail"));
                }
                if (xml.containsKey((Object)"joinscene")) {
                    callback.setJoinScene(xml.getInteger("joinscene"));
                }
                if (xml.containsKey((Object)"quitscene")) {
                    callback.setQuitScene(xml.getInteger("quitscene"));
                }
                if (xml.containsKey((Object)"memchangecnt")) {
                    callback.setMemChangeCnt(xml.getInteger("memchangecnt"));
                }
                if (xml.containsKey((Object)"id")) {
                    callback.setTagId(xml.getString("id"));
                }
                if (xml.containsKey((Object)"tagtype")) {
                    callback.setTagType(xml.getInteger("tagtype"));
                }
                if (xml.containsKey((Object)"strategyid")) {
                    callback.setStrategyId(xml.getInteger("strategyid"));
                }
                this.qiYeWeiXinCallbackMapper.insert(callback);
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03\u5931\u8d25\uff0c\u56de\u8c03\u5185\u5bb9\uff1a{}", (Object)jsonObject.toJSONString(), (Object)e);
            }
        }).start();
    }
}

