/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.chatdata;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.qiyeweixin.dao.chatdata.ChatDataMapper;
import cc.lechun.qiyeweixin.iservice.chatdata.ChatDataHandle;
import cc.lechun.qiyeweixin.iservice.chatdata.ChatDataInterface;
import cc.lechun.qiyeweixin.util.FinanceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatDataService
implements ChatDataInterface {
    private static final Logger logger = LoggerFactory.getLogger(ChatDataService.class);
    @Autowired
    private ChatDataMapper chatDataMapper;
    @Autowired
    OssService ossService;
    private Map<String, ChatDataHandle> chatDataHandleMap = new HashMap<String, ChatDataHandle>();

    @Autowired
    public void setChatDataHandleMap(Map<String, ChatDataHandle> chatDataHandleMap) {
        this.chatDataHandleMap.clear();
        chatDataHandleMap.forEach((k, v) -> this.chatDataHandleMap.put((String)k, (ChatDataHandle)v));
    }

    @Override
    public BaseJsonVo batchSyncChatData() {
        BaseJsonVo baseJsonVo;
        int i;
        Date start = DateUtils.now();
        logger.info("\u6279\u91cf\u540c\u6b65\u804a\u5929\u8bb0\u5f55\uff0c\u5f00\u59cb\u65f6\u95f4:{}", (Object)DateUtils.formatDate((Date)start, (String)""));
        for (i = 0; i < 100 && (baseJsonVo = this.syncChatData(null, null)).isSuccess() && (Integer)baseJsonVo.getValue() >= 1000; ++i) {
        }
        Date end = DateUtils.now();
        logger.info("\u6279\u91cf\u540c\u6b65\u804a\u5929\u8bb0\u5f55\uff0c\u7ed3\u675f\u65f6\u95f4:{}", (Object)DateUtils.formatDate((Date)end, (String)""));
        logger.info("\u6279\u91cf\u540c\u6b65\u804a\u5929\u8bb0\u5f55\uff0c\u540c\u6b65\u4e86{}\u6b21\uff0c\u8017\u65f6{}\u79d2", (Object)(i + 1), (Object)DateUtils.getDateDiffSecond((Date)start, (Date)end));
        return BaseJsonVo.success((Object)i);
    }

    @Override
    public BaseJsonVo syncChatData(Integer seq, Integer limit) {
        BaseJsonVo dataRst;
        if (seq == null) {
            seq = this.chatDataMapper.getMaxSeq();
            seq = seq == null ? 0 : seq;
        }
        if (!(dataRst = FinanceUtil.getChatData(seq, limit)).isSuccess()) {
            return dataRst;
        }
        Map map = (Map)dataRst.getValue();
        List successResult = (List)map.get("successResult");
        List failedSeq = (List)map.get("failedSeq");
        successResult.forEach(chatDataJsonObject -> {
            logger.info("\u540c\u6b65\u4f01\u5fae\u804a\u5929\u8bb0\u5f55\uff0c\u4fdd\u5b58\u5bf9\u8c61\uff1a{}", (Object)chatDataJsonObject.toString());
            if (chatDataJsonObject.get("action") != null && !"switch".equals(chatDataJsonObject.get("action"))) {
                String msgType = (String)chatDataJsonObject.get("msgtype");
                if (this.chatDataHandleMap.containsKey(msgType)) {
                    try {
                        Map<String, Object> transform = this.chatDataHandleMap.get(msgType).transform((JSONObject)chatDataJsonObject);
                        logger.info("\u540c\u6b65\u4f01\u5fae\u804a\u5929\u8bb0\u5f55\uff0c\u4fdd\u5b58\u5bf9\u8c61\u8f6c\u5316\u540e\uff1a{}", (Object)JsonUtils.toJson(transform, (boolean)false));
                        int i = this.chatDataMapper.insert(transform);
                        logger.info("\u540c\u6b65\u4f01\u5fae\u804a\u5929\u8bb0\u5f55\uff0c\u4fdd\u5b58\u5bf9\u8c61\u5230\u6570\u636e\u5e93\uff1a{}", (Object)i);
                        if (transform.containsKey("speak_type")) {
                            // empty if block
                        }
                        new Thread(() -> {
                            try {
                                if ("image".equals(msgType) || "voice".equals(msgType) || "video".equals(msgType) || "emotion".equals(msgType) || "file".equals(msgType)) {
                                    this.getChatDataMedia((String)transform.get("msgid"), (String)transform.get("msgtype"), transform.containsKey("emotion_type") ? (Integer)transform.get("emotion_type") : null, transform.containsKey(msgType + "_fileext") ? (String)transform.get(msgType + "_fileext") : null, transform.containsKey(msgType + "_sdkfileid") ? (String)transform.get(msgType + "_sdkfileid") : null, null);
                                }
                            }
                            catch (Exception e) {
                                logger.error("{}\u540c\u6b65\u804a\u5929\u8bb0\u5f55\u65f6\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25", transform.get("msgid"), (Object)e);
                            }
                        }).start();
                    }
                    catch (Exception e) {
                        logger.error("[seq={}]\u540c\u6b65\u4f01\u5fae\u804a\u5929\u8bb0\u5f55\uff0c\u4fdd\u5b58\u65f6\u53d1\u751f\u9519\u8bef", (Object)chatDataJsonObject.getInt("seq"), (Object)e);
                        failedSeq.add(chatDataJsonObject.getInt("seq"));
                    }
                } else {
                    failedSeq.add(chatDataJsonObject.getInt("seq"));
                }
            }
        });
        if (failedSeq.size() > 0) {
            StringBuilder sb = new StringBuilder();
            failedSeq.forEach(failSeq -> sb.append("(").append(failSeq).append("),"));
            this.chatDataMapper.insertFailedData(sb.deleteCharAt(sb.length() - 1).toString());
        }
        return BaseJsonVo.success((Object)(successResult.size() + failedSeq.size()));
    }

    @Override
    public BaseJsonVo syncChatDataMedia() {
        List<Map<String, Object>> medias = this.chatDataMapper.getChatMediaList();
        medias.forEach(media -> this.getChatDataMedia((String)media.get("MSGID"), (String)media.get("MSGTYPE"), (Integer)media.get("EMOTION_TYPE"), (String)media.get("FILE_FILEEXT"), (String)media.get("SDKFILEID"), null));
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getChatDataMedia(String msgid, String msgtype, Integer emotionType, String fileext, String sdkfileid, String mixed) {
        String fileName = FinanceUtil.pullMediaFiles(msgid, msgtype, emotionType, fileext, sdkfileid, mixed);
        if (StringUtils.isNotEmpty((String)fileName) && !fileName.startsWith("\u5931\u8d25\uff1a")) {
            this.chatDataMapper.insertLocalMedia(msgid, 1, fileName, null);
            this.uploadChatDataMedia(msgid, fileName);
            return BaseJsonVo.success(null);
        }
        logger.error("msgid:{},\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)msgid, (Object)fileName);
        this.chatDataMapper.insertLocalMedia(msgid, 0, null, fileName);
        return BaseJsonVo.error((String)fileName);
    }

    @Override
    public BaseJsonVo syncUploadChatDataMedia() {
        List<Map<String, Object>> medias = this.chatDataMapper.getUnUploadMedia();
        medias.forEach(media -> this.uploadChatDataMedia((String)media.get("MSGID"), (String)media.get("FILE_NAME")));
        return BaseJsonVo.success((Object)"\u4e0a\u4f20\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo uploadChatDataMedia(String msgId, String fileName) {
        String fullFileName = "/var/lechun/cms/chat-media/" + fileName;
        String errMsg = null;
        try {
            FileInputStream is = new FileInputStream(fullFileName);
            String uploadFileName = this.ossService.uploadFile(AliyunOSSDir.QW_CHAT_MEDIA, fileName, is);
            is.close();
            if (StringUtils.isNotEmpty((String)uploadFileName)) {
                this.chatDataMapper.updateUploadMediaSucc(msgId, uploadFileName);
                File file = new File(fullFileName);
                if (file.exists()) {
                    file.delete();
                }
            } else {
                errMsg = "\u4e0a\u4f20OSS\u5931\u8d25";
            }
        }
        catch (FileNotFoundException e) {
            logger.info("\u4e0d\u5728\u8fd9\u53f0\u673a\u5668\u4e0a");
            return BaseJsonVo.error();
        }
        catch (Exception e) {
            logger.error("{}\u4f01\u5fae\u804a\u5929\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25", (Object)msgId, (Object)e);
            errMsg = e.getMessage();
        }
        this.chatDataMapper.updateUploadMediaFail(msgId, errMsg);
        return BaseJsonVo.success(null);
    }
}

