/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.group;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinGroupAdminMapper;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinGroupMapper;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinGroupMemberMapper;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinGroupAdminEntity;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinGroupEntity;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinGroupMemberEntity;
import cc.lechun.qiyeweixin.iservice.group.GroupInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.groupchat.GroupChatInfoResult;
import weixin.popular.bean.qy.groupchat.GroupChatListResult;

@Service
public class GroupService
implements GroupInterface {
    private static final Logger logger = LoggerFactory.getLogger(GroupService.class);
    @Autowired
    private QiYeWeiXinGroupMapper groupMapper;
    @Autowired
    private QiYeWeiXinGroupAdminMapper groupAdminMapper;
    @Autowired
    private QiYeWeiXinGroupMemberMapper groupMemberMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;

    @Override
    public BaseJsonVo syncGroupList() {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        GroupChatListResult groupChatListResult = WxApiUtils.groupChatList((String)accessToken, null, null, null, null);
        if (!groupChatListResult.isSuccess()) {
            logger.error("\u540c\u6b65\u4f01\u5fae\u7fa4\u5931\u8d25\uff1a{}", (Object)JsonUtils.toJson((Object)groupChatListResult, (boolean)false));
            return BaseJsonVo.error((String)groupChatListResult.getErrmsg());
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        groupChatListResult.getGroupChatList().forEach(group -> {
            groupIds.add(group.getChatId());
            QiYeWeiXinGroupEntity existGroup = (QiYeWeiXinGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)group.getChatId()));
            if (existGroup != null && existGroup.getGroupStatus().intValue() != group.getStatus().intValue()) {
                this.groupMapper.updateByPrimaryKeySelective(existGroup);
            } else if (existGroup == null) {
                QiYeWeiXinGroupEntity entity = new QiYeWeiXinGroupEntity();
                entity.setChatId(group.getChatId());
                entity.setGroupStatus(group.getStatus());
                entity.setGroupDismiss(0);
                this.groupMapper.insert(entity);
            }
        });
        if (groupIds.size() > 0) {
            this.groupMapper.deleteGroup(groupIds);
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo syncGroupInfoBatch() {
        this.syncGroupList();
        List list = this.groupMapper.getList(new QiYeWeiXinGroupEntity());
        list.forEach(entity -> this.syncGroupInfo((QiYeWeiXinGroupEntity)entity));
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo syncGroupInfo(String chatId) {
        QiYeWeiXinGroupEntity group = (QiYeWeiXinGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)chatId));
        return group == null ? BaseJsonVo.error((String)"\u4e0d\u5b58\u5728") : this.syncGroupInfo(group);
    }

    @Override
    public BaseJsonVo syncGroupInfo(QiYeWeiXinGroupEntity group) {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        GroupChatInfoResult groupChatInfoResult = WxApiUtils.groupChatInfo((String)accessToken, (String)group.getChatId(), (Integer)0);
        if (!groupChatInfoResult.isSuccess()) {
            logger.error("\u540c\u6b65\u4f01\u5fae\u7fa4\u4fe1\u606f\u5931\u8d25[{}]:[{}]{}", new Object[]{group.getChatId(), groupChatInfoResult.getErrcode(), groupChatInfoResult.getErrmsg()});
            return BaseJsonVo.error((String)(groupChatInfoResult.getErrcode() + groupChatInfoResult.getErrmsg()));
        }
        group.setCreateTime(new Date(groupChatInfoResult.getGroupChat().getCreateTime() * 1000L));
        group.setGroupName(groupChatInfoResult.getGroupChat().getName());
        group.setGroupOwner(groupChatInfoResult.getGroupChat().getOwner());
        group.setGroupNotice(groupChatInfoResult.getGroupChat().getNotice());
        group.setLastUpdateTime(DateUtils.now());
        this.groupMapper.updateByPrimaryKeySelective(group);
        ArrayList<String> memberIds = new ArrayList<String>();
        groupChatInfoResult.getGroupChat().getMemberList().forEach(member -> {
            memberIds.add(member.getUserid());
            QiYeWeiXinGroupMemberEntity memberEntity = new QiYeWeiXinGroupMemberEntity();
            memberEntity.setChatId(group.getChatId());
            memberEntity.setMemberExternalUserId(member.getUserid());
            List list = this.groupMemberMapper.getList(memberEntity);
            if (list != null && list.size() == 1) {
                memberEntity = (QiYeWeiXinGroupMemberEntity)list.get(0);
            } else if (list != null && list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    this.groupMemberMapper.deleteByPrimaryKey(((QiYeWeiXinGroupMemberEntity)list.get(i)).getId());
                }
            }
            memberEntity.setMemberType(member.getType());
            memberEntity.setMemberUnionid(member.getUnionId());
            memberEntity.setJoinTime(new Date(member.getJoinTime() * 1000L));
            memberEntity.setJoinScene(member.getJoinScene());
            memberEntity.setInvitorUserId(member.getInvitor() != null ? member.getInvitor().getUserid() : null);
            memberEntity.setGroupNickName(member.getGroupNickName());
            memberEntity.setMemberName(member.getName());
            memberEntity.setCreateTime(memberEntity.getJoinTime());
            this.groupMemberMapper.insertOrUpdate(memberEntity);
        });
        if (memberIds.size() > 0) {
            this.groupMemberMapper.deleteMember(group.getChatId(), memberIds);
        }
        ArrayList<String> adminIds = new ArrayList<String>();
        groupChatInfoResult.getGroupChat().getAdminList().forEach(admin -> {
            adminIds.add(admin.getUserid());
            QiYeWeiXinGroupAdminEntity adminEntity = new QiYeWeiXinGroupAdminEntity();
            adminEntity.setChatId(group.getChatId());
            adminEntity.setGroupFollowUserId(admin.getUserid());
            List list = this.groupAdminMapper.getList(adminEntity);
            if (list != null && list.size() == 1) {
                adminEntity = (QiYeWeiXinGroupAdminEntity)list.get(0);
            } else if (list != null && list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    this.groupAdminMapper.deleteByPrimaryKey(((QiYeWeiXinGroupAdminEntity)list.get(i)).getId());
                }
            }
            adminEntity.setCreateTime(group.getCreateTime());
            this.groupAdminMapper.insertOrUpdate(adminEntity);
        });
        if (adminIds.size() > 0) {
            this.groupAdminMapper.deleteAdmin(group.getChatId(), adminIds);
        }
        return BaseJsonVo.success((String)"\u540c\u6b65\u6210\u529f", null);
    }
}

