/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.moment;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.moment.MomentMapper;
import cc.lechun.qiyeweixin.iservice.moment.MomentInterface;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.moment.MomentCommentResult;
import weixin.popular.bean.qy.moment.MomentListResult;
import weixin.popular.bean.qy.moment.MomentTaskListResult;

@Service
public class MomentService
implements MomentInterface {
    private static final Logger logger = LoggerFactory.getLogger(MomentService.class);
    @Autowired
    MomentMapper momentMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private RedisService redisService;

    @Override
    public BaseJsonVo syncMoment(String startTimeStr) {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        Date startTime = null;
        startTime = StringUtils.isNotEmpty((String)startTimeStr) ? DateUtils.getDateFromString((String)startTimeStr) : this.momentMapper.getMaxCreateTime();
        Date endTime = DateUtils.getAddDateByDay((Date)startTime, (int)30);
        String cursor = null;
        int i = 1;
        while (true) {
            MomentListResult momentList;
            if (!(momentList = WxApiUtils.getMomentList((String)accessToken, (Long)(startTime.getTime() / 1000L), (Long)(endTime.getTime() / 1000L), null, null, cursor, null)).isSuccess()) {
                logger.error("\u540c\u6b65\u670b\u53cb\u5708\u5931\u8d25[{}]:{}", (Object)momentList.getErrcode(), (Object)momentList.getErrmsg());
                return BaseJsonVo.error((String)("\u540c\u6b65\u670b\u53cb\u5708\u5931\u8d25[" + momentList.getErrcode() + "]:" + momentList.getErrmsg()));
            }
            if (momentList.getMomentList() != null && momentList.getMomentList().size() > 0) {
                momentList.getMomentList().forEach(momentInfo -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("momentId", momentInfo.getMomentId());
                    map.put("creator", momentInfo.getCreator());
                    map.put("createTime", new Date(Long.valueOf(momentInfo.getCreateTime()) * 1000L));
                    map.put("createType", momentInfo.getCreateType());
                    map.put("visibleType", momentInfo.getVisibleType());
                    map.put("textContent", momentInfo.getText() != null && momentInfo.getText().getContent() != null ? momentInfo.getText().getContent() : null);
                    if (momentInfo.getImage() != null && momentInfo.getImage().size() > 0) {
                        momentInfo.getImage().forEach(momentInfoImage -> map.put("imageMediaId", map.get("imageMediaId") + momentInfoImage.getMediaId() + ","));
                    } else {
                        map.put("imageMediaId", null);
                    }
                    map.put("videoMediaId", momentInfo.getVideo() != null && momentInfo.getVideo().getMediaId() != null ? momentInfo.getVideo().getMediaId() : null);
                    map.put("videoThumbMediaId", momentInfo.getVideo() != null && momentInfo.getVideo().getThumbMediaId() != null ? momentInfo.getVideo().getThumbMediaId() : null);
                    map.put("linkTitle", momentInfo.getLink() != null && momentInfo.getLink().getTitle() != null ? momentInfo.getLink().getTitle() : null);
                    map.put("linkUrl", momentInfo.getLink() != null && momentInfo.getLink().getUrl() != null ? momentInfo.getLink().getUrl() : null);
                    map.put("locationLatitude", momentInfo.getLocation() != null && momentInfo.getLocation().getLatitude() != null ? momentInfo.getLocation().getLatitude() : null);
                    map.put("locationLongitude", momentInfo.getLocation() != null && momentInfo.getLocation().getLongitude() != null ? momentInfo.getLocation().getLongitude() : null);
                    map.put("locationName", momentInfo.getLocation() != null && momentInfo.getLocation().getName() != null ? momentInfo.getLocation().getName() : null);
                    this.momentMapper.insert(map);
                });
            }
            if (StringUtils.isNotEmpty((String)momentList.getNextCursor())) {
                cursor = momentList.getNextCursor();
            } else {
                startTime = endTime;
                endTime = DateUtils.getAddDateByDay((Date)startTime, (int)30);
                cursor = null;
            }
            if (startTime.compareTo(DateUtils.now()) > 0) break;
            ++i;
        }
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo syncMomentPublish() {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        List<Map<String, Object>> moments = this.momentMapper.getAllMoment();
        logger.info("\u83b7\u53d6\u5230\u670b\u53cb\u5708\u6761\u6570:{}", (Object)moments.size());
        String[] cursor = new String[]{null};
        moments.forEach(moment -> {
            for (int i = 0; StringUtils.isNotEmpty((String)cursor[0]) || i == 0; ++i) {
                MomentTaskListResult momentTaskListResult = WxApiUtils.getMomentTask((String)accessToken, (String)((String)moment.get("MOMENT_ID")), (String)cursor[0], null);
                logger.info("\u7b2c{}\u6b21\u83b7\u53d6\u5230\u670b\u53cb\u5708\u53d1\u5e03\u60c5\u51b5:{}", (Object)i, (Object)JsonUtils.toJson((Object)momentTaskListResult, (boolean)false));
                if (!momentTaskListResult.isSuccess()) {
                    return;
                }
                cursor[0] = momentTaskListResult.getNextCursor();
                momentTaskListResult.getTaskList().forEach(momentTask -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("momentId", moment.get("MOMENT_ID"));
                    map.put("userId", momentTask.getUserid());
                    map.put("publishStatus", momentTask.getPublishStatus());
                    this.momentMapper.insertMomentPublish(map);
                    logger.info("\u4fdd\u5b58\u670b\u53cb\u5708\u53d1\u5e03\u60c5\u51b5:{}", (Object)JsonUtils.toJson(map, (boolean)false));
                });
            }
        });
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo syncMomentComment() {
        logger.info("zzzzzzzzz\u6267\u884c\u6211\u8fd9\u4e2a\u65b9\u6cd5");
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        List<Map<String, Object>> momentPublishes = this.momentMapper.getAllMomentTask();
        logger.info("zzzzzzzzz\u67e5\u51fa\u6765\u591a\u5c11\u6761\u5462\uff1f\uff1a{}", (Object)momentPublishes.size());
        int j = 0;
        for (Map<String, Object> momentPublish : momentPublishes) {
            if (!momentPublish.get("MOMENT_ID").equals("mom1Egf2CQAA-QIijCTtmUEM0KsBNvadaA")) continue;
            logger.info("zzzzzzzzz\u5148\u5224\u65ad\u6211\u6267\u884c\u4e00\u904d,MOMENT_ID={},USER_ID={},\u8fd9\u662f\u7b2c{}\u904d", new Object[]{momentPublish.get("MOMENT_ID"), momentPublish.get("USER_ID"), ++j});
        }
        HashSet<String> doneSet = new HashSet<String>();
        for (Map<String, Object> momentPublish : momentPublishes) {
            HashMap<String, Object> map;
            Integer existComment;
            MomentCommentResult momentCommentResult;
            if (doneSet.contains((String)momentPublish.get("MOMENT_ID") + (String)momentPublish.get("USER_ID"))) {
                logger.info("zzzzzzzzz\u8fd9\u4e2a\u91cd\u590d\u4e86\u4e0d\u6267\u884c\uff0cMOMENT_ID={},USER_ID={}");
                continue;
            }
            doneSet.add((String)momentPublish.get("MOMENT_ID") + (String)momentPublish.get("USER_ID"));
            if (momentPublish.get("MOMENT_ID").equals("mom1Egf2CQAA-QIijCTtmUEM0KsBNvadaA")) {
                logger.info("zzzzzzzzz\u540e\u5224\u65ad\u6211\u6267\u884c\u4e00\u904d,MOMENT_ID={},USER_ID={}", momentPublish.get("MOMENT_ID"), momentPublish.get("USER_ID"));
            }
            if (!(momentCommentResult = WxApiUtils.getMomentComment((String)accessToken, (String)((String)momentPublish.get("MOMENT_ID")), (String)((String)momentPublish.get("USER_ID")))).isSuccess()) continue;
            int i = 0;
            for (MomentCommentResult.MomentComment comment : momentCommentResult.getCommentList()) {
                if (momentPublish.get("MOMENT_ID").equals("mom1Egf2CQAA-QIijCTtmUEM0KsBNvadaA")) {
                    logger.info("zzzzzzzzz\u6700\u91cc\u8fb9\u5224\u65ad\u6211\u6267\u884c\u4e00\u904d,MOMENT_ID={},USER_ID={},\u8fd9\u662f\u7b2c{}\u904d", new Object[]{momentPublish.get("MOMENT_ID"), momentPublish.get("USER_ID"), ++i});
                }
                if ((existComment = this.momentMapper.existComment((String)momentPublish.get("MOMENT_ID"), (String)momentPublish.get("USER_ID"), 1, DateUtils.formatDate((Date)new Date(comment.getCreateTime() * 1000L), (String)""), comment.getExternalUserid())) > 0) continue;
                map = new HashMap<String, Object>();
                map.put("momentId", momentPublish.get("MOMENT_ID"));
                map.put("userId", momentPublish.get("USER_ID"));
                map.put("externalUserid", comment.getExternalUserid());
                map.put("type", 1);
                map.put("createTime", new Date(comment.getCreateTime() * 1000L));
                this.momentMapper.insertMomentComment(map);
            }
            for (MomentCommentResult.MomentLike like : momentCommentResult.getLikeList()) {
                existComment = this.momentMapper.existComment((String)momentPublish.get("MOMENT_ID"), (String)momentPublish.get("USER_ID"), 2, DateUtils.formatDate((Date)new Date(like.getCreateTime() * 1000L), (String)""), like.getExternalUserid());
                if (existComment > 0) continue;
                map = new HashMap();
                map.put("momentId", momentPublish.get("MOMENT_ID"));
                map.put("userId", momentPublish.get("USER_ID"));
                map.put("externalUserid", like.getExternalUserid());
                map.put("type", 2);
                map.put("createTime", new Date(like.getCreateTime() * 1000L));
                this.momentMapper.insertMomentComment(map);
            }
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getMomentComment(String momentId, String userId) {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        MomentCommentResult momentCommentResult = WxApiUtils.getMomentComment((String)accessToken, (String)momentId, (String)userId);
        return BaseJsonVo.success((Object)JsonUtils.toJson((Object)momentCommentResult, (boolean)false));
    }
}

