/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.needaddphone;

import cc.lechun.apiinvoke.mall.BlackListInvoke;
import cc.lechun.apiinvoke.mall.DistributionInvoke;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinNeedAddPhoneKefuMapper;
import cc.lechun.qiyeweixin.dao.QiYeWeiXinNeedAddPhoneMapper;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinNeedAddPhoneEntity;
import cc.lechun.qiyeweixin.entity.QiYeWeiXinNeedAddPhoneKefuEntity;
import cc.lechun.qiyeweixin.iservice.needaddphone.NeedAddPhoneInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NeedAddPhoneService
implements NeedAddPhoneInterface {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    QiYeWeiXinNeedAddPhoneMapper needAddPhoneMapper;
    @Autowired
    QiYeWeiXinNeedAddPhoneKefuMapper qiYeWeiXinNeedAddPhoneKefuMapper;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    DingdingUtils dingdingUtils;
    @Autowired
    DistributorInterface distributorInterface;
    @Autowired
    MallUserInterface mallUserInterface;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    DistributionInvoke distributionInvoke;
    @Autowired
    BlackListInvoke blackListInvoke;

    @Override
    public BaseJsonVo addNeedAddPhone(String phone, String taskName, Integer feeDuration, Integer callDuration, Integer aiCallStatus) {
        block6: {
            this.logger.info("\u6dfb\u52a0\u7535\u8bdd\u5230\u5f85\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u7535\u8bdd\u4e2d:{}", (Object)phone);
            List<DistributorQiyeweixinExternalContactEntity> contacts = this.distributorInterface.getDistributorContactByPhone(phone);
            if (contacts != null && contacts.size() > 0) {
                this.logger.info("\u624b\u673a\u53f7[{}],{}\u5df2\u6dfb\u52a0\u4f01\u5fae", (Object)phone, (Object)taskName);
                return BaseJsonVo.success((String)"\u8be5\u624b\u673a\u53f7\u5df2\u6dfb\u52a0\u4f01\u5fae", (Object)phone);
            }
            BaseJsonVo<Boolean> isQyCustomer = this.distributionInvoke.isQyCustomer(phone, null);
            if (isQyCustomer.isSuccess() && !((Boolean)isQyCustomer.getValue()).booleanValue()) {
                try {
                    BaseJsonVo<String> filter = this.blackListInvoke.filter(1, phone, "", "", "NEED_ADD_PHONE:" + RandomUtils.generateLowerString((int)4));
                    if (!filter.isSuccess()) {
                        return BaseJsonVo.success((String)"\u8be5\u624b\u673a\u53f7\u5728\u9ed1\u540d\u5355", (Object)phone);
                    }
                    break block6;
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u5546\u57ce\u5224\u65ad\u9ed1\u540d\u5355\u5f02\u5e38", (Throwable)e);
                    return BaseJsonVo.error((String)"\u8c03\u7528\u5546\u57ce\u5224\u65ad\u9ed1\u540d\u5355\u5f02\u5e38");
                }
            }
            return BaseJsonVo.success((String)"\u8be5\u624b\u673a\u53f7\u5df2\u6dfb\u52a0\u4f01\u5fae", (Object)phone);
        }
        QiYeWeiXinNeedAddPhoneEntity needAddPhoneEntity = new QiYeWeiXinNeedAddPhoneEntity();
        needAddPhoneEntity.setMobile(phone);
        needAddPhoneEntity.setFromTask(taskName);
        needAddPhoneEntity.setCreateTime(DateUtils.now());
        needAddPhoneEntity.setAiCallFeeDuration(feeDuration == null ? 0 : feeDuration);
        needAddPhoneEntity.setAiCallCallDuration(callDuration == null ? 0 : callDuration);
        needAddPhoneEntity.setAiCallStatus(aiCallStatus);
        QiYeWeiXinNeedAddPhoneKefuEntity kefuEntity = this.qiYeWeiXinNeedAddPhoneKefuMapper.getMinKefu();
        if (kefuEntity != null) {
            needAddPhoneEntity.setToKefuId(kefuEntity.getKefuId());
            kefuEntity.setCurrentCount(kefuEntity.getCurrentCount() + 1);
            this.qiYeWeiXinNeedAddPhoneKefuMapper.updateByPrimaryKeySelective(kefuEntity);
        }
        needAddPhoneEntity.setHasAdd(0);
        this.needAddPhoneMapper.insert(needAddPhoneEntity);
        return BaseJsonVo.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)needAddPhoneEntity.getToKefuId());
    }

    @Override
    public BaseJsonVo getNeedAddPhone(String toKefuId, String searchDate) {
        List<QiYeWeiXinNeedAddPhoneEntity> list = this.needAddPhoneMapper.getNeedAddPhone(toKefuId, searchDate);
        return BaseJsonVo.success(list);
    }

    @Override
    public BaseJsonVo needAddPhoneAdd(String phone, String addKefuId) {
        QiYeWeiXinNeedAddPhoneEntity param = new QiYeWeiXinNeedAddPhoneEntity();
        param.setMobile(phone);
        param.setToKefuId(addKefuId);
        param.setHasAdd(0);
        List list = this.needAddPhoneMapper.getList(param);
        Integer[] hasAdded = new Integer[]{0};
        list.forEach(entity -> {
            if (entity.getHasAdd() != 0) {
                hasAdded[0] = entity.getHasAdd();
                return;
            }
            entity.setAddKefuId(addKefuId);
            entity.setAddTime(DateUtils.now());
            entity.setHasAdd(1);
            this.needAddPhoneMapper.updateByPrimaryKeySelective(entity);
        });
        if (hasAdded[0] == 0) {
            return BaseJsonVo.success((Object)("[" + phone + "]\u72b6\u6001\u6539\u4e3a\u5df2\u6dfb\u52a0"));
        }
        if (hasAdded[0] == 1) {
            return BaseJsonVo.error((String)("[" + phone + "]\u5df2\u53d1\u9001\u4e86\u9080\u8bf7\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0"));
        }
        return BaseJsonVo.error((String)("[" + phone + "]\u5df2\u6dfb\u52a0\u4e86\u4f01\u5fae\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0"));
    }

    @Override
    public BaseJsonVo addNeedAddPhoneSuccess(String mobile, String externalUserID) {
        QiYeWeiXinNeedAddPhoneEntity param = new QiYeWeiXinNeedAddPhoneEntity();
        param.setMobile(mobile);
        List list = this.needAddPhoneMapper.getList(param);
        list.forEach(entity -> {
            entity.setOpenId(externalUserID);
            entity.setAgreeTime(DateUtils.now());
            entity.setHasAdd(2);
            this.needAddPhoneMapper.updateByPrimaryKeySelective(entity);
        });
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo sendneedAddPhoneNotice() {
        List<Map<String, String>> list = this.needAddPhoneMapper.getNeedAddPhoneListWithNotice();
        String title = "\u552e\u540e\u7cfb\u7edf\u901a\u77e5";
        String content = "\u4eca\u65e5[\u622a\u81f3\u5230" + DateUtils.now((String)"HH:mm:ss") + "]\u4f60\u6709%s\u4e2a\u7528\u6237\u5f85\u6dfb\u52a0\u5230\u4f01\u5fae\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u552e\u540e\u7cfb\u7edf\u5904\u7406";
        for (Map<String, String> m : list) {
            if (!StringUtils.isNotEmpty((String)m.get("dingdingId"))) continue;
            this.dingdingUtils.sendOAMessage(m.get("dingdingId"), title, String.format(content, m.get("phoneCount")), "https://csms.lechun.cc");
        }
        return BaseJsonVo.success((Object)("\u53d1\u9001\u5b8c\u6210\uff0c\u5171\u53d1\u9001" + list.size() + "\u6761"));
    }

    @Override
    public void refreshData() {
        this.qiYeWeiXinNeedAddPhoneKefuMapper.updateToZero();
    }

    @Override
    public void addMobileAgain() {
        Date _14DaysAgo = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-14);
        Date _13DaysAgo = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-13);
        Set<String> mobiles1 = this.needAddPhoneMapper.get14DaysAgoMobiles(_14DaysAgo, _13DaysAgo);
        List list = this.qiYeWeiXinNeedAddPhoneKefuMapper.getList(new QiYeWeiXinNeedAddPhoneKefuEntity());
        Set<String> mobiles2 = this.orderInterface.getOrderConsigneeMobiles(_14DaysAgo, _13DaysAgo, 150 * list.size());
        HashSet<String> allMobiles = new HashSet<String>();
        allMobiles.addAll(mobiles1);
        allMobiles.addAll(mobiles2);
        Integer[] task = new Integer[]{0, 0, 0};
        allMobiles.forEach(mobile -> {
            block5: {
                BaseJsonVo<Boolean> isQyCustomer = this.distributionInvoke.isQyCustomer((String)mobile, null);
                if (isQyCustomer.isSuccess() && !((Boolean)isQyCustomer.getValue()).booleanValue()) {
                    try {
                        BaseJsonVo<String> filter = this.blackListInvoke.filter(1, (String)mobile, "", "", "NEED_ADD_PHONE:" + RandomUtils.generateLowerString((int)4));
                        if (filter.isSuccess()) {
                            this.addNeedAddPhone((String)mobile, "(14\u5929/30\u5929)\u4e4b\u524d\u6dfb\u52a0\u672a\u540c\u610f\u6216\u5fae\u4fe1\u4e0b\u5355", 0, 0, 0);
                            Integer n = task[2];
                            Integer n2 = task[2] = Integer.valueOf(task[2] + 1);
                            break block5;
                        }
                        this.logger.info("task1\u624b\u673a\u53f7[{}]\u662f\u9ed1\u540d\u5355", mobile);
                        Integer n = task[1];
                        Integer n3 = task[1] = Integer.valueOf(task[1] + 1);
                    }
                    catch (Exception e) {
                        this.logger.error("\u8c03\u7528\u5546\u57ce\u5224\u65ad\u9ed1\u540d\u5355\u5f02\u5e38", (Throwable)e);
                    }
                } else {
                    this.logger.info("task1\u624b\u673a\u53f7[{}]\u5df2\u6dfb\u52a0\u4f01\u5fae", mobile);
                    Integer n = task[0];
                    Integer n4 = task[0] = Integer.valueOf(task[0] + 1);
                }
            }
        });
        this.logger.info("\u6bcf\u65e5\u8fd0\u884c\u7ed9\u5ba2\u670d\u6dfb\u52a0\u624b\u673a\u53f7\u4efb\u52a1\uff0c14D\u5f00\u59cb\u65e5\u671f\uff1a{}\uff0c14D\u622a\u6b62\u65e5\u671f\uff1a{}\uff0c\u301014\u5929\u524d\u6ca1\u6709\u6dfb\u52a0\u6210\u529f\u7684\uff1a{}\u3011\uff0c\u301014\u5929\u524d\u5fae\u4fe1\u4e0b\u5355\u7684\uff1a{}\u3011\uff0c\u5408\u5e76\u540e\u5269\u4f59\uff1a{}\uff0c\u5df2\u6dfb\u52a0\u4f01\u5fae\u7684\u5237\u6389\uff1a{}\uff0c\u9ed1\u540d\u5355\u53c8\u5237\u6389\uff1a{}\uff0c\u5c31\u5269\u4e0b\uff1a{}", new Object[]{DateUtils.formatDate((Date)_14DaysAgo, (String)""), DateUtils.formatDate((Date)_13DaysAgo, (String)""), mobiles1.size(), mobiles2.size(), allMobiles.size(), task[0], task[1], task[2]});
    }

    @Override
    public void addMobileAgain2() {
    }

    @Override
    public BaseJsonVo getUnAddedPhones(String userEmail) {
        List<Object> mobiles = new ArrayList();
        if ("liqun@lechun.cc".equals(userEmail)) {
            HashMap<String, String> o = new HashMap<String, String>();
            o.put("ID", "100000000");
            o.put("MOBILE", "15910702720");
            mobiles.add(o);
            o = new HashMap();
            o.put("ID", "100000001");
            o.put("MOBILE", "15910702721");
            mobiles.add(o);
            o = new HashMap();
            o.put("ID", "100000002");
            o.put("MOBILE", "15900367380");
            mobiles.add(o);
        } else {
            mobiles = this.needAddPhoneMapper.getUnToMobilesByKefuId(userEmail);
        }
        return BaseJsonVo.success(mobiles);
    }

    @Override
    public BaseJsonVo needAddPhoneAddById(Integer id) {
        QiYeWeiXinNeedAddPhoneEntity entity = new QiYeWeiXinNeedAddPhoneEntity();
        entity.setId(id);
        entity.setHasAdd(1);
        entity.setAddKefuId("sys");
        entity.setAddTime(new Date());
        this.needAddPhoneMapper.updateByPrimaryKeySelective(entity);
        return BaseJsonVo.success(null);
    }
}

