/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.qiyeweixin.dao.tag.ContactTagGroupMapper;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupQueryVo;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagGroupInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import weixin.popular.bean.qy.tag.TagGroupResult;

@Service
public class ContactTagGroupService
extends BaseService<ContactTagGroupEntity, Integer>
implements ContactTagGroupInterface {
    @Resource
    private ContactTagGroupMapper contactTagGroupMapper;

    @Override
    public PageInfo<ContactTagGroupEntity> getTagGroupList(int pageNum, int pageSize) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        ContactTagGroupEntity query = new ContactTagGroupEntity();
        this.contactTagGroupMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public PageInfo<ContactTagGroupEntity> getTagGroupList(ContactTagGroupQueryVo contactTagGroupQueryVo) {
        return this.getTagGroupList(contactTagGroupQueryVo.getCurrentPage(), contactTagGroupQueryVo.getPageSize());
    }

    @Override
    public BaseJsonVo save(TagGroupResult.TagGroup tagGroup) {
        ContactTagGroupEntity query = new ContactTagGroupEntity();
        query.setWxGroupId(tagGroup.getGroupId());
        ContactTagGroupEntity contactTagGroupEntity = (ContactTagGroupEntity)this.contactTagGroupMapper.getSingle(query);
        this.logger.info("\u6807\u7b7e\u7ec4{}", (Object)JsonUtils.toJson((Object)tagGroup, (boolean)false));
        if (contactTagGroupEntity != null) {
            contactTagGroupEntity.setStatus(tagGroup.isDeleted() ? 0 : 1);
            contactTagGroupEntity.setGroupName(tagGroup.getGroupName());
            contactTagGroupEntity.setSort(tagGroup.getOrder() == null ? 0 : tagGroup.getOrder());
            long time = (long)tagGroup.getCreateTime().intValue() * 1000L;
            contactTagGroupEntity.setCreateTime(new Date(time));
            return this.contactTagGroupMapper.updateByPrimaryKeySelective(contactTagGroupEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
        }
        ContactTagGroupEntity newItemGroup = new ContactTagGroupEntity();
        newItemGroup.setWxGroupId(tagGroup.getGroupId());
        newItemGroup.setSort(tagGroup.getOrder() == null ? 0 : tagGroup.getOrder());
        newItemGroup.setGroupName(tagGroup.getGroupName());
        newItemGroup.setStatus(tagGroup.isDeleted() ? 0 : 1);
        this.logger.info("\u521b\u5efa\u65f6\u95f4{}", (Object)tagGroup.getCreateTime());
        Long time = new Long(tagGroup.getCreateTime().intValue()) * 1000L;
        newItemGroup.setCreateTime(new Date(time));
        newItemGroup.setUpdateTime(DateUtils.now());
        newItemGroup.setCorpId(0);
        return this.contactTagGroupMapper.insertSelective(newItemGroup) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ContactTagGroupService.getTagGroup", expiration=10800)
    public ContactTagGroupEntity getTagGroup(@ParameterValueKeyProvider String wxGroupId) {
        ContactTagGroupEntity contactTagGroupEntity = new ContactTagGroupEntity();
        contactTagGroupEntity.setWxGroupId(wxGroupId);
        return (ContactTagGroupEntity)this.contactTagGroupMapper.getSingle(contactTagGroupEntity);
    }
}

