/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorQiyeweixinExternalContactMapper;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.tag.ContactTagGroupMapper;
import cc.lechun.qiyeweixin.dao.tag.ContactTagMapper;
import cc.lechun.qiyeweixin.dao.tag.CustomerTagMapper;
import cc.lechun.qiyeweixin.entity.tag.ConditionTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntityVo;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.CorpTagQueryVo;
import cc.lechun.qiyeweixin.entity.tag.CustomerTagEntity;
import cc.lechun.qiyeweixin.entity.tag.NewTagItemVo;
import cc.lechun.qiyeweixin.entity.tag.TagItemVo;
import cc.lechun.qiyeweixin.entity.tag.TagTypeEnum;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.tag.TagGroupResult;
import weixin.popular.bean.qy.tag.UserTagInfo;
import weixin.popular.bean.qy.tag.WxTag;
import weixin.popular.bean.qy.tag.WxTagItem;

@Service
public class ContactTagService
extends BaseService<ContactTagEntity, Integer>
implements ContactTagInterface {
    @Resource
    private ContactTagMapper contactTagMapper;
    @Resource
    private ContactTagGroupMapper contactTagGroupMapper;
    @Resource
    private CustomerTagMapper customerTagMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Resource
    private DistributorQiyeweixinExternalContactMapper distributorQiyeweixinExternalContactMapper;

    @Override
    public void testMarkTag(Integer tagId) {
        ContactTagEntity tagItem = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagId);
        this.logger.info("\u6807\u7b7e:{}", (Object)JsonUtils.toJson((Object)tagItem, (boolean)false));
        DistributorQiyeweixinExternalContactEntity query = new DistributorQiyeweixinExternalContactEntity();
        query.setCustomerId("10003355426914989387638");
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactMapper.getSingle(query);
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        String[] tagArr = new String[]{tagItem.getWxContactTagId()};
        userTagInfo.setAdd_tag(tagArr);
        this.logger.info("\u6807\u7b7e:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false));
        BaseResult baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
        if (baseResult.isSuccess()) {
            CustomerTagEntity customerTagEntity = new CustomerTagEntity();
            customerTagEntity.setTagId(tagItem.getWxContactTagId());
            customerTagEntity.setExternalUserid(user.getExternalUserid());
            customerTagEntity.setCustomerId(user.getCustomerId());
            customerTagEntity.setQyWeixinUserid(user.getQyWeixinUserid());
            customerTagEntity.setTagName(tagItem.getName());
            customerTagEntity.setTagType(1);
            this.customerTagMapper.insertSelective(customerTagEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, Exception.class})
    public BaseJsonVo saveTagItem(NewTagItemVo newTagItemVo) {
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        this.logger.info("accessToken={}", (Object)accessToken);
        String wxGroupId = newTagItemVo.getGroup_id();
        WxTag wxTag = new WxTag();
        List tagNameList = newTagItemVo.getTag().stream().map(NewTagItemVo.Tag::getName).collect(Collectors.toList());
        if (StringUtils.isEmpty((String)wxGroupId)) {
            String tagGroupName = newTagItemVo.getGroup_name();
            this.logger.info("\u5f00\u59cb\u521b\u5efa\u6807\u7b7e\u7ec4:{}", (Object)tagGroupName);
            wxTag = WxApiUtils.requestCreateGroupAndTags((String)accessToken, (String)tagGroupName, tagNameList);
            if (wxTag.isSuccess()) {
                this.logger.info("\u521b\u5efa\u6807\u7b7e\u7ec4\u53ca\u6807\u7b7e:{}", (Object)JsonUtils.toJson((Object)wxTag, (boolean)false));
                ContactTagGroupEntity contactTagGroupEntity = new ContactTagGroupEntity();
                contactTagGroupEntity.setGroupName(tagGroupName);
                contactTagGroupEntity.setWxGroupId(wxTag.getTag_group().getGroupId());
                contactTagGroupEntity.setCreateTime(DateUtils.now());
                contactTagGroupEntity.setUpdateTime(DateUtils.now());
                contactTagGroupEntity.setSort(wxTag.getTag_group().getOrder());
                contactTagGroupEntity.setStatus(1);
                this.contactTagGroupMapper.insertSelective(contactTagGroupEntity);
                this.createTag(contactTagGroupEntity, wxTag, newTagItemVo.getTag().get(0).getConditionType());
            } else {
                this.logger.info("\u4fdd\u5b58\u6807\u7b7e\u51fa\u9519: code{},err:{}", (Object)wxTag.getErrcode(), (Object)wxTag.getErrmsg());
            }
        } else {
            this.logger.info("\u6807\u7b7e\u7ec4id{},\u521b\u5efa\u6807\u7b7e\u540d\u79f0:{}", (Object)wxGroupId, tagNameList);
            wxTag = WxApiUtils.requestCreateTags((String)accessToken, (String)wxGroupId, tagNameList);
            this.logger.info("\u521b\u5efa\u6807\u7b7e\u7ec4:{}", (Object)JsonUtils.toJson((Object)wxTag, (boolean)false));
            if (wxTag != null && wxTag.isSuccess()) {
                ContactTagGroupEntity query = new ContactTagGroupEntity();
                query.setWxGroupId(wxGroupId);
                ContactTagGroupEntity entity = (ContactTagGroupEntity)this.contactTagGroupMapper.getSingle(query);
                this.createTag(entity, wxTag, newTagItemVo.getTag().get(0).getConditionType());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveTagItem(TagGroupResult.TagGroup.Tag tag, TagGroupResult.TagGroup tagGroup) {
        ContactTagEntity query = new ContactTagEntity();
        query.setWxContactTagId(tag.getId());
        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.getSingle(query);
        long time = (long)tagGroup.getCreateTime().intValue() * 1000L;
        this.logger.info("\u521b\u5efa\u65f6\u95f4{}", (Object)time);
        if (contactTagEntity != null) {
            contactTagEntity.setSort(tag.getOrder());
            contactTagEntity.setName(tag.getName());
            contactTagEntity.setStatus(tag.isDeleted() ? 0 : 1);
            contactTagEntity.setUpdateTime(DateUtils.now());
            contactTagEntity.setCreateTime(new Date(time));
            this.contactTagMapper.updateByPrimaryKeySelective(contactTagEntity);
        } else {
            contactTagEntity = new ContactTagEntity();
            contactTagEntity.setStatus(tag.isDeleted() ? 0 : 1);
            contactTagEntity.setWxTagGroupId(tagGroup.getGroupId());
            contactTagEntity.setUpdateTime(DateUtils.now());
            contactTagEntity.setWxContactTagId(tag.getId());
            contactTagEntity.setName(tag.getName());
            contactTagEntity.setSort(tag.getOrder());
            contactTagEntity.setCreateTime(new Date(time));
            this.contactTagMapper.insertSelective(contactTagEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    public void createTag(ContactTagGroupEntity entity, WxTag dto, Integer conditionType) {
        List tagDTOList = dto.getTag_group().getTag();
        for (WxTagItem.TagDTO tagDto : tagDTOList) {
            this.createTag(entity, tagDto, conditionType);
        }
    }

    public void createTag(ContactTagGroupEntity entity, WxTagItem.TagDTO tagDto, Integer conditionType) {
        ContactTagEntity tagEntity = new ContactTagEntity();
        tagEntity.setWxContactTagId(tagDto.getId());
        tagEntity.setCorpId(entity.getCorpId());
        tagEntity.setName(tagDto.getName());
        tagEntity.setSort(tagDto.getOrder());
        tagEntity.setConditionType(conditionType);
        tagEntity.setContactTagGroupId(entity.getId());
        tagEntity.setWxTagGroupId(entity.getWxGroupId());
        tagEntity.setCreateTime(DateUtils.now());
        tagEntity.setUpdateTime(DateUtils.now());
        tagEntity.setStatus(1);
        this.insertSelective(tagEntity);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, Exception.class})
    public BaseJsonVo deleteTag(Integer tagId) {
        ContactTagEntity query = new ContactTagEntity();
        query.setId(tagId);
        ContactTagEntity tagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagId);
        if (tagEntity == null) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        this.customerTagMapper.deleteCustomerTag(tagEntity.getWxContactTagId());
        this.contactTagMapper.deleteByPrimaryKey(tagEntity.getId());
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteTag(String tagId) {
        this.logger.info("\u540c\u6b65\u5220\u9664\u6807\u7b7e:{}", (Object)tagId);
        ContactTagEntity query = new ContactTagEntity();
        query.setWxContactTagId(tagId);
        ContactTagEntity tagEntity = (ContactTagEntity)this.contactTagMapper.getSingle(query);
        if (tagEntity == null) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        tagEntity.setStatus(0);
        this.contactTagMapper.updateByPrimaryKeySelective(tagEntity);
        this.customerTagMapper.deleteCustomerTag(tagEntity.getWxContactTagId());
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo saveTag(String wxTagId) {
        List tagGroupList;
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        TagGroupResult baseResult = WxApiUtils.requestGetTagDetail((String)accessToken, (String)wxTagId);
        if (baseResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)(tagGroupList = baseResult.getTagGroupList()))) {
            for (TagGroupResult.TagGroup tagGroup : tagGroupList) {
                ContactTagGroupEntity query = new ContactTagGroupEntity();
                query.setWxGroupId(tagGroup.getGroupId());
                ContactTagGroupEntity contactTagGroupEntity = (ContactTagGroupEntity)this.contactTagGroupMapper.getSingle(query);
                if (contactTagGroupEntity == null) {
                    contactTagGroupEntity = new ContactTagGroupEntity();
                    contactTagGroupEntity.setWxGroupId(tagGroup.getGroupId());
                }
                contactTagGroupEntity.setGroupName(tagGroup.getGroupName());
                contactTagGroupEntity.setStatus(tagGroup.isDeleted() ? 0 : 1);
                contactTagGroupEntity.setSort(tagGroup.getOrder());
                long time = (long)tagGroup.getCreateTime().intValue() * 1000L;
                contactTagGroupEntity.setCreateTime(new Date(time));
                this.contactTagGroupMapper.insertOrUpdate(contactTagGroupEntity);
                for (TagGroupResult.TagGroup.Tag tag : tagGroup.getTagList()) {
                    time = (long)tag.getCreateTime().intValue() * 1000L;
                    ContactTagEntity queryTag = new ContactTagEntity();
                    queryTag.setWxContactTagId(tag.getId());
                    ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.getSingle(queryTag);
                    if (contactTagEntity != null) {
                        contactTagEntity.setSort(tag.getOrder());
                        contactTagEntity.setName(tag.getName());
                        contactTagEntity.setStatus(tag.isDeleted() ? 0 : 1);
                        contactTagEntity.setUpdateTime(DateUtils.now());
                        this.contactTagMapper.updateByPrimaryKeySelective(contactTagEntity);
                        continue;
                    }
                    contactTagEntity = new ContactTagEntity();
                    contactTagEntity.setStatus(tag.isDeleted() ? 0 : 1);
                    contactTagEntity.setWxTagGroupId(tagGroup.getGroupId());
                    contactTagEntity.setUpdateTime(DateUtils.now());
                    contactTagEntity.setWxContactTagId(tag.getId());
                    contactTagEntity.setName(tag.getName());
                    contactTagEntity.setSort(tag.getOrder());
                    contactTagEntity.setCreateTime(new Date(time));
                    contactTagEntity.setTagType(TagTypeEnum.unknown.getValue());
                    this.contactTagMapper.insertSelective(contactTagEntity);
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    public PageInfo getTagList(CorpTagQueryVo corpTagQueryVo) {
        Page page = PageHelper.startPage((int)corpTagQueryVo.getCurrentPage(), (int)corpTagQueryVo.getPageSize());
        page.setOrderBy("id DESC");
        ContactTagEntity query = new ContactTagEntity();
        BeanUtils.copyProperties((Object)corpTagQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)query.getName())) {
            query.setName(SqlUtils.sqlLike((String)query.getName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            query.setName(null);
        }
        if (corpTagQueryVo.getTagGroupId() != null) {
            query.setContactTagGroupId(corpTagQueryVo.getTagGroupId());
        }
        List list = this.contactTagMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        ArrayList<TagItemVo> result = new ArrayList<TagItemVo>();
        for (ContactTagEntity contactTagEntity : list) {
            TagItemVo tagItemVo = new TagItemVo();
            BeanUtils.copyProperties((Object)contactTagEntity, (Object)tagItemVo);
            tagItemVo.setTagTypeName(TagTypeEnum.getName(contactTagEntity.getTagType()));
            ContactTagGroupEntity contactTagGroupEntity = null;
            tagItemVo.setConditionTypeName(ConditionTypeEnum.getName(contactTagEntity.getConditionType()));
            if (contactTagEntity.getContactTagGroupId() != null && contactTagEntity.getContactTagGroupId() != 0) {
                contactTagGroupEntity = (ContactTagGroupEntity)this.contactTagGroupMapper.selectByPrimaryKey(contactTagEntity.getContactTagGroupId());
            } else {
                ContactTagGroupEntity groupQuery = new ContactTagGroupEntity();
                groupQuery.setWxGroupId(contactTagEntity.getWxTagGroupId());
                contactTagGroupEntity = (ContactTagGroupEntity)this.contactTagGroupMapper.getSingle(groupQuery);
                if (contactTagGroupEntity != null) {
                    contactTagEntity.setContactTagGroupId(contactTagGroupEntity.getId());
                    this.contactTagMapper.updateByPrimaryKeySelective(contactTagEntity);
                }
            }
            tagItemVo.setStatusName(contactTagEntity.getStatus() == 1 ? "\u6709\u6548" : "\u65e0\u6548");
            tagItemVo.setTagGroupName(contactTagGroupEntity == null ? "" : contactTagGroupEntity.getGroupName());
            if (corpTagQueryVo.getPageSize() < 50) {
                tagItemVo.setUserNum(this.customerTagMapper.getCustomerNum(contactTagEntity.getWxContactTagId()));
            }
            result.add(tagItemVo);
        }
        pg.setList(result);
        return pg;
    }

    @Override
    public PageInfo<ContactTagEntity> getContactTagEntityList(CorpTagQueryVo corpTagQueryVo) {
        Page page = PageHelper.startPage((int)corpTagQueryVo.getCurrentPage(), (int)corpTagQueryVo.getPageSize());
        page.setOrderBy("sort DESC");
        ContactTagEntity query = new ContactTagEntity();
        BeanUtils.copyProperties((Object)corpTagQueryVo, (Object)query);
        this.contactTagMapper.getList(query);
        return page.toPageInfo();
    }

    @Override
    public List<ContactTagEntity> getContactTagList(Integer contactTagGroupId) {
        ContactTagEntity query = new ContactTagEntity();
        query.setContactTagGroupId(contactTagGroupId);
        return this.contactTagMapper.getList(query);
    }

    @Override
    public List<ContactTagEntity> getContactTagList(String contactTagGroupId) {
        ContactTagEntity query = new ContactTagEntity();
        query.setWxTagGroupId(contactTagGroupId);
        return this.getList(query);
    }

    @Override
    @ReadThroughSingleCache(namespace="ContactTagService.getContactTagList", expiration=18000)
    public List<ContactTagEntity> getContactTagList(@ParameterValueKeyProvider(order=0) Integer tagType, @ParameterValueKeyProvider(order=1) Integer status) {
        ContactTagEntity queryTag = new ContactTagEntity();
        queryTag.setTagType(2);
        queryTag.setStatus(1);
        return this.getList(queryTag);
    }

    @Override
    public Map<String, Integer> getContactTagIds(List<Integer> tagId) {
        List<ContactTagEntity> contactTag = this.getWxContactTagList(tagId);
        if (contactTag == null || contactTag.isEmpty() || contactTag.size() <= 0) {
            return new HashMap<String, Integer>();
        }
        return contactTag.stream().collect(Collectors.toMap(entry -> entry.getWxContactTagId(), entry -> entry.getId()));
    }

    @Override
    public Map<String, Integer> getContactTagId(List<String> wxTagIdList) {
        if (CollectionUtils.isEmpty(wxTagIdList)) {
            return new HashMap<String, Integer>();
        }
        List<ContactTagEntity> contactTag = this.getWxContactTagListByWxTagList(wxTagIdList);
        if (contactTag == null || contactTag.isEmpty() || contactTag.size() <= 0) {
            return new HashMap<String, Integer>();
        }
        return contactTag.stream().collect(Collectors.toMap(entry -> entry.getWxContactTagId(), entry -> entry.getId()));
    }

    @Override
    public List<ContactTagEntity> getWxContactTagListByWxTagList(List<String> wxTagIdList) {
        if (CollectionUtils.isEmpty(wxTagIdList)) {
            return new ArrayList<ContactTagEntity>();
        }
        ArrayList<ContactTagEntity> list = new ArrayList<ContactTagEntity>();
        for (String wxTagId : wxTagIdList) {
            ContactTagEntity query = new ContactTagEntity();
            query.setWxContactTagId(wxTagId);
            ContactTagEntity contactTagEntity = (ContactTagEntity)this.getSingle(query, 0L);
            if (contactTagEntity == null) continue;
            list.add(contactTagEntity);
        }
        return list;
    }

    @Override
    public List<ContactTagEntity> getWxContactTagList(List<Integer> tagIds) {
        ArrayList<ContactTagEntity> list = new ArrayList<ContactTagEntity>();
        for (Integer tagId : tagIds) {
            ContactTagEntity contactTagEntity = (ContactTagEntity)this.selectByPrimaryKey(tagId);
            if (contactTagEntity == null) continue;
            list.add(contactTagEntity);
        }
        return list;
    }

    @Override
    public List<String> getWxContactTagId(List<Integer> tagIds) {
        ArrayList<ContactTagEntity> list = new ArrayList<ContactTagEntity>();
        for (Integer tagId : tagIds) {
            ContactTagEntity contactTagEntity = (ContactTagEntity)this.selectByPrimaryKey(tagId);
            if (contactTagEntity == null) continue;
            list.add(contactTagEntity);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(ContactTagEntity::getWxContactTagId).collect(Collectors.toList());
    }

    @Override
    public List<ContactTagEntityVo> getUserHaveTages(String[] customerIds) {
        return this.contactTagMapper.getUserHaveTages(customerIds);
    }
}

