/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIChannelCodeInvoke;
import cc.lechun.apiinvoke.bi.BICustomerDataInvoke;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.cms.dto.TagOfCustomerDo;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.entity.tag.ConditionTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntityVo;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.CustomerTagEntity;
import cc.lechun.qiyeweixin.entity.tag.TagGroupUserQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagGroupVo;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.TagTypeEnum;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagGroupInterface;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.CorpTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.CustomerTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleGroupInterface;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleInterface;
import cc.lechun.qiyeweixin.service.tag.TagRuleContext;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeMapper;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeTagMapper;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeTagEntity;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.FollowUserAPI;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.FollowUser;
import weixin.popular.bean.qy.FollowUserContactResult;
import weixin.popular.bean.qy.FollowUserTag;
import weixin.popular.bean.qy.LaunchCode;
import weixin.popular.bean.qy.tag.TagGroupResult;
import weixin.popular.bean.qy.tag.UserTagInfo;

@Service
public class CorpTagService
implements CorpTagInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ContactTagInterface contactTagService;
    @Autowired
    ContactTagGroupInterface contactTagGroupService;
    @Autowired
    WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    DistributorQiyeweixinExternalContactInterface distributorQiyeweixinExternalContactService;
    @Autowired
    TagRuleInterface tagRuleService;
    @Autowired
    TagRuleGroupInterface tagRuleGroupService;
    @Autowired
    CustomerTagInterface customerTagService;
    @Autowired
    TagRuleContext tagRuleContext;
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    BICustomerDataInvoke customerDataInvoke;
    @Autowired
    RedisService redisService;
    @Resource
    DistributorMapper distributorMapper;
    @Resource
    private CustomerContactQrcodeMapper customerContactQrcodeMapper;
    @Resource
    private CustomerContactQrcodeTagMapper customerContactQrcodeTagMapper;
    @Autowired
    private BIChannelCodeInvoke biChannelCodeInvoke;

    @Override
    public BaseJsonVo getLaunchCode(LaunchCode launchCode) {
        return BaseJsonVo.success((Object)WxApiUtils.getLaunchCode((String)this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7), (LaunchCode)launchCode));
    }

    @Override
    public List<TagGroupVo> getTagGroupVoList() {
        ContactTagGroupEntity tagGroupQuery = new ContactTagGroupEntity();
        List groupList = this.contactTagGroupService.getList(tagGroupQuery);
        ArrayList<TagGroupVo> list = new ArrayList<TagGroupVo>();
        if (CollectionUtils.isNotEmpty((Collection)groupList)) {
            for (ContactTagGroupEntity tagGroupEntity : groupList) {
                TagGroupVo tagGroupVo = new TagGroupVo();
                tagGroupVo.setGroupId(tagGroupEntity.getWxGroupId());
                tagGroupVo.setGroupName(tagGroupEntity.getGroupName());
                ArrayList<TagGroupVo.TagItem> tagItemList = new ArrayList<TagGroupVo.TagItem>();
                List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(tagGroupEntity.getWxGroupId());
                for (ContactTagEntity tagEntity : tagList) {
                    TagGroupVo.TagItem tagItem = new TagGroupVo.TagItem();
                    tagItem.setTagId(tagEntity.getWxContactTagId());
                    tagItem.setTagName(tagEntity.getName());
                    tagItemList.add(tagItem);
                }
                tagGroupVo.setTagList(tagItemList);
                list.add(tagGroupVo);
            }
        }
        return list;
    }

    @Override
    public BaseJsonVo getCustomerQiWeiTagVoList(String itemList, String qiWeiUserId) {
        this.logger.info("\u67e5\u8be2\u53c2\u6570:{},userId={}", (Object)itemList, (Object)qiWeiUserId);
        try {
            String items = URLDecoder.decode(itemList, "UTF-8");
            TagGroupUserQueryVo tagGroupUserQueryVo = (TagGroupUserQueryVo)JsonUtils.fromJson((String)items, TagGroupUserQueryVo.class);
            if (!StringUtils.isNotEmpty((String)qiWeiUserId)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u7528\u6237\u4f01\u5faeid,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            tagGroupUserQueryVo.setQyWeixinUserid(qiWeiUserId);
            PageInfo<DistributorQiyeweixinExternalContactVo> pageInfo = this.distributorQiyeweixinExternalContactService.getUserContactTagList(tagGroupUserQueryVo);
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                Iterator iterator = pageInfo.getList().iterator();
                while (iterator.hasNext()) {
                    DistributorEntity distributorEntity;
                    DistributorQiyeweixinExternalContactVo distributorQiyeweixinExternalContactVo;
                    distributorQiyeweixinExternalContactVo.setGenderName((distributorQiyeweixinExternalContactVo = (DistributorQiyeweixinExternalContactVo)iterator.next()).getGender() == 0 ? "\u672a\u77e5" : (distributorQiyeweixinExternalContactVo.getGender() == 1 ? "\u7537" : "\u5973"));
                    distributorQiyeweixinExternalContactVo.setSaveSuccName(distributorQiyeweixinExternalContactVo.getSaveSucc() == 1 ? "\u6709\u6548" : (distributorQiyeweixinExternalContactVo.getSaveSucc() > 1 ? "\u5df2\u5220\u9664" : "\u672a\u6dfb\u52a0\u6210\u529f"));
                    distributorQiyeweixinExternalContactVo.setTypeName(distributorQiyeweixinExternalContactVo.getType() == 1 ? "\u5916\u90e8\u5fae\u4fe1\u7528\u6237" : "\u5916\u90e8\u4f01\u4e1a\u7528\u6237");
                    DistributorEntity param = new DistributorEntity();
                    param.setGroupId(5);
                    if (StringUtils.isNotEmpty((String)distributorQiyeweixinExternalContactVo.getQyWeixinUserid())) {
                        param.setQyWeixinUserid(distributorQiyeweixinExternalContactVo.getQyWeixinUserid());
                    }
                    distributorQiyeweixinExternalContactVo.setQyName((distributorEntity = (DistributorEntity)this.distributorMapper.getSingle(param)) == null || StringUtils.isEmpty((String)distributorEntity.getDistributorName()) ? "" : distributorEntity.getDistributorName());
                    List<CustomerTagEntity> customerTagList = this.customerTagService.getCustomerTagList(distributorQiyeweixinExternalContactVo.getQyWeixinUserid(), distributorQiyeweixinExternalContactVo.getExternalUserid(), StringUtils.isNotEmpty((String)distributorQiyeweixinExternalContactVo.getTagIdList()) ? distributorQiyeweixinExternalContactVo.getTagIdList().split(",") : null);
                    if (!CollectionUtils.isNotEmpty(customerTagList)) continue;
                    distributorQiyeweixinExternalContactVo.setCustomerTagList(customerTagList);
                }
            }
            return BaseJsonVo.success(pageInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u67e5\u8be2\u53c2\u6570\u9519\u8bef");
        }
    }

    @Override
    @Deprecated
    public void markTag(String customerId, Integer pageNum) {
        this.logger.info("{}\u5f00\u59cb\u6267\u884c\u6253\u6807\u7b7e", (Object)DateUtils.now());
        int maxPageSize = 0;
        PageForm pageForm = new PageForm();
        List<TagRuleGroupEntity> tagRuleGroupResultList = this.tagRuleGroupService.getTagRuleGroupList();
        pageForm.setPageSize(250);
        String key = "QiYeWeiXin:MakeUserTagPageNum";
        if (pageNum == null) {
            Object cachePage = this.redisService.get(key);
            pageNum = cachePage != null ? (Integer)cachePage : Integer.valueOf(0);
        }
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(TagTypeEnum.model.getValue(), 1);
        int i = pageNum;
        while (true) {
            pageForm.setCurrentPage(i);
            PageInfo<DistributorQiyeweixinExternalContactEntity> pageInfo = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(pageForm, customerId);
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570:{},\u603b\u9875\u6570:{}", (Object)i, (Object)pageInfo.getPages());
            this.redisService.save(key, i, 21600L);
            maxPageSize = pageInfo.getPages();
            if (i > maxPageSize - 1) break;
            for (DistributorQiyeweixinExternalContactEntity user : pageInfo.getList()) {
                if (StringUtils.isEmpty((String)user.getCustomerId())) continue;
                List<FollowUserTag> qiWeiTagList = this.getQiWeiTagList(user);
                if (CollectionUtils.isNotEmpty(qiWeiTagList)) {
                    BaseResult baseResult;
                    List tagIdList = qiWeiTagList.stream().map(FollowUserTag::getTag_id).collect(Collectors.toList());
                    List<ContactTagEntity> ownTagList = tagList.stream().filter(tag -> tagIdList.contains(tag.getWxContactTagId())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(ownTagList) && !(baseResult = this.customerTagService.removeUserTagBatch(user, ownTagList)).isSuccess()) {
                        this.logger.error("\u79fb\u9664\u7528\u6237:{}\u6807\u7b7e\u5931\u8d25:{}", (Object)user.getCustomerId(), (Object)baseResult.getErrmsg());
                        continue;
                    }
                }
                try {
                    BaseJsonVo<List<JSONObject>> baseJsonVo = this.customerDataInvoke.getCustomerDataTagVo(user.getCustomerId());
                    if (baseJsonVo.isSuccess()) {
                        if (StringUtils.isNotEmpty((String)((JSONObject)((List)baseJsonVo.getValue()).get(0)).getString("customerId"))) {
                            this.markTag(user, tagList, tagRuleGroupResultList, (JSONObject)((List)baseJsonVo.getValue()).get(0));
                            continue;
                        }
                        this.logger.error("BI\u7528\u6237:{}\u8bb0\u5f55\u4e0d\u5b58\u5728 ", (Object)user.getCustomerId());
                        continue;
                    }
                    this.logger.error("\u8c03\u7528bi \u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)baseJsonVo.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.redisService.save(key, 0, 21600L);
        this.logger.info("{}\u7ed3\u675f\u6267\u884c\u6253\u6807\u7b7e", (Object)DateUtils.now());
    }

    private List<FollowUserTag> getQiWeiTagList(DistributorQiyeweixinExternalContactEntity user) {
        try {
            FollowUserContactResult followUserContactResult = FollowUserAPI.getFollowUserInfo((String)this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7), (String)user.getExternalUserid());
            if (followUserContactResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)followUserContactResult.getFollow_user())) {
                Optional<FollowUser> optional = followUserContactResult.getFollow_user().stream().filter(followUser -> Objects.equals(followUser.getUserid(), user.getQyWeixinUserid())).findFirst();
                return optional.isPresent() ? optional.get().getTags() : null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Async
    @Deprecated
    public void markTag(DistributorQiyeweixinExternalContactEntity user) {
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(TagTypeEnum.model.getValue(), 1);
        this.customerTagService.removeUserTagBatch(user, tagList);
        List<TagRuleGroupEntity> tagRuleGroupResultList = this.tagRuleGroupService.getTagRuleGroupList();
        try {
            BaseJsonVo<List<JSONObject>> baseJsonVo = this.customerDataInvoke.getCustomerDataTagVo(user.getCustomerId());
            if (baseJsonVo.isSuccess()) {
                if (StringUtils.isNotEmpty((String)((JSONObject)((List)baseJsonVo.getValue()).get(0)).getString("customerId"))) {
                    this.markTag(user, tagList, tagRuleGroupResultList, (JSONObject)((List)baseJsonVo.getValue()).get(0));
                } else {
                    this.logger.error("BI\u7528\u6237:{}\u8bb0\u5f55\u4e0d\u5b58\u5728 \u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)user.getCustomerId());
                }
            } else {
                this.logger.error("\u8c03\u7528bi \u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)baseJsonVo.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Async
    public void markTag(Integer contactUserId) {
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactService.selectByPrimaryKey(contactUserId);
        if (user == null) {
            this.logger.info("\u7528\u6237\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728,id={}", (Object)contactUserId);
            return;
        }
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(TagTypeEnum.model.getValue(), 1);
        List<TagRuleGroupEntity> tagRuleGroupResultList = this.tagRuleGroupService.getTagRuleGroupList();
        ArrayList<ContactTagEntity> tagIdList = new ArrayList<ContactTagEntity>();
        for (ContactTagEntity tagItem : tagList) {
            List tagRuleGroupList = tagRuleGroupResultList.stream().filter(g -> Objects.equals(g.getTagId(), tagItem.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagRuleGroupList)) continue;
            tagIdList.add(tagItem);
        }
        this.customerTagService.removeUserTagBatch(user, tagList);
        this.markTag(user, tagIdList, tagRuleGroupResultList);
    }

    private void markTag(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> tagList, List<TagRuleGroupEntity> tagRuleGroupResultList) {
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        ArrayList<ContactTagEntity> markTagList = new ArrayList<ContactTagEntity>();
        for (ContactTagEntity tagItem : tagList) {
            List<TagRuleGroupEntity> ruleGroupList = tagRuleGroupResultList.stream().filter(tagRuleGroupEntity -> Objects.equals(tagItem.getId(), tagRuleGroupEntity.getTagId())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(ruleGroupList) || !this.checkMarkTag(user, tagItem, ruleGroupList)) continue;
            markTagList.add(tagItem);
        }
        if (markTagList.size() > 0) {
            List<String> tagStrIdList = markTagList.stream().map(ContactTagEntity::getWxContactTagId).collect(Collectors.toList());
            String[] tagArr = tagStrIdList.toArray(new String[tagStrIdList.size()]);
            userTagInfo.setAdd_tag(tagArr);
            this.customerTagService.markTag(userTagInfo, markTagList, user);
        }
    }

    private void markTag(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> tagList, List<TagRuleGroupEntity> tagRuleGroupList, JSONObject jsonObject) {
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        ArrayList<ContactTagEntity> markTagList = new ArrayList<ContactTagEntity>();
        for (ContactTagEntity tagItem : tagList) {
            List<TagRuleGroupEntity> ruleGroupList = tagRuleGroupList.stream().filter(tagRuleGroupEntity -> Objects.equals(tagItem.getId(), tagRuleGroupEntity.getTagId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ruleGroupList) || !this.checkMarkTag(user, tagItem, ruleGroupList, jsonObject)) continue;
            markTagList.add(tagItem);
        }
        if (markTagList.size() > 0) {
            this.customerTagService.markTagAndSave(user, markTagList);
        }
    }

    @Override
    public void markTag(Date date, String tagId, String customerId) {
        this.logger.info("{}\u5f00\u59cb\u6267\u884c\u6253\u6807\u7b7e", (Object)DateUtils.now());
        int maxPageSize = 0;
        PageForm pageForm = new PageForm();
        pageForm.setPageSize(250);
        ContactTagEntity queryTag = new ContactTagEntity();
        queryTag.setTagType(2);
        queryTag.setStatus(1);
        if (StringUtils.isNotEmpty((String)tagId)) {
            queryTag.setWxContactTagId(tagId);
        }
        List tagList = this.contactTagService.getList(queryTag, 0L);
        TagRuleGroupEntity tagRuleGroupQuery = new TagRuleGroupEntity();
        List tagRuleGroupResultList = this.tagRuleGroupService.getList(tagRuleGroupQuery);
        int i = 0;
        while (true) {
            pageForm.setCurrentPage(i);
            PageInfo<DistributorQiyeweixinExternalContactEntity> pageInfo = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(pageForm, customerId);
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570:{},\u603b\u9875\u6570:{}", (Object)i, (Object)pageInfo.getPages());
            maxPageSize = pageInfo.getPages();
            if (i > maxPageSize - 1) break;
            for (DistributorQiyeweixinExternalContactEntity user : pageInfo.getList()) {
                if (StringUtils.isEmpty((String)user.getCustomerId())) continue;
                this.customerTagService.removeUserTagBatch(user, tagList);
                ArrayList<Integer> tagIdList = new ArrayList<Integer>();
                for (ContactTagEntity tagItem : tagList) {
                    List tagRuleGroupList = tagRuleGroupResultList.stream().filter(g -> Objects.equals(g.getTagId(), tagItem.getId())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(tagRuleGroupList)) continue;
                    tagIdList.add(tagItem.getId());
                }
                this.markTag(user, tagList, tagRuleGroupResultList);
            }
            ++i;
        }
        this.logger.info("{}\u7ed3\u675f\u6267\u884c\u6253\u6807\u7b7e", (Object)DateUtils.now());
    }

    @Override
    public void markTag(String externalUserid, String channelId, String userID) {
        try {
            this.logger.info("\u5f00\u59cb\u7ed9\u7528\u6237:{},\u52a0\u4f01\u5fae\u6e20\u9053:{} openId:{}\u6253\u6807\u7b7e", new Object[]{userID, channelId, externalUserid});
            if (StringUtils.isEmpty((String)channelId)) {
                this.logger.info("\u7528\u6237:{},\u6d3b\u7801:{}\u4e3a\u7a7a", (Object)externalUserid, (Object)channelId);
                return;
            }
            CustomerContactQrcodeEntity query = new CustomerContactQrcodeEntity();
            query.setState(channelId);
            CustomerContactQrcodeEntity qrcodeEntity = (CustomerContactQrcodeEntity)this.customerContactQrcodeMapper.getSingle(query);
            String tagId = null;
            if (qrcodeEntity == null) {
                this.logger.info("\u6d3b\u7801:{}\u4e0d\u5b58\u5728", (Object)channelId);
                BaseJsonVo<Map<String, Object>> baseJsonVo = this.biChannelCodeInvoke.getChannelDict(channelId);
                if (!baseJsonVo.isSuccess()) {
                    this.logger.error("\u83b7\u53d6\u6807\u7b7e\u5931\u8d25:{}", (Object)baseJsonVo.getMessage());
                    return;
                }
                String tagName = ((Map)baseJsonVo.getValue()).get("customerTag").toString();
                ContactTagEntity queryTag = new ContactTagEntity();
                queryTag.setName(tagName);
                ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagService.getSingle(queryTag);
                if (contactTagEntity == null) {
                    this.logger.info("\u6807\u7b7e:{}\u4e0d\u5b58\u5728", (Object)tagName);
                    return;
                }
                tagId = contactTagEntity.getWxContactTagId();
            }
            String[] tagArr = null;
            if (StringUtils.isNotEmpty(tagId)) {
                tagArr = new String[]{tagId};
            } else {
                if (qrcodeEntity == null) {
                    this.logger.error("\u6d3b\u7801:{}\u4e3a\u7a7a", (Object)channelId);
                    return;
                }
                CustomerContactQrcodeTagEntity queryTag = new CustomerContactQrcodeTagEntity();
                queryTag.setQrcodeId(qrcodeEntity.getQrId());
                List list = this.customerContactQrcodeTagMapper.getList(queryTag);
                List<String> tagStrIdList = list.stream().map(CustomerContactQrcodeTagEntity::getTagId).collect(Collectors.toList());
                tagArr = tagStrIdList.toArray(new String[tagStrIdList.size()]);
            }
            UserTagInfo userTagInfo = new UserTagInfo();
            userTagInfo.setUserid(userID);
            userTagInfo.setExternal_userid(externalUserid);
            userTagInfo.setAdd_tag(tagArr);
            BaseResult baseResult = this.customerTagService.markTag(userTagInfo);
        }
        catch (Exception e) {
            this.logger.error("\u7ed9\u7528\u6237:{},\u52a0\u4f01\u5fae\u6e20\u9053:{} userId:{}\u6253\u6807\u7b7e\u5f02\u5e38", new Object[]{externalUserid, channelId, userID, e});
        }
    }

    @Override
    public void markTag(String date, Integer userId, Integer tagId) {
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactService.selectByPrimaryKey(userId);
        ContactTagEntity tagItem = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId);
        if (tagItem == null) {
            return;
        }
        this.markTag(date, user, tagItem);
    }

    @Override
    public void markChatTag(String externalUserid) {
        this.logger.info("\u5f00\u59cb\u7ed9\u7528\u6237:{}\u6253\u804a\u5929\u9891\u6b21\u6807\u7b7e", (Object)externalUserid);
        DistributorQiyeweixinExternalContactEntity userQuery = new DistributorQiyeweixinExternalContactEntity();
        userQuery.setExternalUserid(externalUserid);
        userQuery.setSaveSucc(1);
        List userList = this.distributorQiyeweixinExternalContactService.getList(userQuery, 0L);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            this.logger.info("\u8981\u6253\u6807\u7b7e\u7684\u7528\u6237:{}\u4e0d\u5b58\u5728", (Object)externalUserid);
            return;
        }
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(9);
        userList.forEach(user -> this.customerTagService.removeUserTagBatch((DistributorQiyeweixinExternalContactEntity)user, tagList));
        this.markChatTag(107, userList);
        this.markChatTag(108, userList);
        this.markChatTag(109, userList);
    }

    @Override
    public void markChatTag(Integer tagId, List<DistributorQiyeweixinExternalContactEntity> userList) {
        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId);
        if (contactTagEntity == null) {
            this.logger.info("\u6807\u7b7e:{}\u4e0d\u5b58\u5728", (Object)tagId);
            return;
        }
        userList.forEach(user -> {
            ArrayList<ContactTagEntity> list = new ArrayList<ContactTagEntity>();
            if (this.checkMarkTag((DistributorQiyeweixinExternalContactEntity)user, contactTagEntity)) {
                list.add(contactTagEntity);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.customerTagService.markTagAndSave((DistributorQiyeweixinExternalContactEntity)user, (List<ContactTagEntity>)list);
            }
        });
    }

    private void markTag(String date, DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem) {
        List<TagRuleGroupEntity> tagRuleGroupList = this.tagRuleGroupService.getList(tagItem.getId());
        if (CollectionUtils.isNotEmpty(tagRuleGroupList)) {
            BaseJsonVo<List<JSONObject>> baseJsonVo = this.customerDataInvoke.getCustomerDataTagVo(user.getCustomerId());
            if (baseJsonVo.isSuccess()) {
                if (StringUtils.isNotEmpty((String)((JSONObject)((List)baseJsonVo.getValue()).get(0)).getString("customerId"))) {
                    if (this.checkMarkTag(user, tagItem, tagRuleGroupList, (JSONObject)((List)baseJsonVo.getValue()).get(0))) {
                        this.customerTagService.markTag(user, tagItem, date);
                    }
                } else {
                    this.logger.error("BI\u7528\u6237:{}\u8bb0\u5f55\u4e0d\u5b58\u5728 \u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)user.getCustomerId());
                }
            } else {
                this.logger.error("\u8c03\u7528bi \u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)baseJsonVo.getMessage());
            }
        }
    }

    @Override
    @Async
    public void markTag4CallBack(String externaluserid, String userid) {
    }

    @Override
    @Async
    public void markTag(String date, DistributorQiyeweixinExternalContactEntity user, Integer tagId) {
        ContactTagEntity tagItem = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId);
        if (tagItem == null) {
            return;
        }
        this.markTag(date, user, tagItem);
    }

    @Override
    public void markTag(TagOfCustomerDo tagOfCustomerDo) {
        this.logger.info("\u5fae\u670d\u52a1\u63a5\u6536\u53c2\u6570:{}", (Object)tagOfCustomerDo.toString());
        if (tagOfCustomerDo != null) {
            DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactService.selectByPrimaryKey(tagOfCustomerDo.getUserId());
            UserTagInfo userTagInfo = new UserTagInfo();
            userTagInfo.setUserid(user.getQyWeixinUserid());
            userTagInfo.setExternal_userid(user.getExternalUserid());
            ArrayList<String> tagIdList = new ArrayList<String>();
            for (Integer tagId : tagOfCustomerDo.getTagIdList()) {
                ContactTagEntity tagItem;
                List<TagRuleGroupEntity> tagRuleGroupList = this.tagRuleGroupService.getList(tagId);
                if (!CollectionUtils.isNotEmpty(tagRuleGroupList) || !this.checkMarkTag(user, tagItem = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId), tagRuleGroupList)) continue;
                tagIdList.add(tagItem.getWxContactTagId());
            }
            if (tagIdList.size() > 0) {
                String[] tagArr = tagIdList.toArray(new String[tagIdList.size()]);
                userTagInfo.setAdd_tag(tagArr);
                this.customerTagService.markTag(userTagInfo);
            }
        }
    }

    @Override
    public void markTag(String date, Integer userId, Integer[] tagIdList) {
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactService.selectByPrimaryKey(userId);
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        ArrayList<String> tagStrIdList = new ArrayList<String>();
        ArrayList<ContactTagEntity> list = new ArrayList<ContactTagEntity>();
        List<TagRuleGroupEntity> tagRuleGroupList = this.tagRuleGroupService.getTagRuleGroupList();
        if (tagIdList != null && tagIdList.length > 0) {
            for (Integer tagId : tagIdList) {
                List<TagRuleGroupEntity> ruleGroupList = tagRuleGroupList.stream().filter(tagRuleGroupEntity -> Objects.equals(tagId, tagRuleGroupEntity.getTagId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(ruleGroupList)) {
                    this.logger.info("\u6807\u7b7e:{}\u672a\u914d\u7f6e\u89c4\u5219\u7ec4", (Object)tagId);
                    continue;
                }
                ContactTagEntity tagItem = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId);
                if (!this.checkMarkTag(user, tagItem, ruleGroupList)) continue;
                tagStrIdList.add(tagItem.getWxContactTagId());
                list.add(tagItem);
            }
            if (tagStrIdList.size() > 0) {
                String[] tagArr = tagStrIdList.toArray(new String[tagStrIdList.size()]);
                userTagInfo.setAdd_tag(tagArr);
                this.customerTagService.markTag(userTagInfo);
                this.customerTagService.saveUserTag(user, list);
            }
        }
    }

    private boolean checkMarkTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem) {
        List<TagRuleGroupEntity> tagRuleGroupList = this.tagRuleGroupService.getTagRuleGroupList();
        if (CollectionUtils.isEmpty(tagRuleGroupList)) {
            this.logger.info("\u6807\u7b7e:{}\u672a\u914d\u7f6e\u89c4\u5219\u7ec4", (Object)tagItem.getName());
            return false;
        }
        List<TagRuleGroupEntity> ruleGroupList = tagRuleGroupList.stream().filter(tagRuleGroupEntity -> Objects.equals(tagItem.getId(), tagRuleGroupEntity.getTagId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ruleGroupList)) {
            this.logger.info("\u6807\u7b7e:{}\u672a\u914d\u7f6e\u89c4\u5219\u7ec4", (Object)tagItem.getName());
            return false;
        }
        return this.checkMarkTag(user, tagItem, ruleGroupList);
    }

    private boolean checkMarkTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem, List<TagRuleGroupEntity> tagRuleGroupList) {
        boolean groupRuleFlag = false;
        for (TagRuleGroupEntity tagRuleGroupItem : tagRuleGroupList) {
            List<TagRuleEntity> tagRuleList = this.tagRuleService.getTagRuleEntityList(tagRuleGroupItem.getId());
            if (!CollectionUtils.isNotEmpty(tagRuleList)) continue;
            for (TagRuleEntity tagRuleItem : tagRuleList) {
                groupRuleFlag = this.tagRuleContext.checkTagRule(user, tagRuleItem);
                this.logger.info("\u7528\u6237:{},\u89c4\u5219:{},\u6807\u7b7e:{},\u6807\u7b7e\u662f\u5426\u6807\u8bc6:{}", new Object[]{user.getCustomerId(), tagRuleItem.getRuleName(), tagItem.getName(), groupRuleFlag});
                if (!(tagRuleGroupItem.getConditionType().intValue() == ConditionTypeEnum.and.getValue() ? !groupRuleFlag : tagRuleGroupItem.getConditionType().intValue() == ConditionTypeEnum.or.getValue() && groupRuleFlag)) continue;
                break;
            }
            if (!(tagItem.getConditionType().intValue() == ConditionTypeEnum.and.getValue() ? !groupRuleFlag : tagItem.getConditionType().intValue() == ConditionTypeEnum.or.getValue() && groupRuleFlag)) continue;
            break;
        }
        return groupRuleFlag;
    }

    private boolean checkMarkTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem, List<TagRuleGroupEntity> tagRuleGroupList, JSONObject jsonObject) {
        boolean groupRuleFlag = false;
        for (TagRuleGroupEntity tagRuleGroupItem : tagRuleGroupList) {
            List<TagRuleEntity> tagRuleList = this.tagRuleService.getTagRuleEntityList(tagRuleGroupItem.getId());
            if (!CollectionUtils.isNotEmpty(tagRuleList)) continue;
            for (TagRuleEntity tagRuleItem : tagRuleList) {
                groupRuleFlag = this.tagRuleContext.checkTagRule(user, tagRuleItem, jsonObject);
                if (!(tagRuleGroupItem.getConditionType().intValue() == ConditionTypeEnum.and.getValue() ? !groupRuleFlag : tagRuleGroupItem.getConditionType().intValue() == ConditionTypeEnum.or.getValue() && groupRuleFlag)) continue;
                break;
            }
            if (!(tagItem.getConditionType().intValue() == ConditionTypeEnum.and.getValue() ? !groupRuleFlag : tagItem.getConditionType().intValue() == ConditionTypeEnum.or.getValue() && groupRuleFlag)) continue;
            break;
        }
        return groupRuleFlag;
    }

    @Override
    public void removeTag(String tagId, String customerId, Integer pageNum) {
        this.logger.info("{}\u5f00\u59cb\u79fb\u9664\u6807\u7b7e", (Object)DateUtils.now());
        int maxPageSize = 0;
        PageForm pageForm = new PageForm();
        pageForm.setPageSize(250);
        ContactTagEntity queryTag = new ContactTagEntity();
        if (StringUtils.isNotEmpty((String)tagId)) {
            queryTag.setWxContactTagId(tagId);
        } else {
            queryTag.setTagType(2);
            queryTag.setStatus(1);
        }
        List tagList = this.contactTagService.getList(queryTag, 0L);
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            return;
        }
        String key = "QiYeWeiXin:RemoveUserTagPageNum";
        if (pageNum == null) {
            Object cachePage = this.redisService.get(key);
            pageNum = cachePage != null ? (Integer)cachePage : Integer.valueOf(0);
        }
        int i = pageNum;
        while (true) {
            pageForm.setCurrentPage(i);
            PageInfo<DistributorQiyeweixinExternalContactEntity> pageInfo = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(pageForm, customerId);
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570:{},\u603b\u9875\u6570:{}", (Object)i, (Object)pageInfo.getPages());
            maxPageSize = pageInfo.getPages();
            this.redisService.save(key, i, 21600L);
            if (i > maxPageSize - 1) break;
            for (DistributorQiyeweixinExternalContactEntity user : pageInfo.getList()) {
                if (StringUtils.isEmpty((String)user.getCustomerId())) continue;
                BaseResult baseResult = this.customerTagService.removeUserTagBatch(user, tagList);
            }
            ++i;
        }
        this.redisService.save(key, 0, 21600L);
        this.logger.info("{}\u7ed3\u675f\u6267\u884c\u79fb\u9664\u6807\u7b7e", (Object)DateUtils.now());
    }

    @Override
    public void removeTag(Integer userId, Integer tagId) {
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactService.selectByPrimaryKey(userId);
        if (user != null) {
            ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(tagId);
            if (contactTagEntity != null) {
                this.customerTagService.removeUserTag(user, contactTagEntity);
            } else {
                this.logger.info("\u8981\u79fb\u9664\u7684\u6807\u7b7e{}\u4e0d\u5b58\u5728", (Object)tagId);
            }
        } else {
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e\uff0c\u7528\u6237:{}\u4e0d\u5b58\u5728", (Object)userId);
        }
    }

    @Override
    public void getUserTag(String customerId, Integer pageNum) {
        Long beginTime = System.currentTimeMillis();
        int maxPageSize = 0;
        PageForm pageForm = new PageForm();
        pageForm.setPageSize(250);
        String key = "QiYeWeiXin:GetUserTagPageNum";
        if (pageNum == null) {
            Object cachePage = this.redisService.get(key);
            pageNum = cachePage != null ? (Integer)cachePage : Integer.valueOf(0);
        }
        int i = pageNum;
        while (true) {
            pageForm.setCurrentPage(i);
            PageInfo<DistributorQiyeweixinExternalContactEntity> pageInfo = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(pageForm, customerId);
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570:{},\u603b\u9875\u6570:{}", (Object)i, (Object)pageInfo.getPages());
            maxPageSize = pageInfo.getPages();
            this.redisService.save(key, i, 21600L);
            if (i > maxPageSize - 1) break;
            String cursor = "";
            for (DistributorQiyeweixinExternalContactEntity user : pageInfo.getList()) {
                FollowUserContactResult followUserContactResult = FollowUserAPI.getFollowUserInfo((String)this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7), (String)user.getExternalUserid());
                if (!followUserContactResult.isSuccess()) continue;
                followUserContactResult.getFollow_user().forEach(followUserInfo -> {
                    if (Objects.equals(followUserInfo.getUserid(), user.getQyWeixinUserid())) {
                        this.customerTagService.saveUserTag(followUserInfo.getTags(), user.getExternalUserid(), user.getCustomerId(), user.getQyWeixinUserid());
                    }
                });
            }
            ++i;
        }
        this.redisService.save(key, 0, 21600L);
        this.logger.info("\u83b7\u53d6\u7528\u6237\u6807\u7b7e\u7528\u65f6{}\u79d2", (Object)Float.valueOf((float)(System.currentTimeMillis() - beginTime) / 1000.0f));
    }

    @Override
    @Async
    public void getUserTag(DistributorQiyeweixinExternalContactEntity user) {
        FollowUserContactResult followUserContactResult = FollowUserAPI.getFollowUserInfo((String)this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7), (String)user.getExternalUserid());
        if (followUserContactResult.isSuccess()) {
            followUserContactResult.getFollow_user().forEach(followUserInfo -> {
                if (Objects.equals(followUserInfo.getUserid(), user.getQyWeixinUserid())) {
                    this.customerTagService.saveUserTag(followUserInfo.getTags(), user.getExternalUserid(), user.getCustomerId(), user.getQyWeixinUserid());
                }
            });
        }
    }

    @Override
    public BaseJsonVo pullTag() {
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        TagGroupResult baseResult = WxApiUtils.requestGetAllTag((String)accessToken);
        this.logger.info("\u540c\u6b65\u6807\u7b7e:{}", (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            for (TagGroupResult.TagGroup tagGroup : baseResult.getTagGroupList()) {
                BaseJsonVo baseJsonVo = this.contactTagGroupService.save(tagGroup);
                if (!baseJsonVo.isSuccess()) continue;
                for (TagGroupResult.TagGroup.Tag tag : tagGroup.getTagList()) {
                    this.logger.info("\u540c\u6b65\u6807\u7b7e:{}", (Object)JsonUtils.toJson((Object)tag, (boolean)false));
                    this.contactTagService.saveTagItem(tag, tagGroup);
                }
            }
        } else {
            return BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.success((Object)"\u540c\u6b65\u6210\u529f");
    }

    @Override
    public void markTag4FirstOrder(DistributorQiyeweixinExternalContactEntity user) {
        ContactTagEntity contactTagEntity;
        this.logger.info("\u7528\u6237:{}\u52a0\u79c1\u57df\u65e5\u671f:{}", (Object)user.getCustomerId(), (Object)user.getCreateTime());
        CustomerEntity customerEntity = this.customerInterface.getCustomer(user.getCustomerId());
        String firstOrderDate = "";
        try {
            BaseJsonVo<String> baseJsonVo;
            if (StringUtils.isNotEmpty((String)customerEntity.getMobile())) {
                baseJsonVo = this.biOrderDetailInvoke.getFirstOrderDateByPhone(customerEntity.getMobile());
                if (baseJsonVo.isSuccess() && StringUtils.isNotEmpty((String)((String)baseJsonVo.getValue()))) {
                    firstOrderDate = (String)baseJsonVo.getValue();
                }
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getFirstOrderDateByCustomerId(user.getCustomerId());
                if (baseJsonVo.isSuccess() && StringUtils.isNotEmpty((String)((String)baseJsonVo.getValue()))) {
                    firstOrderDate = (String)baseJsonVo.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info("\u7528\u6237:{}\u9996\u5355\u65e5\u671f:{}", (Object)user.getCustomerId(), (Object)firstOrderDate);
        if (Objects.equals(DateUtils.formatDate((Date)user.getCreateTime(), (String)"yyyy-MM-dd"), firstOrderDate) && (contactTagEntity = (ContactTagEntity)this.contactTagService.selectByPrimaryKey(Integer.valueOf(9))) != null) {
            CustomerTagEntity customerTagQuery = new CustomerTagEntity();
            customerTagQuery.setCustomerId(user.getCustomerId());
            customerTagQuery.setTagId(contactTagEntity.getWxContactTagId());
            CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagService.getSingle(customerTagQuery, 0L);
            if (customerTagEntity != null) {
                this.customerTagService.removeUserTag(user, customerTagEntity);
            }
            this.customerTagService.markTag(user, contactTagEntity, firstOrderDate);
        }
    }

    @Override
    public void marKTag4Province(Map<String, Object> orderItemMap, String execDate, DistributorQiyeweixinExternalContactEntity user) {
        int day = 365;
        if (orderItemMap.containsKey("phone") && StringUtils.isNotEmpty((String)orderItemMap.get("phone").toString())) {
            BaseJsonVo<Map<String, Object>> baseJsonVo = this.biOrderDetailInvoke.getMostProvince(orderItemMap.get("phone").toString(), day);
            if (baseJsonVo.isSuccess()) {
                if (baseJsonVo.getValue() != null) {
                    ContactTagEntity query = new ContactTagEntity();
                    if (((Map)baseJsonVo.getValue()).containsKey("province")) {
                        query.setName(((Map)baseJsonVo.getValue()).get("province").toString().replace("\u7701", "").replace("\u5e02", ""));
                        query.setStatus(1);
                        query.setContactTagGroupId(14);
                        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagService.getSingle(query);
                        if (contactTagEntity != null) {
                            CustomerTagEntity customerTagQuery = new CustomerTagEntity();
                            customerTagQuery.setCustomerId(user.getCustomerId());
                            customerTagQuery.setTagGroupName("\u57fa\u7840\u5c5e\u6027-\u7701\u4efd");
                            List list = this.customerTagService.getList(customerTagQuery, 0L);
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                this.customerTagService.removeUserTag(user, list);
                            }
                            this.customerTagService.markTag(user, contactTagEntity, execDate);
                        } else {
                            this.logger.info("\u7701\u4efd:{}\u6ca1\u6709\u67e5\u627e\u5230\u6807\u7b7e", (Object)((Map)baseJsonVo.getValue()).get("province").toString());
                        }
                    } else {
                        this.logger.info("\u67e5\u8be2\u7ed3\u679c\u4e2d\u4e0d\u5305\u542b\u7701\u4efd");
                    }
                }
            } else {
                this.logger.info("\u7528\u6237:{},{}\u5929\u67e5\u8be2\u7701\u4efd\u51fa\u9519", (Object)orderItemMap.get("phone").toString(), (Object)day);
            }
        }
    }

    @Override
    public BaseJsonVo deleteTag(String tagIds) {
        String[] ids = tagIds.split(",");
        List<ContactTagEntity> tagEntityList = this.contactTagService.getWxContactTagListByWxTagList(Arrays.asList(ids));
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        List wxTagIds = tagEntityList.stream().map(ContactTagEntity::getWxContactTagId).collect(Collectors.toList());
        BaseResult baseResult = WxApiUtils.requestDelTags((String)accessToken, wxTagIds);
        this.logger.info("\u5220\u9664\u6807\u7b7e:{},\u5220\u9664\u7ed3\u679c:{}", (Object)tagIds, (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            for (ContactTagEntity tagEntity : tagEntityList) {
                this.contactTagService.deleteTag(tagEntity.getId());
            }
        }
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    private List<ContactTagEntity> getCustomerTag(List<DistributorQiyeweixinExternalContactEntity> users, List<ContactTagEntity> tagList, List<TagRuleGroupEntity> tagRuleGroupList, JSONObject jsonObject) {
        ArrayList<ContactTagEntity> markTagList = new ArrayList<ContactTagEntity>();
        for (DistributorQiyeweixinExternalContactEntity user : users) {
            if (StringUtils.isNotEmpty((String)jsonObject.getString("customerId"))) {
                for (ContactTagEntity tagItem : tagList) {
                    List<TagRuleGroupEntity> ruleGroupList = tagRuleGroupList.stream().filter(tagRuleGroupEntity -> Objects.equals(tagItem.getId(), tagRuleGroupEntity.getTagId())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(ruleGroupList) || !this.checkMarkTag(user, tagItem, ruleGroupList, jsonObject) || markTagList.stream().filter(c -> c.getId().equals(tagItem.getId())).count() != 0L) continue;
                    markTagList.add(tagItem);
                }
                continue;
            }
            this.logger.error("BI\u7528\u6237:{}\u8bb0\u5f55\u4e0d\u5b58\u5728 ", (Object)user.getCustomerId());
        }
        return markTagList;
    }

    @Override
    public BaseJsonVo setBiTags(String customerId) {
        Integer maxId = null;
        List<TagRuleGroupEntity> tagRuleGroupResultList = this.tagRuleGroupService.getTagRuleGroupList();
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(TagTypeEnum.model.getValue(), 1);
        long beginTime = System.currentTimeMillis();
        while (!Integer.valueOf(-1).equals(maxId)) {
            BaseJsonVo<List<JSONObject>> baseJsonVo = this.customerDataInvoke.getDoTagItemList(customerId, maxId, 100);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("BI\u65e0\u6cd5\u8fd4\u56de\u6570\u636e");
                return baseJsonVo;
            }
            if (((List)baseJsonVo.getValue()).size() == 0) {
                maxId = -1;
                this.logger.info("setBiTags\u7ed3\u675f,\u7528\u65f6{}\u79d2\uff1a", (Object)Float.valueOf((float)(System.currentTimeMillis() - beginTime) / 1000.0f));
                break;
            }
            maxId = tagList.stream().mapToInt(c -> c.getId()).max().getAsInt();
            List<String> custs = ((List)baseJsonVo.getValue()).stream().map(c -> c.getString("customerId")).collect(Collectors.toList());
            List<DistributorQiyeweixinExternalContactEntity> contactEntities = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(custs.toArray(new String[custs.size()]));
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            for (JSONObject jsonObject : (List)baseJsonVo.getValue()) {
                JSONObject jsonObject1 = new JSONObject();
                jsonObject1.put("id", jsonObject.get((Object)"id"));
                jsonObject1.put("tagDate", (Object)DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
                jsonObject1.put("tagIds", (Object)"");
                jsonObject1.put("tagState", (Object)0);
                if (StringUtils.isNotEmpty((String)jsonObject.getString("customerId"))) {
                    List<DistributorQiyeweixinExternalContactEntity> users = contactEntities.stream().filter(c -> jsonObject.getString("customerId").equals(c.getCustomerId())).collect(Collectors.toList());
                    if (users.size() == 0) {
                        this.logger.error("\u7528\u6237{}\u65e0\u57fa\u7840\u6570\u636e" + jsonObject.getString("customerId"));
                    } else {
                        String oldtags = jsonObject.getString("tagIds");
                        List<ContactTagEntity> userNewTagList = this.getCustomerTag(users, tagList, tagRuleGroupResultList, jsonObject);
                        if (userNewTagList.size() > 0) {
                            List lst = userNewTagList.stream().map(c -> c.getWxContactTagId()).collect(Collectors.toList());
                            String newtags = String.join((CharSequence)",", lst);
                            if (!newtags.equals(oldtags)) {
                                jsonObject1.put("tagIds", (Object)newtags);
                            } else {
                                jsonObject1.put("tagIds", null);
                                jsonObject1.put("tagState", (Object)jsonObject.getIntValue("tagState"));
                            }
                        }
                    }
                }
                result.add(jsonObject1);
            }
            if (result.size() <= 0) continue;
            this.customerDataInvoke.updateTagAndDate(JsonUtils.toJson(result, (boolean)false));
        }
        return BaseJsonVo.success((Object)"\u5b8c\u6210");
    }

    @Override
    public void markTagNew(String customerId, Integer pageNum) {
        this.logger.info("{}\u5f00\u59cb\u6267\u884c\u6253\u6807\u7b7e", (Object)DateUtils.now());
        boolean isComplate = false;
        long beginTime = System.currentTimeMillis();
        List<ContactTagEntity> tagList = this.contactTagService.getContactTagList(TagTypeEnum.model.getValue(), 1);
        while (!isComplate) {
            long startTime = System.currentTimeMillis();
            BaseJsonVo<List<JSONObject>> baseJsonVo = this.customerDataInvoke.getWaitTagItemList(customerId, 100);
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("BI\u65e0\u6cd5\u8fd4\u56de\u6570\u636e");
                return;
            }
            if (((List)baseJsonVo.getValue()).size() == 0) {
                isComplate = true;
                this.logger.info("\u6253\u6807\u7b7e\u7ed3\u675f,\u7528\u65f6{}\u79d2\uff1a", (Object)Float.valueOf((float)(System.currentTimeMillis() - beginTime) / 1000.0f));
                break;
            }
            List<String> custs = ((List)baseJsonVo.getValue()).stream().map(c -> c.getString("customerId")).collect(Collectors.toList());
            custs = custs.stream().filter(c -> StringUtils.isNotEmpty((String)c)).collect(Collectors.toList());
            List<DistributorQiyeweixinExternalContactEntity> contactEntities = this.distributorQiyeweixinExternalContactService.getDistributorQiyeweixinExternalContactEntityList(custs.toArray(new String[custs.size()]));
            List<ContactTagEntityVo> contactTagEntityVos = this.contactTagService.getUserHaveTages(custs.toArray(new String[custs.size()]));
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            for (JSONObject jsonObject : (List)baseJsonVo.getValue()) {
                JSONObject jsonObject1 = new JSONObject();
                jsonObject1.put("id", jsonObject.get((Object)"id"));
                jsonObject1.put("tagState", (Object)1);
                List<ContactTagEntityVo> ownTagList = contactTagEntityVos.stream().filter(c -> jsonObject.getString("customerId").equals(c.getCustomerId())).collect(Collectors.toList());
                String deletedTag = "etEgf2CQAAK_7FZtdU14pV6UBAg4VI5w";
                ownTagList.removeAll(ownTagList.stream().filter(c -> c.getWxContactTagId().equals(deletedTag)).collect(Collectors.toList()));
                List<DistributorQiyeweixinExternalContactEntity> users = contactEntities.stream().filter(c -> jsonObject.getString("customerId").equals(c.getCustomerId())).collect(Collectors.toList());
                if (users.size() == 0) {
                    this.logger.error("\u7528\u6237{}\u65e0\u57fa\u7840\u6570\u636e" + jsonObject.getString("customerId"));
                    jsonObject1.put("tagMessage", (Object)"\u7528\u6237\u5df2\u5220\u9664");
                    jsonObject1.put("tagState", (Object)-1);
                } else {
                    String tags = jsonObject.getString("tagIds");
                    List<ContactTagEntity> userNewTagList = this.getTags(tagList, tags);
                    try {
                        BaseResult baseResult;
                        List removeList = ownTagList.stream().filter(item -> userNewTagList.stream().map(ContactTagEntity::getWxContactTagId).anyMatch(item1 -> Objects.equals(item1, item.getWxContactTagId()))).collect(Collectors.toList());
                        if (removeList.size() > 0) {
                            ownTagList.removeAll(removeList);
                            userNewTagList.removeAll(userNewTagList.stream().filter(item -> removeList.stream().map(ContactTagEntity::getWxContactTagId).anyMatch(item1 -> Objects.equals(item1, item.getWxContactTagId()))).collect(Collectors.toList()));
                        }
                        if (!(ownTagList.size() <= 0 && userNewTagList.size() <= 0 || (baseResult = this.customerTagService.markUserWeixinTag(users, ownTagList, userNewTagList)).isSuccess())) {
                            jsonObject1.put("tagState", (Object)-1);
                            jsonObject1.put("tagMessage", (Object)baseResult.getErrmsg());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                result.add(jsonObject1);
            }
            if (result.size() > 0) {
                BaseJsonVo baseJsonVo2 = this.customerDataInvoke.updateTagAndDate(JsonUtils.toJson(result, (boolean)false));
            }
            this.logger.info("\u4e00\u7ec4\u7528\u6237[{}]\u6267\u884c\u7528\u65f6{}\u79d2", (Object)((List)baseJsonVo.getValue()).size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
        }
        this.logger.info("\u7ed3\u675f\u6267\u884c\u6253\u6807\u7b7e{}", (Object)DateUtils.now());
    }

    private List<ContactTagEntity> getTags(List<ContactTagEntity> tagEntities, String tags) {
        if (StringUtils.isEmpty((String)tags) || tagEntities.size() == 0) {
            return new ArrayList<ContactTagEntity>();
        }
        String[] tagArr = tags.split(",");
        return tagEntities.stream().filter(item -> Arrays.stream(tagArr).anyMatch(item1 -> Objects.equals(item1, item.getWxContactTagId()))).collect(Collectors.toList());
    }
}

