/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.cms.MarkTagInvoke;
import cc.lechun.cms.dto.TagOfCustomerDo;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.dao.distribution.DistributorQiyeweixinExternalContactMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.tag.ContactTagMapper;
import cc.lechun.qiyeweixin.dao.tag.CustomerTagMapper;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntityVo;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.CustomerTagDo;
import cc.lechun.qiyeweixin.entity.tag.CustomerTagEntity;
import cc.lechun.qiyeweixin.entity.tag.TagCustomerQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagCustomerVo;
import cc.lechun.qiyeweixin.entity.tag.TagTypeEnum;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagGroupInterface;
import cc.lechun.qiyeweixin.iservice.tag.CustomerTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.WorkUpdateTimeInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.FollowUserTag;
import weixin.popular.bean.qy.tag.UserTagInfo;

@Service
public class CustomerTagService
extends BaseService<CustomerTagEntity, Integer>
implements CustomerTagInterface {
    @Resource
    private CustomerTagMapper customerTagMapper;
    @Autowired
    private CustomerInterface customerInterface;
    @Resource
    private DistributorMapper distributorMapper;
    @Autowired
    WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Resource
    private ContactTagGroupInterface contactTagGroupService;
    @Autowired
    WorkUpdateTimeInterface workUpdateTimeService;
    @Resource
    private DistributorQiyeweixinExternalContactMapper distributorQiyeweixinExternalContactMapper;
    @Resource
    private ContactTagMapper contactTagMapper;
    @Lazy
    @Autowired
    MarkTagInvoke markTagInvoke;

    @Override
    @Async
    public void addUserTag(String userId, String externalUserID) {
        try {
            DistributorQiyeweixinExternalContactEntity query = new DistributorQiyeweixinExternalContactEntity();
            if (StringUtils.isNotEmpty((String)externalUserID)) {
                query.setExternalUserid(externalUserID);
            }
            if (StringUtils.isNotEmpty((String)userId)) {
                query.setQyWeixinUserid(userId);
            }
            this.logger.info("\u67e5\u8be2\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)query, (boolean)false));
            DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactMapper.getSingle(query);
            this.logger.info("\u67e5\u8be2\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)user, (boolean)false));
            if (user != null) {
                CustomerEntity customerEntity = this.customerInterface.getCustomer(user.getCustomerId());
                if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getMobile())) {
                    List<Map<String, Object>> list = this.distributorQiyeweixinExternalContactMapper.getUserCommunityPhoneList(customerEntity.getMobile());
                    this.logger.info("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7ed3\u679c:{}", (Object)JsonUtils.toJson(list, (boolean)false));
                    if (CollectionUtils.isNotEmpty(list)) {
                        ArrayList result = new ArrayList();
                        list.forEach(info -> {
                            CustomerTagEntity customerTagEntity = new CustomerTagEntity();
                            customerTagEntity.setTagId("\u7528\u6237\u5c0f\u533a");
                            customerTagEntity.setExternalUserid(user.getExternalUserid());
                            customerTagEntity.setQyWeixinUserid(user.getQyWeixinUserid());
                            customerTagEntity.setCustomerId(user.getCustomerId());
                            customerTagEntity.setTagType(4);
                            customerTagEntity.setTagGroupName("\u7528\u6237\u5c0f\u533a\u7ec4");
                            customerTagEntity.setCreateTime(DateUtils.now());
                            customerTagEntity.setTagName(info.getOrDefault("community_name", "").toString());
                            result.add(customerTagEntity);
                        });
                        if (CollectionUtils.isNotEmpty(result)) {
                            this.customerTagMapper.batchInsert(result);
                        }
                    }
                } else {
                    this.logger.info("\u7528\u6237:{},\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7", (Object)user.getCustomerId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<CustomerTagEntity> getCustomerTagList(String qyWeixinUserid, String externalUserid, String[] tagIdList) {
        return this.customerTagMapper.getCustomerTagList(qyWeixinUserid, externalUserid, tagIdList);
    }

    @Override
    public void testGetUserList(String tagId) {
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
    }

    @Override
    public void testRemoveTag(String tagId) {
        String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid("LangHua");
        userTagInfo.setExternal_userid("wmEgf2CQAAu22uryWa7jWuiZagUOUIOQ");
        String[] tagArr = new String[]{tagId};
        userTagInfo.setRemove_tag(tagArr);
        this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e\u8f93\u5165\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false));
        BaseResult baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
        this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e:{},\u7ed3\u679c{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)baseResult.toString());
        if (baseResult == null || baseResult.isSuccess()) {
            // empty if block
        }
    }

    @Override
    public void saveUserTag(List<FollowUserTag> tags, String external_userid, String customerId, String userId) {
        try {
            if (CollectionUtils.isNotEmpty(tags)) {
                ArrayList<CustomerTagEntity> result = new ArrayList<CustomerTagEntity>();
                for (FollowUserTag tag : tags) {
                    CustomerTagEntity query = new CustomerTagEntity();
                    query.setTagId(tag.getTag_id());
                    query.setExternalUserid(external_userid);
                    query.setQyWeixinUserid(userId);
                    CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagMapper.getSingle(query);
                    if (customerTagEntity != null) continue;
                    customerTagEntity = new CustomerTagEntity();
                    customerTagEntity.setTagId(tag.getTag_id());
                    customerTagEntity.setExternalUserid(external_userid);
                    customerTagEntity.setCustomerId(customerId);
                    customerTagEntity.setQyWeixinUserid(userId);
                    customerTagEntity.setTagName(tag.getTag_name());
                    customerTagEntity.setTagGroupName(tag.getGroup_name());
                    customerTagEntity.setTagType(tag.getType());
                    customerTagEntity.setCreateTime(DateUtils.now());
                    result.add(customerTagEntity);
                }
                if (CollectionUtils.isNotEmpty(result)) {
                    this.customerTagMapper.batchInsert(result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6279\u91cf\u6dfb\u52a0\u7528\u6237\u6807\u7b7e\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    @Override
    public void saveUserTag(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> list) {
        ArrayList tempList = new ArrayList();
        list.forEach(tag -> {
            CustomerTagEntity query = new CustomerTagEntity();
            query.setTagId(tag.getWxContactTagId());
            query.setCustomerId(user.getCustomerId());
            query.setQyWeixinUserid(user.getQyWeixinUserid());
            CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagMapper.getSingle(query);
            if (customerTagEntity == null) {
                customerTagEntity = new CustomerTagEntity();
                customerTagEntity.setCreateTime(DateUtils.now());
                customerTagEntity.setCustomerId(user.getCustomerId());
                customerTagEntity.setExternalUserid(user.getExternalUserid());
                customerTagEntity.setQyWeixinUserid(user.getQyWeixinUserid());
                customerTagEntity.setTagId(tag.getWxContactTagId());
                customerTagEntity.setTagName(tag.getName());
                customerTagEntity.setTagType(1);
                ContactTagGroupEntity contactTagGroupEntity = this.contactTagGroupService.getTagGroup(tag.getWxTagGroupId());
                customerTagEntity.setTagGroupName(contactTagGroupEntity != null ? contactTagGroupEntity.getGroupName() : "");
                tempList.add(customerTagEntity);
            }
        });
        if (CollectionUtils.isNotEmpty(tempList)) {
            this.batchInsert(tempList);
        }
    }

    @Override
    @Async
    public void markTagAndSave(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> list) {
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        List<String> tagStrIdList = list.stream().map(ContactTagEntity::getWxContactTagId).collect(Collectors.toList());
        String[] tagArr = tagStrIdList.toArray(new String[tagStrIdList.size()]);
        userTagInfo.setAdd_tag(tagArr);
        BaseResult baseResult = this.markTag(userTagInfo);
        if (baseResult.isSuccess()) {
            this.saveUserTag(user, list);
        }
    }

    @Override
    public int getCustomerNum(String tagId) {
        return this.customerTagMapper.getCustomerNum(tagId);
    }

    @Override
    @Async
    public void removeUserTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem, CustomerTagEntity customerTagEntity) {
        try {
            BaseResult baseResult = this.removeUserTag(user, tagItem);
            if (baseResult != null && baseResult.isSuccess()) {
                this.deleteByPrimaryKey(customerTagEntity.getId());
                this.logger.info("\u5220\u9664\u7528\u6237{},\u6807\u7b7e\u6a21\u578b:{}\u6210\u529f", (Object)user.getCustomerId(), (Object)tagItem.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6253\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{}", (Object)JsonUtils.toJson((Object)tagItem, (boolean)false), (Object)JsonUtils.toJson((Object)user, (boolean)false));
        }
    }

    @Override
    public BaseResult removeUserTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem) {
        try {
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
            UserTagInfo userTagInfo = new UserTagInfo();
            userTagInfo.setUserid(user.getQyWeixinUserid());
            userTagInfo.setExternal_userid(user.getExternalUserid());
            String[] tagArr = new String[]{tagItem.getWxContactTagId()};
            userTagInfo.setRemove_tag(tagArr);
            this.logger.info(" \u670d\u52a1\u4eba\u5458:{}\u79fb\u9664\u7528\u6237:{}\u6807\u7b7e :{}", new Object[]{user.getQyWeixinUserid(), user.getCustomerId(), tagItem.getName()});
            BaseResult baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e:{},\u7ed3\u679c{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)baseResult.toString());
            return baseResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6253\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{}", (Object)JsonUtils.toJson((Object)tagItem, (boolean)false), (Object)JsonUtils.toJson((Object)user, (boolean)false));
            BaseResult baseResult = new BaseResult();
            baseResult.setErrmsg("\u79fb\u9664\u6807\u7b7e\u51fa\u9519");
            return baseResult;
        }
    }

    private BaseResult removeUserTag(UserTagInfo userTagInfo) {
        BaseResult baseResult = new BaseResult();
        try {
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e\u8f93\u5165\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false));
            baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e:{},\u7ed3\u679c{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)baseResult.toString());
            return baseResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6253\u6807\u7b7e\u51fa\u9519,\u7528\u6237\u6807\u7b7e:{},\u9519\u8bef\u6d88\u606f:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)e.getMessage());
            baseResult.setErrcode("-9999");
            baseResult.setErrmsg("\u79fb\u9664\u6807\u7b7e\u51fa\u9519" + e.getMessage());
            return baseResult;
        }
    }

    @Override
    public void removeUserTagByTagId(DistributorQiyeweixinExternalContactEntity user, Integer tagId) {
        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagId);
        if (contactTagEntity == null) {
            this.logger.info("\u6807\u7b7e:{}\u4e0d\u5b58\u5728", (Object)tagId);
            return;
        }
        CustomerTagEntity customerTagQuery = new CustomerTagEntity();
        customerTagQuery.setTagId(contactTagEntity.getWxContactTagId());
        customerTagQuery.setCustomerId(user.getCustomerId());
        CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagMapper.getSingle(customerTagQuery);
        if (customerTagEntity == null) {
            this.logger.info("\u7528\u6237:{}\u6807\u7b7e:{}\u4e0d\u5b58\u5728", (Object)user.getCustomerId(), (Object)tagId);
            return;
        }
        this.removeUserTag(user, customerTagEntity);
    }

    @Override
    public BaseResult removeUserTag(DistributorQiyeweixinExternalContactEntity user, Integer tagType) {
        List<CustomerTagEntity> userTagList = this.customerTagMapper.getUserList(user.getCustomerId(), tagType, user.getQyWeixinUserid());
        if (CollectionUtils.isNotEmpty(userTagList)) {
            return this.removeUserTag(userTagList, user.getExternalUserid());
        }
        this.logger.info("\u7528\u6237:{}\u65e0\u6a21\u578b\u6807\u7b7e\u8bb0\u5f55", (Object)user.getCustomerId());
        BaseResult baseResult = new BaseResult();
        baseResult.setErrcode("-9998");
        baseResult.setErrmsg("\u7528\u6237\u65e0\u6a21\u578b\u6807\u7b7e\u8bb0\u5f55");
        return baseResult;
    }

    @Override
    public void removeUserTag(DistributorQiyeweixinExternalContactEntity user, CustomerTagEntity customerTagEntity) {
        try {
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
            UserTagInfo userTagInfo = new UserTagInfo();
            userTagInfo.setUserid(user.getQyWeixinUserid());
            userTagInfo.setExternal_userid(user.getExternalUserid());
            String[] tagArr = new String[]{customerTagEntity.getTagId()};
            userTagInfo.setRemove_tag(tagArr);
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e\u8f93\u5165\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false));
            BaseResult baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
            this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e:{},\u7ed3\u679c{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)baseResult.toString());
            if (baseResult != null && baseResult.isSuccess()) {
                this.deleteByPrimaryKey(customerTagEntity.getId());
                this.logger.info("\u5220\u9664\u7528\u6237{},\u6807\u7b7e\u6a21\u578b:{}\u6210\u529f", (Object)user.getCustomerId(), (Object)customerTagEntity.getTagName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6253\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{}", (Object)JsonUtils.toJson((Object)customerTagEntity, (boolean)false), (Object)JsonUtils.toJson((Object)user, (boolean)false));
        }
    }

    @Override
    @Async
    public void removeUserTag(DistributorQiyeweixinExternalContactEntity user, List<CustomerTagEntity> list) {
        this.removeUserTag(list, user.getExternalUserid());
    }

    @Override
    public BaseResult removeUserTag(List<CustomerTagEntity> list, String externalUserid) {
        BaseResult baseResult = new BaseResult();
        Map<String, List<CustomerTagEntity>> map = list.stream().collect(Collectors.groupingBy(CustomerTagEntity::getQyWeixinUserid));
        try {
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
            for (Map.Entry<String, List<CustomerTagEntity>> entry : map.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
                UserTagInfo userTagInfo = new UserTagInfo();
                userTagInfo.setUserid(entry.getKey());
                userTagInfo.setExternal_userid(externalUserid);
                String[] tagArr = entry.getValue().stream().map(CustomerTagEntity::getTagId).collect(Collectors.toList()).toArray(new String[entry.getValue().size()]);
                userTagInfo.setRemove_tag(tagArr);
                List<Integer> idList = entry.getValue().stream().map(CustomerTagEntity::getId).collect(Collectors.toList());
                this.batchDelete(idList.toArray(new Integer[idList.size()]));
                baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
                this.logger.info("\u79fb\u9664\u7528\u6237\u6807\u7b7e:{},\u7ed3\u679c{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)baseResult.toString());
                return baseResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u79fb\u9664\u6807\u7b7e\u51fa\u9519,\u7528\u6237\u53ca\u6807\u7b7e:{},\u9519\u8bef\u6d88\u606f:{}", (Object)JsonUtils.toJson(list, (boolean)false), (Object)e.getMessage());
            baseResult.setErrmsg(e.getMessage());
            baseResult.setErrcode("-9999");
        }
        return baseResult;
    }

    @Override
    public BaseResult removeUserTagBatch(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> list) {
        List<CustomerTagEntity> userTagList;
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        String[] tagArr = list.stream().map(ContactTagEntity::getWxContactTagId).collect(Collectors.toList()).toArray(new String[list.size()]);
        userTagInfo.setRemove_tag(tagArr);
        BaseResult baseResult = this.removeUserTag(userTagInfo);
        if (baseResult.isSuccess() && CollectionUtils.isNotEmpty(userTagList = this.customerTagMapper.getUserList(user.getCustomerId(), TagTypeEnum.model.getValue(), user.getQyWeixinUserid()))) {
            List<Integer> idList = userTagList.stream().map(CustomerTagEntity::getId).collect(Collectors.toList());
            this.batchDelete(idList.toArray(new Integer[idList.size()]));
        }
        return baseResult;
    }

    @Override
    @Async
    public void removeUserTag(String customerId, Integer tagId) {
        try {
            DistributorQiyeweixinExternalContactEntity query = new DistributorQiyeweixinExternalContactEntity();
            query.setCustomerId(customerId);
            List userList = this.distributorQiyeweixinExternalContactMapper.getList(query);
            if (CollectionUtils.isNotEmpty((Collection)userList)) {
                ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagId);
                CustomerTagEntity customerTagQuery = new CustomerTagEntity();
                customerTagQuery.setTagId(contactTagEntity.getWxContactTagId());
                customerTagQuery.setCustomerId(customerId);
                CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagMapper.getSingle(customerTagQuery);
                for (DistributorQiyeweixinExternalContactEntity user : userList) {
                    this.removeUserTag(user, contactTagEntity, customerTagEntity);
                }
            } else {
                this.logger.info("\u65e0\u7528\u6237{}\u6807\u7b7e\u8bb0\u5f55", (Object)customerId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u79fb\u9664\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{}", (Object)tagId, (Object)customerId);
        }
    }

    @Override
    public void removeUserTag(Integer userId, Integer tagId) {
        try {
            this.markTagInvoke.removeTagByUser(userId, tagId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u79fb\u9664\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{},\u9519\u8bef\u6d88\u606f{}", new Object[]{tagId, userId, e.getMessage()});
        }
    }

    @Override
    public void markTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem, String date) {
        BaseResult baseResult = this.markTag(user, tagItem);
        this.logger.info("\u7528\u6237:{},\u6807\u7b7e:{},\u6807\u8bc6\u7ed3\u679c:{}", new Object[]{user.getCustomerId(), tagItem.getName(), baseResult.isSuccess()});
        if (baseResult.isSuccess()) {
            CustomerTagEntity query = new CustomerTagEntity();
            query.setQyWeixinUserid(user.getQyWeixinUserid());
            query.setCustomerId(user.getCustomerId());
            query.setTagId(tagItem.getWxContactTagId());
            CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.customerTagMapper.getSingle(query);
            if (customerTagEntity == null) {
                customerTagEntity = new CustomerTagEntity();
                customerTagEntity.setTagId(tagItem.getWxContactTagId());
                customerTagEntity.setExternalUserid(user.getExternalUserid());
                customerTagEntity.setCustomerId(user.getCustomerId());
                customerTagEntity.setQyWeixinUserid(user.getQyWeixinUserid());
                customerTagEntity.setTagName(tagItem.getName());
                ContactTagGroupEntity tagGroupQuery = new ContactTagGroupEntity();
                tagGroupQuery.setWxGroupId(tagItem.getWxTagGroupId());
                ContactTagGroupEntity contactTagGroupEntity = (ContactTagGroupEntity)this.contactTagGroupService.getSingle(tagGroupQuery);
                customerTagEntity.setTagGroupName(contactTagGroupEntity == null ? "" : contactTagGroupEntity.getGroupName());
                customerTagEntity.setTagType(1);
                customerTagEntity.setCreateTime(DateUtils.now());
                this.insertSelective(customerTagEntity);
            }
        }
    }

    @Override
    public BaseResult markTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity tagItem) {
        UserTagInfo userTagInfo = new UserTagInfo();
        userTagInfo.setUserid(user.getQyWeixinUserid());
        userTagInfo.setExternal_userid(user.getExternalUserid());
        String[] tagArr = new String[]{tagItem.getWxContactTagId()};
        userTagInfo.setAdd_tag(tagArr);
        return this.markTag(userTagInfo);
    }

    @Override
    public void markTag(DistributorQiyeweixinExternalContactEntity user, Integer tagId, String date) {
        ContactTagEntity tagItem = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagId);
        if (tagItem == null) {
            return;
        }
        this.markTag(user, tagItem, date);
    }

    @Override
    public void markTag(DistributorQiyeweixinExternalContactEntity user, List<ContactTagEntity> tagItemList) {
        tagItemList.forEach(tagItem -> this.markTag(user, (ContactTagEntity)tagItem, DateUtils.date()));
    }

    @Override
    public BaseResult markTag(UserTagInfo userTagInfo) {
        try {
            this.logger.info("\u6253\u6807\u7b7e\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false));
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(7);
            BaseResult baseResult = WxApiUtils.markTag((String)accessToken, (UserTagInfo)userTagInfo);
            this.logger.info("\u7528\u6237:{},\u6279\u91cf\u6807\u7b7e,\u6807\u8bc6\u7ed3\u679c:{}", (Object)userTagInfo.getExternal_userid(), (Object)baseResult.isSuccess());
            return baseResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6253\u6807\u7b7e\u51fa\u9519,\u6807\u7b7e:{},\u7528\u6237:{},\u9519\u8bef\u6d88\u606f:{}", (Object)JsonUtils.toJson((Object)userTagInfo, (boolean)false), (Object)e.getMessage());
            BaseResult baseResult = new BaseResult();
            baseResult.setErrmsg("\u6253\u6807\u7b7e\u51fa\u9519");
            baseResult.setErrcode("-9999");
            return baseResult;
        }
    }

    @Override
    @Async
    public void markTag(UserTagInfo userTagInfo, List<ContactTagEntity> markTagList, DistributorQiyeweixinExternalContactEntity user) {
        BaseResult baseResult = this.markTag(userTagInfo);
        if (baseResult.isSuccess()) {
            this.saveUserTag(user, markTagList);
        }
    }

    @Override
    @Async
    public void markTag(Integer userId, int tagId, String date) {
        try {
            this.markTagInvoke.markTagByUserAndTagRule2(date, userId, tagId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void markTag(Integer userId, List<Integer> tagIdList, String date) {
        try {
            this.markTagInvoke.markTagByUser2(date, userId, tagIdList.toArray(new Integer[tagIdList.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u7ed9\u7528\u6237userId:{}\u6253\u6807\u7b7e\u8c03\u7528\u5fae\u670d\u52a1\u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)userId, (Object)e.getMessage());
        }
    }

    @Override
    @Async
    public void markTag(List<CustomerTagDo> customerTagDoList, String date) {
        try {
            for (CustomerTagDo customerTagDo : customerTagDoList) {
                this.markTagInvoke.markTagByUserAndTagRule2(date, customerTagDo.getUserId(), customerTagDo.getTagId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Async
    public void markTag(TagOfCustomerDo tagOfCustomerDo) {
        try {
            this.logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u4f20\u9012\u53c2\u6570:{}", (Object)tagOfCustomerDo.toString());
            this.markTagInvoke.markTagByUser(tagOfCustomerDo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void markTag(String customerId, int tagId, String date) {
        DistributorQiyeweixinExternalContactEntity userQuery = new DistributorQiyeweixinExternalContactEntity();
        userQuery.setCustomerId(customerId);
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactMapper.getSingle(userQuery);
        if (user == null) {
            this.logger.info("\u8981\u6253\u6807\u7b7e\u7684\u7528\u6237:{}\u4e0d\u5b58\u5728", (Object)customerId);
            return;
        }
        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(Integer.valueOf(tagId));
        if (contactTagEntity == null) {
            this.logger.info("\u6807\u7b7e:{}\u4e0d\u5b58\u5728", (Object)tagId);
            return;
        }
        if (!this.checkHasTag(user, contactTagEntity)) {
            this.markTag(user, contactTagEntity, date);
        }
    }

    boolean checkHasTag(DistributorQiyeweixinExternalContactEntity user, ContactTagEntity contactTagEntity) {
        CustomerTagEntity query = new CustomerTagEntity();
        query.setCustomerId(user.getCustomerId());
        query.setQyWeixinUserid(user.getQyWeixinUserid());
        CustomerTagEntity customerTagEntity = (CustomerTagEntity)this.getSingle(query);
        return customerTagEntity != null;
    }

    @Override
    public void markTagByPhone(String phone, int tagId) {
        CustomerEntity customerEntity = this.customerInterface.getCustomerByMobile(phone, 1000);
        if (customerEntity == null) {
            this.logger.info("\u7528\u6237:{},\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7 \u6807\u7b7etagId:{}", (Object)phone, (Object)tagId);
            return;
        }
        DistributorQiyeweixinExternalContactEntity userQuery = new DistributorQiyeweixinExternalContactEntity();
        userQuery.setCustomerId(customerEntity.getCustomerId());
        DistributorQiyeweixinExternalContactEntity user = (DistributorQiyeweixinExternalContactEntity)this.distributorQiyeweixinExternalContactMapper.getSingle(userQuery);
        if (user == null) {
            this.logger.info("\u7528\u6237\u624b\u673a\u53f7:{}\u8981\u6253\u6807\u7b7e\u7528\u6237\u4e0d\u5b58\u5728", (Object)phone);
            return;
        }
        ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(Integer.valueOf(tagId));
        if (contactTagEntity == null) {
            this.logger.info("\u6807\u7b7etagId:{} \u4e0d\u5b58\u5728", (Object)phone, (Object)tagId);
            return;
        }
        if (!this.checkHasTag(user, contactTagEntity)) {
            this.markTag(user, contactTagEntity, DateUtils.date());
        }
    }

    @Override
    public PageInfo getTagCustomerList(TagCustomerQueryVo tagCustomerQueryVo) {
        Page page = PageHelper.startPage((int)tagCustomerQueryVo.getCurrentPage(), (int)tagCustomerQueryVo.getPageSize());
        page.setOrderBy("order DESC");
        CustomerTagEntity query = new CustomerTagEntity();
        query.setTagId(tagCustomerQueryVo.getWxTagId());
        List list = this.customerTagMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        ArrayList<TagCustomerVo> result = new ArrayList<TagCustomerVo>();
        for (CustomerTagEntity customerTagEntity : list) {
            TagCustomerVo tagCustomerVo = new TagCustomerVo();
            BeanUtils.copyProperties((Object)customerTagEntity, (Object)tagCustomerVo);
            CustomerEntity customerEntity = this.customerInterface.getCustomer(customerTagEntity.getCustomerId());
            if (customerEntity != null) {
                tagCustomerVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
                tagCustomerVo.setNickName(customerEntity.getNickName());
            }
            DistributorEntity distributorQuery = new DistributorEntity();
            distributorQuery.setQyWeixinUserid(customerTagEntity.getExternalUserid());
            distributorQuery.setGroupId(5);
            DistributorEntity distributorEntity = (DistributorEntity)this.distributorMapper.getSingle(distributorQuery);
            if (distributorEntity != null) {
                tagCustomerVo.setKefuName(distributorEntity.getDistributorName());
            }
            result.add(tagCustomerVo);
        }
        pg.setList(result);
        return pg;
    }

    @Override
    public BaseResult markUserWeixinTag(List<DistributorQiyeweixinExternalContactEntity> users, List<ContactTagEntityVo> dellist, List<ContactTagEntity> addlist) {
        List<String> delArr = dellist.stream().map(ContactTagEntity::getWxContactTagId).sorted((c, d) -> c.compareTo((String)d)).collect(Collectors.toList());
        List<String> addArr = addlist.stream().map(ContactTagEntity::getWxContactTagId).sorted((c, d) -> c.compareTo((String)d)).collect(Collectors.toList());
        BaseResult baseResult = new BaseResult();
        for (DistributorQiyeweixinExternalContactEntity user : users) {
            UserTagInfo userTagInfo = new UserTagInfo();
            userTagInfo.setUserid(user.getQyWeixinUserid());
            userTagInfo.setExternal_userid(user.getExternalUserid());
            String deletedTag = "etEgf2CQAAK_7FZtdU14pV6UBAg4VI5w";
            if (Integer.valueOf(2).equals(user.getSaveSucc())) {
                if (addArr.stream().filter(c -> c.equals(deletedTag)).count() == 0L) {
                    addArr.add(deletedTag);
                }
                delArr.remove(deletedTag);
            } else {
                if (delArr.stream().filter(c -> c.equals(deletedTag)).count() == 0L) {
                    delArr.add(deletedTag);
                }
                addArr.remove(deletedTag);
            }
            if (delArr.size() > 0) {
                userTagInfo.setRemove_tag(delArr.toArray(new String[delArr.size()]));
            }
            if (addArr.size() > 0) {
                userTagInfo.setAdd_tag(addArr.toArray(new String[addArr.size()]));
            }
            if (addArr.size() == 0 && delArr.size() == 0 || !(baseResult = this.markTag(userTagInfo)).isSuccess()) continue;
            int i = 0;
            for (String s : delArr) {
                i += this.customerTagMapper.deleteByUser(user.getExternalUserid(), user.getQyWeixinUserid(), s);
            }
            int j = 0;
            if (addlist.size() <= 0) continue;
            ArrayList<CustomerTagEntity> tempList = new ArrayList<CustomerTagEntity>();
            for (ContactTagEntity tag : addlist) {
                CustomerTagEntity customerTagEntity = new CustomerTagEntity();
                customerTagEntity.setCreateTime(DateUtils.now());
                customerTagEntity.setCustomerId(user.getCustomerId());
                customerTagEntity.setExternalUserid(user.getExternalUserid());
                customerTagEntity.setQyWeixinUserid(user.getQyWeixinUserid());
                customerTagEntity.setTagId(tag.getWxContactTagId());
                customerTagEntity.setTagName(tag.getName());
                customerTagEntity.setTagType(1);
                ContactTagGroupEntity contactTagGroupEntity = this.contactTagGroupService.getTagGroup(tag.getWxTagGroupId());
                customerTagEntity.setTagGroupName(contactTagGroupEntity != null ? contactTagGroupEntity.getGroupName() : "");
                tempList.add(customerTagEntity);
            }
            j = this.customerTagMapper.batchInsert(tempList);
        }
        return baseResult;
    }
}

