/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_0")
public class DayOfLastOrderlHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private RedisService redisService;

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String phone = this.getUserPhone(user.getCustomerId());
        int day = 0;
        String key = "BIDayOfLastOrder:";
        BaseJsonVo<Integer> baseJsonVo = BaseJsonVo.error();
        if (StringUtils.isNotEmpty((String)phone)) {
            Object cacheDay = this.redisService.get(key = key + phone);
            if (cacheDay != null) {
                day = Integer.valueOf(cacheDay.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getCustomerLastOrderDaysByPhone(phone);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    day = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, day, 1800L);
                }
            }
        } else {
            Object cacheDay = this.redisService.get(key = key + user.getCustomerId());
            if (cacheDay != null) {
                day = Integer.valueOf(cacheDay.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getCustomerLastOrderDaysByCustomerId(user.getCustomerId());
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    day = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, day, 1800L);
                }
            }
        }
        groupRuleFlag = this.checkTagRule(day, tagRuleItem);
        return groupRuleFlag;
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        int day = 0;
        if (jsonObject.get((Object)"lastBuyOfDay") != null) {
            day = jsonObject.getIntValue("lastBuyOfDay");
            return this.checkTagRule(day, tagRuleItem);
        }
        return false;
    }
}

