/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_13")
public class MostProvinceOfUserlHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private RedisService redisService;

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String phone = this.getUserPhone(user.getCustomerId());
        int day = 0;
        String key = "BIDayOfLastOrder:";
        BaseJsonVo<Integer> baseJsonVo = BaseJsonVo.error();
        if (StringUtils.isNotEmpty((String)phone)) {
            this.logger.info("\u7528\u6237:{}\u7ed1\u5b9a\u624b\u673a\u53f7:{}", (Object)user.getCustomerId(), (Object)phone);
            key = key + phone;
            Object cacheDay = this.redisService.get(key);
            if (cacheDay != null) {
                day = Integer.valueOf(cacheDay.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getCustomerLastOrderDaysByPhone(phone);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    day = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, day, 1800L);
                }
            }
        } else {
            Object cacheDay = this.redisService.get(key = key + user.getCustomerId());
            if (cacheDay != null) {
                day = Integer.valueOf(cacheDay.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getCustomerLastOrderDaysByCustomerId(user.getCustomerId());
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    day = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, day, 1800L);
                }
            }
        }
        this.logger.info("\u7528\u6237\u503c:{}, \u89c4\u5219\u8981\u6c42:{},{} ", new Object[]{day, OperateTypeEnum.getName(tagRuleItem.getOperateType()), tagRuleItem.getRuleValue()});
        groupRuleFlag = this.checkTagRule(day, tagRuleItem);
        return groupRuleFlag;
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        String province = "";
        if (jsonObject.get((Object)"maxProvince") != null) {
            province = jsonObject.getString("maxProvince").replace("\u7701", "").replace("\u5e02", "");
            return this.checkTagRule(province, tagRuleItem);
        }
        return false;
    }
}

