/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_3")
public class NumAndTimeHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    MallOrderMainInterface orderMainInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        Object cacheValue;
        boolean groupRuleFlag = false;
        int day = Integer.valueOf(tagRuleItem.getRuleValue().split(",")[0]);
        int hasOrderNum = 0;
        String key = "NumAndTime:";
        BaseJsonVo<Integer> baseJsonVo = BaseJsonVo.error();
        String phone = this.getUserPhone(user.getCustomerId());
        if (StringUtils.isNotEmpty((String)phone)) {
            cacheValue = this.redisService.get(key = key + phone + ":" + day);
            if (cacheValue != null) {
                hasOrderNum = Integer.valueOf(cacheValue.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getOrderNumOfDayByPhone(phone, day);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    hasOrderNum = (Integer)baseJsonVo.getValue();
                    this.logger.info("\u7528\u6237:{},\u5355\u6570:{}", (Object)phone, (Object)hasOrderNum);
                    this.redisService.save(key, hasOrderNum, 1800L);
                }
            }
        } else {
            cacheValue = this.redisService.get(key = key + user.getCustomerId() + ":" + day);
            if (cacheValue != null) {
                hasOrderNum = Integer.valueOf(cacheValue.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getOrderNumOfDayByCustomerId(user.getCustomerId(), day);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    hasOrderNum = (Integer)baseJsonVo.getValue();
                    this.logger.info("\u7528\u6237:{},\u5355\u6570:{}", (Object)phone, (Object)hasOrderNum);
                    this.redisService.save(key, hasOrderNum, 1800L);
                }
            }
        }
        int num = Integer.valueOf(tagRuleItem.getRuleValue().split(",")[1]);
        this.logger.info("\u7528\u6237\u6570:{}, \u89c4\u5219\u8981\u6c42:{},{} ", new Object[]{hasOrderNum, OperateTypeEnum.getName(tagRuleItem.getOperateType()), tagRuleItem.getRuleValue()});
        groupRuleFlag = this.checkTagRule4Num(hasOrderNum, num, tagRuleItem);
        return groupRuleFlag;
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        int day = Integer.valueOf(tagRuleItem.getRuleValue().split(",")[0]);
        int dataValue = 0;
        int num = Integer.valueOf(tagRuleItem.getRuleValue().split(",")[1]);
        switch (day) {
            case 90: {
                if (jsonObject.get((Object)"m3OrderCount") != null) {
                    dataValue = jsonObject.getIntValue("m3OrderCount");
                }
                return this.checkTagRule4Num(dataValue, num, tagRuleItem);
            }
            case 180: {
                if (jsonObject.get((Object)"m6OrderCount") != null) {
                    dataValue = jsonObject.getIntValue("m6OrderCount");
                }
                return this.checkTagRule4Num(dataValue, num, tagRuleItem);
            }
        }
        return false;
    }
}

