/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_5")
public class OrderChannelHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String phone = this.getUserPhone(user.getCustomerId());
        String channel = "";
        if (StringUtils.isNotEmpty((String)phone)) {
            BaseJsonVo<String> baseJsonVo = this.biOrderDetailInvoke.getChannelLastOrder(phone);
            if (baseJsonVo.isSuccess()) {
                if (baseJsonVo.getValue() == null) return false;
                channel = (String)baseJsonVo.getValue();
            }
        } else {
            this.logger.info("\u7528\u6237:{}\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7", (Object)user.getCustomerId());
            BaseJsonVo<String> baseJsonVo = this.biOrderDetailInvoke.getChannelLastOrderByCustomerId(user.getCustomerId());
            if (!baseJsonVo.isSuccess()) return false;
            if (baseJsonVo.getValue() != null) {
                channel = (String)baseJsonVo.getValue();
            }
        }
        this.logger.info("\u7528\u6237\u672b\u5355\u8d2d\u4e70\u6e20\u9053:{}", (Object)channel);
        this.logger.info("\u7528\u6237\u503c:{}, \u89c4\u5219\u8981\u6c42:{}{} ", new Object[]{channel, OperateTypeEnum.getName(tagRuleItem.getOperateType()), tagRuleItem.getRuleValue()});
        return this.checkTagRule(channel, tagRuleItem);
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        String dataValue = "";
        if (jsonObject.get((Object)"lastChannelClass") != null) {
            dataValue = jsonObject.getString("lastChannelClass");
            return this.checkTagRule(dataValue, tagRuleItem);
        }
        return false;
    }
}

