/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_1")
public class OrderNumHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private RedisService redisService;

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String phone = this.getUserPhone(user.getCustomerId());
        int hasOrderNum = 0;
        String key = "OrderNum:";
        BaseJsonVo<Integer> baseJsonVo = BaseJsonVo.error();
        if (StringUtils.isNotEmpty((String)phone)) {
            Object cacheValue = this.redisService.get(key = key + phone);
            if (cacheValue != null) {
                hasOrderNum = Integer.valueOf(cacheValue.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getOrderNumByPhone(phone);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    hasOrderNum = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, hasOrderNum, 1800L);
                }
            }
        } else {
            this.logger.info("\u7528\u6237:{}\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7", (Object)user.getCustomerId());
            key = key + user.getCustomerId();
            Object cacheValue = this.redisService.get(key);
            if (cacheValue != null) {
                hasOrderNum = Integer.valueOf(cacheValue.toString());
            } else {
                baseJsonVo = this.biOrderDetailInvoke.getOrderNumByCustomerId(user.getCustomerId());
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    hasOrderNum = (Integer)baseJsonVo.getValue();
                    this.redisService.save(key, hasOrderNum, 1800L);
                }
            }
        }
        this.logger.info("\u7528\u6237\u503c:{}, \u89c4\u5219\u8981\u6c42:{},{} ", new Object[]{hasOrderNum, OperateTypeEnum.getName(tagRuleItem.getOperateType()), tagRuleItem.getRuleValue()});
        if (baseJsonVo.isSuccess()) {
            this.logger.info("\u7528\u6237\u8ba2\u5355\u6570:{}", (Object)hasOrderNum);
            groupRuleFlag = this.checkTagRule(hasOrderNum, tagRuleItem);
        } else {
            this.logger.info("\u67e5\u8be2\u7528\u6237\u8ba2\u5355\u6570\u51fa\u9519,\u7528\u6237:{},\u89c4\u5219:{}", (Object)JsonUtils.toJson((Object)user, (boolean)false), (Object)JsonUtils.toJson((Object)tagRuleItem, (boolean)false));
        }
        return groupRuleFlag;
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        int dataValue = 0;
        if (jsonObject.get((Object)"orderCount") != null) {
            dataValue = jsonObject.getIntValue("orderCount");
            return this.checkTagRule(dataValue, tagRuleItem);
        }
        return false;
    }
}

