/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class TagRuleBase {
    @Autowired
    CustomerInterface customerInterface;

    public String getUserPhone(String customerId) {
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        return StringUtils.isNotEmpty((String)customerEntity.getMobile()) ? customerEntity.getMobile() : "";
    }

    public boolean checkTagRule(int baseValue, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        Integer ruleValue = Integer.valueOf(tagRuleItem.getRuleValue());
        if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.eq.getValue()) {
            groupRuleFlag = Objects.equals(baseValue, ruleValue);
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater.getValue()) {
            groupRuleFlag = baseValue > ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater_eq.getValue()) {
            groupRuleFlag = baseValue >= ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less.getValue()) {
            groupRuleFlag = baseValue < ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less_eq.getValue()) {
            groupRuleFlag = baseValue <= ruleValue;
        }
        return groupRuleFlag;
    }

    public boolean checkTagRule(String baseValue, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String ruleValue = tagRuleItem.getRuleValue().trim();
        if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.eq.getValue()) {
            groupRuleFlag = Objects.equals(baseValue, ruleValue);
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.not_eq.getValue()) {
            groupRuleFlag = !Objects.equals(baseValue, ruleValue);
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.contains.getValue()) {
            groupRuleFlag = baseValue.contains(ruleValue);
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.not_contains.getValue()) {
            groupRuleFlag = !baseValue.contains(ruleValue);
        }
        return groupRuleFlag;
    }

    public boolean checkTagRule4Num(int hasValue, Integer ruleValue, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.eq.getValue()) {
            groupRuleFlag = Objects.equals(hasValue, ruleValue);
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater.getValue()) {
            groupRuleFlag = hasValue > ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater_eq.getValue()) {
            groupRuleFlag = hasValue >= ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less.getValue()) {
            groupRuleFlag = hasValue < ruleValue;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less_eq.getValue()) {
            groupRuleFlag = hasValue <= ruleValue;
        }
        return groupRuleFlag;
    }

    public boolean checkTagRule4BigDecimal(BigDecimal baseValue, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        BigDecimal ruleValue = new BigDecimal(tagRuleItem.getRuleValue());
        if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.eq.getValue()) {
            groupRuleFlag = ruleValue.compareTo(baseValue) == 0;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater.getValue()) {
            groupRuleFlag = baseValue.compareTo(ruleValue) > 0;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.greater_eq.getValue()) {
            groupRuleFlag = baseValue.compareTo(ruleValue) >= 0;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less.getValue()) {
            groupRuleFlag = baseValue.compareTo(ruleValue) < 0;
        } else if (tagRuleItem.getOperateType().intValue() == OperateTypeEnum.less_eq.getValue()) {
            groupRuleFlag = baseValue.compareTo(ruleValue) <= 0;
        }
        return groupRuleFlag;
    }
}

