/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagRuleContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ITagRuleCustomer> ruleCustomerMap = new ConcurrentHashMap<String, ITagRuleCustomer>();

    @Autowired
    public TagRuleContext(Map<String, ITagRuleCustomer> ruleCustomerMap) {
        this.ruleCustomerMap.clear();
        ruleCustomerMap.forEach((k, v) -> this.ruleCustomerMap.put((String)k, (ITagRuleCustomer)v));
    }

    public boolean checkTagRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        ITagRuleCustomer ruleCustomer = this.ruleCustomerMap.get("tag_" + tagRuleItem.getRuleType());
        if (ruleCustomer != null) {
            try {
                groupRuleFlag = ruleCustomer.checkCustomerRule(user, tagRuleItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u7528\u6237:{}\uff0c\u68c0\u67e5\u89c4\u5219:{}\u51fa\u9519:{}", new Object[]{user.getCustomerId(), JsonUtils.toJson((Object)tagRuleItem, (boolean)false), e.getMessage()});
            }
        }
        return groupRuleFlag;
    }

    public boolean checkTagRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        boolean groupRuleFlag = false;
        ITagRuleCustomer ruleCustomer = this.ruleCustomerMap.get("tag_" + tagRuleItem.getRuleType());
        if (ruleCustomer != null) {
            try {
                groupRuleFlag = ruleCustomer.checkCustomerRule(user, tagRuleItem, jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return groupRuleFlag;
    }
}

