/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.qiyeweixin.dao.tag.ContactTagMapper;
import cc.lechun.qiyeweixin.dao.tag.TagRuleGroupMapper;
import cc.lechun.qiyeweixin.entity.tag.ConditionTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupVo;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleGroupInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TagRuleGroupService
extends BaseService<TagRuleGroupEntity, Integer>
implements TagRuleGroupInterface {
    @Resource
    private TagRuleGroupMapper tagRuleGroupMapper;
    @Resource
    ContactTagMapper contactTagMapper;

    @Override
    @ReadThroughSingleCache(namespace="TagRuleGroupService.getList", expiration=21600)
    public List<TagRuleGroupEntity> getList(@ParameterValueKeyProvider Integer tagId) {
        TagRuleGroupEntity ruleGroupQuery = new TagRuleGroupEntity();
        ruleGroupQuery.setTagId(tagId);
        return this.getList(ruleGroupQuery);
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="TagRuleGroupService.getTagRuleGroupList", expiration=21600)
    public List<TagRuleGroupEntity> getTagRuleGroupList() {
        TagRuleGroupEntity ruleGroupQuery = new TagRuleGroupEntity();
        return this.getList(ruleGroupQuery);
    }

    @Override
    public PageInfo<TagRuleGroupVo> getList(TagRuleGroupQueryVo tagRuleGroupQueryVo) {
        Page page = PageHelper.startPage((int)tagRuleGroupQueryVo.getCurrentPage(), (int)tagRuleGroupQueryVo.getPageSize());
        page.setOrderBy(" id DESC");
        TagRuleGroupEntity query = new TagRuleGroupEntity();
        BeanUtils.copyProperties((Object)tagRuleGroupQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)query.getGroupName())) {
            query.setGroupName(SqlUtils.sqlLike((String)query.getGroupName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            query.setGroupName(null);
        }
        List list = this.tagRuleGroupMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        ArrayList<TagRuleGroupVo> result = new ArrayList<TagRuleGroupVo>();
        for (TagRuleGroupEntity tagRuleGroupEntity : list) {
            TagRuleGroupVo tagRuleGroupVo = new TagRuleGroupVo();
            BeanUtils.copyProperties((Object)tagRuleGroupEntity, (Object)tagRuleGroupVo);
            tagRuleGroupVo.setConditionTypeName(ConditionTypeEnum.getName(tagRuleGroupEntity.getConditionType()));
            ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.selectByPrimaryKey(tagRuleGroupEntity.getTagId());
            tagRuleGroupVo.setTagName(contactTagEntity == null ? "" : contactTagEntity.getName());
            result.add(tagRuleGroupVo);
        }
        pg.setList(result);
        return pg;
    }
}

