/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.qiyeweixin.dao.tag.TagRuleGroupMapper;
import cc.lechun.qiyeweixin.dao.tag.TagRuleMapper;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.RuleValueTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagRuleTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleVo;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TagRuleService
extends BaseService<TagRuleEntity, Integer>
implements TagRuleInterface {
    @Resource
    private TagRuleMapper tagRuleMapper;
    @Resource
    private TagRuleGroupMapper tagRuleGroupMapper;

    @Override
    @ReadThroughSingleCache(namespace="TagRuleService.getTagRuleEntityList", expiration=14400)
    public List<TagRuleEntity> getTagRuleEntityList(@ParameterValueKeyProvider Integer ruleGroupId) {
        TagRuleEntity tagRuleQuery = new TagRuleEntity();
        tagRuleQuery.setRuleGroupId(ruleGroupId);
        return this.getList(tagRuleQuery);
    }

    @Override
    public PageInfo<TagRuleVo> getList(TagRuleQueryVo tagRuleQueryVo) {
        Page page = PageHelper.startPage((int)tagRuleQueryVo.getCurrentPage(), (int)tagRuleQueryVo.getPageSize());
        page.setOrderBy(" ID DESC");
        TagRuleEntity query = new TagRuleEntity();
        BeanUtils.copyProperties((Object)tagRuleQueryVo, (Object)query);
        if (StringUtils.isNotEmpty((String)query.getRuleName())) {
            query.setRuleName(SqlUtils.sqlLike((String)query.getRuleName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            query.setRuleName(null);
        }
        List list = this.tagRuleMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        ArrayList<TagRuleVo> result = new ArrayList<TagRuleVo>();
        for (TagRuleEntity tagRuleEntity : list) {
            TagRuleVo tagRuleVo = new TagRuleVo();
            BeanUtils.copyProperties((Object)tagRuleEntity, (Object)tagRuleVo);
            tagRuleVo.setRuleValueTypeName(RuleValueTypeEnum.getName(tagRuleEntity.getRuleValueType()));
            tagRuleVo.setOperateTypeName(OperateTypeEnum.getName(tagRuleEntity.getOperateType()));
            tagRuleVo.setRuleTypeName(TagRuleTypeEnum.getName(tagRuleEntity.getRuleType()));
            TagRuleGroupEntity tagRuleGroupEntity = (TagRuleGroupEntity)this.tagRuleGroupMapper.selectByPrimaryKey(tagRuleEntity.getRuleGroupId());
            tagRuleVo.setRuleGroupName(tagRuleGroupEntity == null ? "" : tagRuleGroupEntity.getGroupName());
            result.add(tagRuleVo);
        }
        pg.setList(result);
        return pg;
    }
}

