/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.qiyeweixin.service.tag;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.qiyeweixin.entity.tag.OperateTypeEnum;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.service.tag.ITagRuleCustomer;
import cc.lechun.qiyeweixin.service.tag.TagRuleBase;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tag_2")
public class UserPayAmountHandle
extends TagRuleBase
implements ITagRuleCustomer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private RedisService redisService;

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem) {
        boolean groupRuleFlag = false;
        String phone = this.getUserPhone(user.getCustomerId());
        BigDecimal orderPayAmout = BigDecimal.ZERO;
        String key = "UserPayAmount:";
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            Object cacheAmount = this.redisService.get(key = key + phone);
            if (cacheAmount != null) {
                orderPayAmout = new BigDecimal(cacheAmount.toString());
            } else {
                BaseJsonVo<BigDecimal> baseJsonVo = this.biOrderDetailInvoke.getOrderPayAmountByPhone(phone);
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    orderPayAmout = (BigDecimal)baseJsonVo.getValue();
                    this.logger.info("\u7528\u6237:{},\u8ba2\u5355GMV:{}", (Object)phone, (Object)orderPayAmout);
                    this.redisService.save(key, orderPayAmout, 1800L);
                }
            }
        } else {
            this.logger.info("\u7528\u6237:{}\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7", (Object)user.getCustomerId());
            key = key + user.getCustomerId();
            Object cacheAmount = this.redisService.get(key);
            if (cacheAmount != null) {
                orderPayAmout = new BigDecimal(cacheAmount.toString());
            } else {
                BaseJsonVo<BigDecimal> baseJsonVo = this.biOrderDetailInvoke.getOrderPayAmountByCustomerId(user.getCustomerId());
                if (baseJsonVo.isSuccess()) {
                    if (baseJsonVo.getValue() == null) {
                        return false;
                    }
                    orderPayAmout = (BigDecimal)baseJsonVo.getValue();
                    this.logger.info("\u7528\u6237:{},\u8ba2\u5355GMV:{}", (Object)user.getCustomerId(), (Object)orderPayAmout);
                    this.redisService.save(key, orderPayAmout, 1800L);
                }
            }
        }
        this.logger.info("\u7528\u6237\u652f\u4ed8\u603b\u91d1\u989d:{}, \u89c4\u5219\u8981\u6c42:{}{} ", new Object[]{orderPayAmout, OperateTypeEnum.getName(tagRuleItem.getOperateType()), tagRuleItem.getRuleValue()});
        groupRuleFlag = this.checkTagRule4BigDecimal(orderPayAmout, tagRuleItem);
        return groupRuleFlag;
    }

    @Override
    public boolean checkCustomerRule(DistributorQiyeweixinExternalContactEntity user, TagRuleEntity tagRuleItem, JSONObject jsonObject) {
        BigDecimal dataValue = BigDecimal.ZERO;
        if (jsonObject.get((Object)"gmv") != null) {
            dataValue = jsonObject.getBigDecimal("gmv");
            return this.checkTagRule4BigDecimal(dataValue, tagRuleItem);
        }
        return false;
    }
}

