/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.bonus;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.scrm.entity.bonus.AuditingEnum;
import cc.lechun.scrm.entity.bonus.ExperienceEntity;
import cc.lechun.scrm.entity.bonus.ExperienceExportVo;
import cc.lechun.scrm.entity.bonus.ExperienceQueryVo;
import cc.lechun.scrm.entity.bonus.ExperienceResultVo;
import cc.lechun.scrm.entity.bonus.ExperienceTypeEnum;
import cc.lechun.scrm.entity.bonus.ExperienceVoteEntity;
import cc.lechun.scrm.entity.bonus.VoteTypeEnum;
import cc.lechun.scrm.iservice.bonus.ExperienceInterface;
import cc.lechun.scrm.iservice.bonus.ExperienceVoteInterface;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import cc.lechun.scrm.service.bonus.BonusBase;
import cc.lechun.scrm.service.bonus.BonusRuleInterface;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class BonusServiceContext
extends BonusBase {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SysUserInterface userInterface;
    @Resource
    private DistributorMapper distributorMapper;
    @Autowired
    private ExperienceInterface experienceService;
    @Autowired
    ExperienceVoteInterface experienceVoteInterface;
    @Lazy
    @Autowired
    CalendarInterface calendarInterface;
    private final Map<String, BonusRuleInterface> bonusRule = new ConcurrentHashMap<String, BonusRuleInterface>();

    @Autowired
    public BonusServiceContext(Map<String, BonusRuleInterface> bonusRule) {
        this.bonusRule.clear();
        bonusRule.forEach((k, v) -> this.bonusRule.put((String)k, (BonusRuleInterface)v));
    }

    public List<Map<String, String>> getQiWeiUserList(Integer appId) {
        BaseJsonVo baseJsonVo = this.calendarInterface.getQwUser(appId);
        ((List)baseJsonVo.getValue()).removeIf(d -> d.getOrDefault("name", "").contains("\u5f20\u7545") || d.getOrDefault("name", "").contains("\u674e\u7fa4") || d.getOrDefault("name", "").contains("\u738b\u6c49\u6653") || d.getOrDefault("name", "").contains("\u5218\u5b8f\u4f73") || d.getOrDefault("name", "").contains("\u77f3\u839c\u831c"));
        return (List)baseJsonVo.getValue();
    }

    public PageInfo<ExperienceResultVo> getExperienceList(ExperienceQueryVo experienceQueryVo, String userId, boolean visibleType) {
        this.logger.info("\u67e5\u8be2\u53c2\u65701:{}", (Object)JsonUtils.toJson((Object)experienceQueryVo, (boolean)false));
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getExperienceName())) {
            experienceQueryVo.setExperienceName(SqlUtils.sqlLike((String)experienceQueryVo.getExperienceName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            experienceQueryVo.setExperienceName(null);
        }
        if (Objects.equals(experienceQueryVo.getType(), 0)) {
            experienceQueryVo.setType(null);
        }
        if (Objects.equals(experienceQueryVo.getAuditing(), -1)) {
            experienceQueryVo.setAuditing(null);
        }
        PageInfo<ExperienceEntity> pageInfo = this.experienceService.getDataList(experienceQueryVo);
        ArrayList result = new ArrayList();
        PageInfo resultPageInfo = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)resultPageInfo);
        pageInfo.getList().stream().map(experienceEntity -> {
            ExperienceResultVo experienceResultVo = new ExperienceResultVo();
            BeanUtils.copyProperties((Object)experienceEntity, (Object)experienceResultVo);
            if (Objects.equals(experienceEntity.getType(), 1)) {
                experienceResultVo.setGmvDate(DateUtils.formatDate((Date)experienceResultVo.getCreateDate(), (String)"yyyy-MM-dd"));
            }
            boolean visible = visibleType;
            BonusRuleInterface bonusRuleInterface = this.bonusRule.get("experience_" + experienceEntity.getType());
            if (bonusRuleInterface != null && !visibleType) {
                this.logger.info("\u6848\u4f8b\u7528\u6237:{},\u8bbf\u95ee\u7528\u6237:{}", (Object)experienceEntity.getQwUserid(), (Object)userId);
                visible = bonusRuleInterface.getVisible((ExperienceEntity)experienceEntity, userId);
                if (!visible) {
                    pageInfo.setTotal(pageInfo.getTotal() - 1L);
                    this.logger.info("\u7ecf\u9a8c:{},\u521b\u5efa\u4eba:{}\u4e0d\u53ef\u89c1", (Object)experienceEntity.getExperienceName(), (Object)experienceEntity.getQwNickname());
                }
            }
            if (experienceEntity.getAuditing() != null && StringUtils.isNotEmpty((String)experienceEntity.getAuditingUserid())) {
                try {
                    MallUserEntity userEntity = this.userInterface.getMallUser(experienceEntity.getAuditingUserid());
                    experienceResultVo.setAuditingName(userEntity.getUserNick());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.info("\u67e5\u8be2\u5ba1\u6838\u7528\u6237\u51fa\u9519:" + e);
                }
            }
            experienceResultVo.setTypeName(ExperienceTypeEnum.getName(experienceEntity.getType()));
            experienceResultVo.setAuditingStatusName(AuditingEnum.getName(experienceEntity.getAuditing()));
            experienceResultVo.setCanEdit(0);
            boolean canEdit = this.getCanEdit((ExperienceEntity)experienceEntity, userId);
            if (canEdit) {
                if (bonusRuleInterface != null) {
                    canEdit = bonusRuleInterface.getCanEdit((ExperienceEntity)experienceEntity);
                }
                experienceResultVo.setCanEdit(canEdit ? 1 : 0);
            }
            if (visible) {
                result.add(experienceResultVo);
            }
            if (Objects.equals(experienceEntity.getAuditing(), AuditingEnum.Auditinged.getValue())) {
                ExperienceVoteEntity queryVote = new ExperienceVoteEntity();
                queryVote.setVoteType(VoteTypeEnum.vote.getValue());
                queryVote.setVoteTargetId(experienceEntity.getExperienceId());
                experienceResultVo.setVoteNum(this.experienceVoteInterface.votNum(queryVote));
            } else {
                experienceResultVo.setVoteNum(0);
            }
            return experienceResultVo;
        }).collect(Collectors.toList());
        resultPageInfo.setList(result);
        return resultPageInfo;
    }

    public List<ExperienceExportVo> getExperienceExportVoList(ExperienceQueryVo experienceQueryVo, String userId) {
        PageInfo<ExperienceResultVo> pageInfo = this.getExperienceList(experienceQueryVo, userId, true);
        if (pageInfo.getTotal() > 0L) {
            ArrayList<ExperienceExportVo> result = new ArrayList<ExperienceExportVo>();
            result.addAll(pageInfo.getList().stream().map(experienceResultVo -> {
                ExperienceExportVo experienceExportVo = new ExperienceExportVo();
                BeanUtils.copyProperties((Object)experienceResultVo, (Object)experienceExportVo);
                return experienceExportVo;
            }).collect(Collectors.toList()));
            return result;
        }
        return new ArrayList<ExperienceExportVo>();
    }

    public ExperienceResultVo getCase(Integer experienceId, String userId, Integer operateType) {
        return this.getExperienceResultVo((ExperienceEntity)this.experienceService.selectByPrimaryKey(experienceId, 0L), userId, operateType);
    }

    private ExperienceResultVo getExperienceResultVo(ExperienceEntity experienceEntity, String userId, Integer operateType) {
        ExperienceResultVo experienceResultVo = new ExperienceResultVo();
        BeanUtils.copyProperties((Object)experienceEntity, (Object)experienceResultVo);
        BonusRuleInterface bonusRuleInterface = this.bonusRule.get("experience_" + experienceEntity.getType());
        if (experienceEntity.getAuditing() != null && StringUtils.isNotEmpty((String)experienceEntity.getAuditingUserid())) {
            MallUserEntity userEntity = this.userInterface.getMallUser(experienceEntity.getAuditingUserid());
            experienceResultVo.setAuditingName(userEntity.getUserNick());
        }
        experienceResultVo.setTypeName(ExperienceTypeEnum.getName(experienceEntity.getType()));
        experienceResultVo.setAuditingStatusName(AuditingEnum.getName(experienceEntity.getAuditing()));
        experienceResultVo.setCanEdit(0);
        this.logger.info("\u4f01\u5fae:{},\u6848\u4f8b\u7528\u6237userId:{}", (Object)userId, (Object)experienceEntity.getQwUserid());
        boolean canEdit = this.getCanEdit(experienceEntity, userId);
        if (canEdit) {
            if (bonusRuleInterface != null) {
                canEdit = bonusRuleInterface.getCanEdit(experienceEntity);
                this.logger.info("\u6848\u4f8b:{},\u5df2\u8fc7\u671f\u6216\u8005\u5df2\u5ba1\u6838", (Object)canEdit);
            }
            experienceResultVo.setCanEdit(canEdit ? 1 : 0);
        }
        experienceResultVo.setCanAuditing(Objects.equals(operateType, 1) && Objects.equals(experienceEntity.getAuditing(), AuditingEnum.UN_Auditing.getValue()) ? 1 : 2);
        experienceResultVo.setCanVote(this.canVote(experienceEntity, userId) ? 1 : 0);
        return experienceResultVo;
    }

    private boolean canVote(ExperienceEntity experienceEntity, String userId) {
        return Objects.equals(experienceEntity.getAuditing(), AuditingEnum.Auditinged.getValue()) && experienceEntity.getEndTime().after(DateUtils.now()) && !Objects.equals(experienceEntity.getQwUserid(), userId);
    }

    public PageInfo<ExperienceResultVo> getExperienceList(ExperienceQueryVo experienceQueryVo) {
        return this.getExperienceList(experienceQueryVo, null, true);
    }

    public BaseJsonVo auditingExperience(Integer experienceId, String userId) {
        ExperienceEntity experienceEntity = (ExperienceEntity)this.experienceService.selectByPrimaryKey(experienceId);
        experienceEntity.setAuditingUserid(userId);
        return this.auditingExperience(experienceEntity);
    }

    public BaseJsonVo cancelCase(Integer experienceId, String userId) {
        ExperienceEntity experienceEntity = (ExperienceEntity)this.experienceService.selectByPrimaryKey(experienceId);
        experienceEntity.setAuditingUserid(userId);
        experienceEntity.setAuditing(AuditingEnum.cancel.getValue());
        experienceEntity.setAuditingTime(DateUtils.now());
        this.experienceService.updateByPrimaryKeySelective(experienceEntity);
        return BaseJsonVo.success((Object)"\u4f5c\u5e9f\u6210\u529f");
    }

    public BaseJsonVo auditingExperience(ExperienceEntity experienceEntity) {
        BonusRuleInterface bonusRuleInterface = this.bonusRule.get("experience_" + experienceEntity.getType());
        if (bonusRuleInterface != null) {
            return bonusRuleInterface.auditingExperience(experienceEntity);
        }
        return BaseJsonVo.error((String)"\u5ba1\u6838\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseJsonVo saveExperience(ExperienceEntity experienceEntity, Integer appId) {
        this.logger.info(JsonUtils.toJson((Object)experienceEntity, (boolean)false));
        if (experienceEntity != null) {
            BonusRuleInterface bonusRuleInterface;
            if (experienceEntity.getExperienceId() == null || experienceEntity.getExperienceId() == 0) {
                experienceEntity.setVoteTotal(this.getQiWeiUserList(appId).size());
                experienceEntity.setExperienceId(null);
            }
            if ((bonusRuleInterface = this.bonusRule.get("experience_" + experienceEntity.getType())) != null) {
                return bonusRuleInterface.saveExperience(experienceEntity);
            }
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u51fa\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public BaseJsonVo saveVote(ExperienceVoteEntity experienceVoteEntity) {
        ExperienceEntity experienceEntity = (ExperienceEntity)this.experienceService.selectByPrimaryKey(experienceVoteEntity.getVoteTargetId());
        if (experienceEntity == null) {
            return BaseJsonVo.error((String)"\u6295\u7968\u51fa\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        BonusRuleInterface bonusRuleInterface = this.bonusRule.get("experience_" + experienceEntity.getType());
        if (bonusRuleInterface != null) {
            BaseJsonVo temp = bonusRuleInterface.checkVote(experienceEntity, experienceVoteEntity);
            if (!temp.isSuccess()) {
                return temp;
            }
            return this.experienceVoteInterface.updateByPrimaryKeySelective(experienceVoteEntity) > 0 ? BaseJsonVo.success((Object)"\u6295\u7968\u6210\u529f") : BaseJsonVo.error((String)"\u6295\u7968\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return BaseJsonVo.error((String)"\u6295\u7968\u51fa\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public void initGmv(Date date, Integer day, Integer appId) {
        this.logger.info("\u67e5\u8be2\u65e5\u671f:{},\u53d6\u5929\u6570:{}", (Object)date, (Object)day);
        List<Map<String, Object>> gmvList = this.distributorMapper.getMaxGmv(date, day);
        if (CollectionUtils.isNotEmpty(gmvList)) {
            gmvList.forEach(map -> {
                String name = map.get("DISTRIBUTOR_NAME").toString() + map.get("CREATE_TIME") + ExperienceTypeEnum.GMV.getName() + ":" + map.get("GMV") + "\u7ecf\u9a8c";
                ExperienceEntity query = new ExperienceEntity();
                query.setQwUserid(map.get("USER_ID").toString());
                query.setType(ExperienceTypeEnum.GMV.getValue());
                query.setCreateDate(DateUtils.StrToDate((String)map.get("CREATE_TIME").toString()));
                this.logger.info("\u4f01\u5faeGMV\u7ecf\u9a8c\u67e5\u8be2:{}", (Object)query.toString());
                ExperienceEntity experienceEntity = (ExperienceEntity)this.experienceService.getSingle(query, 0L);
                if (experienceEntity == null) {
                    experienceEntity = new ExperienceEntity();
                    experienceEntity.setType(ExperienceTypeEnum.GMV.getValue());
                    experienceEntity.setStatus(0);
                    experienceEntity.setAuditing(AuditingEnum.UN_Auditing.getValue());
                    experienceEntity.setVoteTotal(this.getQiWeiUserList(appId).size());
                    for (Map.Entry item : map.entrySet()) {
                        if (Objects.equals(item.getKey(), "USER_ID")) {
                            experienceEntity.setQwUserid(item.getValue().toString());
                            continue;
                        }
                        if (Objects.equals(item.getKey(), "qy_weixin_userid")) {
                            experienceEntity.setQyWeixinUserid(item.getValue().toString());
                            continue;
                        }
                        if (Objects.equals(item.getKey(), "CREATE_TIME")) {
                            experienceEntity.setCreateDate(DateUtils.StrToDate((String)item.getValue().toString()));
                            experienceEntity.setCreateTime(date);
                            experienceEntity.setEndTime(DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)item.getValue().toString()), (int)3));
                            continue;
                        }
                        if (!Objects.equals(item.getKey(), "DISTRIBUTOR_NAME")) continue;
                        experienceEntity.setQwNickname(item.getValue().toString());
                        experienceEntity.setExperienceName(name);
                        experienceEntity.setExperienceDesc(experienceEntity.getExperienceName());
                    }
                    this.logger.info("\u8c03\u7528\u4fdd\u5b58gmv\u6392\u540d\u7b2c\u4e00\u6848\u4f8b:{}", (Object)experienceEntity.getExperienceName());
                    this.saveExperience(experienceEntity, appId);
                } else {
                    this.logger.info("\u7528\u6237:{}\u6848\u4f8b\u5df2\u5b58\u5728", (Object)map.get("USER_ID").toString());
                }
            });
        }
    }
}

