/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.bonus;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.dao.bonus.ExperienceMapper;
import cc.lechun.scrm.entity.bonus.AuditingEnum;
import cc.lechun.scrm.entity.bonus.ExperienceEntity;
import cc.lechun.scrm.entity.bonus.ExperienceVoteEntity;
import cc.lechun.scrm.service.bonus.BonusRuleInterface;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="experience_1")
public class GmvBonusRule
implements BonusRuleInterface {
    @Resource
    private ExperienceMapper experienceMapper;

    @Override
    public BaseJsonVo saveExperience(ExperienceEntity experienceEntity) {
        BaseJsonVo baseJsonVo = this.checkExperience(experienceEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        if (experienceEntity.getExperienceId() == null) {
            experienceEntity.setStatus(0);
            experienceEntity.setCreateTime(DateUtils.now());
            experienceEntity.setEndTime(DateUtils.getAddDateByDay((Date)experienceEntity.getCreateTime(), (int)3));
            return this.experienceMapper.insertSelective(experienceEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
        }
        if (experienceEntity.getEndTime() != null && experienceEntity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u7ecf\u9a8c\u586b\u5199\u5df2\u8fc7\u7ed3\u675f\u65e5\u671f");
        }
        experienceEntity.setAuditing(1);
        experienceEntity.setStatus(1);
        experienceEntity.setAuditingTime(DateUtils.now());
        if (experienceEntity.getEndTime() == null) {
            experienceEntity.setEndTime(DateUtils.getAddDateByDay((Date)experienceEntity.getAuditingTime(), (int)3));
        }
        return this.experienceMapper.updateByPrimaryKeySelective(experienceEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    private BaseJsonVo checkExperience(ExperienceEntity experienceEntity) {
        if (experienceEntity.getExperienceId() != null && experienceEntity.getExperienceContent().length() < 100) {
            return BaseJsonVo.error((String)"\u7ecf\u9a8c\u8981100\u5b57\u4ee5\u4e0a");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo auditingExperience(ExperienceEntity experienceEntity) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean getCanEdit(ExperienceEntity experienceEntity) {
        if (experienceEntity.getEndTime() != null) {
            return experienceEntity.getEndTime().after(DateUtils.now());
        }
        return true;
    }

    @Override
    public boolean getVisible(ExperienceEntity experienceEntity, String userId) {
        return Objects.equals(userId, experienceEntity.getQwUserid()) || Objects.equals(experienceEntity.getAuditing(), AuditingEnum.Auditinged.getValue());
    }

    @Override
    public BaseJsonVo checkVote(ExperienceEntity experienceEntity, ExperienceVoteEntity experienceVoteEntity) {
        boolean result = DateUtils.now().before(experienceEntity.getEndTime());
        if (!result) {
            return BaseJsonVo.error((String)"\u6295\u7968\u5df2\u7ed3\u675f");
        }
        return BaseJsonVo.success((Object)"");
    }
}

