/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.bonus;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.dao.bonus.ExperienceMapper;
import cc.lechun.scrm.entity.bonus.AuditingEnum;
import cc.lechun.scrm.entity.bonus.ExperienceEntity;
import cc.lechun.scrm.entity.bonus.ExperienceVoteEntity;
import cc.lechun.scrm.service.bonus.BonusRuleInterface;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="experience_3")
public class SopBonusRule
implements BonusRuleInterface {
    @Resource
    private ExperienceMapper experienceMapper;

    @Override
    public BaseJsonVo saveExperience(ExperienceEntity experienceEntity) {
        if (experienceEntity.getAuditing() == null) {
            experienceEntity.setAuditing(AuditingEnum.UN_Auditing.getValue());
        }
        if (experienceEntity.getExperienceId() == null) {
            experienceEntity.setStatus(1);
        }
        if (experienceEntity.getExperienceId() == null) {
            return this.experienceMapper.insertSelective(experienceEntity) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
        }
        return this.experienceMapper.updateByPrimaryKeySelective(experienceEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public BaseJsonVo auditingExperience(ExperienceEntity experienceEntity) {
        experienceEntity.setAuditing(1);
        experienceEntity.setAuditingTime(DateUtils.now());
        experienceEntity.setEndTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)3));
        return this.experienceMapper.updateByPrimaryKeySelective(experienceEntity) > 0 ? BaseJsonVo.success((Object)"\u5ba1\u6838\u6210\u529f") : BaseJsonVo.error((String)"\u5ba1\u6838\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public boolean getCanEdit(ExperienceEntity experienceEntity) {
        return Objects.equals(experienceEntity.getAuditing(), AuditingEnum.UN_Auditing.getValue());
    }

    @Override
    public boolean getVisible(ExperienceEntity experienceEntity, String userId) {
        return Objects.equals(experienceEntity.getAuditing(), AuditingEnum.Auditinged.getValue()) || Objects.equals(userId, experienceEntity.getQwUserid());
    }

    @Override
    public BaseJsonVo checkVote(ExperienceEntity experienceEntity, ExperienceVoteEntity experienceVoteEntity) {
        boolean result;
        boolean bl = result = Objects.equals(experienceEntity.getAuditing(), AuditingEnum.Auditinged.getValue()) && DateUtils.now().before(experienceEntity.getEndTime());
        if (!result) {
            return BaseJsonVo.error((String)"\u6295\u7968\u5df2\u7ed3\u675f");
        }
        return BaseJsonVo.success((Object)"");
    }
}

