/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.calendar;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.scrm.dao.calendar.CalendarMapper;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.calendar.CalendarEntity;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import cc.lechun.utils.PeriodUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class CalendarService
extends BaseService<CalendarEntity, Date>
implements CalendarInterface {
    @Resource
    private CalendarMapper calendarMapper;
    @Autowired
    private MallUserInterface mallUserInterface;
    @Resource
    private DistributorMapper distributorMapper;

    @Override
    public BaseJsonVo builderCalendar(Integer year, String weekend, Integer appId) {
        if (year == null) {
            year = LocalDate.now().getYear();
            if (LocalDate.now().getMonth().getValue() == 12) {
                year = year + 1;
            }
        }
        CalendarEntity search = new CalendarEntity();
        search.setYear(year);
        List existsCalendars = this.calendarMapper.getList(search);
        List<Map<String, Object>> lst = PeriodUtil.buildCalendar(year, weekend);
        for (Map<String, Object> m : lst) {
            CalendarEntity calendarEntity = new CalendarEntity();
            BeanUtils.mapToBean(m, (Object)calendarEntity);
            calendarEntity.setYear(year);
            Date date = calendarEntity.getDate();
            Optional<CalendarEntity> exist = existsCalendars.stream().filter(c -> c.getDate().equals(date)).findFirst();
            if (exist.isPresent()) {
                calendarEntity.setQyWorkType(exist.get().getQyWorkType());
                calendarEntity.setQyWeixinUserId(exist.get().getQyWeixinUserId());
                calendarEntity.setQyWeixinUserName(exist.get().getQyWeixinUserName());
            }
            this.logger.info("\u6784\u5efa\u5de5\u4f5c\u65e5\u5386:{}", (Object)calendarEntity.toString());
            this.insertOrUpdate(calendarEntity);
        }
        return BaseJsonVo.success((Object)"\u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Override
    public CalendarEntity getNextWorkDay(Date date, String qyWeixinUserId) {
        CalendarEntity calendarEntity = this.calendarMapper.getNextWorkDay(date, qyWeixinUserId);
        if (calendarEntity == null) {
            return null;
        }
        if (calendarEntity.getDate().equals(date)) {
            return null;
        }
        return calendarEntity;
    }

    @Override
    public BaseJsonVo saveEdit(CalendarEntity calendarEntity) {
        if (calendarEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (calendarEntity.getDate() == null) {
            return BaseJsonVo.error((String)"\u4e0d\u652f\u6301\u65b0\u589e\uff0c\u9700\u8981\u65b0\u589e\u8bf7\u70b9\u521d\u59cb\u5316\u6309\u94ae");
        }
        calendarEntity.setHolidayName(null);
        calendarEntity.setIsHoliday(null);
        if (StringUtils.isNotEmpty((String)calendarEntity.getQyWeixinUserId())) {
            BaseJsonVo jsonVo = this.getQwUser(calendarEntity.getAppId());
            ArrayList lst = (ArrayList)jsonVo.getValue();
            String[] qyweixinuserId = calendarEntity.getQyWeixinUserId().split(",");
            ArrayList<String> names = new ArrayList<String>();
            for (String u : qyweixinuserId) {
                names.add(this.getQwUserName(u));
            }
            calendarEntity.setQyWeixinUserName(org.apache.commons.lang.StringUtils.join((Object[])names.toArray(), (String)","));
        } else {
            calendarEntity.setQyWeixinUserName("");
        }
        this.updateByPrimaryKeySelective(calendarEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo getQwUser(Integer appId) {
        DistributorEntity query = new DistributorEntity();
        query.setAppId(appId);
        if (Objects.equals(appId, AppEnum.SCRM.getValue())) {
            query.setGroupId(5);
        }
        query.setStatus(1);
        List list = this.distributorMapper.getList(query);
        List lst = this.mallUserInterface.getList(new MallUserEntity());
        lst = lst.stream().filter(c -> StringUtils.isNotEmpty((String)c.getQyWeixinUserid())).collect(Collectors.toList());
        ArrayList maps = new ArrayList();
        for (DistributorEntity item : list) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Optional<MallUserEntity> userEntityOptional = lst.stream().filter(u -> Objects.equals(item.getQyWeixinUserid(), u.getQyWeixinUserid())).findFirst();
            if (!userEntityOptional.isPresent()) continue;
            map.put("id", userEntityOptional.get().getQyWeixinUserid());
            map.put("name", userEntityOptional.get().getUserNick());
            maps.add(map);
        }
        return BaseJsonVo.success(maps);
    }

    @Override
    public BaseJsonVo getAllQwUser(Integer appId) {
        DistributorEntity query = new DistributorEntity();
        query.setAppId(appId);
        if (Objects.equals(appId, AppEnum.SCRM.getValue())) {
            query.setGroupId(5);
        }
        List list = this.distributorMapper.getList(query);
        List lst = this.mallUserInterface.getList(new MallUserEntity());
        lst = lst.stream().filter(c -> StringUtils.isNotEmpty((String)c.getQyWeixinUserid())).collect(Collectors.toList());
        ArrayList maps = new ArrayList();
        for (DistributorEntity item : list) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Optional<MallUserEntity> userEntityOptional = lst.stream().filter(u -> Objects.equals(item.getQyWeixinUserid(), u.getQyWeixinUserid())).findFirst();
            if (!userEntityOptional.isPresent()) continue;
            map.put("id", userEntityOptional.get().getQyWeixinUserid());
            map.put("name", userEntityOptional.get().getUserNick());
            maps.add(map);
        }
        return BaseJsonVo.success(maps);
    }

    @Override
    public BaseJsonVo getValidQwUser(Integer appId) {
        BaseJsonVo baseJsonVo = this.getQwUser(appId);
        return baseJsonVo;
    }

    private String getQwUserName(String qyWeixinUserId) {
        MallUserEntity userEntity = new MallUserEntity();
        userEntity.setQyWeixinUserid(qyWeixinUserId);
        userEntity = (MallUserEntity)this.mallUserInterface.getSingle(userEntity);
        if (userEntity != null) {
            return userEntity.getUserNick();
        }
        return "";
    }

    @Override
    public CalendarEntity getCalendarListByDate(Date date) {
        CalendarEntity calendarEntity;
        if (date == null) {
            date = DateUtils.currentDate();
        }
        if ((calendarEntity = (CalendarEntity)this.calendarMapper.selectByPrimaryKey(date)) == null || StringUtils.isEmpty((String)calendarEntity.getQyWeixinUserId())) {
            return null;
        }
        return calendarEntity;
    }

    @Override
    @Cacheable(value={"getCalendarListByDate"}, key="#sdate + '_' + #edate")
    public List<CalendarEntity> getCalendarListByDate(Date sdate, Date edate) {
        return this.calendarMapper.getCalendarListByDate(sdate, edate);
    }

    @Override
    @Cacheable(value={"getNextWorkDayList"}, key="#date + '_' + #day")
    public List<CalendarEntity> getNextWorkDayList(Date date, int day) {
        if (date == null) {
            date = DateUtils.currentDate();
        }
        return this.calendarMapper.getNextWorkDayList(DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"), day);
    }
}

