/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.contact;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.tag.ContactTagMapper;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeAttachmentsMapper;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeGroupMapper;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeMapper;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeTagMapper;
import cc.lechun.scrm.dao.contact.CustomerContactQrcodeUserMapper;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeAttachmentsEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeGroupEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeInfo;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeQueryVo;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeTagEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeUserEntity;
import cc.lechun.scrm.entity.contact.CustomerContactQrcodeVo;
import cc.lechun.scrm.entity.contact.QrcodeAttachmentVo;
import cc.lechun.scrm.entity.contact.QrcodeTagVo;
import cc.lechun.scrm.entity.contact.QrcodeUserVo;
import cc.lechun.scrm.iservice.contact.CustomerContactQrcodeInterface;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.ContactMeAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.contact.ConfigContactMeResult;
import weixin.popular.bean.qy.contact.ConfigContactMeUpdateInfo;
import weixin.popular.bean.qy.contact.ConfigContactMeVo;
import weixin.popular.bean.qy.contact.ContactListQuery;
import weixin.popular.bean.qy.contact.ContactMeDetailResult;
import weixin.popular.bean.qy.contact.ContactMeListResult;

@Service
public class CustomerContactQrcodeService
extends BaseService<CustomerContactQrcodeEntity, Integer>
implements CustomerContactQrcodeInterface {
    @Resource
    private CustomerContactQrcodeMapper customerContactQrcodeMapper;
    @Resource
    private CustomerContactQrcodeUserMapper customerContactQrcodeUserMapper;
    @Resource
    private CustomerContactQrcodeGroupMapper customerContactQrcodeGroupMapper;
    @Resource
    private CustomerContactQrcodeAttachmentsMapper customerContactQrcodeAttachmentsMapper;
    @Resource
    private CustomerContactQrcodeTagMapper customerContactQrcodeTagMapper;
    @Resource
    private ContactTagMapper contactTagMapper;
    @Lazy
    @Autowired
    private MaterialInterface materialInterface;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    OssService ossService;
    @Resource
    MallUserMapper userMapper;
    @Resource
    private DistributorMapper distributorMapper;

    @Override
    public PageInfo<CustomerContactQrcodeVo> getQrcodeList(CustomerContactQrcodeQueryVo customerContactQrcodeQueryVo) {
        CustomerContactQrcodeEntity customerContactQrcodeEntity = new CustomerContactQrcodeEntity();
        this.getCustomerContactQrcodeUser(customerContactQrcodeQueryVo, customerContactQrcodeEntity);
        Page pages = PageHelper.startPage((int)customerContactQrcodeQueryVo.getPageNum(), (int)customerContactQrcodeQueryVo.getPageSize(), (String)"CREATE_TIME desc");
        if (StringUtils.isNotEmpty((String)customerContactQrcodeQueryVo.getQrName())) {
            customerContactQrcodeEntity.setQrName(SqlUtils.sqlLike((String)customerContactQrcodeQueryVo.getQrName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (customerContactQrcodeQueryVo.getQrcodeGroupId() != null) {
            customerContactQrcodeEntity.setQrcodeGroupId(customerContactQrcodeQueryVo.getQrcodeGroupId());
        }
        this.customerContactQrcodeMapper.getList(customerContactQrcodeEntity);
        PageInfo pg = pages.toPageInfo();
        List result = pg.getList().stream().map(item -> this.getCustomerContactQrcodeVo((CustomerContactQrcodeEntity)item)).collect(Collectors.toList());
        PageInfo pageInfo2 = new PageInfo();
        BeanUtils.copyProperties((Object)pg, (Object)pageInfo2);
        pageInfo2.setList(result);
        return pageInfo2;
    }

    @Override
    public void initQrcode() {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        ContactListQuery contactListQuery = new ContactListQuery();
        contactListQuery.setLimit(Integer.valueOf(1000));
        ContactMeListResult contactMeListResult = ContactMeAPI.getContactList((String)accessToken, (ContactListQuery)contactListQuery);
        if (contactMeListResult.isSuccess()) {
            contactMeListResult.getContactWay().forEach(qrcode -> {
                this.logger.info("\u67e5\u8be2\u6d3b\u7801:{}", (Object)JsonUtils.toJson((Object)qrcode, (boolean)false));
                this.addCustomerContactQrcode(accessToken, (ContactMeListResult.ContactWay)qrcode);
            });
        }
    }

    private void getCustomerContactQrcodeUser(CustomerContactQrcodeQueryVo customerContactQrcodeQueryVo, CustomerContactQrcodeEntity customerContactQrcodeEntity) {
        if (StringUtils.isNotEmpty((String)customerContactQrcodeQueryVo.getQyWeiXinUserId())) {
            CustomerContactQrcodeUserEntity customerContactQrcodeUserEntity = new CustomerContactQrcodeUserEntity();
            customerContactQrcodeUserEntity.setQyWeixinUserId(customerContactQrcodeQueryVo.getQyWeiXinUserId());
            CustomerContactQrcodeUserEntity result = (CustomerContactQrcodeUserEntity)this.customerContactQrcodeUserMapper.getSingle(customerContactQrcodeUserEntity);
            if (result != null) {
                customerContactQrcodeEntity.setQrId(result.getQrcodeId());
            }
        }
    }

    @NotNull
    private CustomerContactQrcodeVo getCustomerContactQrcodeVo(CustomerContactQrcodeEntity item) {
        CustomerContactQrcodeVo customerContactQrcodeVo = new CustomerContactQrcodeVo();
        BeanUtils.copyProperties((Object)item, (Object)customerContactQrcodeVo);
        ContactMeDetailResult contactMeDetailResult = ContactMeAPI.getContactDetail((String)this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue()), (String)item.getConfigId());
        if (contactMeDetailResult.isSuccess()) {
            BeanUtils.copyProperties((Object)contactMeDetailResult, (Object)customerContactQrcodeVo);
            customerContactQrcodeVo.setSkipVerify(contactMeDetailResult.getContactWay().isSkip_verify());
        }
        customerContactQrcodeVo.setQrPath(this.ossService.getImageResoure(customerContactQrcodeVo.getQrPath()));
        customerContactQrcodeVo.setGroupId(item.getQrcodeGroupId());
        CustomerContactQrcodeGroupEntity customerContactQrcodeGroupEntity = (CustomerContactQrcodeGroupEntity)this.customerContactQrcodeGroupMapper.selectByPrimaryKey(item.getQrcodeGroupId());
        customerContactQrcodeVo.setGroupName(customerContactQrcodeGroupEntity != null ? customerContactQrcodeGroupEntity.getQrcodeGroupName() : null);
        CustomerContactQrcodeUserEntity qrcodeUserQuery = new CustomerContactQrcodeUserEntity();
        qrcodeUserQuery.setQrcodeId(item.getQrId());
        List qrcodeUserList = this.customerContactQrcodeUserMapper.getList(qrcodeUserQuery);
        if (CollectionUtils.isNotEmpty((Collection)qrcodeUserList)) {
            List<QrcodeUserVo> qrcodeUserVoList = qrcodeUserList.stream().map(qrcodeUser -> {
                QrcodeUserVo qrcodeUserVo = new QrcodeUserVo();
                BeanUtils.copyProperties((Object)qrcodeUser, (Object)qrcodeUserVo);
                MallUserEntity userQuery = new MallUserEntity();
                userQuery.setQyWeixinUserid(qrcodeUser.getQyWeixinUserId());
                MallUserEntity userEntity = (MallUserEntity)this.userMapper.getSingle(userQuery);
                qrcodeUserVo.setQyWeiXinUserName(userEntity != null ? userEntity.getUserNick() : null);
                return qrcodeUserVo;
            }).collect(Collectors.toList());
            customerContactQrcodeVo.setUserList(qrcodeUserVoList);
        }
        CustomerContactQrcodeAttachmentsEntity qrcodeAttachmentsQuery = new CustomerContactQrcodeAttachmentsEntity();
        qrcodeAttachmentsQuery.setQrcodeId(item.getQrId());
        List qrcodeAttachmentsEntityList = this.customerContactQrcodeAttachmentsMapper.getList(qrcodeAttachmentsQuery);
        if (CollectionUtils.isNotEmpty((Collection)qrcodeAttachmentsEntityList)) {
            List<QrcodeAttachmentVo> attachmentsEntityList = qrcodeAttachmentsEntityList.stream().map(qrcodeAttachmentsEntity -> {
                QrcodeAttachmentVo qrcodeAttachmentVo = new QrcodeAttachmentVo();
                BeanUtils.copyProperties((Object)qrcodeAttachmentsEntity, (Object)qrcodeAttachmentVo);
                Map map = this.materialInterface.getMaterialWithType(qrcodeAttachmentsEntity.getMaterialId());
                qrcodeAttachmentVo.setMaterailId(qrcodeAttachmentsEntity.getMaterialId());
                qrcodeAttachmentVo.setMaterialName(map.getOrDefault("materialName", "").toString());
                qrcodeAttachmentVo.setMediaType(map.getOrDefault("materialType", "").toString());
                if ("image".equals(map.get("materialType")) || "media".equals(map.get("materialType")) || "video".equals(map.get("materialType")) || "file".equals(map.get("materialType"))) {
                    qrcodeAttachmentVo.setMediaUrl(map.getOrDefault("ossUrl", "").toString());
                }
                if ("text".equals(map.get("materialType"))) {
                    qrcodeAttachmentVo.setPushText(map.getOrDefault("pushText", "").toString());
                }
                return qrcodeAttachmentVo;
            }).collect(Collectors.toList());
            customerContactQrcodeVo.setQrcodeAttachmentVoList(attachmentsEntityList);
        }
        CustomerContactQrcodeTagEntity qrcodeTagQuery = new CustomerContactQrcodeTagEntity();
        qrcodeTagQuery.setQrcodeId(item.getQrId());
        List qrcodeTagEntityList = this.customerContactQrcodeTagMapper.getList(qrcodeTagQuery);
        if (CollectionUtils.isNotEmpty((Collection)qrcodeTagEntityList)) {
            List<QrcodeTagVo> qrcodeTagVoList = qrcodeTagEntityList.stream().map(qrcodeTag -> {
                QrcodeTagVo qrcodeTagVo = new QrcodeTagVo();
                BeanUtils.copyProperties((Object)qrcodeTag, (Object)qrcodeTagVo);
                ContactTagEntity tagQuery = new ContactTagEntity();
                tagQuery.setWxContactTagId(qrcodeTag.getTagId());
                ContactTagEntity contactTagEntity = (ContactTagEntity)this.contactTagMapper.getSingle(tagQuery);
                if (contactTagEntity != null) {
                    qrcodeTagVo.setTagName(contactTagEntity.getName());
                    qrcodeTagVo.setTagId(contactTagEntity.getWxContactTagId());
                }
                return qrcodeTagVo;
            }).collect(Collectors.toList());
            customerContactQrcodeVo.setTagVoList(qrcodeTagVoList);
        }
        return customerContactQrcodeVo;
    }

    private void addCustomerContactQrcode(String accessToken, ContactMeListResult.ContactWay contactWay) {
        this.logger.info("\u67e5\u8be2\u6d3b\u7801:{}\u8be6\u60c5", (Object)contactWay.getConfigId());
        ContactMeDetailResult contactMeDetailResult = ContactMeAPI.getContactDetail((String)accessToken, (String)contactWay.getConfigId());
        if (contactMeDetailResult != null && contactMeDetailResult.isSuccess()) {
            CustomerContactQrcodeEntity customerContactQrcodeEntity = new CustomerContactQrcodeEntity();
            BeanUtils.copyProperties((Object)contactMeDetailResult.getContactWay(), (Object)customerContactQrcodeEntity);
            customerContactQrcodeEntity.setQrName(contactMeDetailResult.getContactWay().getRemark());
            customerContactQrcodeEntity.setAutoAddStatus(contactMeDetailResult.getContactWay().isSkip_verify() ? 1 : 0);
            customerContactQrcodeEntity.setConfigId(contactWay.getConfigId());
            String path = this.saveFileStream(contactMeDetailResult.getContactWay().getQr_code(), contactWay.getConfigId());
            if (StringUtils.isEmpty((String)path)) {
                this.logger.error("\u6d3b\u7801\u5bfc\u5165\u5931\u8d25");
                return;
            }
            customerContactQrcodeEntity.setQrPath(path);
            customerContactQrcodeEntity.setStatus(1);
            customerContactQrcodeEntity.setCreateUserId("1");
            customerContactQrcodeEntity.setCreateTime(DateUtils.now());
            int rtn = this.customerContactQrcodeMapper.insert(customerContactQrcodeEntity);
            if (CollectionUtils.isNotEmpty((Collection)contactMeDetailResult.getContactWay().getUser())) {
                this.saveQrcodeQiWei2(contactMeDetailResult.getContactWay().getUser(), customerContactQrcodeEntity.getQrId());
            }
        }
    }

    @Override
    public BaseJsonVo saveCustomerContact(CustomerContactQrcodeInfo customerContactQrcodeVo) {
        this.logger.info("\u4fdd\u5b58\u6d3b\u7801:{}", (Object)JsonUtils.toJson((Object)customerContactQrcodeVo, (boolean)false));
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        if (customerContactQrcodeVo.getQrId() == null) {
            this.addQrcode(accessToken, customerContactQrcodeVo);
        } else {
            this.saveQrcode(accessToken, customerContactQrcodeVo);
        }
        this.saveQrcodeMaterial(customerContactQrcodeVo.getQrId(), customerContactQrcodeVo.getQrcodeAttachmentVoList());
        this.saveQrcodeQiWei(customerContactQrcodeVo.getUserList(), customerContactQrcodeVo.getQrId());
        this.saveTag(customerContactQrcodeVo.getTagVoList(), customerContactQrcodeVo.getQrId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteQrcode(Integer qrcodeId, String configId) {
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        BaseResult baseResult = ContactMeAPI.delContactWay((String)accessToken, (String)configId);
        if (baseResult.isSuccess()) {
            if (qrcodeId == null) {
                CustomerContactQrcodeEntity customerContactQrcodeEntity = new CustomerContactQrcodeEntity();
                customerContactQrcodeEntity.setConfigId(configId);
                customerContactQrcodeEntity = (CustomerContactQrcodeEntity)this.customerContactQrcodeMapper.getSingle(customerContactQrcodeEntity);
                qrcodeId = customerContactQrcodeEntity.getQrId();
            }
            this.customerContactQrcodeMapper.deleteByPrimaryKey(qrcodeId);
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    @Override
    public BaseJsonVo getQrcode(Integer qrcodeId) {
        CustomerContactQrcodeEntity customerContactQrcodeEntity = (CustomerContactQrcodeEntity)this.customerContactQrcodeMapper.selectByPrimaryKey(qrcodeId);
        return BaseJsonVo.success((Object)this.getCustomerContactQrcodeVo(customerContactQrcodeEntity));
    }

    @Override
    public BaseJsonVo<CustomerContactQrcodeVo> getCustomerContactQrcodeVo(Integer qrcodeId) {
        return null;
    }

    private BaseJsonVo addQrcode(String accessToken, CustomerContactQrcodeInfo customerContactQrcodeVo) {
        ConfigContactMeVo configContactMeVo = new ConfigContactMeVo();
        BeanUtils.copyProperties((Object)customerContactQrcodeVo, (Object)configContactMeVo);
        configContactMeVo.setUser(customerContactQrcodeVo.getUserList().stream().map(CustomerContactQrcodeInfo.QrcodeUser::getQyWeixinUserId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(customerContactQrcodeVo.getUserList())) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u4f01\u5fae\u670d\u52a1\u4eba\u5458\uff0c\u8bf7\u9009\u62e9\u4f01\u5fae\u540e\u518d\u8bd5!");
        }
        if (StringUtils.isEmpty((String)customerContactQrcodeVo.getState())) {
            return BaseJsonVo.error((String)"\u6d3b\u7801\u6e20\u9053\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6d3b\u7801\u6e20\u9053\u518d\u8bd5!");
        }
        ConfigContactMeResult configContactMeResult = ContactMeAPI.addContactWay((String)accessToken, (ConfigContactMeVo)configContactMeVo);
        if (configContactMeResult.isSuccess()) {
            CustomerContactQrcodeEntity qrcodeQuery = new CustomerContactQrcodeEntity();
            qrcodeQuery.setConfigId(configContactMeResult.getConfigId());
            CustomerContactQrcodeEntity customerContactQrcodeEntity = (CustomerContactQrcodeEntity)this.customerContactQrcodeMapper.getSingle(qrcodeQuery);
            if (customerContactQrcodeEntity == null) {
                customerContactQrcodeEntity = new CustomerContactQrcodeEntity();
                customerContactQrcodeEntity.setStatus(1);
                customerContactQrcodeEntity.setQrcodeGroupId(customerContactQrcodeVo.getGroupId());
                BeanUtils.copyProperties((Object)configContactMeVo, (Object)customerContactQrcodeEntity);
                customerContactQrcodeEntity.setQrName(customerContactQrcodeVo.getQrName());
                customerContactQrcodeEntity.setConfigId(configContactMeResult.getConfigId());
                String path = this.saveFileStream(configContactMeResult.getQrCode(), configContactMeResult.getConfigId());
                if (StringUtils.isEmpty((String)path)) {
                    return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                }
                customerContactQrcodeEntity.setQrPath(path);
                customerContactQrcodeEntity.setCreateUserId(customerContactQrcodeVo.getCreator());
                customerContactQrcodeEntity.setCreateTime(DateUtils.now());
                customerContactQrcodeEntity.setAutoAddStatus(customerContactQrcodeVo.getSkipVerify() != false ? 1 : 2);
                this.customerContactQrcodeMapper.insert(customerContactQrcodeEntity);
                customerContactQrcodeVo.setQrId(customerContactQrcodeEntity.getQrId());
                return BaseJsonVo.success((Object)"");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo saveQrcode(String accessToken, CustomerContactQrcodeInfo customerContactQrcodeVo) {
        ConfigContactMeUpdateInfo configContactMeVo = new ConfigContactMeUpdateInfo();
        BeanUtils.copyProperties((Object)configContactMeVo, (Object)customerContactQrcodeVo);
        BaseResult baseResult = ContactMeAPI.updateContactWay((String)accessToken, (ConfigContactMeUpdateInfo)configContactMeVo);
        if (baseResult.isSuccess()) {
            CustomerContactQrcodeEntity customerContactQrcodeEntity = (CustomerContactQrcodeEntity)this.customerContactQrcodeMapper.selectByPrimaryKey(customerContactQrcodeVo.getQrId());
            if (customerContactQrcodeEntity == null) {
                return BaseJsonVo.error((String)"\u6d3b\u7801\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            BeanUtils.copyProperties((Object)customerContactQrcodeEntity, (Object)customerContactQrcodeVo);
            customerContactQrcodeEntity.setUpdateUserId(customerContactQrcodeVo.getCreator());
            customerContactQrcodeEntity.setUpdateTime(DateUtils.now());
        }
        return BaseJsonVo.success((Object)"");
    }

    private String saveFileStream(String path, String configId) {
        try {
            URL url = new URL(path);
            InputStream is = url.openStream();
            return this.ossService.uploadFile(AliyunOSSDir.QRCODE_IMG_ROOT_STORAGE, configId + ".jpg", is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private BaseJsonVo saveTag(List<CustomerContactQrcodeInfo.QrcodeTag> tagVoList, Integer qrcodeId) {
        if (CollectionUtils.isNotEmpty(tagVoList)) {
            CustomerContactQrcodeTagEntity queryQrcodeTag = new CustomerContactQrcodeTagEntity();
            queryQrcodeTag.setQrcodeId(qrcodeId);
            List tempList = this.customerContactQrcodeTagMapper.getList(queryQrcodeTag);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                Serializable[] arrTemp = tempList.stream().map(CustomerContactQrcodeTagEntity::getQrcodeTagId).collect(Collectors.toList()).toArray(new Integer[tempList.size()]);
                this.customerContactQrcodeTagMapper.batchDelete(arrTemp);
            }
            List list = tagVoList.stream().map(item -> {
                CustomerContactQrcodeTagEntity customerContactQrcodeTagEntity = new CustomerContactQrcodeTagEntity();
                BeanUtils.copyProperties((Object)item, (Object)customerContactQrcodeTagEntity);
                customerContactQrcodeTagEntity.setQrcodeId(qrcodeId);
                customerContactQrcodeTagEntity.setTagId(item.getWxContactTagId());
                return customerContactQrcodeTagEntity;
            }).collect(Collectors.toList());
            this.customerContactQrcodeTagMapper.batchInsertIgnore(list);
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo saveQrcodeMaterial(Integer qrcodeId, List<CustomerContactQrcodeInfo.QrcodeAttachment> qrcodeAttachmentVoList) {
        if (CollectionUtils.isNotEmpty(qrcodeAttachmentVoList)) {
            CustomerContactQrcodeAttachmentsEntity queryQrcodeAttachments = new CustomerContactQrcodeAttachmentsEntity();
            queryQrcodeAttachments.setQrcodeId(qrcodeId);
            List tempList = this.customerContactQrcodeAttachmentsMapper.getList(queryQrcodeAttachments);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                Serializable[] arrTemp = tempList.stream().map(CustomerContactQrcodeAttachmentsEntity::getAttachmentId).collect(Collectors.toList()).toArray(new Integer[tempList.size()]);
                this.customerContactQrcodeTagMapper.batchDelete(arrTemp);
            }
            List list = qrcodeAttachmentVoList.stream().map(item -> {
                CustomerContactQrcodeAttachmentsEntity customerContactQrcodeAttachmentsEntity = new CustomerContactQrcodeAttachmentsEntity();
                BeanUtils.copyProperties((Object)item, (Object)customerContactQrcodeAttachmentsEntity);
                customerContactQrcodeAttachmentsEntity.setQrcodeId(qrcodeId);
                customerContactQrcodeAttachmentsEntity.setMaterialId(item.getMaterailId());
                return customerContactQrcodeAttachmentsEntity;
            }).collect(Collectors.toList());
            this.customerContactQrcodeAttachmentsMapper.batchInsertIgnore(list);
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo saveQrcodeQiWei(List<CustomerContactQrcodeInfo.QrcodeUser> userList, Integer qrcodeId) {
        if (CollectionUtils.isNotEmpty(userList)) {
            CustomerContactQrcodeUserEntity qrcodeUserEntity = new CustomerContactQrcodeUserEntity();
            qrcodeUserEntity.setQrcodeId(qrcodeId);
            List tempList = this.customerContactQrcodeUserMapper.getList(qrcodeUserEntity);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                Serializable[] arrTemp = tempList.stream().map(CustomerContactQrcodeUserEntity::getQrcodeUserId).collect(Collectors.toList()).toArray(new Integer[tempList.size()]);
                this.customerContactQrcodeUserMapper.batchDelete(arrTemp);
            }
            List list = userList.stream().map(item -> {
                CustomerContactQrcodeUserEntity customerContactQrcodeUserEntity = new CustomerContactQrcodeUserEntity();
                BeanUtils.copyProperties((Object)item, (Object)customerContactQrcodeUserEntity);
                MallUserEntity queryUser = new MallUserEntity();
                queryUser.setQyWeixinUserid(item.getQyWeixinUserId());
                MallUserEntity mallUserEntity = (MallUserEntity)this.userMapper.getSingle(queryUser);
                customerContactQrcodeUserEntity.setUserId(mallUserEntity != null ? mallUserEntity.getUserId() : null);
                customerContactQrcodeUserEntity.setQrcodeId(qrcodeId);
                return customerContactQrcodeUserEntity;
            }).collect(Collectors.toList());
            this.customerContactQrcodeUserMapper.batchInsertIgnore(list);
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo saveQrcodeQiWei2(List<String> userList, Integer qrcodeId) {
        if (CollectionUtils.isNotEmpty(userList)) {
            List list = userList.stream().map(item -> {
                MallUserEntity queryUser = new MallUserEntity();
                queryUser.setQyWeixinUserid((String)item);
                MallUserEntity mallUserEntity = (MallUserEntity)this.userMapper.getSingle(queryUser);
                CustomerContactQrcodeUserEntity customerContactQrcodeUserEntity = new CustomerContactQrcodeUserEntity();
                customerContactQrcodeUserEntity.setQrcodeId(qrcodeId);
                customerContactQrcodeUserEntity.setQyWeixinUserId((String)item);
                if (mallUserEntity != null) {
                    customerContactQrcodeUserEntity.setUserId(mallUserEntity.getUserId());
                }
                return customerContactQrcodeUserEntity;
            }).collect(Collectors.toList());
            this.customerContactQrcodeUserMapper.batchInsertIgnore(list);
        }
        return BaseJsonVo.success((Object)"");
    }
}

