/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.echelon;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.scrm.dao.echelon.EchelonLogMapper;
import cc.lechun.scrm.entity.echelon.CompleteStatusEnum;
import cc.lechun.scrm.entity.echelon.EchelonAwardVo;
import cc.lechun.scrm.entity.echelon.EchelonDetailedEntity;
import cc.lechun.scrm.entity.echelon.EchelonDetailedVo;
import cc.lechun.scrm.entity.echelon.EchelonEntity;
import cc.lechun.scrm.entity.echelon.EchelonLogEntity;
import cc.lechun.scrm.entity.echelon.EchelonMasterVo;
import cc.lechun.scrm.entity.echelon.EchelonPeriodEntity;
import cc.lechun.scrm.entity.echelon.EchelonQueryVo;
import cc.lechun.scrm.iservice.echelon.ComputeAward;
import cc.lechun.scrm.iservice.echelon.EchelonDetailedInterface;
import cc.lechun.scrm.iservice.echelon.EchelonInterface;
import cc.lechun.scrm.iservice.echelon.EchelonPeriodInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ComputeAwardService
implements ComputeAward {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EchelonInterface echelonInterface;
    @Autowired
    private EchelonDetailedInterface echelonDetailedInterface;
    @Autowired
    private EchelonPeriodInterface echelonPeriodInterface;
    @Resource
    private DistributorMapper distributorMapper;
    @Autowired
    @Lazy
    private SysUserInterface userInterface;
    @Resource
    private EchelonLogMapper echelonLogMapper;

    @Override
    public void computeAwardByMonth(Integer periodId) {
        EchelonEntity query = new EchelonEntity();
        query.setPeriodId(periodId);
        List list = this.echelonInterface.getList(query, 0L);
        EchelonPeriodEntity periodEntity = (EchelonPeriodEntity)this.echelonPeriodInterface.selectByPrimaryKey(periodId);
        List<Object> echelonAwardVoList = new ArrayList<EchelonAwardVo>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (EchelonEntity echelonEntity : list) {
                echelonAwardVoList.add(this.computeAwardByMonth(echelonEntity, periodEntity));
            }
            echelonAwardVoList = echelonAwardVoList.stream().sorted((e1, e2) -> e2.getGmv().compareTo(e1.getGmv())).collect(Collectors.toList());
            int sort = 1;
            for (EchelonAwardVo echelonAwardVo : echelonAwardVoList) {
                echelonAwardVo.setSort(sort);
                EchelonEntity updateSort = new EchelonEntity();
                updateSort.setEchelonId(echelonAwardVo.getEchelonId());
                updateSort.setSort(sort);
                updateSort.setGmv(echelonAwardVo.getGmv());
                updateSort.setUpdateTime(DateUtils.now());
                this.echelonInterface.updateByPrimaryKeySelective(updateSort);
                this.logger.info("\u68af\u961f:{},\u6392\u540d:{},GMV:{}\u5df2\u66f4\u65b0", new Object[]{echelonAwardVo.getEchelonId(), sort, echelonAwardVo.getGmv()});
                ++sort;
            }
            this.computeAwardXiShu4First((EchelonAwardVo)echelonAwardVoList.get(0));
            this.computeAwardXiShu4Last((EchelonAwardVo)echelonAwardVoList.get(echelonAwardVoList.size() - 1));
            this.computeAwardXiShu4FirstPerson((EchelonAwardVo)echelonAwardVoList.get(0));
        }
    }

    private void computeAwardXiShu4First(EchelonAwardVo echelonAwardVo) {
        EchelonEntity last;
        echelonAwardVo.setPerformanceCoefficient(new BigDecimal("1.1"));
        EchelonEntity update = new EchelonEntity();
        update.setEchelonId(echelonAwardVo.getEchelonId());
        update.setParentEchelonId(echelonAwardVo.getParentCoefficientId());
        this.echelonInterface.updateByPrimaryKeySelective(update);
        EchelonLogEntity echelonLogEntity = new EchelonLogEntity();
        echelonLogEntity.setRemark("\u8bbe\u7f6e\u68af\u961f\u7b2c\u4e00\u540d\u7cfb\u6570\u4e3a1.1");
        echelonLogEntity.setCreateTime(DateUtils.now());
        echelonLogEntity.setEchelonId(echelonAwardVo.getEchelonId());
        this.echelonLogMapper.insertSelective(echelonLogEntity);
        if (echelonAwardVo.getParrentEchelonId() != null && (last = (EchelonEntity)this.echelonInterface.selectByPrimaryKey(echelonAwardVo.getParrentEchelonId())) != null && Objects.equals(last.getSort(), 1)) {
            echelonAwardVo.setPerformanceCoefficient(new BigDecimal("1.2"));
            update.setParentEchelonId(echelonAwardVo.getParentCoefficientId());
            this.echelonInterface.updateByPrimaryKeySelective(update);
            echelonLogEntity.setRemark("\u68af\u961f\u8fde\u7eed\u4e24\u4e2a\u6708\u6392\u540d \u8bbe\u7f6e\u68af\u961f\u7b2c\u4e00\u540d\u7cfb\u6570\u4e3a1.2");
            echelonLogEntity.setCreateTime(DateUtils.now());
            this.echelonLogMapper.insertSelective(echelonLogEntity);
        }
        this.logger.info("\u68af\u961f:{}\u6392\u540d\u7b2c\u4e00\u7cfb\u6570\u8ba1\u7b97\u5b8c\u6bd5", (Object)echelonAwardVo.getEchelonId());
    }

    private void computeAwardXiShu4FirstPerson(EchelonAwardVo echelonAwardVo) {
        for (EchelonDetailedVo echelonDetailedVo : echelonAwardVo.getEchelonDetailedVoList()) {
            if (echelonAwardVo.getParrentEchelonId() == null) continue;
            EchelonEntity lastEchelon = (EchelonEntity)this.echelonInterface.selectByPrimaryKey(echelonAwardVo.getParrentEchelonId());
            EchelonEntity query = new EchelonEntity();
            query.setPeriodId(lastEchelon.getPeriodId());
            query.setStatus(1);
            query.setSort(1);
            EchelonEntity first = (EchelonEntity)this.echelonInterface.getSingle(query, 0L);
            if (first == null) {
                this.logger.info("\u671f\u6b21:{}\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728", (Object)lastEchelon.getPeriodId());
                return;
            }
            EchelonDetailedEntity detailedEntity = new EchelonDetailedEntity();
            detailedEntity.setEchelonId(first.getEchelonId());
            detailedEntity.setUserId(echelonDetailedVo.getUserId());
            detailedEntity.setStatus(1);
            EchelonDetailedEntity temp = (EchelonDetailedEntity)this.echelonDetailedInterface.getSingle(detailedEntity, 0L);
            if (temp != null) {
                this.logger.info("\u4f01\u5fae:{}\u5728\u4e0a\u4e00\u671f:{} \u7b2c\u4e00\u68af\u961f\u4e2d \u4e2a\u4eba\u7cfb\u6570*1.1", (Object)echelonDetailedVo.getUserId(), (Object)first.getPeriodName());
                EchelonDetailedEntity updateEchelonDetailedEntity = new EchelonDetailedEntity();
                updateEchelonDetailedEntity.setPerformanceCoefficient(PriceUtils.multiply((BigDecimal)echelonDetailedVo.getPerformanceCoefficient(), (BigDecimal)new BigDecimal("1.1")));
                updateEchelonDetailedEntity.setEchelonDetailedId(echelonDetailedVo.getEchelonDetailedId());
                this.echelonDetailedInterface.updateByPrimaryKeySelective(updateEchelonDetailedEntity);
                EchelonLogEntity echelonLogEntity = new EchelonLogEntity();
                echelonLogEntity.setEchelonId(echelonDetailedVo.getEchelonId());
                echelonLogEntity.setCreateTime(DateUtils.now());
                echelonLogEntity.setUserName(echelonDetailedVo.getUserName());
                echelonLogEntity.setRemark("\u8fde\u7eed\u4e24\u4e2a\u6708\u5904\u4e8e\u7b2c\u4e00\u68af\u961f\u7cfb\u6570*1.1");
                this.echelonLogMapper.insertSelective(echelonLogEntity);
                if (first.getParentEchelonId() != null) {
                    lastEchelon = (EchelonEntity)this.echelonInterface.selectByPrimaryKey(first.getParentEchelonId());
                    query = new EchelonEntity();
                    query.setPeriodId(lastEchelon.getPeriodId());
                    query.setStatus(1);
                    query.setSort(1);
                    first = (EchelonEntity)this.echelonInterface.getSingle(query, 0L);
                    if (first == null) {
                        this.logger.info("\u671f\u6b21:{}\u4e0a\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728", (Object)first.getPeriodId());
                        return;
                    }
                    detailedEntity = new EchelonDetailedEntity();
                    detailedEntity.setEchelonId(first.getEchelonId());
                    detailedEntity.setUserId(echelonDetailedVo.getUserId());
                    detailedEntity.setStatus(1);
                    temp = (EchelonDetailedEntity)this.echelonDetailedInterface.getSingle(detailedEntity, 0L);
                    if (temp == null) continue;
                    this.logger.info("\u4f01\u5fae:{}\u5728\u4e0a\u4e00\u671f:{} \u7b2c\u4e00\u68af\u961f\u4e2d \u4e2a\u4eba\u7cfb\u6570*1.2", (Object)echelonDetailedVo.getUserId(), (Object)first.getPeriodName());
                    updateEchelonDetailedEntity = new EchelonDetailedEntity();
                    updateEchelonDetailedEntity.setPerformanceCoefficient(PriceUtils.multiply((BigDecimal)echelonDetailedVo.getPerformanceCoefficient(), (BigDecimal)new BigDecimal("1.2")));
                    updateEchelonDetailedEntity.setEchelonDetailedId(echelonDetailedVo.getEchelonDetailedId());
                    this.echelonDetailedInterface.updateByPrimaryKeySelective(updateEchelonDetailedEntity);
                    echelonLogEntity = new EchelonLogEntity();
                    echelonLogEntity.setEchelonId(echelonDetailedVo.getEchelonId());
                    echelonLogEntity.setCreateTime(DateUtils.now());
                    echelonLogEntity.setUserName(echelonDetailedVo.getUserName());
                    echelonLogEntity.setRemark("\u8fde\u7eed\u4e09\u4e2a\u6708\u5904\u4e8e\u7b2c\u4e00\u68af\u961f\u7cfb\u6570*1.2");
                    this.echelonLogMapper.insertSelective(echelonLogEntity);
                    continue;
                }
                this.logger.info("\u671f\u6b21:{}\u4e0a\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728", (Object)first.getPeriodId());
                continue;
            }
            this.logger.info("\u4f01\u5fae:{}\u4e0d\u5728\u4e0a\u4e00\u671f:{}\u7b2c\u4e00\u68af\u961f\u4e2d", (Object)echelonDetailedVo.getUserId(), (Object)first.getPeriodName());
        }
        this.logger.info("\u68af\u961f:{}\u6392\u540d\u7b2c\u4e00\u7cfb\u6570\u8ba1\u7b97\u5b8c\u6bd5", (Object)echelonAwardVo.getEchelonId());
    }

    private void computeAwardXiShu4Last(EchelonAwardVo echelonAwardVo) {
        echelonAwardVo.setPerformanceCoefficient(new BigDecimal("0.9"));
        EchelonEntity update = new EchelonEntity();
        update.setEchelonId(echelonAwardVo.getEchelonId());
        update.setParentEchelonId(echelonAwardVo.getParentCoefficientId());
        this.echelonInterface.updateByPrimaryKeySelective(update);
        EchelonLogEntity echelonLogEntity = new EchelonLogEntity();
        echelonLogEntity.setRemark("\u8bbe\u7f6e\u68af\u961f\u7b2c\u4e00\u540d\u7cfb\u6570\u4e3a0.9");
        echelonLogEntity.setCreateTime(DateUtils.now());
        echelonLogEntity.setEchelonId(echelonAwardVo.getEchelonId());
        this.echelonLogMapper.insertSelective(echelonLogEntity);
        if (echelonAwardVo.getParrentEchelonId() != null && this.echelonInterface.checkLast(echelonAwardVo.getParrentEchelonId())) {
            echelonAwardVo.setPerformanceCoefficient(new BigDecimal("0.8"));
            update.setParentEchelonId(echelonAwardVo.getParentCoefficientId());
            this.echelonInterface.updateByPrimaryKeySelective(update);
            echelonLogEntity.setRemark("\u68af\u961f\u8fde\u7eed\u4e24\u4e2a\u6708\u6392\u540d \u8bbe\u7f6e\u68af\u961f\u7b2c\u4e00\u540d\u7cfb\u6570\u4e3a0.8");
            echelonLogEntity.setCreateTime(DateUtils.now());
            this.echelonLogMapper.insertSelective(echelonLogEntity);
        }
        this.logger.info("\u68af\u961f:{}\u6392\u540d\u6700\u540e\u4e00\u540d\u7cfb\u6570\u8ba1\u7b97\u5b8c\u6bd5", (Object)echelonAwardVo.getEchelonId());
    }

    @Override
    public EchelonAwardVo computeAwardByMonth(EchelonEntity echelonEntity, EchelonPeriodEntity periodEntity) {
        EchelonAwardVo echelonAwardVo = new EchelonAwardVo();
        BeanUtils.copyProperties((Object)echelonEntity, (Object)echelonAwardVo);
        echelonAwardVo.setEchelonDetailedVoList(new ArrayList<EchelonDetailedVo>());
        EchelonDetailedEntity query = new EchelonDetailedEntity();
        query.setEchelonId(echelonEntity.getEchelonId());
        List list = this.echelonDetailedInterface.getList(query);
        ArrayList<EchelonDetailedVo> detailResult = new ArrayList<EchelonDetailedVo>();
        for (Object detailedEntity : list) {
            EchelonDetailedVo echelonDetailedVo = this.computeAwardApprentice((EchelonDetailedEntity)detailedEntity, echelonEntity, periodEntity);
            detailResult.add(echelonDetailedVo);
            echelonAwardVo.setGmv(PriceUtils.add((BigDecimal)(echelonAwardVo.getGmv() == null ? BigDecimal.ZERO : echelonAwardVo.getGmv()), (BigDecimal)echelonDetailedVo.getGmv()));
        }
        echelonAwardVo.setEchelonDetailedVoList(detailResult);
        List tudiList = list.stream().filter(echelonDetailedEntity -> StringUtils.isNotEmpty((String)echelonDetailedEntity.getMasterUserid())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tudiList)) {
            for (EchelonDetailedEntity echelonDetailedEntity2 : tudiList) {
                this.computeAwardApprentice(echelonDetailedEntity2, echelonEntity, periodEntity);
            }
            List masterUserIdList = tudiList.stream().map(EchelonDetailedEntity::getMasterUserid).collect(Collectors.toList());
            HashSet set = new HashSet(masterUserIdList);
            if (CollectionUtils.isNotEmpty(masterUserIdList)) {
                for (String masterId : set) {
                    EchelonDetailedEntity masterQuery = new EchelonDetailedEntity();
                    masterQuery.setUserId(masterId);
                    masterQuery.setEchelonId(echelonEntity.getEchelonId());
                    EchelonDetailedEntity master = (EchelonDetailedEntity)this.echelonDetailedInterface.getSingle(masterQuery, 0L);
                    if (master == null) {
                        this.logger.error("\u5e08\u5085:{}\u67e5\u627e\u51fa\u9519", (Object)masterId);
                        continue;
                    }
                    EchelonMasterVo echelonMasterVo = new EchelonMasterVo();
                    BeanUtils.copyProperties((Object)master, (Object)echelonMasterVo);
                    List<EchelonDetailedVo> childrenList = detailResult.stream().filter(detailedVo -> Objects.equals(detailedVo.getMasterUserid(), masterId)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(childrenList)) {
                        echelonMasterVo.setEchelonDetailedVoList(childrenList);
                        this.computeAwardMaster(echelonMasterVo, periodEntity);
                        continue;
                    }
                    this.logger.error("\u4f01\u5fae:{} \u671f\u6b21:{} \u65e0\u5f92\u5f1f", (Object)master.getUserName(), (Object)master.getPeriodId());
                }
            }
        }
        return echelonAwardVo;
    }

    @Override
    public void computeAwardBySeason() {
    }

    @Override
    public PageInfo getGmv4Daily(Integer currentPage, Integer pageSize, String start, String end, String qyWeixinUserid) {
        Page pages = PageHelper.startPage((int)currentPage, (int)pageSize, (String)" CREATE_TIME desc,GMV desc");
        if (StringUtils.isEmpty((String)start)) {
            start = DateUtils.formatDate((Date)Date.from(LocalDate.now().minusDays(1L).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()), (String)"yyyy-MM-dd");
        }
        if (StringUtils.isEmpty((String)end)) {
            end = DateUtils.formatDate((Date)Date.from(LocalDate.now().atStartOfDay(ZoneOffset.ofHours(8)).toInstant()), (String)"yyyy-MM-dd");
        }
        if (StringUtils.isEmpty((String)qyWeixinUserid)) {
            qyWeixinUserid = null;
        }
        this.distributorMapper.getGmv4Daily(start, end, qyWeixinUserid);
        return pages.toPageInfo();
    }

    @Override
    public PageInfo getMonth(EchelonQueryVo echelonQueryVo) {
        Page pages = PageHelper.startPage((int)echelonQueryVo.getCurrentPage(), (int)echelonQueryVo.getPageSize(), (String)" CREATE_TIME desc,ECHELON_NAME,GMV desc");
        this.distributorMapper.getGmv4Month(echelonQueryVo.getStart(), echelonQueryVo.getEnd(), echelonQueryVo.getQyWeixinUserid());
        return pages.toPageInfo();
    }

    @Override
    public PageInfo getEchelonMonth(EchelonQueryVo echelonQueryVo) {
        return null;
    }

    private void computeAwardByMonth(EchelonDetailedEntity echelonDetailedEntity, EchelonEntity echelonEntity, EchelonPeriodEntity periodEntity) {
    }

    private EchelonDetailedVo computeAwardApprentice(EchelonDetailedEntity echelonDetailedEntity, EchelonEntity echelonEntity, EchelonPeriodEntity periodEntity) {
        EchelonDetailedVo echelonDetailedVo = new EchelonDetailedVo();
        BeanUtils.copyProperties((Object)echelonDetailedEntity, (Object)echelonDetailedEntity);
        if (StringUtils.isNotEmpty((String)echelonDetailedEntity.getMasterUserid())) {
            MallUserEntity mallUserEntity = this.userInterface.getMallUser(echelonDetailedEntity.getMasterUserid());
            echelonDetailedVo.setMasterNickName(mallUserEntity != null ? mallUserEntity.getUserNick() : "");
            if (this.computeAward(echelonDetailedEntity, echelonEntity, periodEntity)) {
                BigDecimal perCapitaValue = PriceUtils.divide((BigDecimal)echelonDetailedEntity.getGmv(), (BigDecimal)new BigDecimal(echelonDetailedEntity.getCustomerNum()));
                if (perCapitaValue.compareTo(echelonDetailedEntity.getLimitGmv()) < 0) {
                    this.logger.info("\u4f01\u5fae:{} \u671f\u6b21:{},\u4e1a\u7ee9:{},\u4f4e\u4e8e:{}", new Object[]{echelonDetailedEntity.getUserName(), echelonEntity.getPeriodName(), echelonDetailedEntity.getGmv(), echelonDetailedEntity.getLimitGmv()});
                    echelonDetailedVo.setCompleteStatus(CompleteStatusEnum.below_the_red_line.getValue());
                    echelonDetailedVo.setMasterCoefficient(new BigDecimal("0.85"));
                } else if (perCapitaValue.compareTo(echelonDetailedEntity.getTargetGmv()) >= 0) {
                    this.logger.info("\u4f01\u5fae:{} \u671f\u6b21:{},\u4e1a\u7ee9:{},\u5b8c\u6210\u76ee\u6807:{}", new Object[]{echelonDetailedEntity.getUserName(), echelonEntity.getPeriodName(), echelonDetailedEntity.getGmv(), echelonDetailedEntity.getLimitGmv()});
                    echelonDetailedVo.setCompleteStatus(CompleteStatusEnum.done.getValue());
                    BigDecimal bonusGmv = PriceUtils.divide((BigDecimal)echelonDetailedEntity.getGmv(), (BigDecimal)new BigDecimal(3));
                    echelonDetailedVo.setBonusGmv(bonusGmv);
                } else {
                    echelonDetailedVo.setCompleteStatus(CompleteStatusEnum.undone.getValue());
                    echelonDetailedVo.setMasterCoefficient(new BigDecimal("0.85"));
                }
            }
        }
        return echelonDetailedVo;
    }

    private void computeAwardMaster(EchelonMasterVo echelonMasterVo, EchelonPeriodEntity periodEntity) {
        for (EchelonDetailedVo echelonDetailedVo : echelonMasterVo.getEchelonDetailedVoList()) {
            EchelonLogEntity logEntity = new EchelonLogEntity();
            logEntity.setCreateTime(DateUtils.now());
            logEntity.setEchelonDetailedId(echelonMasterVo.getEchelonDetailedId());
            logEntity.setUserId(echelonMasterVo.getUserId());
            logEntity.setUserName(echelonMasterVo.getUserName());
            logEntity.setBeforeGmv(echelonMasterVo.getGmv());
            if (Objects.equals(echelonDetailedVo.getCompleteStatus(), CompleteStatusEnum.done.getValue())) {
                echelonMasterVo.setBonusGmv(echelonDetailedVo.getBonusGmv());
                logEntity.setRemark("\u5f92\u5f1f:" + echelonDetailedVo.getUserName() + "gmv\u8fbe\u6807 \u5956\u52b1 \u5f92\u5f1fgmv 1/3 " + echelonDetailedVo.getBonusGmv());
                this.logger.info("\u5e08\u5085:{} \u5e26\u5f92\u5f1f:{} \u5f92\u5f1fGMV:{}  \u8fbe\u6807\u540e\uff0c\u5956\u52b1gmv:{}", new Object[]{echelonMasterVo.getUserName(), echelonDetailedVo.getUserName(), echelonDetailedVo.getGmv(), echelonDetailedVo.getBonusGmv()});
            } else if (Objects.equals(echelonDetailedVo.getCompleteStatus(), CompleteStatusEnum.undone.getValue()) || Objects.equals(echelonDetailedVo.getCompleteStatus(), CompleteStatusEnum.below_the_red_line.getValue())) {
                this.logger.info("\u5e08\u5085:{} \u5e26\u5f92\u5f1f:{} \u5f92\u5f1fGMV:{},\u5f92\u5f1f\u4eba\u6570:{},\u5f92\u5f1f\u76ee\u6807:{}  \u672a\u5b8c\u6210\u76ee\u6807\uff0c\u7cfb\u6570:{}", new Object[]{echelonMasterVo.getUserName(), echelonDetailedVo.getUserName(), echelonDetailedVo.getGmv(), echelonDetailedVo.getCustomerNum(), echelonDetailedVo.getTargetGmv(), echelonDetailedVo.getMasterCoefficient()});
                echelonMasterVo.setPerformanceCoefficient(echelonDetailedVo.getMasterCoefficient() != null ? PriceUtils.multiply((BigDecimal)echelonDetailedVo.getMasterCoefficient(), (BigDecimal)echelonDetailedVo.getMasterCoefficient()) : echelonDetailedVo.getMasterCoefficient());
                this.logger.info("\u5e08\u5085:{}\u8c03\u6574\u540e\u7684\u5e26\u5f92\u5f1f\u7cfb\u6570:{}", (Object)echelonDetailedVo.getUserName(), (Object)echelonDetailedVo.getPerformanceCoefficient());
                logEntity.setRemark("\u5f92\u5f1f:" + echelonDetailedVo.getUserName() + " gmv\u672a\u8fbe\u6807 \u7cfb\u6570 \u8c03\u6574 " + echelonDetailedVo.getMasterCoefficient() + " \u8c03\u6574\u540e\u7cfb\u6570:" + echelonMasterVo.getPerformanceCoefficient());
            }
            this.echelonLogMapper.insertSelective(logEntity);
        }
        EchelonDetailedEntity update = new EchelonDetailedEntity();
        update.setEchelonDetailedId(echelonMasterVo.getEchelonDetailedId());
        update.setBonusGmv(echelonMasterVo.getBonusGmv());
        update.setPerformanceCoefficient(echelonMasterVo.getPerformanceCoefficient());
        this.echelonDetailedInterface.updateByPrimaryKeySelective(update);
        EchelonLogEntity logEntity = new EchelonLogEntity();
        logEntity.setCreateTime(DateUtils.now());
        logEntity.setEchelonDetailedId(echelonMasterVo.getEchelonDetailedId());
        logEntity.setUserId(echelonMasterVo.getUserId());
        logEntity.setUserName(echelonMasterVo.getUserName());
        logEntity.setBeforeGmv(echelonMasterVo.getGmv());
        logEntity.setAfterGmv(echelonMasterVo.getGmv());
        logEntity.setRemark("\u66f4\u65b0\u5e08\u5085" + echelonMasterVo.getUserName() + "gmv\u5956\u52b1:" + echelonMasterVo.getBonusGmv() + " \u66f4\u65b0\u7cfb\u6570: " + echelonMasterVo.getMasterCoefficient());
        this.echelonLogMapper.insertSelective(logEntity);
    }

    private boolean computeAward(EchelonDetailedEntity echelonDetailedEntity, EchelonEntity echelonEntity, EchelonPeriodEntity periodEntity) {
        Map<String, Object> map;
        if (Objects.equals(echelonDetailedEntity.getStatus(), 0) && (map = this.distributorMapper.getGmv(echelonDetailedEntity.getQyWeixinUserid(), periodEntity.getPeriodStart(), periodEntity.getPeriodEnd())) != null) {
            echelonDetailedEntity.setGmv(new BigDecimal(map.get("GMV").toString()));
            echelonDetailedEntity.setImportGmvTime(DateUtils.now());
            echelonDetailedEntity.setStatus(1);
            echelonDetailedEntity.setPerformanceCoefficient(BigDecimal.ONE);
            this.echelonDetailedInterface.updateByPrimaryKeySelective(echelonDetailedEntity);
            this.logger.info("\u4f01\u5fae:{} \u671f\u6b21:{},GMV\u5df2\u7ed3\u7b97", (Object)echelonDetailedEntity.getUserName(), (Object)periodEntity.getPeriodId());
            return true;
        }
        return false;
    }

    private void computeTeamAward(EchelonAwardVo echelonAwardVo) {
        for (EchelonDetailedVo echelonDetailedVo : echelonAwardVo.getEchelonDetailedVoList()) {
            echelonAwardVo.setGmv(PriceUtils.add((BigDecimal)echelonAwardVo.getGmv(), (BigDecimal)echelonDetailedVo.getGmv()));
        }
    }
}

