/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.echelon;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.scrm.dao.echelon.EchelonDetailedMapper;
import cc.lechun.scrm.dao.echelon.EchelonMapper;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.echelon.EchelonDetailedEntity;
import cc.lechun.scrm.entity.echelon.EchelonEntity;
import cc.lechun.scrm.entity.echelon.EchelonRoleEnum;
import cc.lechun.scrm.entity.echelon.EchelonRoleVo;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import cc.lechun.scrm.iservice.echelon.EchelonDetailedInterface;
import cc.lechun.scrm.iservice.echelon.EchelonPeriodInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EchelonDetailedService
extends BaseService<EchelonDetailedEntity, Integer>
implements EchelonDetailedInterface {
    @Resource
    private EchelonDetailedMapper echelonDetailedMapper;
    @Resource
    private EchelonMapper echelonMapper;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    EchelonPeriodInterface echelonPeriodInterface;
    @Lazy
    @Autowired
    CalendarInterface calendarInterface;

    @Override
    public BaseJsonVo initEchelonDetailed(Integer echelonId, String qyWeixinUserid, Integer roleType, String masterUserid) {
        EchelonEntity echelonEntity = (EchelonEntity)this.echelonMapper.selectByPrimaryKey(echelonId);
        EchelonDetailedEntity query = new EchelonDetailedEntity();
        query.setEchelonId(echelonId);
        query.setQyWeixinUserid(qyWeixinUserid);
        echelonEntity.setPeriodId(echelonEntity.getPeriodId());
        EchelonDetailedEntity echelonDetailedEntity = (EchelonDetailedEntity)this.echelonDetailedMapper.getSingle(query);
        if (echelonDetailedEntity == null) {
            echelonDetailedEntity = new EchelonDetailedEntity();
            echelonDetailedEntity.setQyWeixinUserid(qyWeixinUserid);
            echelonDetailedEntity.setEchelonId(echelonId);
            if (StringUtils.isNotEmpty((String)masterUserid)) {
                echelonDetailedEntity.setMasterUserid(masterUserid);
            }
            MallUserEntity queryUser = new MallUserEntity();
            queryUser.setQyWeixinUserid(qyWeixinUserid);
            MallUserEntity userEntity = this.userInterface.getSingle(queryUser);
            if (userEntity != null) {
                echelonDetailedEntity.setPeriodType(echelonEntity.getPeriodType());
                echelonDetailedEntity.setUserName(userEntity.getUserNick());
                echelonDetailedEntity.setUserId(userEntity.getUserId());
            }
            echelonDetailedEntity.setRoleType(roleType);
            echelonDetailedEntity.setStatus(0);
            echelonDetailedEntity.setCreateTime(DateUtils.now());
            this.echelonDetailedMapper.insertSelective(echelonDetailedEntity);
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo setMaster(Integer echelonDetailedId, String masterQyWeixinUserid) {
        EchelonDetailedEntity echelonDetailedEntity = (EchelonDetailedEntity)this.selectByPrimaryKey(echelonDetailedId);
        String userId = null;
        if (StringUtils.isNotEmpty((String)masterQyWeixinUserid)) {
            MallUserEntity queryUser = new MallUserEntity();
            queryUser.setQyWeixinUserid(masterQyWeixinUserid);
            MallUserEntity userEntity = this.userInterface.getSingle(queryUser);
            if (userEntity == null) {
                return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5e08\u5085,\u8bf7\u68c0\u67e5");
            }
            if (Objects.equals(echelonDetailedEntity.getUserId(), userEntity.getUserId())) {
                return BaseJsonVo.error((String)"\u5e08\u5085\u548c\u5f92\u5f1f\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a,\u8bf7\u68c0\u67e5");
            }
            echelonDetailedEntity.setMasterUserid(userEntity.getUserId());
            userId = userEntity.getUserId();
        } else {
            userId = masterQyWeixinUserid;
        }
        EchelonDetailedEntity update = new EchelonDetailedEntity();
        update.setMasterUserid(userId);
        update.setEchelonDetailedId(echelonDetailedId);
        return this.echelonDetailedMapper.updateByPrimaryKeySelective(update) > 0 ? BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public BaseJsonVo saveEchelonDetailed(EchelonDetailedEntity echelonDetailedEntity) {
        EchelonDetailedEntity queryDetail = new EchelonDetailedEntity();
        queryDetail.setEchelonId(echelonDetailedEntity.getEchelonId());
        queryDetail.setQyWeixinUserid(echelonDetailedEntity.getQyWeixinUserid());
        EchelonDetailedEntity result = (EchelonDetailedEntity)this.echelonDetailedMapper.getSingle(queryDetail);
        if (result == null) {
            if (echelonDetailedEntity.getEchelonDetailedId() == null) {
                echelonDetailedEntity.setCreateTime(DateUtils.now());
                EchelonEntity echelonEntity = (EchelonEntity)this.echelonMapper.selectByPrimaryKey(echelonDetailedEntity.getEchelonId());
                echelonDetailedEntity.setPeriodId(echelonEntity.getPeriodId());
                MallUserEntity query = new MallUserEntity();
                query.setQyWeixinUserid(echelonDetailedEntity.getQyWeixinUserid());
                MallUserEntity mallUserEntity = this.userInterface.getSingle(query);
                echelonDetailedEntity.setUserId(mallUserEntity.getUserId());
                echelonDetailedEntity.setPeriodType(echelonEntity.getPeriodType());
                echelonDetailedEntity.setStatus(0);
                echelonDetailedEntity.setUserName(mallUserEntity.getUserNick());
                this.echelonDetailedMapper.insertSelective(echelonDetailedEntity);
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            this.echelonDetailedMapper.updateByPrimaryKeySelective(echelonDetailedEntity);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo getEchelonMemberList(Integer echelonId) {
        BaseJsonVo baseJsonVo = this.calendarInterface.getValidQwUser(AppEnum.SCRM.getValue());
        EchelonDetailedEntity query = new EchelonDetailedEntity();
        query.setEchelonId(echelonId);
        List detailedEntityList = this.getList(query, 0L);
        ArrayList<EchelonRoleVo> echelonRoleVoList = new ArrayList<EchelonRoleVo>();
        boolean hasMaster = false;
        if (CollectionUtils.isNotEmpty((Collection)detailedEntityList)) {
            hasMaster = detailedEntityList.stream().allMatch(d -> Objects.equals(d.getRoleType(), 1));
        }
        for (Map map : (List)baseJsonVo.getValue()) {
            EchelonRoleVo echelonRoleVo = new EchelonRoleVo();
            echelonRoleVo.setCanSetTeamMember(true);
            echelonRoleVo.setQyWeixinUserid((String)map.get("id"));
            echelonRoleVo.setCanSetLeader(!hasMaster);
            echelonRoleVo.setCanSetTeamMember(true);
            echelonRoleVo.setEchelonId(echelonId);
            echelonRoleVo.setName((String)map.get("name"));
            echelonRoleVo.setRoleTypeName("-");
            echelonRoleVo.setMasterName("-");
            for (EchelonDetailedEntity item : detailedEntityList) {
                if (!Objects.equals(item.getQyWeixinUserid(), map.get("id"))) continue;
                echelonRoleVo.setRoleType(item.getRoleType());
                echelonRoleVo.setRoleTypeName(EchelonRoleEnum.getName(item.getRoleType()));
                echelonRoleVo.setCanSetTeamMember(false);
                echelonRoleVo.setCanSetLeader(false);
                echelonRoleVo.setEchelonDetailedId(item.getEchelonDetailedId());
                if (!StringUtils.isNotEmpty((String)item.getMasterUserid())) continue;
                MallUserEntity userEntity = this.userInterface.getMallUser(item.getMasterUserid());
                echelonRoleVo.setMasterName(userEntity.getUserNick());
                echelonRoleVo.setMasterQyWeixinUserid(userEntity.getQyWeixinUserid());
            }
            echelonRoleVoList.add(echelonRoleVo);
        }
        return BaseJsonVo.success(echelonRoleVoList);
    }
}

