/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.echelon;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.echelon.EchelonPeriodMapper;
import cc.lechun.scrm.entity.echelon.EchelonPeriodEntity;
import cc.lechun.scrm.iservice.echelon.EchelonPeriodInterface;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EchelonPeriodService
extends BaseService<EchelonPeriodEntity, Integer>
implements EchelonPeriodInterface {
    @Resource
    private EchelonPeriodMapper echelonPeriodMapper;

    public BaseJsonVo initMonthPeriod() {
        Calendar calendar = Calendar.getInstance();
        int whatDayTodayIs = calendar.get(5);
        if (whatDayTodayIs < 28) {
            this.logger.info("\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u6708\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u6708\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)10);
        calendar.setTime(date);
        EchelonPeriodEntity entity = new EchelonPeriodEntity();
        entity.setPeriodType(1);
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(calendar.get(2) + 1);
        List list = this.echelonPeriodMapper.getList(entity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return BaseJsonVo.success(list.get(0));
        }
        calendar.set(5, 1);
        Date periodStart = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date periodEnd = calendar.getTime();
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        entity.setPeriodDesc("" + calendar.get(1) + "\u5e74" + entity.getHeadPeriod() + "\u6708(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        this.echelonPeriodMapper.insert(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public void initSeasonPeriod(Integer year, Integer month, boolean first) {
        EchelonPeriodEntity query = new EchelonPeriodEntity();
        query.setHeadYear(year);
        query.setInQuarter(year + "Q" + (month % 3 == 0 ? month / 3 : month / 3 + 1));
        query.setPeriodType(2);
        EchelonPeriodEntity echelonPeriodEntity = (EchelonPeriodEntity)this.echelonPeriodMapper.getSingle(query);
        if (echelonPeriodEntity == null) {
            echelonPeriodEntity = new EchelonPeriodEntity();
            BeanUtils.copyProperties((Object)query, (Object)echelonPeriodEntity);
            if (!first) {
                EchelonPeriodEntity last = this.getLastTimeEchelonPeriod(year, month, 2);
                echelonPeriodEntity.setHeadPeriod(last.getPeriodId());
            } else {
                echelonPeriodEntity.setHeadPeriod(0);
            }
            echelonPeriodEntity.setInQuarter(year + "Q" + (month % 3 == 0 ? month / 3 : month / 3 + 1));
            echelonPeriodEntity.setPeriodDesc(echelonPeriodEntity.getInQuarter());
            echelonPeriodEntity.setPeriodStart(Date.from(LocalDate.of((int)year, month, 1).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()));
            echelonPeriodEntity.setPeriodEnd(Date.from(LocalDate.of((int)year, month, 1).plusMonths(4L).plusDays(-1L).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()));
            this.echelonPeriodMapper.insertSelective(echelonPeriodEntity);
        }
    }

    private EchelonPeriodEntity getLastTimeEchelonPeriod(Integer year, Integer month, Integer type) {
        LocalDate localDate = LocalDate.of((int)year, month, 1).plusDays(-1L);
        return this.echelonPeriodMapper.getLast(this.getDate(localDate), localDate.getYear(), type);
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    private Date getDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
    }

    @Override
    public void intiMonthPeriod(Integer year, Integer month, boolean first) {
        EchelonPeriodEntity query = new EchelonPeriodEntity();
        query.setHeadYear(year);
        query.setInMonth(year + "-" + (month >= 10 ? month : "0" + month));
        query.setPeriodType(1);
        EchelonPeriodEntity echelonPeriodEntity = (EchelonPeriodEntity)this.echelonPeriodMapper.getSingle(query);
        if (echelonPeriodEntity == null) {
            echelonPeriodEntity = new EchelonPeriodEntity();
            BeanUtils.copyProperties((Object)query, (Object)echelonPeriodEntity);
            if (!first) {
                EchelonPeriodEntity last = this.getLastTimeEchelonPeriod(year, month, 1);
                echelonPeriodEntity.setHeadPeriod(last.getPeriodId());
            } else {
                echelonPeriodEntity.setHeadPeriod(0);
            }
            echelonPeriodEntity.setPeriodDesc(year + "-" + (month >= 10 ? month : "0" + month));
            echelonPeriodEntity.setPeriodStart(Date.from(LocalDate.of((int)year, month, 1).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()));
            echelonPeriodEntity.setPeriodEnd(Date.from(LocalDate.of((int)year, month, 1).plusMonths(1L).plusDays(-1L).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()));
            this.echelonPeriodMapper.insertSelective(echelonPeriodEntity);
        }
    }

    @Override
    public void initPeriod() {
        EchelonPeriodEntity query = new EchelonPeriodEntity();
        query.setPeriodType(1);
        LocalDate date = LocalDate.now();
        LocalDate firstDay = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = firstDay.atStartOfDay().atZone(zone).toInstant();
        query.setPeriodStart(Date.from(instant));
        Instant instantLast = lastDay.atStartOfDay().atZone(zone).toInstant();
        query.setPeriodStart(Date.from(instantLast));
        query.setPeriodStart(Date.from(instant));
        EchelonPeriodEntity result = (EchelonPeriodEntity)this.echelonPeriodMapper.getSingle(query);
        if (result == null) {
            result = new EchelonPeriodEntity();
            result.setPeriodStart(query.getPeriodStart());
            result.setPeriodType(1);
            result.setHeadYear(date.getYear());
            result.setInQuarter(date.getYear() + "\u5e74Q" + ((date.getMonthValue() - 1) / 3 + 1));
            result.setPeriodDesc(date.getYear() + "\u5e74" + date.getMonthValue() + "\u6708");
            result.setPeriodEnd(Date.from(instantLast));
            result.setPeriodStart(Date.from(instant));
            EchelonPeriodEntity lastEchelonPeriodEntity = this.getLastTimePeriod();
            result.setHeadPeriod(lastEchelonPeriodEntity == null ? null : lastEchelonPeriodEntity.getPeriodId());
            result.setInMonth(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM"));
            this.echelonPeriodMapper.insertSelective(result);
        }
    }

    public EchelonPeriodEntity getLastTimePeriod() {
        EchelonPeriodEntity query = new EchelonPeriodEntity();
        query.setPeriodType(1);
        LocalDate date = LocalDate.now();
        LocalDate lastMonth = date.minusMonths(1L);
        LocalDate firstDay = lastMonth.with(TemporalAdjusters.firstDayOfMonth());
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = firstDay.atStartOfDay().atZone(zone).toInstant();
        query.setPeriodStart(Date.from(instant));
        return (EchelonPeriodEntity)this.echelonPeriodMapper.getSingle(query);
    }
}

