/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.echelon;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.echelon.EchelonMapper;
import cc.lechun.scrm.dao.echelon.EchelonPeriodMapper;
import cc.lechun.scrm.entity.echelon.EchelonEntity;
import cc.lechun.scrm.entity.echelon.EchelonPeriodEntity;
import cc.lechun.scrm.entity.echelon.EchelonQueryVo;
import cc.lechun.scrm.iservice.echelon.EchelonInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EchelonService
extends BaseService<EchelonEntity, Integer>
implements EchelonInterface {
    @Resource
    private EchelonMapper echelonMapper;
    @Resource
    private EchelonPeriodMapper echelonPeriodMapper;

    @Override
    public boolean checkLast(Integer echelonId) {
        EchelonEntity echelonEntity = (EchelonEntity)this.echelonMapper.selectByPrimaryKey(echelonId);
        if (Objects.equals(echelonEntity.getStatus(), 0)) {
            this.logger.error("\u68af\u961f:{}\u672a\u7ed3\u7b97", (Object)echelonEntity.getPeriodName());
            throw new RuntimeException("\u68af\u961f:" + echelonEntity.getPeriodName() + "\u672a\u7ed3\u7b97");
        }
        Integer lastSort = this.echelonMapper.getLastSort(echelonEntity.getPeriodId());
        return Objects.equals(echelonEntity.getSort(), lastSort);
    }

    @Override
    public void initMonthEchelon(Integer echelonId, Integer type, Integer periodId) {
        EchelonEntity parent = (EchelonEntity)this.selectByPrimaryKey(echelonId);
        EchelonEntity query = new EchelonEntity();
        query.setPeriodId(periodId);
        query.setPeriodType(type);
        query.setParentEchelonId(parent.getParentEchelonId());
        EchelonEntity echelonEntity = (EchelonEntity)this.echelonMapper.getSingle(query);
        if (echelonEntity == null) {
            EchelonPeriodEntity echelonPeriodEntity = (EchelonPeriodEntity)this.echelonPeriodMapper.selectByPrimaryKey(periodId);
            echelonEntity = new EchelonEntity();
            BeanUtils.copyProperties((Object)query, (Object)echelonEntity);
            echelonEntity.setCreateTime(DateUtils.now());
            echelonEntity.setPeriodName(echelonPeriodEntity.getPeriodDesc());
            echelonEntity.setStatus(0);
            this.echelonMapper.insertSelective(echelonEntity);
        }
    }

    @Override
    public void initEchelon(EchelonPeriodEntity echelonPeriodEntity, String echelonName) {
        EchelonEntity query = new EchelonEntity();
        if (Objects.equals(echelonPeriodEntity.getPeriodType(), 1)) {
            query.setEchelonName(echelonPeriodEntity.getInMonth() + echelonName);
        }
        if (Objects.equals(echelonPeriodEntity.getPeriodType(), 2)) {
            query.setEchelonName(echelonPeriodEntity.getInQuarter() + echelonName);
        }
        query.setPeriodId(echelonPeriodEntity.getPeriodId());
        query.setPeriodType(echelonPeriodEntity.getPeriodType());
        EchelonEntity echelonEntity = (EchelonEntity)this.echelonMapper.getSingle(query);
        if (echelonEntity == null) {
            echelonEntity = new EchelonEntity();
            BeanUtils.copyProperties((Object)query, (Object)echelonEntity);
            echelonEntity.setCreateTime(DateUtils.now());
            if (Objects.equals(echelonPeriodEntity.getPeriodType(), 1)) {
                echelonEntity.setPeriodName(echelonPeriodEntity.getInMonth() + echelonName);
            }
            if (Objects.equals(echelonPeriodEntity.getPeriodType(), 2)) {
                echelonEntity.setPeriodName(echelonPeriodEntity.getInQuarter() + echelonName);
            }
            echelonEntity.setStatus(0);
            this.echelonMapper.insertSelective(echelonEntity);
        }
    }

    @Override
    public void initEchelon(EchelonPeriodEntity echelonPeriodEntity) {
        String[] nameArr;
        for (String item : nameArr = new String[]{"\u7b2c\u4e00\u68af\u961f", "\u7b2c\u4e8c\u68af\u961f", "\u7b2c\u4e09\u68af\u961f"}) {
            this.initEchelon(echelonPeriodEntity, item);
        }
    }

    @Override
    public void initEchelon(Integer periodId) {
        EchelonPeriodEntity echelonPeriodEntity = (EchelonPeriodEntity)this.echelonPeriodMapper.selectByPrimaryKey(periodId);
        this.initEchelon(echelonPeriodEntity);
    }

    @Override
    public void initEchelon() {
        EchelonPeriodEntity echelonPeriodEntity = this.echelonPeriodMapper.getLastEchelonPeriod(1);
        this.initEchelon(echelonPeriodEntity);
    }

    @Override
    public PageInfo<EchelonEntity> getDataList(EchelonQueryVo echelonQueryVo) {
        Page page = PageHelper.startPage((int)echelonQueryVo.getCurrentPage(), (int)echelonQueryVo.getPageSize(), (String)" CREATE_TIME DESC ");
        EchelonEntity query = new EchelonEntity();
        BeanUtils.copyProperties((Object)echelonQueryVo, (Object)query);
        this.echelonMapper.getList(query);
        return page.toPageInfo();
    }
}

