/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.event;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.event.EventGroupMapper;
import cc.lechun.scrm.entity.event.EventGroupEntity;
import cc.lechun.scrm.entity.event.EventGroupQueryVo;
import cc.lechun.scrm.iservice.event.EventGroupInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EventGroupService
extends BaseService<EventGroupEntity, Integer>
implements EventGroupInterface {
    @Resource
    private EventGroupMapper eventGroupMapper;

    @Override
    public PageInfo<EventGroupEntity> getEventGroupList(EventGroupQueryVo eventGroupQueryVo) {
        Page page = PageHelper.startPage((int)eventGroupQueryVo.getCurrentPage(), (int)eventGroupQueryVo.getPageSize());
        page.setOrderBy(" SORT ");
        EventGroupEntity eventGroupEntity = new EventGroupEntity();
        BeanUtils.copyProperties((Object)eventGroupQueryVo, (Object)eventGroupEntity);
        if (StringUtils.isEmpty((String)eventGroupQueryVo.getEventGroupName())) {
            eventGroupEntity.setEventGroupName(null);
        } else {
            eventGroupEntity.setEventGroupName(SqlUtils.sqlLike((String)eventGroupQueryVo.getEventGroupName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)eventGroupQueryVo.getEventGroupRemark())) {
            eventGroupEntity.setEventGroupRemark(null);
        } else {
            eventGroupEntity.setEventGroupRemark(SqlUtils.sqlLike((String)eventGroupQueryVo.getEventGroupRemark(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.eventGroupMapper.getList(eventGroupEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveEventGroup(EventGroupEntity eventGroupEntity) {
        if (eventGroupEntity.getEventGroupId() == null) {
            EventGroupEntity query = new EventGroupEntity();
            query.setEventGroupName(eventGroupEntity.getEventGroupName());
            List tempList = this.getList(query, 0L);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                return BaseJsonVo.error((String)"\u4e8b\u4ef6\u7ec4\u91cd\u540d");
            }
            eventGroupEntity.setCreateTime(DateUtils.now());
            this.eventGroupMapper.insert(eventGroupEntity);
        } else {
            EventGroupEntity oldEventGroup = (EventGroupEntity)this.selectByPrimaryKey(eventGroupEntity.getEventGroupId());
            if (!Objects.equals(oldEventGroup.getEventGroupName(), eventGroupEntity.getEventGroupName())) {
                EventGroupEntity query = new EventGroupEntity();
                query.setEventGroupName(eventGroupEntity.getEventGroupName());
                List tempList = this.getList(query, 0L);
                if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                    return BaseJsonVo.error((String)"\u4e8b\u4ef6\u7ec4\u91cd\u540d");
                }
            }
            this.eventGroupMapper.updateByPrimaryKeySelective(eventGroupEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

