/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.event;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.event.EventGroupMapper;
import cc.lechun.scrm.dao.event.EventMapper;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.event.EventGroupEntity;
import cc.lechun.scrm.entity.event.EventItemVo;
import cc.lechun.scrm.entity.event.EventQuery;
import cc.lechun.scrm.entity.event.EventTypeEnum;
import cc.lechun.scrm.entity.event.EventVo;
import cc.lechun.scrm.iservice.event.EventInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EventService
extends BaseService<EventEntity, Integer>
implements EventInterface {
    @Resource
    private EventMapper eventMapper;
    @Resource
    private EventGroupMapper eventGroupMapper;

    @Override
    public BaseJsonVo getEventList(EventEntity eventEntity) {
        List<Object> result = new ArrayList();
        if (StringUtils.isNotEmpty((String)eventEntity.getEventName())) {
            eventEntity.setEventName(SqlUtils.sqlLike((String)eventEntity.getEventName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        List list = this.getList(eventEntity, 0L);
        List eventGroupEntityList = this.eventGroupMapper.getList(new EventGroupEntity());
        if (CollectionUtils.isNotEmpty((Collection)eventGroupEntityList)) {
            result = eventGroupEntityList.stream().map(eventGroupEntity -> {
                EventVo eventVo = new EventVo();
                eventVo.setEventGroupName(eventGroupEntity.getEventGroupName());
                eventVo.setEventGroupId(eventGroupEntity.getEventGroupId());
                ArrayList<EventItemVo> itemList = new ArrayList();
                itemList = list.stream().filter(e -> Objects.equals(e.getEventGroupId(), eventGroupEntity.getEventGroupId())).map(item -> {
                    EventItemVo eventItemVo = new EventItemVo();
                    BeanUtils.copyProperties((Object)item, (Object)eventItemVo);
                    eventItemVo.setEventGroupName(eventGroupEntity != null ? eventGroupEntity.getEventGroupName() : "");
                    eventItemVo.setEventTypeName(EventTypeEnum.getName(item.getEventType()));
                    return eventItemVo;
                }).collect(Collectors.toList());
                eventVo.setEventItemVoList(itemList);
                return eventVo;
            }).collect(Collectors.toList());
        }
        return BaseJsonVo.success(result);
    }

    @Override
    public PageInfo getEventList(EventQuery eventQuery) {
        Page page = PageHelper.startPage((int)eventQuery.getCurrentPage(), (int)eventQuery.getPageSize(), (String)" SORT ");
        EventEntity eventEntity = new EventEntity();
        if (StringUtils.isEmpty((String)eventQuery.getEventName())) {
            eventQuery.setEventName(null);
        } else {
            eventQuery.setEventName(SqlUtils.sqlLike((String)eventQuery.getEventName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)eventQuery.getEventRemark())) {
            eventQuery.setEventRemark(null);
        } else {
            eventQuery.setEventRemark(SqlUtils.sqlLike((String)eventQuery.getEventRemark(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        BeanUtils.copyProperties((Object)eventQuery, (Object)eventEntity);
        List list = this.eventMapper.getList(eventEntity);
        List groupList = this.eventGroupMapper.getList(new EventGroupEntity());
        List<Object> eventItemVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            eventItemVoList = list.stream().map(item -> {
                EventItemVo eventItemVo = new EventItemVo();
                BeanUtils.copyProperties((Object)item, (Object)eventItemVo);
                Optional<EventGroupEntity> eventGroupEntityOptional = groupList.stream().filter(d -> Objects.equals(d.getEventGroupId(), item.getEventGroupId())).findAny();
                if (eventGroupEntityOptional.isPresent()) {
                    eventItemVo.setEventGroupName(eventGroupEntityOptional.get().getEventGroupName());
                }
                eventItemVo.setEventTypeName(EventTypeEnum.getName(item.getEventType()));
                return eventItemVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(eventItemVoList);
        return pg;
    }

    @Override
    public BaseJsonVo getEventDetail(Integer eventId) {
        return null;
    }

    @Override
    public BaseJsonVo saveEvent(EventEntity eventEntity) {
        if (eventEntity.getEventId() == null || eventEntity.getEventId() == 0) {
            eventEntity.setEventId(null);
            eventEntity.setCreateTime(DateUtils.now());
            EventEntity query = new EventEntity();
            query.setEventName(eventEntity.getEventName());
            query.setAppId(eventEntity.getAppId());
            List tempList = this.getList(query, 0L);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                return BaseJsonVo.error((String)"\u4e8b\u4ef6\u91cd\u540d");
            }
            eventEntity.setStatus(1);
            this.eventMapper.insert(eventEntity);
        } else {
            EventEntity oldEventGroup = (EventEntity)this.selectByPrimaryKey(eventEntity.getEventId());
            if (!Objects.equals(oldEventGroup.getEventName(), eventEntity.getEventName())) {
                EventEntity query = new EventEntity();
                query.setEventName(eventEntity.getEventName());
                query.setAppId(eventEntity.getAppId());
                List tempList = this.getList(query, 0L);
                if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                    return BaseJsonVo.error((String)"\u4e8b\u4ef6\u91cd\u540d");
                }
            }
            this.eventMapper.updateByPrimaryKeySelective(eventEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo changeEventStatus(EventEntity eventEntity) {
        EventEntity update = new EventEntity();
        update.setStatus(eventEntity.getStatus());
        update.setEventId(eventEntity.getEventId());
        return this.eventMapper.updateByPrimaryKeySelective(update) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

