/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.group;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.group.SceneRouteGroupRefMapper;
import cc.lechun.scrm.entity.group.SceneRouteGroupEntity;
import cc.lechun.scrm.entity.group.SceneRouteGroupRefEntity;
import cc.lechun.scrm.iservice.group.SceneRouteGroupInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneRouteGroupRefService
extends BaseService<SceneRouteGroupRefEntity, Integer>
implements SceneRouteGroupRefInterface {
    @Resource
    private SceneRouteGroupRefMapper sceneRouteGroupRefMapper;
    @Autowired
    private SceneRouteGroupInterface sceneRouteGroupInterface;

    @Override
    public BaseJsonVo saveGroupRef(SceneRouteGroupRefEntity groupRefEntity) {
        if (groupRefEntity.getGroupId() == null) {
            return BaseJsonVo.error((String)"\u7ec4\u4e3a\u7a7a");
        }
        if (groupRefEntity.getSceneRouteId() == null) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4/\u65c5\u7a0b/\u7d20\u6750\u4e3a\u7a7a");
        }
        if (groupRefEntity.getSceneRoute() == null) {
            return BaseJsonVo.error((String)"\u7ec4\u7c7b\u522b\u4e3a\u7a7a");
        }
        if (groupRefEntity.getCreateTime() == null) {
            groupRefEntity.setCreateTime(new Date());
        }
        SceneRouteGroupRefEntity search = new SceneRouteGroupRefEntity();
        search.setGroupId(groupRefEntity.getGroupId());
        search.setSceneRoute(groupRefEntity.getSceneRoute());
        search.setSceneRouteId(groupRefEntity.getSceneRouteId());
        search = (SceneRouteGroupRefEntity)this.getSingle(search);
        if (search != null) {
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u52a0\u5165\u7ec4");
        }
        this.insertSelective(groupRefEntity);
        return BaseJsonVo.success((Object)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public BaseJsonVo removeGroup(Integer groupId, Integer sceneRouteId, Integer sceneRoute, String userId) {
        SceneRouteGroupRefEntity search = new SceneRouteGroupRefEntity();
        search.setGroupId(groupId);
        search.setSceneRoute(sceneRoute);
        search.setSceneRouteId(sceneRouteId);
        List lst = this.getList(search);
        for (SceneRouteGroupRefEntity r : lst) {
            SceneRouteGroupEntity groupEntity = (SceneRouteGroupEntity)this.sceneRouteGroupInterface.selectByPrimaryKey(r.getGroupId());
            if (Integer.valueOf(2).equals(groupEntity.getType()) && !userId.equals(groupEntity.getCreateUserId())) continue;
            this.deleteByPrimaryKey(r.getId());
        }
        return BaseJsonVo.success((Object)"\u79fb\u9664\u6210\u529f");
    }

    @Override
    public String getRouteRef(Integer sceneRouteId, Integer sceneRoute) {
        SceneRouteGroupRefEntity search = new SceneRouteGroupRefEntity();
        search.setSceneRoute(sceneRoute);
        search.setSceneRouteId(sceneRouteId);
        List lst = this.getList(search);
        Object[] groups = lst.stream().map(c -> c.getGroupId()).toArray();
        String result = "";
        for (Object o : groups) {
            result = o.toString() + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

