/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.group;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.group.SceneRouteGroupMapper;
import cc.lechun.scrm.entity.group.SceneRouteGroupEntity;
import cc.lechun.scrm.entity.group.SceneRouteGroupRefEntity;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.iservice.group.SceneRouteGroupInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneRouteGroupService
extends BaseService<SceneRouteGroupEntity, Integer>
implements SceneRouteGroupInterface {
    @Resource
    private SceneRouteGroupMapper sceneRouteGroupMapper;
    @Autowired
    private SceneRouteGroupRefInterface sceneRouteGroupRefInterface;
    @Autowired
    private MaterialInterface materialInterface;

    @Override
    public BaseJsonVo saveGroup(SceneRouteGroupEntity groupEntity) {
        if (StringUtils.isEmpty((String)groupEntity.getGroupName())) {
            return BaseJsonVo.error((String)"\u7ec4\u540d\u4e3a\u7a7a");
        }
        if (groupEntity.getSceneRoute() == null) {
            return BaseJsonVo.error((String)"\u521b\u5efa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SceneRouteGroupEntity search = new SceneRouteGroupEntity();
        search.setGroupName(groupEntity.getGroupName());
        search.setSceneRoute(groupEntity.getSceneRoute());
        search = (SceneRouteGroupEntity)this.getSingle(search);
        if (search != null && !search.getId().equals(groupEntity.getId())) {
            return BaseJsonVo.error((String)"\u7ec4\u540d\u91cd\u590d\uff0c\u8bf7\u66f4\u6362");
        }
        if (groupEntity.getIsTransfer() == null) {
            groupEntity.setIsTransfer(0);
        }
        if (groupEntity.getIsWorkTransfer() == null) {
            groupEntity.setIsWorkTransfer(1);
        }
        if (groupEntity.getId() == null || groupEntity.getId() == 0) {
            groupEntity.setCreateTime(new Date());
        }
        this.insertOrUpdate(groupEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public PageInfo getGroupPageList(Integer currentPage, Integer pageSize, SceneRouteGroupEntity routeGroupEntity) {
        Page pages = PageHelper.startPage((int)currentPage, (int)pageSize, (String)"seq,group_name");
        this.sceneRouteGroupMapper.getGroupPageList(routeGroupEntity);
        PageInfo lst = pages.toPageInfo();
        this.logger.info("\u67e5\u8be2\u76ee\u5f55:{}", (Object)lst.toString());
        for (SceneRouteGroupEntity g : lst.getList()) {
            SceneRouteGroupRefEntity refEntity = new SceneRouteGroupRefEntity();
            refEntity.setGroupId(g.getId());
            refEntity.setSceneRoute(routeGroupEntity.getSceneRoute());
            int i = 0;
            if (Integer.valueOf(3).equals(routeGroupEntity.getSceneRoute())) {
                MaterialEntity m = new MaterialEntity();
                m.setGroupId(g.getId());
                i = this.materialInterface.existsByEntity(m);
            } else {
                i = this.sceneRouteGroupRefInterface.existsByEntity(refEntity);
            }
            g.setQuantity(i);
        }
        return lst;
    }

    @Override
    public BaseJsonVo saveGroupSort(List<SceneRouteGroupEntity> lst) {
        for (SceneRouteGroupEntity g : lst) {
            SceneRouteGroupEntity group = new SceneRouteGroupEntity();
            group.setId(g.getId());
            group.setSeq(g.getSeq());
            this.updateByPrimaryKeySelective(group);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

