/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.iservice.material.MaterialProcessInterface;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MaterialContext {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, MaterialProcessInterface> concurrentHashMap = new ConcurrentHashMap<String, MaterialProcessInterface>();

    @Autowired
    public MaterialContext(Map<String, MaterialProcessInterface> interfaceMap) {
        this.concurrentHashMap.clear();
        interfaceMap.forEach((k, v) -> this.concurrentHashMap.put((String)k, (MaterialProcessInterface)v));
    }

    @Transactional
    public boolean save(MaterialEntity materialEntity, Map map) {
        boolean result = false;
        MaterialProcessInterface materialProcessInterface = this.concurrentHashMap.get("scrm_material_" + materialEntity.getMaterialType());
        if (materialProcessInterface != null) {
            result = materialProcessInterface.save(materialEntity, map);
        }
        return result;
    }

    public boolean delete(Integer materialId, String materialType) {
        boolean result = false;
        MaterialProcessInterface materialProcessInterface = this.concurrentHashMap.get("scrm_material_" + materialType);
        if (materialProcessInterface != null) {
            try {
                result = materialProcessInterface.delete(materialId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Object getEntity(Integer materialId, String materialType) {
        MaterialProcessInterface materialProcessInterface = this.concurrentHashMap.get("scrm_material_" + materialType);
        if (materialProcessInterface != null) {
            try {
                return materialProcessInterface.getEntity(materialId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public BaseJsonVo<String> reUploadToQW(Integer materialId, String materialType) {
        MaterialProcessInterface materialProcessInterface = this.concurrentHashMap.get("scrm_material_" + materialType);
        if (materialProcessInterface != null) {
            return materialProcessInterface.reUploadToQW(materialId);
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7d20\u6750");
    }
}

