/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.scrm.dao.material.MaterialLinkMapper;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialLinkEntity;
import cc.lechun.scrm.entity.material.MaterialVo;
import cc.lechun.scrm.iservice.material.MaterialProcessInterface;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import weixin.popular.api.qy.WxApiUtils;

@Component(value="scrm_material_link")
public class MaterialLinkService
extends BaseService<MaterialLinkEntity, Integer>
implements MaterialProcessInterface {
    @Resource
    private MaterialLinkMapper materialLinkMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;

    @Override
    public boolean save(MaterialEntity materialEntity, Map map) {
        if (materialEntity.getId() == null) {
            return false;
        }
        MaterialLinkEntity materialLinkEntity = new MaterialLinkEntity();
        BeanUtils.mapToBean((Map)map, (Object)materialLinkEntity);
        materialLinkEntity.setMaterailId(materialEntity.getId());
        materialLinkEntity.setLinkImglUrl(materialLinkEntity.getOssUrl());
        MaterialLinkEntity old = null;
        if (materialEntity.getId() != null) {
            old = (MaterialLinkEntity)this.materialLinkMapper.selectByPrimaryKey(materialEntity.getId());
        }
        this.logger.info("map:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
        this.logger.info("old:{}", (Object)JsonUtils.toJson((Object)old, (boolean)false));
        this.logger.info("materialMediaEntity:{}", (Object)JsonUtils.toJson((Object)materialLinkEntity, (boolean)false));
        this.materialLinkMapper.insertOrUpdate(materialLinkEntity);
        return true;
    }

    @Override
    public boolean delete(Integer materialId) {
        return this.materialLinkMapper.deleteByPrimaryKey(materialId) >= 0;
    }

    @Override
    public Object getEntity(Integer materialId) {
        return this.materialLinkMapper.selectByPrimaryKey(materialId);
    }

    public BaseJsonVo uploadMedia(MaterialVo materialVo, MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String newName = IDGenerate.getUniqueIdStr() + prefix;
        String uploadPath = AliyunOSSDir.QW_MEDIA_UPLOAD.getPath() + newName;
        this.ossService.uploadFile(uploadPath, multipartFile.getInputStream());
        String fullPath = this.ossService.getImageResoure(uploadPath);
        this.logger.info("\u4e0a\u4f20OSS\u6210\u529f\uff0cfullPath:{}", (Object)fullPath);
        materialVo.setOssUrl(fullPath);
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        File file = MaterialLinkService.multipartFileToFile(multipartFile);
        String mediaId = WxApiUtils.uploadFileToTemp((String)accessToken, (String)materialVo.getMediaType(), (File)file);
        this.logger.info("\u4e0a\u4f20\u4f01\u5fae\u7ed3\u679c\uff0cmedia_id:{}", (Object)mediaId);
        materialVo.setMaterailOuterId(mediaId);
        materialVo.setCreateTime(new Date());
        materialVo.setDisableTime(DateUtils.getAddDateByDay((Date)materialVo.getCreateTime(), (int)3));
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo<String> reUploadToQW(Integer materialId) {
        return BaseJsonVo.success((Object)"");
    }

    public static File multipartFileToFile(MultipartFile multiFile) {
        String fileName = multiFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        try {
            File file = File.createTempFile(fileName, prefix);
            multiFile.transferTo(file);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

