/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.material.MaterialLogMapper;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialLogEntity;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.material.MaterialLogInterface;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialLogService
extends BaseService<MaterialLogEntity, Integer>
implements MaterialLogInterface {
    @Resource
    private MaterialLogMapper materialLogMapper;
    @Autowired
    private MaterialInterface materialInterface;

    @Override
    @Transactional
    public boolean saveLog(String checkContent, String pushText, String pushTextPre, String keyWord, Integer materialId, String creator, Date createTime) {
        MaterialLogEntity search = new MaterialLogEntity();
        search.setMaterialId(materialId);
        PageInfo pageInfo = this.getPageList(1, 1, search, "begin_time desc");
        if (pageInfo.getList().size() > 0) {
            ((MaterialLogEntity)pageInfo.getList().get(0)).setEndTime(new Date());
            this.updateByPrimaryKeySelective(pageInfo.getList().get(0));
        }
        MaterialLogEntity logEntity = new MaterialLogEntity();
        logEntity.setBeginTime(new Date());
        logEntity.setCheckContent(checkContent);
        logEntity.setMaterialId(materialId);
        logEntity.setCreator(creator);
        logEntity.setCreateTime(new Date());
        logEntity.setKeyword(keyWord);
        logEntity.setPushText(pushText);
        logEntity.setPushTextPre(pushTextPre);
        this.insertSelective(logEntity);
        return true;
    }

    @Override
    public List<LinkedHashMap> getMaterialLogList(Integer materialId) {
        if (materialId == null) {
            return new ArrayList<LinkedHashMap>();
        }
        MaterialLogEntity search = new MaterialLogEntity();
        search.setMaterialId(materialId);
        List lst = this.getList(search);
        lst = lst.stream().sorted(Comparator.comparing(MaterialLogEntity::getBeginTime).reversed()).collect(Collectors.toList());
        ArrayList<LinkedHashMap> results = new ArrayList<LinkedHashMap>();
        MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey(materialId);
        if (materialEntity == null) {
            return new ArrayList<LinkedHashMap>();
        }
        for (MaterialLogEntity m : lst) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", m.getId());
            map.put("materialId", m.getMaterialId());
            map.put("materialCode", materialEntity.getMaterialCode());
            map.put("pushText", m.getPushText());
            map.put("beginTime", DateUtils.formatDate((Date)m.getBeginTime(), (String)"MM-dd HH:mm"));
            if (m.getEndTime() != null) {
                map.put("endTime", DateUtils.formatDate((Date)m.getEndTime(), (String)"MM-dd HH:mm"));
            } else {
                map.put("endTime", "");
            }
            map.put("sendCount", m.getSendCount());
            map.put("factCount", m.getFactCount());
            map.put("execRate", m.getExecRate() == null ? "0.0%" : m.getExecRate().multiply(BigDecimal.valueOf(100L)).setScale(1, 4).toString() + "%");
            map.put("repateRate", m.getRepateRate() == null ? "0.0%" : m.getRepateRate().multiply(BigDecimal.valueOf(100L)).setScale(1, 4).toString() + "%");
            map.put("convertRate", m.getConvertRate() == null ? "0.0%" : m.getConvertRate().multiply(BigDecimal.valueOf(100L)).setScale(1, 4).toString() + "%");
            results.add(map);
        }
        return results;
    }
}

