/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.file.FileUtils;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.scrm.dao.material.MaterialMediaMapper;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialMediaEntity;
import cc.lechun.scrm.entity.material.MaterialVo;
import cc.lechun.scrm.iservice.material.MaterialProcessInterface;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import weixin.popular.api.qy.WxApiUtils;

@Component(value="scrm_material_media")
public class MaterialMediaService
extends BaseService<MaterialMediaEntity, Integer>
implements MaterialProcessInterface {
    @Resource
    private MaterialMediaMapper materialMediaMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;

    @Override
    public boolean save(MaterialEntity materialEntity, Map map) {
        if (materialEntity.getId() == null) {
            return false;
        }
        MaterialMediaEntity materialMediaEntity = new MaterialMediaEntity();
        BeanUtils.mapToBean((Map)map, (Object)materialMediaEntity);
        materialMediaEntity.setMaterailId(materialEntity.getId());
        MaterialMediaEntity old = null;
        if (materialEntity.getId() != null) {
            old = (MaterialMediaEntity)this.materialMediaMapper.selectByPrimaryKey(materialEntity.getId());
        }
        this.logger.info("map:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
        this.logger.info("old:{}", (Object)JsonUtils.toJson((Object)old, (boolean)false));
        this.logger.info("materialMediaEntity:{}", (Object)JsonUtils.toJson((Object)materialMediaEntity, (boolean)false));
        this.materialMediaMapper.insertOrUpdate(materialMediaEntity);
        return true;
    }

    @Override
    public boolean delete(Integer materialId) {
        return this.materialMediaMapper.deleteByPrimaryKey(materialId) >= 0;
    }

    @Override
    public Object getEntity(Integer materialId) {
        return this.materialMediaMapper.selectByPrimaryKey(materialId);
    }

    public BaseJsonVo uploadMedia(MaterialVo materialVo, MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String newName = IDGenerate.getUniqueIdStr() + prefix;
        String uploadPath = AliyunOSSDir.QW_MEDIA_UPLOAD.getPath() + newName;
        this.ossService.uploadFile(uploadPath, multipartFile.getInputStream());
        String fullPath = this.ossService.getImageResoure(uploadPath);
        this.logger.info("\u4e0a\u4f20OSS\u6210\u529f\uff0cfullPath:{}", (Object)fullPath);
        materialVo.setOssUrl(fullPath);
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        File file = MaterialMediaService.multipartFileToFile(multipartFile);
        String mediaType = materialVo.getMediaType();
        if (Objects.equals(mediaType, "link") || Objects.equals(mediaType, "miniprogram")) {
            mediaType = "image";
        }
        String mediaId = WxApiUtils.uploadFileToTemp((String)accessToken, (String)mediaType, (File)file);
        this.logger.info("\u4e0a\u4f20\u4f01\u5fae\u7ed3\u679c\uff0cmedia_id:{}", (Object)mediaId);
        materialVo.setMaterailOuterId(mediaId);
        materialVo.setCreateTime(DateUtils.now());
        materialVo.setDisableTime(DateUtils.getAddDateByDay((Date)materialVo.getCreateTime(), (int)3));
        return BaseJsonVo.success((Object)materialVo);
    }

    @Override
    public BaseJsonVo<String> reUploadToQW(Integer materialId) {
        MaterialMediaEntity materialMediaEntity = (MaterialMediaEntity)this.materialMediaMapper.selectByPrimaryKey(materialId);
        if (materialMediaEntity == null) {
            return BaseJsonVo.error((String)"ID\u4e0d\u5b58\u5728");
        }
        if (materialMediaEntity.getDisableTime().before(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)7200))) {
            File file = null;
            try {
                file = FileUtils.getFile(materialMediaEntity.getOssUrl());
            }
            catch (Exception e) {
                this.logger.error("[{}]\u83b7\u53d6OSS\u6587\u4ef6\u5931\u8d25", (Object)materialId, (Object)e);
                return BaseJsonVo.error((String)"\u83b7\u53d6OSS\u6587\u4ef6\u5931\u8d25");
            }
            String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
            String mediaId = WxApiUtils.uploadFileToTemp((String)accessToken, (String)materialMediaEntity.getMediaType(), (File)file);
            this.logger.info("{}\u91cd\u65b0\u4e0a\u4f20\u4f01\u5fae\u7ed3\u679c\uff0cmedia_id:{}", (Object)materialId, (Object)mediaId);
            materialMediaEntity.setMaterailOuterId(mediaId);
            this.materialMediaMapper.updateByPrimaryKeySelective(materialMediaEntity);
            return BaseJsonVo.success((Object)mediaId);
        }
        return BaseJsonVo.success((String)"\u5bcc\u88d52\u5c0f\u65f6\u4ee5\u4e0a\u4e0d\u9700\u8981\u91cd\u65b0\u4e0a\u4f20", null);
    }

    public static File multipartFileToFile(MultipartFile multiFile) {
        String fileName = multiFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        try {
            File file = File.createTempFile(fileName, prefix);
            multiFile.transferTo(file);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

