/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.apiinvoke.mall.ProductInvoke;
import cc.lechun.cms.api.ShortLinkApi;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.shortlink.ShortLinkInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.mallapi.dto.product.ItemIndexScrmVo;
import cc.lechun.scrm.dao.material.MaterialMapper;
import cc.lechun.scrm.dao.route.RouteCustomerMapper;
import cc.lechun.scrm.entity.material.MaterialDetailEntity;
import cc.lechun.scrm.entity.material.MaterialDetailVo;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialEntitySearchVo;
import cc.lechun.scrm.entity.material.MediaEntity;
import cc.lechun.scrm.entity.material.MediaTypeEnum;
import cc.lechun.scrm.entity.material.PushTypeEnum;
import cc.lechun.scrm.entity.material.SopObject;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.entity.route.RouteSceneVo;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.material.MediaInterface;
import cc.lechun.scrm.iservice.route.RouteInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.scrm.service.material.MaterialContext;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialService
extends BaseService<MaterialEntity, Integer>
implements MaterialInterface {
    @Resource
    private MaterialMapper materialMapper;
    @Autowired
    private MaterialContext materialContext;
    @Autowired
    ShortLinkApi shortLinkApi;
    @Autowired
    ShortLinkInterface shortLinkInterface;
    @Autowired
    RouteLinkInterface routeLinkInterface;
    @Autowired
    private MiniSchemeInterface miniSchemeInterface;
    @Lazy
    @Autowired
    RouteInterface routeInterface;
    @Lazy
    @Autowired
    SceneInterface sceneInterface;
    @Resource
    RouteCustomerMapper routeCustomerMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    ProductInvoke productInvoke;
    @Autowired
    private MediaInterface mediaInterface;

    @Override
    public BaseJsonVo saveMaterialCode(MaterialEntity materialEntity) {
        if (materialEntity.getId() == null) {
            return BaseJsonVo.error((String)"\u4e0d\u652f\u6301\u65b0\u589e");
        }
        MaterialEntity search = new MaterialEntity();
        search.setMaterialCode(materialEntity.getMaterialCode());
        search.setAppId(materialEntity.getAppId());
        List lst = this.getList(search, 0L);
        if (lst.stream().filter(c -> !c.getId().equals(materialEntity.getId())).count() > 0L) {
            return BaseJsonVo.error((String)"\u7d20\u6750\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362");
        }
        search.setId(materialEntity.getId());
        search.setMaterialName(search.getMaterialCode());
        this.updateByPrimaryKeySelective(search);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo saveMaterial(MaterialEntity materialEntity, Map map) {
        MaterialEntity search;
        MaterialEntity parent;
        if (materialEntity.getParentId() != null && (parent = (MaterialEntity)this.selectByPrimaryKey(materialEntity.getParentId())) != null) {
            materialEntity.setParentMaterialCode(parent.getMaterialCode());
        }
        if (materialEntity.getId() == null || materialEntity.getId() == 0) {
            search = new MaterialEntity();
            search.setAppId(materialEntity.getAppId());
            search.setMaterialCode(materialEntity.getMaterialCode());
            search = (MaterialEntity)this.getSingle(search);
            if (search != null) {
                return BaseJsonVo.error((String)"\u7d20\u6750\u7f16\u7801\u5df2\u5b58\u5728");
            }
            materialEntity.setId(null);
            materialEntity.setCreateTime(new Date());
            this.materialMapper.insert(materialEntity);
        } else {
            if (materialEntity.getParentId() != null && materialEntity.getId().intValue() == materialEntity.getParentId().intValue()) {
                return BaseJsonVo.error((String)"\u524d\u7f6e\u7d20\u6750\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1");
            }
            search = new MaterialEntity();
            search.setMaterialCode(materialEntity.getMaterialCode());
            search.setAppId(materialEntity.getAppId());
            List lst = this.getList(search, 0L);
            if (lst.stream().filter(c -> !c.getId().equals(materialEntity.getId())).count() > 0L) {
                return BaseJsonVo.error((String)"\u7d20\u6750\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362");
            }
            this.updateByPrimaryKey(materialEntity);
        }
        boolean result = this.materialContext.save(materialEntity, map);
        if (result) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    @Cacheable(value={"MaterialService.getMaterial"}, key="#id")
    public MaterialEntity getMaterial(Integer id) {
        return (MaterialEntity)this.materialMapper.selectByPrimaryKey(id);
    }

    @Override
    public BaseJsonVo getOptionList(Integer materialClass, Integer appId) {
        MaterialEntity search = new MaterialEntity();
        search.setStatus(1);
        search.setMaterialClass(materialClass);
        search.setAppId(appId);
        List lst = this.getList(search, 0L);
        ArrayList results = new ArrayList();
        for (MaterialEntity m : lst) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", m.getId());
            map.put("label", m.getMaterialName());
            results.add(map);
        }
        return BaseJsonVo.success(results);
    }

    @Override
    @ReadThroughSingleCache(namespace="MaterialService.getMaterialWithType", expiration=300)
    public Map getMaterialWithType(@ParameterValueKeyProvider Integer materialId) {
        if (materialId == null) {
            return new HashMap();
        }
        MaterialEntity entity = (MaterialEntity)this.selectByPrimaryKey(materialId, 0L);
        Map<String, String> map = new HashMap();
        if (entity != null) {
            Object o = this.materialContext.getEntity(materialId, entity.getMaterialType());
            if (o != null) {
                map = BeanUtils.beanToMap((Object)o);
            }
            map.putAll(BeanUtils.beanToMap((Object)entity));
            if (map.containsKey("pushText")) {
                map.put("pushText", this.replaceHrefLongUrl(map.get("pushText") == null ? null : map.get("pushText").toString()));
            }
            if (map.containsKey("pushTextPre")) {
                map.put("pushTextPre", this.replaceHrefLongUrl(map.get("pushTextPre") == null ? null : map.get("pushTextPre").toString()));
            }
            if (map.get("pushTextPre") == null || StringUtils.isEmpty((String)map.get("pushTextPre").toString())) {
                map.put("pushTextPre", (String)map.get("pushText"));
            }
            map.put("pushTypeName", PushTypeEnum.getName(entity.getPushType()));
            return map;
        }
        return new HashMap();
    }

    @Override
    public BaseJsonVo<String> reUploadToQW(Integer materialId) {
        MaterialEntity entity = (MaterialEntity)this.selectByPrimaryKey(materialId, 0L);
        if (entity != null) {
            return this.materialContext.reUploadToQW(materialId, entity.getMaterialType());
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7d20\u6750");
    }

    private String replaceHrefLongUrl(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        String result = text;
        String regEx = "(?<=href=\\\").*?(?=\\\")";
        Pattern pattern = Pattern.compile(regEx, 2);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String var1 = text.substring(matcher.start(), matcher.end());
            result = result.replace(var1, this.getShortLink(var1));
        }
        return result;
    }

    private String getShortLink(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        if (url.contains("//t.lechun.cc") || url.contains("//cms.lechun.cc") || url.contains("//scms.lechun.cc")) {
            return url;
        }
        BaseJsonVo jsonVo = this.shortLinkApi.getShortLink(url, "", "SCRM\u7d20\u6750\u77ed\u94fe");
        if (jsonVo.isSuccess()) {
            return jsonVo.getValue().toString();
        }
        return url;
    }

    @Override
    public BaseJsonVo deleteMaterial(Integer materialId) {
        boolean b = false;
        MaterialEntity entity = (MaterialEntity)this.selectByPrimaryKey(materialId);
        if (entity != null && (b = this.materialContext.delete(materialId, entity.getMaterialType()))) {
            this.materialMapper.deleteByPrimaryKey(materialId);
        }
        return b ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getMaterial(RouteLinkEntity linkEntity) {
        if (linkEntity == null || linkEntity.getActionDetailId() == null) {
            return BaseJsonVo.error((String)"\u7d20\u6750\u6216\u573a\u666f\u4e3a\u7a7a");
        }
        Map map = this.getMaterialWithType(linkEntity.getActionDetailId());
        if ("text".equals(map.get("materialType"))) {
            return BaseJsonVo.success((Object)map.get("pushText").toString());
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u7d20\u6750");
    }

    @Override
    public BaseJsonVo getMaterialPageList(int pageNum, int pageSize, MaterialEntitySearchVo materialEntity, String qyWeixinUserid, String nickName, String orderBy) {
        BaseJsonVo<String> codeBaseJsonVo;
        String shareCode = "";
        if (StringUtils.isNotEmpty((String)qyWeixinUserid) && (codeBaseJsonVo = this.distributorInterface.getQiyeWeixinShareCode(qyWeixinUserid)).isSuccess()) {
            shareCode = (String)codeBaseJsonVo.getValue();
        }
        return this.getMaterialPageList2(pageNum, pageSize, materialEntity, shareCode, nickName, orderBy);
    }

    private BaseJsonVo getMaterialPageList2(int pageNum, int pageSize, MaterialEntitySearchVo materialEntity, String ncp_bat, String nickName, String orderBy) {
        List<RouteSceneVo> routeEntityList = this.routeInterface.getListByMaterail();
        List<Map> sopCountByDate = null;
        if (StringUtils.isNotEmpty((String)materialEntity.getFirstSnedTime())) {
            String sdate = materialEntity.getFirstSnedTime().split(",")[0];
            String edate = materialEntity.getFirstSnedTime().split(",")[1];
            sopCountByDate = this.routeCustomerMapper.getSopCountByDate(sdate, edate);
            materialEntity.setFirstSnedTime(null);
        }
        Page pages = PageHelper.startPage((int)pageNum, (int)pageSize, (String)"ID DESC");
        if (StringUtils.isNotEmpty((String)materialEntity.getMaterialCode())) {
            materialEntity.setMaterialCode(SqlUtils.sqlLike((String)materialEntity.getMaterialCode().trim(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)materialEntity.getMaterialType())) {
            materialEntity.setMaterialType(null);
        }
        this.materialMapper.getMaterialList(materialEntity);
        PageInfo pg = pages.toPageInfo();
        ArrayList<MaterialDetailVo> list = new ArrayList<MaterialDetailVo>();
        PageInfo result = new PageInfo();
        org.springframework.beans.BeanUtils.copyProperties((Object)pg, (Object)result);
        for (MaterialDetailEntity item : pg.getList()) {
            Optional<Map> map;
            Map<String, List<SopObject>> sopObject;
            List<RouteSceneVo> tempList = routeEntityList.stream().filter(r -> Objects.equals(item.getId(), r.getMaterailId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tempList) && (sopObject = this.getTripList(tempList)) != null) {
                item.setSenceList(sopObject.get("senceList"));
                item.setRouteList(sopObject.get("routeList"));
            }
            MaterialDetailVo materialDetailVo = new MaterialDetailVo();
            org.springframework.beans.BeanUtils.copyProperties((Object)item, (Object)materialDetailVo);
            if (StringUtils.isNotEmpty((String)ncp_bat)) {
                materialDetailVo.setNcp_bat(ncp_bat);
            }
            if (sopCountByDate != null) {
                map = sopCountByDate.stream().filter(c -> c.get("materialId").equals(item.getId())).findFirst();
                materialDetailVo.setShouldSendCount(map.isPresent() ? Integer.valueOf(map.get().get("shouldSendCount").toString()) : 0);
                materialDetailVo.setSendCount(map.isPresent() ? Integer.valueOf(map.get().get("sendCount").toString()) : 0);
                materialDetailVo.setReplyCount(map.isPresent() ? Integer.valueOf(((Map)map.get()).get("repeatCount").toString()) : 0);
                materialDetailVo.setOrderCount(map.isPresent() ? Integer.valueOf(((Map)map.get()).get("orderPersonCount").toString()) : 0);
            }
            if (materialDetailVo != null && materialDetailVo.getSendCount() != null && materialDetailVo.getSendCount() > 0) {
                Double replyRate = Double.valueOf(materialDetailVo.getReplyCount().intValue()) / Double.valueOf(materialDetailVo.getSendCount().intValue());
                replyRate = Double.valueOf(String.format("%.4f", replyRate));
                materialDetailVo.setReplyRateValue(replyRate);
                materialDetailVo.setReplyRate(this.getDouble(replyRate * 100.0) + "%");
                if (item.getRepateRate() != null && replyRate > item.getRepateRate().doubleValue()) {
                    materialDetailVo.setMaxReplyRateDesc("\u662f");
                }
                Double sevenRate = Double.valueOf(materialDetailVo.getOrderCount().intValue()) / Double.valueOf(materialDetailVo.getSendCount().intValue());
                sevenRate = Double.valueOf(String.format("%.4f", sevenRate));
                materialDetailVo.setSevenRateValue(sevenRate);
                materialDetailVo.setSevenRate(this.getDouble(sevenRate * 100.0) + "%");
                if (item.getConvertRate() != null && sevenRate > item.getConvertRate().doubleValue()) {
                    materialDetailVo.setMaxConvertRate("\u662f");
                }
            } else {
                materialDetailVo.setMaxConvertRate("-");
                materialDetailVo.setMaxReplyRateDesc("-");
            }
            if ("media".equals(materialDetailVo.getMaterialType()) && materialDetailVo.getDisableTime() != null) {
                materialDetailVo.setEnable(DateUtils.now().before(materialDetailVo.getDisableTime()) ? 1 : 0);
            }
            if (Objects.equals(materialDetailVo.getMaterialType(), "link")) {
                map = this.getMaterialWithType(materialDetailVo.getId());
                this.logger.info("{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
                if (map != null) {
                    materialDetailVo.setTitle(map.getOrDefault("title", "").toString());
                    materialDetailVo.setPage(map.getOrDefault("link", "").toString());
                    materialDetailVo.setOssUrl(map.getOrDefault("linkImglUrl", "").toString());
                    materialDetailVo.setSummary(map.getOrDefault("linkDesc", "").toString());
                }
            }
            if (Objects.equals(materialDetailVo.getMaterialType(), "miniprogram")) {
                map = this.getMaterialWithType(materialDetailVo.getId());
                this.logger.info("{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
                if (map != null) {
                    materialDetailVo.setTitle(map.getOrDefault("title", "").toString());
                    materialDetailVo.setPage(map.getOrDefault("page", "").toString());
                    materialDetailVo.setAppid(map.getOrDefault("appid", "").toString());
                    materialDetailVo.setMiniImgUrl(map.getOrDefault("miniImgUrl", "").toString());
                    materialDetailVo.setQiWeiName(nickName);
                }
            }
            if (StringUtils.isEmpty((String)materialDetailVo.getMediaType())) {
                materialDetailVo.setMediaType(materialDetailVo.getMaterialType());
            }
            list.add(materialDetailVo);
        }
        result.setList(list);
        return BaseJsonVo.success((Object)result);
    }

    @Override
    public BaseJsonVo getIndexItemList(String userId, String qyWeixinUserid, String nickName, Integer saleType, String itemId) {
        BaseJsonVo<String> codeBaseJsonVo;
        String shareCode = "";
        if (StringUtils.isNotEmpty((String)qyWeixinUserid) && (codeBaseJsonVo = this.distributorInterface.getQiyeWeixinShareCode(qyWeixinUserid)).isSuccess()) {
            shareCode = (String)codeBaseJsonVo.getValue();
        }
        MediaEntity query = new MediaEntity();
        query.setMediaType(MediaTypeEnum.collect.getValue());
        if (StringUtils.isNotEmpty((String)userId)) {
            query.setCreateUserid(userId);
        }
        List collectionList = this.mediaInterface.getList(query, 0L);
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseAccessToken.getAccessTokenByPlatformId(4);
        this.logger.info("\u8f93\u5165\u53c2\u6570:plateform={},saleType={},itemId={}", new Object[]{4, saleType, itemId});
        BaseJsonVo baseJsonVo = this.productInvoke.getIndexMallProducts(4, 0, itemId);
        if (baseJsonVo.isSuccess()) {
            for (ItemIndexScrmVo indexScrmVo : (List)baseJsonVo.getValue()) {
                List tempList;
                indexScrmVo.setQiWeiName(nickName);
                indexScrmVo.setAppid(weiXinBaseEntity.getAppid());
                indexScrmVo.setCollectStatus(Integer.valueOf(0));
                if (CollectionUtils.isNotEmpty((Collection)collectionList) && CollectionUtils.isNotEmpty(tempList = collectionList.stream().filter(collect -> Objects.equals(collect.getType(), indexScrmVo.getType()) && Objects.equals(collect.getItemId(), indexScrmVo.getItemId())).collect(Collectors.toList()))) {
                    indexScrmVo.setCollectStatus(Integer.valueOf(1));
                    indexScrmVo.setMediaId(((MediaEntity)tempList.get(0)).getMediaId());
                }
                indexScrmVo.setShareCode(shareCode);
                if (indexScrmVo.getPage().indexOf("?") > 0) {
                    indexScrmVo.setPage(indexScrmVo.getPage() + "&ncp_bat=" + shareCode);
                    continue;
                }
                indexScrmVo.setPage(indexScrmVo.getPage() + "?ncp_bat=" + shareCode);
            }
        }
        return baseJsonVo;
    }

    private Double getDouble(Double value) {
        return (double)Double.valueOf(value * 100.0).intValue() / 100.0;
    }

    private Map<String, List<SopObject>> getTripList(List<RouteSceneVo> routeEntityList) {
        HashMap<String, List<SopObject>> map = new HashMap<String, List<SopObject>>();
        ArrayList<SopObject> tripList = new ArrayList<SopObject>();
        ArrayList<SopObject> senceList = new ArrayList<SopObject>();
        if (CollectionUtils.isNotEmpty(routeEntityList)) {
            for (RouteSceneVo routeSceneVo : routeEntityList) {
                SopObject sopRoute = new SopObject();
                sopRoute.setId(routeSceneVo.getRouteId());
                sopRoute.setName(routeSceneVo.getRouteName());
                sopRoute.setStatusName(routeSceneVo.getRouteStatus() == 1 ? "\u6709\u6548" : "\u7981\u7528");
                tripList.add(sopRoute);
                SopObject sopSence = new SopObject();
                sopSence.setId(routeSceneVo.getSceneId());
                sopSence.setName(routeSceneVo.getSceneName());
                sopSence.setStatusName(routeSceneVo.getSceneStatus() == 1 ? "\u6709\u6548" : "\u7981\u7528");
                senceList.add(sopSence);
            }
            map.put("routeList", tripList);
            map.put("senceList", senceList);
            return map;
        }
        return null;
    }

    @Override
    public BaseJsonVo changeStatus(Integer materialId, Integer status) {
        if (materialId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u7d20\u6750");
        }
        if (!Integer.valueOf(1).equals(status) && !Integer.valueOf(0).equals(status)) {
            return BaseJsonVo.error((String)"\u72b6\u6001\u9519\u8bef");
        }
        MaterialEntity materialEntity = new MaterialEntity();
        materialEntity.setId(materialId);
        materialEntity.setStatus(status);
        materialEntity.setUpdateTime(new Date());
        this.updateByPrimaryKeySelective(materialEntity);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public void statistics(Date date) {
        MaterialEntity materialEntity = new MaterialEntity();
        materialEntity.setStatus(1);
        materialEntity.setMaterialClass(1);
        PageInfo pageInfo = this.getPageList(1, 10, materialEntity, "ID desc");
        for (MaterialEntity item : pageInfo.getList()) {
            this.statistics(item);
        }
        int i = 1;
        while ((long)i < pageInfo.getTotal()) {
            pageInfo = this.getPageList(i, 10, materialEntity, "ID DESC ");
            for (MaterialEntity item : pageInfo.getList()) {
                this.statistics(item);
            }
            ++i;
        }
    }

    @Override
    public void statistics(MaterialEntity materialEntity) {
        Integer shouldSendNum = this.getShouldSendCount(materialEntity);
        Integer sendNum = this.getSendCount(materialEntity);
        Integer replyNum = this.getReplyCount(materialEntity);
        Integer orderNum = this.getOrderCount(materialEntity);
        MaterialEntity update = new MaterialEntity();
        update.setId(materialEntity.getId());
        update.setSendCount(sendNum);
        update.setReplyCount(replyNum);
        update.setOrderCount(orderNum);
        update.setShouldSendCount(shouldSendNum);
        update.setFirstSnedTime(this.getFirstSendDate(materialEntity));
        this.updateByPrimaryKeySelective(update);
    }

    private Integer getShouldSendCount(MaterialEntity materialEntity) {
        Map<String, Object> sendNum = this.routeCustomerMapper.getShouldSendNum(materialEntity.getId());
        if (sendNum != null) {
            return Integer.valueOf(sendNum.getOrDefault("shouldSendNum", "0").toString());
        }
        return 0;
    }

    private Integer getSendCount(MaterialEntity materialEntity) {
        Map<String, Object> sendNum = this.routeCustomerMapper.getSendNum(materialEntity.getId());
        if (sendNum != null) {
            return Integer.valueOf(sendNum.getOrDefault("sendNum", "0").toString());
        }
        return 0;
    }

    private String getFirstSendDate(MaterialEntity materialEntity) {
        Map<String, Object> sendNum = this.routeCustomerMapper.getSendNum(materialEntity.getId());
        if (sendNum != null) {
            return sendNum.getOrDefault("firstSendDate", "").toString();
        }
        return "";
    }

    private Integer getReplyCount(MaterialEntity materialEntity) {
        Map<String, Object> replyNum = this.routeCustomerMapper.getReplyNum(materialEntity.getId());
        if (replyNum != null) {
            return Integer.valueOf(replyNum.getOrDefault("replyNum", "0").toString());
        }
        return 0;
    }

    private Integer getOrderCount(MaterialEntity materialEntity) {
        Map<String, Object> orderNum = this.routeCustomerMapper.getOrderdNum(materialEntity.getId());
        if (orderNum != null) {
            return Integer.valueOf(orderNum.getOrDefault("orderNum", "0").toString());
        }
        return 0;
    }

    @Override
    public String getHrefLongUrlChanId(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return "";
        }
        String result = "";
        String regEx = "((?<=(href=|data-miniprogram-path=)\\\").*?(?=\\\"))|((t.lechun.cc/)+.{7})";
        Pattern pattern = Pattern.compile(regEx, 2);
        Matcher matcher = pattern.matcher(text);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while (matcher.find()) {
            String[] arr;
            String var1 = text.substring(matcher.start(), matcher.end());
            if (var1.indexOf("t.lechun.cc/") >= 0) {
                var1 = var1.replace("http://t.lechun.cc/", "").replace("https://t.lechun.cc/", "").replace("t.lechun.cc/", "");
                if ((var1 = this.shortLinkInterface.getMallUrl(var1)) != null) {
                    try {
                        var1 = URLDecoder.decode(var1, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!StringUtils.isNotEmpty((String)var1) || (arr = var1.split("chan_id=")).length <= 1) continue;
            String[] arr1 = arr[1].split("&");
            set.add(arr1[0]);
        }
        if (set.size() > 0) {
            result = String.join((CharSequence)",", set.toArray(new String[set.size()]));
        }
        return result;
    }

    @Override
    public Map getMaterialEntity(String channelState) {
        MaterialEntity query = new MaterialEntity();
        query.setChannelState(channelState);
        query.setChannelState(SqlUtils.sqlLike((String)channelState, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        MaterialEntity materialEntity = (MaterialEntity)this.materialMapper.getSingle(query);
        if (materialEntity == null) {
            return null;
        }
        Map map = this.getMaterialWithType(materialEntity.getId());
        return map;
    }

    public String matchUrl(String text, String regEx) {
        if (StringUtils.isEmpty((String)text)) {
            return "";
        }
        String result = "";
        Pattern pattern = Pattern.compile(regEx, 2);
        Matcher matcher = pattern.matcher(text);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        while (matcher.find()) {
            String var1 = text.substring(matcher.start(), matcher.end());
            if (var1.indexOf("t.lechun.cc/") >= 0) {
                return "";
            }
            if (!StringUtils.isNotEmpty((String)var1)) continue;
            set.add(var1);
        }
        if (set.size() > 0) {
            result = String.join((CharSequence)",", set.toArray(new String[set.size()]));
        }
        return result;
    }

    @Override
    public String replateMiniTagToHref(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return "";
        }
        String result = "";
        String regEx = "<a\\s[^>]*>.*?<\\/a>";
        Pattern pattern = Pattern.compile(regEx, 2);
        Matcher matcher = pattern.matcher(text);
        LinkedHashSet set = new LinkedHashSet();
        while (matcher.find()) {
            String reg;
            String var2;
            String var1 = text.substring(matcher.start(), matcher.end());
            if (var1.indexOf("t.lechun.cc/") >= 0 || !StringUtils.isNotEmpty((String)var1) || StringUtils.isEmpty((String)(var2 = this.matchUrl(var1, reg = "((?<=(href=|data-miniprogram-path=)\\\").*?(?=\\\"))|((t.lechun.cc/)+.{7})"))) || var2.trim().startsWith("http://") || var2.trim().startsWith("https://") || var2.indexOf("lechun.cc") >= 0) continue;
            String var3 = "";
            this.logger.info("\u8c03\u7528\u8f6c\u77ed\u94fe\u63a5\u63a5\u53e3var2:" + var2);
            BaseJsonVo<MiniSchemeEntity> miniSchemeEntityBaseJsonVo = this.miniSchemeInterface.getMiniSchemeSystemByPara(var2);
            if (miniSchemeEntityBaseJsonVo.isSuccess()) {
                var3 = ((MiniSchemeEntity)miniSchemeEntityBaseJsonVo.getValue()).getShortLink();
                this.logger.info("\u8c03\u7528\u8f6c\u77ed\u94fe\u63a5\u63a5\u53e3var3:" + var3);
            }
            this.logger.info("\u8c03\u7528\u8f6c\u77ed\u94fe\u63a5\u63a5\u53e3var3_1:" + var3);
            reg = "((?<=(.*?)>).*?(?=<))";
            String conent = this.matchUrl(var1, reg);
            text = text.replace(var1, var3);
        }
        return text;
    }
}

