/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.cms.api.ShortLinkApi;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.material.MaterialTextMapper;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialTextEntity;
import cc.lechun.scrm.iservice.material.MaterialLogInterface;
import cc.lechun.scrm.iservice.material.MaterialProcessInterface;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scrm_material_text")
public class MaterialTextService
extends BaseService
implements MaterialProcessInterface {
    @Resource
    private MaterialTextMapper materialTextMapper;
    @Autowired
    private ShortLinkApi shortLinkApi;
    @Autowired
    private MaterialLogInterface materialLogInterface;

    @Override
    public boolean save(MaterialEntity materialEntity, Map map) {
        if (materialEntity.getId() == null) {
            return false;
        }
        Integer recordLog = 1;
        if (map.get("recordLog") != null && StringUtils.isNotEmpty((String)map.get("recordLog").toString())) {
            recordLog = Integer.valueOf(map.get("recordLog").toString());
        }
        MaterialTextEntity materialTextEntity = new MaterialTextEntity();
        BeanUtils.mapToBean((Map)map, (Object)materialTextEntity);
        materialTextEntity.setMaterailId(materialEntity.getId());
        materialTextEntity.setShortUrl(this.getShortLink(materialTextEntity.getUrl()));
        MaterialTextEntity old = null;
        if (materialEntity.getId() != null) {
            old = (MaterialTextEntity)this.materialTextMapper.selectByPrimaryKey(materialEntity.getId());
        }
        this.logger.info("recordLog:" + recordLog);
        this.logger.info("map:" + JsonUtils.toJson((Object)map, (boolean)true));
        this.logger.info("old:" + JsonUtils.toJson((Object)old, (boolean)true));
        this.logger.info("materialTextEntity:" + JsonUtils.toJson((Object)materialTextEntity, (boolean)true));
        if (Integer.valueOf(1).equals(materialTextEntity.getCheckStatus()) && Integer.valueOf(1).equals(recordLog) && materialEntity.getId() != null && old != null) {
            if (old.getPushText() == null) {
                old.setPushText("");
            }
            if (!old.getPushText().equals(materialTextEntity.getPushTextPre())) {
                this.materialLogInterface.saveLog(materialTextEntity.getCheckContent(), materialTextEntity.getPushTextPre(), "", materialTextEntity.getKeyword(), materialTextEntity.getMaterailId(), materialTextEntity.getCheker(), old.getUpdateTime());
            }
        }
        if (Integer.valueOf(0).equals(materialTextEntity.getCheckStatus())) {
            if (old != null) {
                materialTextEntity.setPushText(old.getPushText());
            } else {
                materialTextEntity.setPushText("");
            }
        }
        int i = this.materialTextMapper.insertOrUpdate(materialTextEntity);
        return true;
    }

    @Override
    public BaseJsonVo<String> reUploadToQW(Integer materialId) {
        return BaseJsonVo.success((Object)"");
    }

    private String getShortLink(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        if (url.contains("//t.lechun.cc") || url.contains("//cms.lechun.cc") || url.contains("//scms.lechun.cc")) {
            return url;
        }
        BaseJsonVo jsonVo = this.shortLinkApi.getShortLink(url, "", "SCRM\u7d20\u6750\u77ed\u94fe");
        if (jsonVo.isSuccess()) {
            return jsonVo.getValue().toString();
        }
        return url;
    }

    @Override
    public boolean delete(Integer materialId) {
        this.materialTextMapper.deleteByPrimaryKey(materialId);
        return true;
    }

    @Override
    public Object getEntity(Integer materialId) {
        return this.materialTextMapper.selectByPrimaryKey(materialId);
    }
}

