/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.apiinvoke.bi.BICustomerDataInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.scrm.dao.material.MaterialTraceMapper;
import cc.lechun.scrm.entity.material.MaterialTraceEntity;
import cc.lechun.scrm.entity.route.RouteCustomerEntity;
import cc.lechun.scrm.iservice.material.MaterialTraceInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialTraceService
extends BaseService<MaterialTraceEntity, Integer>
implements MaterialTraceInterface {
    @Resource
    private MaterialTraceMapper materialTraceMapper;
    @Autowired
    private BICustomerDataInvoke biCustomerDataInvoke;

    @Override
    public BaseJsonVo deleteMaterialTrace(Integer traceId) {
        if (traceId == null) {
            return BaseJsonVo.error((String)"id\u4e3a\u7a7a");
        }
        int i = this.deleteByPrimaryKey(traceId);
        if (i > 0) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public List<MaterialTraceEntity> getMaterialTraceList(MaterialTraceEntity search) {
        if (search == null) {
            return new ArrayList<MaterialTraceEntity>();
        }
        return this.getList(search);
    }

    @Override
    public BaseJsonVo saveMaterialTrace(List<MaterialTraceEntity> lst) {
        if (lst.size() == 0) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u4fdd\u5b58\u7684\u6570\u636e");
        }
        int i = 1;
        for (MaterialTraceEntity m : lst) {
            if (m.getMaterialId() == null) {
                return BaseJsonVo.error((String)("\u7b2c" + i + "\u884c\u6ca1\u6709\u9009\u62e9\u7d20\u6750"));
            }
            if (m.getTraceType() == null) {
                return BaseJsonVo.error((String)("\u7b2c" + i + "\u884c\u6ca1\u6709\u9009\u62e9\u8ffd\u8e2a\u7c7b\u578b"));
            }
            if (StringUtils.isEmpty((String)m.getTag())) {
                return BaseJsonVo.error((String)("\u7b2c" + i + "\u884c\u8bf7\u586b\u5199\u6807\u7b7e"));
            }
            ++i;
        }
        for (MaterialTraceEntity m : lst) {
            if (m.getId() == null) {
                this.insert(m);
                continue;
            }
            this.updateByPrimaryKey(m);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public String getMaterialTraceTag(RouteCustomerEntity rc, Integer isRepeat, List<Map<String, String>> chats) {
        try {
            MaterialTraceEntity search = new MaterialTraceEntity();
            search.setMaterialId(rc.getMaterialId());
            List traceList = this.getList(search).stream().sorted((d, c) -> c.getTraceType().compareTo(d.getTraceType())).collect(Collectors.toList());
            block8: for (MaterialTraceEntity t : traceList) {
                switch (t.getTraceType()) {
                    case 0: {
                        if (isRepeat != 0) break;
                        return t.getTag().toUpperCase(Locale.ROOT);
                    }
                    case 1: {
                        if (isRepeat != 1) break;
                        if (StringUtils.isEmpty((String)t.getContent())) {
                            return t.getTag().toUpperCase(Locale.ROOT);
                        }
                        if (chats.stream().filter(c -> Integer.valueOf("2").equals(c.get("speakType")) && t.getContent().equals(c.get("textContent"))).count() <= 0L) break;
                        return t.getTag().toUpperCase(Locale.ROOT);
                    }
                    case 2: {
                        if (isRepeat != 1) break;
                        Optional<Map> linkChat = chats.stream().filter(c -> Integer.valueOf("1").equals(c.get("speakType")) && ("link".equals(c.get("msgType")) || "weapp".equals(c.get("msgType")))).findFirst();
                        if (!linkChat.isPresent() || !(StringUtils.isEmpty((String)t.getContent()) ? chats.stream().filter(c -> Integer.valueOf("2").equals(c.get("speakType")) && DateUtils.getDateFromString((String)((String)c.get("msgTime"))).after(DateUtils.getDateFromString((String)((String)((Map)linkChat.get()).get("msgTime"))))).count() > 0L : chats.stream().filter(c -> Integer.valueOf("2").equals(c.get("speakType")) && DateUtils.getDateFromString((String)((String)c.get("msgTime"))).after(DateUtils.getDateFromString((String)((String)((Map)linkChat.get()).get("msgTime")))) && t.getContent().equals(c.get("textContent"))).count() > 0L)) continue block8;
                        return t.getTag().toUpperCase(Locale.ROOT);
                    }
                    case 3: {
                        Optional<Map> linkChat = chats.stream().filter(c -> Integer.valueOf("1").equals(c.get("speakType")) && ("link".equals(c.get("msgType")) || "weapp".equals(c.get("msgType")))).findFirst();
                        if (!linkChat.isPresent()) break;
                        BaseJsonVo jsonVo = this.biCustomerDataInvoke.getCustomerVisite(rc.getCustomerId(), (String)linkChat.get().get("msgTime"));
                        if (!jsonVo.isSuccess() || Integer.valueOf(jsonVo.getValue().toString()) <= 0) continue block8;
                        return t.getTag().toUpperCase(Locale.ROOT);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

