/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.material;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.scrm.entity.material.MediaEntity;
import cc.lechun.scrm.entity.material.MediaTypeEnum;
import cc.lechun.scrm.entity.material.MiniMedia;
import cc.lechun.scrm.entity.material.MiniMediaManaData;
import cc.lechun.scrm.entity.material.SaleItem;
import cc.lechun.scrm.iservice.material.MediaInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiWeiMiniService {
    @Autowired
    private MediaInterface mediaInterface;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private SysUserInterface mallUserService;
    @Autowired
    MiniSchemeInterface miniSchemeInterface;
    @Resource
    private ActivePropertyMapper activePropertyMapper;

    public BaseJsonVo saveQiWeiMini(MediaEntity mediaEntity) {
        MediaEntity result;
        if (StringUtils.isEmpty((String)mediaEntity.getItemId())) {
            return BaseJsonVo.error((String)"\u4fc3\u9500\u3001\u5355\u54c1\u3001\u6d3b\u52a8id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mediaEntity.getType() == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MediaEntity query = new MediaEntity();
        query.setItemId(mediaEntity.getItemId());
        query.setType(mediaEntity.getType());
        query.setMediaType(mediaEntity.getMediaType());
        if (Objects.equals(MediaTypeEnum.collect.getValue(), mediaEntity.getMediaType()) || Objects.equals(MediaTypeEnum.collect.getValue(), mediaEntity.getMediaType())) {
            query.setCreateUserid(mediaEntity.getCreateUserid());
        }
        if ((result = (MediaEntity)this.mediaInterface.getSingle(query, 0L)) == null) {
            mediaEntity.setCreateTime(new Date());
            if (Objects.equals(mediaEntity.getMediaType(), MediaTypeEnum.recently.getValue()) || Objects.equals(mediaEntity.getMediaType(), MediaTypeEnum.collect.getValue())) {
                mediaEntity.setNum(0);
            }
            this.mediaInterface.insertSelective(mediaEntity);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        mediaEntity.setMediaId(result.getMediaId());
        this.mediaInterface.updateByPrimaryKeySelective(mediaEntity);
        this.mediaInterface.updateNum(mediaEntity.getMediaId());
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo deleteMedia(Integer mediaId, String userId) {
        if (mediaId == null) {
            return BaseJsonVo.success((Object)"");
        }
        MediaEntity mediaEntity = (MediaEntity)this.mediaInterface.selectByPrimaryKey(mediaId, 0L);
        if (mediaEntity != null) {
            MediaEntity query = new MediaEntity();
            query.setMediaType(MediaTypeEnum.collect.getValue());
            query.setType(mediaEntity.getType());
            query.setCreateUserid(userId);
            query.setItemId(mediaEntity.getItemId());
            MediaEntity result = (MediaEntity)this.mediaInterface.getSingle(query, 0L);
            if (result != null) {
                this.mediaInterface.deleteByPrimaryKey(result.getMediaId());
            }
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    public BaseJsonVo deleteMedia(Integer mediaId) {
        this.mediaInterface.deleteByPrimaryKey(mediaId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    public PageInfo<MiniMediaManaData> getMiniMediaManaDataList(int currentPage, int pageSize, Integer mediaType) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        page.setOrderBy(" CREATE_TIME desc ");
        MediaEntity query = new MediaEntity();
        query.setMediaType(mediaType);
        List list = this.mediaInterface.getList(query, 0L);
        List<Object> result = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = list.stream().map(item -> {
                MiniMediaManaData miniMediaManaData = new MiniMediaManaData();
                BeanUtils.copyProperties((Object)item, (Object)miniMediaManaData);
                MallUserEntity userEntity = this.mallUserService.getMallUser(item.getCreateUserid());
                miniMediaManaData.setMediaTypeName(MediaTypeEnum.getName(item.getMediaType()));
                miniMediaManaData.setCreator(userEntity.getUserNick());
                String shortLink = "-";
                if (Objects.equals(item.getType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                    MallProductEntity productEntity = this.productInterface.getProduct(item.getItemId());
                    if (productEntity != null) {
                        miniMediaManaData.setItemName(productEntity.getProName());
                    }
                    miniMediaManaData.setTypeName(SalesTypeEnum.SALES_PRODUCT.getName());
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_PROMOTION.getValue())) {
                    MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(item.getItemId());
                    if (promotionEntity != null) {
                        miniMediaManaData.setItemName(promotionEntity.getPromotionName());
                    } else {
                        System.out.printf("\u4fc3\u9500:" + item.getItemId() + "\u4e0d\u5b58\u5728", new Object[0]);
                        miniMediaManaData.setItemName("-");
                    }
                    miniMediaManaData.setTypeName(SalesTypeEnum.SALES_PROMOTION.getName());
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_ACTIVE.getValue())) {
                    ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(item.getItemId());
                    miniMediaManaData.setItemName(activeEntity.getActiveName());
                    miniMediaManaData.setTypeName(SalesTypeEnum.SALES_ACTIVE.getName());
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_GROUP.getValue())) {
                    // empty if block
                }
                return miniMediaManaData;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(result);
        return pg;
    }

    public PageInfo<MiniMedia> getMiniMediaList(int currentPage, int pageSize, Integer mediaType, String userId, String qyWeixinUserid, String nickName, String itemId, Integer saleType) {
        BaseJsonVo<String> codeBaseJsonVo;
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseAccessToken.getAccessTokenByPlatformId(4);
        List collectionList = new ArrayList();
        if (mediaType < MediaTypeEnum.collect.getValue()) {
            MediaEntity query = new MediaEntity();
            query.setMediaType(MediaTypeEnum.collect.getValue());
            if (StringUtils.isNotEmpty((String)userId)) {
                query.setCreateUserid(userId);
            }
            collectionList = this.mediaInterface.getList(query, 0L);
        }
        ArrayList tempList = collectionList;
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        page.setOrderBy(" CREATE_TIME desc ");
        MediaEntity query = new MediaEntity();
        query.setMediaType(mediaType);
        if (StringUtils.isNotEmpty((String)userId)) {
            query.setCreateUserid(userId);
        }
        if (StringUtils.isNotEmpty((String)itemId)) {
            query.setItemId(itemId);
        }
        if (saleType != null) {
            query.setType(saleType);
        }
        List list = this.mediaInterface.getList(query, 0L);
        List<Object> miniMediaList = new ArrayList();
        String shareCode = "";
        if (StringUtils.isNotEmpty((String)qyWeixinUserid) && (codeBaseJsonVo = this.distributorInterface.getQiyeWeixinShareCode(qyWeixinUserid)).isSuccess()) {
            shareCode = (String)codeBaseJsonVo.getValue();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String code = shareCode;
            miniMediaList = list.stream().map(item -> {
                MiniMedia miniMedia = new MiniMedia();
                miniMedia.setMediaId(item.getMediaId());
                miniMedia.setAppid(weiXinBaseEntity.getAppid());
                miniMedia.setQiWeiName(nickName);
                miniMedia.setItemId(item.getItemId());
                miniMedia.setType(item.getType());
                miniMedia.setStatus(1);
                miniMedia.setShareCode(code);
                miniMedia.setCollectStatus(Objects.equals(mediaType, MediaTypeEnum.collect.getValue()) ? 1 : 0);
                if (CollectionUtils.isNotEmpty((Collection)tempList) && tempList.stream().anyMatch(c -> Objects.equals(c.getItemId(), item.getItemId()) && Objects.equals(c.getType(), item.getType()))) {
                    miniMedia.setCollectStatus(1);
                }
                if (Objects.equals(item.getType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                    MallProductEntity productEntity = this.productInterface.getProduct(item.getItemId());
                    miniMedia.setPage("pages/product_detail/index.html?productId=" + productEntity.getProId() + "&productType=4&ncp_bat=" + code);
                    miniMedia.setTitle(productEntity.getProName());
                    miniMedia.setImgUrl(this.picService.getProductPicUrlMap(productEntity.getProId(), SalesTypeEnum.SALES_PRODUCT.getValue()).get(ProductPicTypeEnum.PRO_SAMLL.getName()).get(0));
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_PROMOTION.getValue())) {
                    MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(item.getItemId());
                    if (promotionEntity != null) {
                        if (promotionEntity.getStatus() == 0 || promotionEntity.getBeginTime().after(new Date()) && promotionEntity.getEndTime().before(new Date())) {
                            miniMedia.setStatus(0);
                        }
                        miniMedia.setPage("pages/product_detail/index.html?productId=" + promotionEntity.getPromotionId() + "&productType=1&ncp_bat=" + code);
                        miniMedia.setTitle(promotionEntity.getPromotionName());
                        miniMedia.setImgUrl(this.picService.getProductPicUrlMap(promotionEntity.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue()).get(ProductPicTypeEnum.PROMO_SAMLL.getName()).get(0));
                    }
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_ACTIVE.getValue())) {
                    ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(item.getItemId());
                    if (activeEntity.getStatus() == 0 || activeEntity.getBeginTime().after(new Date()) || activeEntity.getEndTime().before(new Date())) {
                        miniMedia.setStatus(0);
                    }
                    String activeUrl = this.activeInterface.getActivePageUrl(item.getItemId());
                    if (Objects.equals(activeEntity.getActiveType(), 15)) {
                        activeUrl = this.getCashTakeCode(activeEntity, activeUrl);
                    }
                    miniMedia.setPage(activeUrl.contains("?") ? activeUrl.substring(0, activeUrl.indexOf("?")) + ".html" + activeUrl.substring(activeUrl.indexOf("?")) + "&ncp_bat=" + code : activeUrl + ".html?ncp_bat=" + code);
                    miniMedia.setTitle(activeEntity.getActiveName());
                    miniMedia.setImgUrl(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()).get(ProductPicTypeEnum.ACT_SAMLL.getName()).get(0));
                } else if (Objects.equals(item.getType(), SalesTypeEnum.SALES_GROUP.getValue())) {
                    // empty if block
                }
                return miniMedia;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(miniMediaList);
        return pg;
    }

    private String getCashTakeCode(ActiveEntity activeEntity, String activeUrl) {
        String result = activeUrl;
        if (Objects.equals(activeEntity.getActiveType(), 15)) {
            ActivePropertyEntity query = new ActivePropertyEntity();
            query.setBindCode(activeEntity.getBindCode());
            List propertyEntities = this.activePropertyMapper.getList(query);
            if (CollectionUtils.isNotEmpty((Collection)propertyEntities) && propertyEntities.stream().anyMatch(p -> Objects.equals(p.getPropertyKey(), "cashTakeType") && Objects.equals(p.getPropertyValue(), "\u4ec5\u4e00\u6b21"))) {
                String code = RandomUtils.generateString((int)8);
                code = this.encrypt16(code);
                result = activeUrl + "&code=" + code;
            }
        }
        return result;
    }

    public String encrypt32(String encryptStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Bytes = md5.digest(encryptStr.getBytes());
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            encryptStr = hexValue.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptStr;
    }

    public String encrypt16(String encryptStr) {
        return this.encrypt32(encryptStr).substring(8, 24);
    }

    public PageInfo<SaleItem> getSaleItemList(int currentPage, int pageSize, String itemName) {
        return this.productInterface.getSaleItemList(currentPage, pageSize, itemName);
    }
}

