/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.scrm.service.moment;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.dao.tag.ContactTagMapper;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.scrm.dao.moment.ScrmMomentMapper;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.moment.MomentDTO;
import cc.lechun.scrm.entity.moment.ScrmMomentEntity;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.moment.ScrmMomentInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.qy.moment.AddMoment;
import weixin.popular.bean.qy.moment.AddMomentResult;
import weixin.popular.bean.qy.moment.MomentTaskResult;

@Service
public class ScrmMomentService
extends BaseService<ScrmMomentEntity, Integer>
implements ScrmMomentInterface {
    @Resource
    private ScrmMomentMapper scrmMomentMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    private MaterialInterface materialInterface;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private ContactTagMapper contactTagMapper;

    @Override
    public PageInfo momentList(String createFrom, String taskName, String mediaType, PageForm pageForm) {
        if ("fromCompany".equals(createFrom)) {
            Page page = PageHelper.startPage((int)pageForm.getPageSize(), (int)pageForm.getPageSize());
            page.setOrderBy("TASK_CREATE_TIME DESC");
            ScrmMomentEntity param = new ScrmMomentEntity();
            param.setTaskName(taskName);
            param.setMediaType(mediaType);
            this.scrmMomentMapper.getMomentList(taskName, mediaType);
            PageInfo pg = page.toPageInfo();
            List list = pg.getList();
            return pg;
        }
        if ("fromQW".equals(createFrom)) {
            Page page = PageHelper.startPage((int)pageForm.getPageSize(), (int)pageForm.getPageSize());
            this.scrmMomentMapper.getCustomMomentList();
            PageInfo pg = page.toPageInfo();
            return pg;
        }
        return null;
    }

    @Override
    public BaseJsonVo getMoment(Integer id) {
        List list;
        Serializable param;
        ScrmMomentEntity scrmMomentEntity = (ScrmMomentEntity)this.scrmMomentMapper.selectByPrimaryKey(id);
        Map stringObjectMap = ObjectConvert.objectConvertToObjectMap((Object)scrmMomentEntity);
        if (StringUtils.isNotEmpty((String)scrmMomentEntity.getMediaId())) {
            ArrayList<Object> materialEntities = new ArrayList<Object>();
            for (String s : scrmMomentEntity.getMediaId().split(",")) {
                materialEntities.add(this.materialInterface.selectByPrimaryKey(Integer.valueOf(s)));
            }
            stringObjectMap.put("mediaList", materialEntities);
        }
        if (StringUtils.isNotEmpty((String)scrmMomentEntity.getSenderUser())) {
            ArrayList distributorEntities = new ArrayList();
            for (String s : scrmMomentEntity.getSenderUser().split(",")) {
                param = new DistributorEntity();
                ((DistributorEntity)param).setQyWeixinUserid(s);
                list = this.distributorInterface.getList(param);
                if (list == null || list.size() <= 0) continue;
                distributorEntities.add(list.get(0));
            }
            stringObjectMap.put("senderUserList", distributorEntities);
        }
        if (StringUtils.isNotEmpty((String)scrmMomentEntity.getCustomerTag())) {
            ArrayList tagEntities = new ArrayList();
            for (String s : scrmMomentEntity.getCustomerTag().split(",")) {
                param = new ContactTagEntity();
                ((ContactTagEntity)param).setWxContactTagId(s);
                list = this.contactTagMapper.getList(param);
                if (list == null || list.size() <= 0) continue;
                tagEntities.add(list.get(0));
            }
            stringObjectMap.put("tagList", tagEntities);
        }
        return BaseJsonVo.success((Object)stringObjectMap);
    }

    @Override
    public BaseJsonVo addMomentJobTask(MomentDTO momentDTO) {
        this.logger.info("\u4fdd\u5b58\u670b\u53cb\u5708\u53d1\u5e03\u4efb\u52a1\uff1a{}", (Object)JsonUtils.toJson((Object)momentDTO, (boolean)false));
        if (StringUtils.isEmpty((String)momentDTO.getMomentText()) && StringUtils.isEmpty((String)momentDTO.getMediaType())) {
            return BaseJsonVo.error((String)"\u4e0d\u80fd\u6587\u5b57\u548c\u7d20\u6750\u90fd\u4e3a\u7a7a");
        }
        ScrmMomentEntity momentEntity = null;
        if (momentDTO.getId() != null && momentDTO.getId() != 0) {
            momentEntity = (ScrmMomentEntity)this.selectByPrimaryKey(momentDTO.getId());
            if (momentEntity.getTaskStatus() != 0) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u53d1\u5e03\u7684\u4efb\u52a1\u4e0d\u80fd\u518d\u4fee\u6539");
            }
        } else {
            momentEntity = new ScrmMomentEntity();
            momentEntity.setTaskStatus(0);
        }
        momentEntity.setTaskName(momentDTO.getTaskName());
        if (StringUtils.isNotEmpty((String)momentDTO.getMomentText())) {
            momentEntity.setMomentText(momentDTO.getMomentText());
        }
        if (StringUtils.isNotEmpty((String)momentDTO.getMediaType())) {
            momentEntity.setMediaType(momentDTO.getMediaType());
            if (momentDTO.getMediaId() == null) {
                return BaseJsonVo.error((String)"\u4f60\u7d20\u6750\u5fd8\u9009\u4e86");
            }
            MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey(Integer.valueOf(momentDTO.getMediaId()[0]));
            if (!"media".equals(materialEntity.getMaterialType())) {
                return BaseJsonVo.error((String)"\u7d20\u6750\u8bf7\u9009\u62e9\u56fe\u7247\u89c6\u9891\u6216\u94fe\u63a5");
            }
            if ("image".equals(momentDTO.getMediaType())) {
                if (momentDTO.getMediaId().toString().split(",").length > 9) {
                    return BaseJsonVo.error((String)"\u56fe\u7247\u7d20\u6750\u6700\u591a\u9009\u62e99\u5f20");
                }
            } else if (momentDTO.getMediaId().toString().contains(",")) {
                return BaseJsonVo.error((String)"\u89c6\u9891\u548c\u94fe\u63a5\u7d20\u6750\u53ea\u80fd\u9009\u62e91\u4e2a");
            }
            momentEntity.setMediaId(String.join((CharSequence)",", momentDTO.getMediaId()));
        }
        if (momentDTO.getSenderUser() != null) {
            momentEntity.setSenderUser(String.join((CharSequence)",", momentDTO.getSenderUser()));
        }
        if (momentDTO.getSenderDepartment() != null) {
            momentEntity.setSenderDepartment(String.join((CharSequence)",", momentDTO.getSenderDepartment()));
        }
        if (momentDTO.getCustomerTag() != null) {
            momentEntity.setCustomerTag(String.join((CharSequence)",", momentDTO.getCustomerTag()));
        }
        this.scrmMomentMapper.insertOrUpdate(momentEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo publishMomentJob(Integer id) {
        AddMoment.Attachment attachment;
        ScrmMomentEntity momentEntity = (ScrmMomentEntity)this.selectByPrimaryKey(id);
        AddMoment addMoment = new AddMoment();
        if (StringUtils.isNotEmpty((String)momentEntity.getMomentText())) {
            AddMoment.Text addMomentText = new AddMoment.Text();
            addMomentText.setContent(momentEntity.getMomentText());
            addMoment.setText(addMomentText);
        }
        ArrayList<AddMoment.Attachment> attachments = new ArrayList<AddMoment.Attachment>();
        if ("image".equals(momentEntity.getMediaType())) {
            String[] mediaIds;
            for (String string : mediaIds = momentEntity.getMediaId().split(",")) {
                AddMoment.Attachment.Image image = new AddMoment.Attachment.Image();
                AddMoment.Attachment attachment2 = new AddMoment.Attachment();
                image.setMediaId(string);
                attachment2.setMsgtype("image");
                attachment2.setImage(image);
                attachments.add(attachment2);
            }
        } else if ("video".equals(momentEntity.getMediaType())) {
            AddMoment.Attachment.Video video = new AddMoment.Attachment.Video();
            attachment = new AddMoment.Attachment();
            video.setMediaId(momentEntity.getMediaId());
            attachment.setMsgtype("video");
            attachment.setVideo(video);
            attachments.add(attachment);
        } else if ("link".equals(momentEntity.getMediaType())) {
            AddMoment.Attachment.Link link = new AddMoment.Attachment.Link();
            attachment = new AddMoment.Attachment();
            link.setMediaId(momentEntity.getMediaId());
            link.setTitle(momentEntity.getLinkTitle());
            link.setUrl(momentEntity.getLinkUrl());
            attachment.setMsgtype("link");
            attachment.setLink(link);
            attachments.add(attachment);
        }
        addMoment.setAttachments(attachments);
        AddMoment.VisibleRange visibleRange = new AddMoment.VisibleRange();
        AddMoment.VisibleRange.SenderList senderList = new AddMoment.VisibleRange.SenderList();
        if (StringUtils.isNotEmpty((String)momentEntity.getSenderUser())) {
            String[] split;
            ArrayList<String> senderUsers = new ArrayList<String>();
            for (String s : split = momentEntity.getSenderUser().split(",")) {
                senderUsers.add(s);
            }
            senderList.setUserList(senderUsers);
        }
        if (StringUtils.isNotEmpty((String)momentEntity.getSenderDepartment())) {
            String[] split;
            ArrayList<Integer> senderDepts = new ArrayList<Integer>();
            for (String s : split = momentEntity.getSenderDepartment().split(",")) {
                senderDepts.add(Integer.valueOf(s));
            }
            senderList.setDepartmentList(senderDepts);
        }
        visibleRange.setSenderList(senderList);
        AddMoment.VisibleRange.ExternalContactList tagList = new AddMoment.VisibleRange.ExternalContactList();
        if (StringUtils.isNotEmpty((String)momentEntity.getCustomerTag())) {
            String[] stringArray;
            ArrayList<String> tags = new ArrayList<String>();
            for (String s : stringArray = momentEntity.getCustomerTag().split(",")) {
                tags.add(s);
            }
            tagList.setTagList(tags);
        }
        visibleRange.setExternalContactList(tagList);
        this.logger.info("\u53d1\u5e03\u670b\u53cb\u5708\u4efb\u52a1:{}", (Object)JsonUtils.toJson((Object)addMoment, (boolean)false));
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        AddMomentResult addMomentResult = WxApiUtils.addMomentTask((String)accessToken, (AddMoment)addMoment);
        if (addMomentResult.isSuccess()) {
            momentEntity.setTaskStatus(1);
            momentEntity.setJobId(addMomentResult.getJobid());
            this.scrmMomentMapper.updateByPrimaryKeySelective(momentEntity);
            return BaseJsonVo.success((Object)"\u4efb\u52a1\u53d1\u5e03\u6210\u529f");
        }
        return BaseJsonVo.error((String)addMomentResult.getErrmsg());
    }

    @Override
    public BaseJsonVo getMomentJobTaskResult(Integer id) {
        ScrmMomentEntity momentEntity = (ScrmMomentEntity)this.scrmMomentMapper.selectByPrimaryKey(id);
        if (momentEntity == null) {
            return BaseJsonVo.error((String)("\u4e0d\u5b58\u5728\u7684\u670b\u53cb\u5708\u53d1\u5e03\u8bb0\u5f55:" + id));
        }
        if (momentEntity.getTaskStatus() == 0) {
            return BaseJsonVo.error((String)("\u8be5\u72b6\u6001(" + momentEntity.getTaskStatus() + ")\u4e0b\u65e0\u6cd5\u67e5\u8be2\u53d1\u5e03\u7ed3\u679c"));
        }
        String jobId = momentEntity.getJobId();
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        MomentTaskResult momentTaskResult = WxApiUtils.getMomentTaskResult((String)accessToken, (String)jobId);
        this.logger.info("\u83b7\u53d6\u53d1\u5e03\u670b\u53cb\u5708\u4efb\u52a1\u521b\u5efa\u7ed3\u679c\uff1a{}", (Object)JsonUtils.toJson((Object)momentTaskResult, (boolean)false));
        if (momentTaskResult.isSuccess()) {
            String momentId = momentTaskResult.getResult().getMomentId();
            momentEntity.setMomentId(momentId);
            this.scrmMomentMapper.updateByPrimaryKeySelective(momentEntity);
        }
        return BaseJsonVo.error((String)momentTaskResult.getErrmsg());
    }

    @Override
    public BaseJsonVo cancelMomentTask(Integer id) {
        ScrmMomentEntity momentEntity = (ScrmMomentEntity)this.scrmMomentMapper.selectByPrimaryKey(id);
        if (momentEntity == null) {
            return BaseJsonVo.error((String)("\u4e0d\u5b58\u5728\u7684\u670b\u53cb\u5708\u53d1\u5e03\u8bb0\u5f55:" + id));
        }
        if (momentEntity.getTaskStatus() != 1) {
            return BaseJsonVo.error((String)("\u8be5\u72b6\u6001(" + momentEntity.getTaskStatus() + ")\u4e0b\u65e0\u6cd5\u53d6\u6d88\u53d1\u5e03"));
        }
        String momentId = momentEntity.getMomentId();
        String accessToken = this.weiXinBaseAccessToken.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_QIYEWEIXIN_CONTACT_THIRD_APP.getValue());
        BaseResult baseResult = WxApiUtils.cancelMomentTask((String)accessToken, (String)momentId);
        if (baseResult.isSuccess()) {
            momentEntity.setTaskStatus(3);
            this.scrmMomentMapper.updateByPrimaryKeySelective(momentEntity);
        }
        return BaseJsonVo.error((String)baseResult.getErrmsg());
    }
}

